local exports = exports or {}
local SeekModeScript = SeekModeScript or {}
SeekModeScript.__index = SeekModeScript

function SeekModeScript.new(construct, ...)
    local self = setmetatable({}, SeekModeScript)

    if construct and SeekModeScript.constructor then SeekModeScript.constructor(self, ...) end
    return self
end

function SeekModeScript:constructor()
    self.name = "scriptComp"
end

function SeekModeScript:onStart(comp)
    local output_rt = comp.entity.scene:getOutputRenderTexture()
    output_rt.attachment = Amaz.RenderTextureAttachment.NONE
    self.Mat = comp.entity.scene:findEntityBy("structure"):getComponent("MeshRenderer").sharedMaterials:get(0)
    

    local w = Amaz.BuiltinObject:getInputTextureWidth()
    local h = Amaz.BuiltinObject:getInputTextureHeight()
    
    self.texH = Amaz.Texture2D()
    self.texS = Amaz.Texture2D()
    self.Mat:setInt("imageWidth",w)
    self.Mat:setInt("imageHeight",h)

end

function SeekModeScript:onUpdate(comp, deltaTime)
    local algo_result = Amaz.Algorithm.getAEAlgorithmResult()
    local name = comp.entity.scene:getEffectName()
    -- local name = '2023_02_16_16_21_23_e61e0c34add211ed8ea49a74e0f57e8a'
    local structxtCount = algo_result:getAlgorithmInfoCount(name, "structxt_0", "")
    -- Amaz.LOGE ( 0000,"structxtCount is: " .. structxtCount)
    -- Amaz.LOGE ( 0000,"name:    " .. name)
    local structxtInfo = algo_result:getAlgorithmInfo(name, "structxt_0", "", 0) ---- structxt Result//Bach buffer
    if structxtInfo ~= nil then
        local structxtData = structxtInfo.data -- AMGMap
        local structxtH = structxtData:find("StereoH_image") -- AMGImage
        local structxtS = structxtData:find("StereoS_image") -- AMGImage
        if structxtH and structxtS then


            local StereoH_w = structxtH.width
            local StereoH_h = structxtH.height
            -- Amaz.LOGE(999999, "structxtH imageW is: " .. StereoH_w)
            -- Amaz.LOGE(999999,"structxtH imageH is: " .. StereoH_h)
           
            local StereoS_w = structxtS.width
            local StereoS_h = structxtS.height
            -- Amaz.LOGE(0000, "structxtS imageW is: " .. StereoS_w)
            -- Amaz.LOGE(0000,"structxtS imageH is: " .. StereoS_h)

            self.texH.width = StereoH_w  
            self.texH.height = StereoH_h
            self.texH:storage(structxtH)
            self.Mat:setTex("stereoH", self.texH)
            -- self.finalMat:getTex("stereoH"):storage(structxtH)


            self.texS.width = StereoS_w
            self.texS.height = StereoS_h
            self.texS:storage(structxtS)
            self.Mat:setTex("stereoS",self.texS)
            
            self.Mat:setInt("histWidth", StereoH_w)
        end
    end
end

function SeekModeScript:onEvent(comp,event)
    if event.type ~= Amaz.BEFEventType.BET_COMPOSER then
        return
    end
    if event.args:get(0) == "structure" then
        local percentage = event.args:get(2)
        self.Mat:setFloat("structureStrength",percentage*2.0 - 1.0 )
    end     
end

exports.SeekModeScript = SeekModeScript
return exports
