precision highp float;

attribute vec3 attPosition;
attribute vec2 attUV;

varying vec2 textureCoordinate;
varying vec2 imageCoord;
uniform int imageWidth;
uniform int imageHeight;

void main() 
{
    // float width = 1251.00000;
    // float height = 1668.00000;
    float width = float(imageWidth);
    float height = float(imageHeight);
    vec4 sourceTextureRect = vec4(0.000000,0.0000,width,height);
    vec4 destinationRect = vec4(0.000000,0.0000,width,height);
    vec2 sourceSize = vec2(width,height);
    vec2 targetSize = vec2(width,height);
    float flip = 0.0;
  textureCoordinate = vec2(attUV.x, 1.0 - attUV.y);
  imageCoord = vec2(attUV.x, 1.0 - attUV.y);
    
  vec2 position = (destinationRect.xy + textureCoordinate * destinationRect.zw) / targetSize;
    
  position.y = mix(position.y, 1. - position.y, flip);
    
  position *= 2.0;
  position -= 1.0;

  gl_Position = vec4(position.xy, 1.0, 1.0);
}
