local exports = exports or {}
local stroke_default = stroke_default or {}
stroke_default.__index = stroke_default

local AE_BRUSH2D_TAG = 'AE_BRUSH2D_TAG'

local function print(...)
    local str = ""
    for k, v in pairs({...})  do
        str = str.. tostring(v)
    end
    Amaz.LOGS('AE_EFFECT_TAG stroke_default', str)
    -- EffectSdk.LOG_LEVEL(8, str)
end


function stroke_default.new(construct, ...)
    local self = setmetatable({}, stroke_default)
    if construct and stroke_default.constructor then
        stroke_default.constructor(self, ...)
    end
    return self
end
function stroke_default:constructor()
end

function stroke_default:onStrokeStart(comp, stroke, canvas)
    self.entity = stroke.entity
    self.generator = self.entity:getComponent("Brush2DMeshGenerator")
    self.processor = self.entity:getComponent("Brush2DInputProcessor")

    if self.generator == nil or self.processor == nil then
        self:onStrokeStartExternal(comp, stroke, canvas)
        return
    end
    
    self.config = canvas.brushConfig
    self.blitMaterial = canvas.blitMaterial
    self.stroke = stroke
    self.resolution = stroke.resolution
    self.halfResolution = self.resolution * 0.5
    self.undoTexCache = stroke.undoTexCache
    self.redoTexCache = stroke.redoTexCache
    
    self.processor = self.entity:getComponent("Brush2DInputProcessor")
    if self.processor then
        self.processor:setResolution(self.halfResolution)
        self.processor:setConfig(self.config)
    end 
    if self.generator then
        self.generator:setResolution(self.halfResolution)
        self.generator:setConfig(self.config)
    end
    self.renderMaterial = self.config.brushMaterial
    local renderXshader = self.renderMaterial.xshader
    self.passNum = renderXshader.passes:size()

    self.renderMaterial:setVec2("resolution", self.resolution)
    local baseResolution = self.config.baseResolution
    local strokeSize = self.config.strokeSize
    self.renderMaterial:setFloat("baseResolution", baseResolution)
    self.renderMaterial:setFloat("strokeSize", baseResolution * strokeSize.value)

    self.subMeshIndex = -1
    self.incUVNum = 0
    self.cacheFlag = false
    self.targetCache = Amaz.RenderTexture()
    self.targetCache.width = self.resolution.x
    self.targetCache.height = self.resolution.y
    if self.passNum > 1 then
        self.outputTex = Amaz.RenderTexture()
        self.outputTex.width = self.resolution.x
        self.outputTex.height = self.resolution.y
    end
    self.renderCmd = Amaz.CommandBuffer()
    self.renderCmd.name = 'brush_render_cmd'
    self.cacheCmd = Amaz.CommandBuffer()
    self.cacheCmd.name = 'brush_cache_cmd'
    self.stModel = Amaz.Matrix4x4f():SetIdentity()
    if self.passNum > 1 then
        self.rectMesh = Amaz.Mesh()
    end
    self.cropMesh = Amaz.Mesh()
    self.strokeBBox = Amaz.AABB()
end

function stroke_default:onStrokeUpdate(comp, deltaTime)
    if self.generator == nil then
        self:onStrokeUpdateExternal(comp, deltaTime)
        return
    end

    local dirty = self.stroke.dirtyFlag
    local finished = self.stroke.finished
    if dirty == Amaz.Brush2DDirtyFlag.Increase then
        if self.generator == nil then
            return
        end

        self.strokeMesh = self.generator:getMesh()
        local newIndex = self.strokeMesh.submeshes:size() - 1
        if self.subMeshIndex < newIndex then
            local subMesh = self.strokeMesh:getSubMesh(newIndex)
            self.incUVNum = self.incUVNum + self.strokeMesh:getVertexCount() / 4
            -- subMesh:releaseIBO()
            self.subMeshIndex = newIndex
            self.dirtyRect = subMesh.boundingBox
            self.stroke.dirtyRect = self.dirtyRect
            self.strokeBBox = self.strokeMesh.boundingBox
            self.stroke.boundingBox = self.strokeBBox
            -- print('onStrokeUpdate--case1------self.subMeshIndex < newIndex----', 'self.subMeshIndex==', self.subMeshIndex, ' newIndex==', newIndex)
        elseif finished == true and newIndex >= 0 then
            dirty = Amaz.Brush2DDirtyFlag.Cache
            -- print('onStrokeUpdate----case2----finished == true and newIndex >= 0----')
        else
            dirty = Amaz.Brush2DDirtyFlag.Unchanged
            -- print('onStrokeUpdate----case3----dirty = Amaz.Brush2DDirtyFlag.Unchanged----')
        end
    elseif dirty == Amaz.Brush2DDirtyFlag.Undo or dirty == Amaz.Brush2DDirtyFlag.Redo then
        if finished == true then
            self.stroke.dirtyRect = self.strokeBBox
            -- print('onStrokeUpdate----case4----finished == true   and dirty==----', dirty)
        else
            dirty = Amaz.Brush2DDirtyFlag.Unchanged
            -- print('onStrokeUpdate----case5----Amaz.Brush2DDirtyFlag.Unchanged')
        end
    end

    self.stroke.dirtyFlag = dirty
    self.renderCmd:clearAll()
    self.cacheCmd:clearAll()
end

function stroke_default:onStrokeRender(comp, target)
    if self.generator == nil then
        self:onStrokeRenderExternal(comp, target)
        return
    end

    local dirty = self.stroke.dirtyFlag
    local finished = self.stroke.finished
    if dirty == Amaz.Brush2DDirtyFlag.Unchanged and self.cacheFlag then
        -- print('onStrokeRender----[]---case1----Amaz.Brush2DDirtyFlag.Unchanged')
        return
    end

    if dirty == Amaz.Brush2DDirtyFlag.Increase then
        if self.passNum > 1 then

            Amaz.Brush2DUtils.generateBBoxMesh(self.dirtyRect, self.rectMesh, true, true)
        end
        if self.subMeshIndex == 0 then
            local startPoint = self.strokeMesh:getUv(1, 0)
            self.renderMaterial:setVec2("start", startPoint)
            if self.passNum > 1 then
                self.renderCmd:setRenderTexture(self.outputTex)
                self.renderCmd:clearRenderTexture(true, false, Amaz.Color(0, 0, 0, 0))
            end
            self.renderCmd:blit(target, self.targetCache)
            -- print('onStrokeRender----[]---case2----self.renderCmd:blit(target, self.targetCache)')
        end
        if self.passNum > 1 then
            self.renderCmd:setRenderTexture(self.outputTex)
            self.renderCmd:drawMesh(self.strokeMesh, self.stModel, self.renderMaterial, self.subMeshIndex, 0, nil)
            self.renderCmd:setGlobalTexture("layerTexture", self.targetCache)
            -- self.renderCmd:setGlobalTexture("strokeTexture", self.outputTex)

            if comp.properties:get("StrokeTexture") then
                self.renderCmd:setGlobalTexture("strokeTexture", comp.properties:get("StrokeTexture"))        
            else
                self.renderCmd:setGlobalTexture("strokeTexture", self.outputTex)
            end
            self.renderCmd:setRenderTexture(target)
            self.renderCmd:setGlobalTexture("_MainTex", self.targetCache)
            self.renderCmd:drawMesh(self.rectMesh, self.stModel, self.blitMaterial, 0, 0, nil)
            self.renderCmd:drawMesh(self.rectMesh, self.stModel, self.renderMaterial, 0, 1, nil)
            -- print('onStrokeRender-------case2--passNum > 1--self.renderCmd:blit(target, self.targetCache)')
        else
            self.renderCmd:setRenderTexture(target)
            self.renderCmd:drawMesh(self.strokeMesh, self.stModel, self.renderMaterial, self.subMeshIndex, 0, nil)
            -- print('onStrokeRender-------case3--passNum = 1--drawMesh')
        end
        comp.entity.scene:commitCommandBuffer(self.renderCmd)
    elseif dirty == Amaz.Brush2DDirtyFlag.Undo then
        if self.undoTexCache then
            self.cacheTex = self.undoTexCache:getTexture()
        end
    elseif dirty == Amaz.Brush2DDirtyFlag.Redo then
        if self.redoTexCache then
            self.cacheTex = self.redoTexCache:getTexture()
        end
    elseif dirty == Amaz.Brush2DDirtyFlag.Cache then
        self.cacheTex = nil
        collectgarbage("collect")
    end
    dirty = Amaz.Brush2DDirtyFlag.Unchanged

    if finished then
        if not self.cacheFlag and self.stroke.loadFromContext == false then
            Amaz.Brush2DUtils.alignBBoxToResolution(self.halfResolution, self.strokeBBox)
            Amaz.Brush2DUtils.generateBBoxMesh(self.strokeBBox, self.cropMesh, false, true)
            local cacheWidth = (self.strokeBBox.max_x - self.strokeBBox.min_x) * self.halfResolution.x
            local cacheHeight = (self.strokeBBox.max_y - self.strokeBBox.min_y) * self.halfResolution.y
            if self.undoTexCache then
                self.undoTex = Amaz.RenderTexture()
                self.undoTex.width = cacheWidth
                self.undoTex.height = cacheHeight
                self.undoTexCache:setTexture(self.undoTex)
                self.cacheCmd:setRenderTexture(self.undoTex)
                self.cacheCmd:setGlobalTexture("_MainTex", self.targetCache)
                self.cacheCmd:drawMesh(self.cropMesh, self.stModel, self.blitMaterial, 0, 0, nil)
                -- print('onStrokeRender-------case5--drawMesh undo texture')
            end
            if self.redoTexCache then
                self.redoTex = Amaz.RenderTexture()
                self.redoTex.width = cacheWidth
                self.redoTex.height = cacheHeight
                self.redoTexCache:setTexture(self.redoTex)
                self.cacheCmd:setRenderTexture(self.redoTex)
                self.cacheCmd:setGlobalTexture("_MainTex", target)
                self.cacheCmd:drawMesh(self.cropMesh, self.stModel, self.blitMaterial, 0, 0, nil)
                -- print('onStrokeRender-------case6--drawMesh redo texture')
            end
            comp.entity.scene:commitCommandBuffer(self.cacheCmd)
            dirty = Amaz.Brush2DDirtyFlag.Cache
            self.cacheFlag = true
        elseif self.cacheTex then
            if self.cacheMesh then
                local block = Amaz.MaterialPropertyBlock()
                block:setTexture("_MainTex", self.cacheTex)
                self.renderCmd:setRenderTexture(target)
                self.renderCmd:drawMesh(self.cacheMesh, self.stModel, self.blitMaterial, 0, 0, block)
                comp.entity.scene:commitCommandBuffer(self.renderCmd)
            else
                Amaz.LOGS(AE_BRUSH2D_TAG, 'stroke_default onStrokeRender self.cacheMesh is nil')
            end

            dirty = Amaz.Brush2DDirtyFlag.Cache
            -- print('onStrokeRender----[]---case7--draw cache texture')
        end
    end

    self.stroke.dirtyFlag = dirty
end

function stroke_default:onStrokeFinish()
    if self.generator == nil then
        self:onStrokeFinishExternal()
        return
    end
    Amaz.LOGS(AE_BRUSH2D_TAG, 'stroke_default onStrokeFinish')
    self.config.uvIndex = self.config.uvIndex + self.incUVNum
    self.entity:removeComponent("Brush2DInputProcessor")
    self.entity:removeComponent("Brush2DMeshGenerator")
    self.cacheMesh = Amaz.Mesh()
    if self.stroke.loadFromContext == false then
        self.stroke.boundingBox = self.strokeBBox
        Amaz.Brush2DUtils.generateBBoxMesh(self.strokeBBox, self.cacheMesh, true, false)
    else
        Amaz.Brush2DUtils.generateBBoxMesh(self.stroke.boundingBox, self.cacheMesh, true, false)
    end

    -- print('onStrokeFinish----case1--generateBBoxMesh')
    self.resolution = nil
    self.config = nil
    self.entity = nil
    self.processor = nil
    self.generator = nil
    self.targetCache = nil
    self.outputTex = nil
    self.undoTex = nil
    self.redoTex = nil
    self.strokeMesh = nil
    self.rectMesh = nil
    self.cropMesh = nil

    collectgarbage("collect")
end

function stroke_default:onSubStrokeRender(stroke, target, startIndex, endIndex, needCache)
    if self.generator == nil then
        return
    end
    local clearRT = false
    local startAndEndDataExixt = false
    local arrowIndex = -1
    if stroke.entity.scene:findEntityBy("Graffiti_pen") then
        Amaz.LOGI("brush brushEndIndex", 1)
        if stroke.entity.scene:findEntityBy("Graffiti_pen"):getComponent("TableComponent") then
            Amaz.LOGI("brush brushEndIndex", 2)
            local table = stroke.entity.scene:findEntityBy("Graffiti_pen"):getComponent("TableComponent").table
            clearRT = table:get("clearRT")
            if table:get("brushEndIndex") then
                Amaz.LOGI("brush brushEndIndex", 3)
                startAndEndDataExixt = true
                arrowIndex = table:get("brushEndIndex")
                Amaz.LOGI("brush brushEndIndex", arrowIndex)
            end
        end
    end

    local canvas = stroke:getParentCanvas()
    local resolution = stroke.resolution
    local halfResolution = resolution * 0.5
    local config = stroke:getBrushConfig()
    -- local renderMaterial = config.brushMaterial
    local renderMaterial = stroke:getBrushMaterial()
    local renderXshader = renderMaterial.xshader
    local passNum = renderXshader.passes:size()
    local generator = stroke.entity:getComponent("Brush2DMeshGenerator")

    if self.targetCache == nil or self.targetCache.width ~= resolution.x or self.targetCache.height ~= resolution.y then
        self.targetCache = Amaz.RenderTexture()
        self.targetCache.width = resolution.x
        self.targetCache.height = resolution.y
    end

    if self.outputTex == nil or self.outputTex.width ~= resolution.x or self.outputTex.height ~= resolution.y then
        self.outputTex = Amaz.RenderTexture()
        self.outputTex.width = resolution.x
        self.outputTex.height = resolution.y
    end

    local temp = self.outputTex
    if needCache then
        self.outputTex = Amaz.RenderTexture()
        self.outputTex.width = resolution.x
        self.outputTex.height = resolution.y
    end
    local strokeMesh = generator:getRangeMeshByIndex(startIndex, endIndex)
    local strokeMesh1 = generator:getRangeMeshByIndex(0, 0)

    local stModel = Amaz.Matrix4x4f():SetIdentity()
    local subMesh = strokeMesh:getSubMesh(0)
    local dirtyRect = subMesh.boundingBox
    stroke.dirtyRect = dirtyRect

    local renderCmd = Amaz.CommandBuffer()
    renderCmd.name = 'brush_substroke_render_cmd'
    renderCmd:clearAll()
    if startIndex == 0 or clearRT == true then
        local startPoint = strokeMesh1:getUv(1, 0)
        renderMaterial:setVec2("start", startPoint)
        if passNum > 1 then
            renderCmd:setRenderTexture(self.outputTex)
            renderCmd:clearRenderTexture(true, false, Amaz.Color(0, 0, 0, 0))
        end
        renderCmd:blit(target, self.targetCache)
    end
    if passNum > 1 then

        if self.rectMesh == nil then
            self.rectMesh = Amaz.Mesh()
        end
        local rectMesh = self.rectMesh
        if needCache then
            rectMesh = Amaz.Mesh()
        end
        Amaz.Brush2DUtils.generateBBoxMesh(dirtyRect, rectMesh, true, true)

        renderCmd:setRenderTexture(self.outputTex)
        renderCmd:drawMesh(strokeMesh, stModel, renderMaterial, 0, 0, nil)
        renderCmd:setGlobalTexture("layerTexture", self.targetCache)
        renderCmd:setGlobalTexture("strokeTexture", self.outputTex)
        renderCmd:setRenderTexture(target)
        renderCmd:setGlobalTexture("_MainTex", self.targetCache)
        renderCmd:drawMesh(rectMesh, stModel, canvas.blitMaterial, 0, 0, nil)
        renderCmd:drawMesh(rectMesh, stModel, renderMaterial, 0, 1, nil)
    else
        renderCmd:setRenderTexture(target)
        renderCmd:drawMesh(strokeMesh, stModel, renderMaterial, 0, 0, nil)
    end
    stroke.entity.scene:commitCommandBuffer(renderCmd)

    if needCache then
        if self.cropMesh == nil then
            self.cropMesh = Amaz.Mesh()
        end
        local strokeBBox = strokeMesh.boundingBox
        stroke.boundingBox = strokeBBox
        Amaz.Brush2DUtils.alignBBoxToResolution(halfResolution, strokeBBox)
        Amaz.Brush2DUtils.generateBBoxMesh(strokeBBox, self.cropMesh, false, true)
        local cacheWidth = (strokeBBox.max_x - strokeBBox.min_x) * halfResolution.x
        local cacheHeight = (strokeBBox.max_y - strokeBBox.min_y) * halfResolution.y

        local strokeTex = stroke:getStrokeTexture()
        strokeTex.width = cacheWidth
        strokeTex.height = cacheHeight

        local cacheCmd = Amaz.CommandBuffer()
        cacheCmd.name = 'brush_substroke_cache_cmd'

        cacheCmd:setRenderTexture(strokeTex)
        cacheCmd:setGlobalTexture("_MainTex", target)
        cacheCmd:drawMesh(self.cropMesh, stModel, canvas.blitMaterial, 0, 0, nil)
        cacheCmd:setRenderTexture(self.targetCache)
        cacheCmd:clearRenderTexture(true, false, Amaz.Color(0, 0, 0, 0))
        cacheCmd:setRenderTexture(self.outputTex)
        cacheCmd:clearRenderTexture(true, false, Amaz.Color(0, 0, 0, 0))
        self.outputTex = temp
        stroke.entity.scene:commitCommandBuffer(cacheCmd)
        collectgarbage("collect")
        -- print('onSubStrokeRender----cache stroke texture')
    end
end


function stroke_default:onStrokeStartExternal(comp, stroke, canvas)
    Amaz.LOGE(AE_EFFECT_TAG, ' onStrokeStartExternal()')
    self.config = canvas.brushConfig
    self.blitMaterial = canvas.blitMaterial
    self.stroke = stroke
    self.resolution = stroke.resolution
    self.halfResolution = self.resolution * 0.5
    self.undoTexCache = stroke.undoTexCache
    self.redoTexCache = stroke.redoTexCache
    local entity = stroke.entity
    self.renderMaterial = self.config.brushMaterial
    local renderXshader = self.renderMaterial.xshader

    self.cacheFlag = false
    self.targetCache = Amaz.RenderTexture()
    self.targetCache.width = self.resolution.x
    self.targetCache.height = self.resolution.y
    self.renderCmd = Amaz.CommandBuffer()
    self.cacheCmd = Amaz.CommandBuffer()
    self.stModel = Amaz.Matrix4x4f():SetIdentity()
    self.cropMesh = Amaz.Mesh()
    self.block1 = Amaz.MaterialPropertyBlock()
    self.block2 = Amaz.MaterialPropertyBlock()     
end

function stroke_default:onStrokeUpdateExternal(comp, deltaTime)

    Amaz.LOGE(AE_EFFECT_TAG, 'onStrokeUpdateExternal()')
    local dirty = self.stroke.dirtyFlag
    local finished = self.stroke.finished
    if dirty == Amaz.Brush2DDirtyFlag.Increase then
        self.stroke.dirtyRect = self.stroke.boundingBox
        self.strokeBBox = self.stroke.boundingBox
        self.strokeMesh = Amaz.Mesh()
        Amaz.Brush2DUtils.alignBBoxToResolution(self.halfResolution, self.strokeBBox)
        Amaz.Brush2DUtils.generateBBoxMesh(self.strokeBBox, self.strokeMesh, true, true)
    elseif dirty == Amaz.Brush2DDirtyFlag.Undo or dirty == Amaz.Brush2DDirtyFlag.Redo then
        if not finished then
            dirty = Amaz.Brush2DDirtyFlag.Unchanged
        end
    end

    self.stroke.dirtyFlag = dirty
    self.renderCmd:clearAll()
    self.cacheCmd:clearAll()
    --self.blitMaterial:setTex("_MainTex", nil)
end

function stroke_default:onStrokeRenderExternal(comp, target)
    
    Amaz.LOGE(AE_EFFECT_TAG, ' onStrokeRenderExternal()')
    local dirty = self.stroke.dirtyFlag
    if dirty == Amaz.Brush2DDirtyFlag.Unchanged and self.cacheFlag then
        return
    end

    if dirty == Amaz.Brush2DDirtyFlag.Increase then
        self.renderCmd:blit(target, self.targetCache)
        self.renderCmd:setRenderTexture(target)
        self.renderCmd:setGlobalTexture("strokeTexture", comp.properties:get("StrokeTexture"))
        self.renderCmd:setGlobalTexture("layerTexture", self.targetCache)

        if self.rectMesh == nil then
            self.rectMesh = Amaz.Mesh()
            self.dirtyRect = self.stroke.boundingBox
            Amaz.Brush2DUtils.generateBBoxMesh(self.dirtyRect, self.rectMesh, true, true)
        end

        -- self.renderCmd:setGlobalTexture("strokeTexture", self.outputTex)
        self.renderCmd:drawMesh(self.rectMesh, self.stModel, self.renderMaterial, 0, 1, nil)
        comp.entity.scene:commitCommandBuffer(self.renderCmd)
        self.stroke.finished = true
    elseif dirty == Amaz.Brush2DDirtyFlag.Undo then
        if self.undoTexCache then
            self.cacheTex = self.undoTexCache:getTexture()
            if not self.cacheTex then
                Amaz.LOGE(AE_EFFECT_TAG, 'onStrokeRender() cacheTex is invalid')
            end
        else
            Amaz.LOGE(AE_EFFECT_TAG, 'onStrokeRender() undoTexCache is invalid')
        end
    elseif dirty == Amaz.Brush2DDirtyFlag.Redo then
        if self.redoTexCache then
            self.cacheTex = self.redoTexCache:getTexture()
            if not self.cacheTex then
                Amaz.LOGE(AE_EFFECT_TAG, 'onStrokeRender() cacheTex is invalid')
            end
        else
            Amaz.LOGE(AE_EFFECT_TAG, 'onStrokeRender() redoTexCache is invalid')
        end
    elseif dirty == Amaz.Brush2DDirtyFlag.Cache then
        self.cacheTex = nil
        collectgarbage("collect")
    end
    dirty = Amaz.Brush2DDirtyFlag.Unchanged

    local finished = self.stroke.finished
    if finished then
        if not self.cacheFlag then
            Amaz.Brush2DUtils.generateBBoxMesh(self.strokeBBox, self.cropMesh, false, true)
            local cacheWidth = (self.strokeBBox.max_x - self.strokeBBox.min_x) * self.halfResolution.x
            local cacheHeight = (self.strokeBBox.max_y - self.strokeBBox.min_y) * self.halfResolution.y
            if self.undoTexCache then
                self.undoTex = Amaz.RenderTexture()
                self.undoTex.width = cacheWidth
                self.undoTex.height = cacheHeight
                self.undoTexCache:setTexture(self.undoTex)
                self.cacheCmd:setRenderTexture(self.undoTex)
                self.block1:setTexture("_MainTex",self.targetCache)
                self.cacheCmd:setGlobalTexture("_MainTex", self.targetCache)
                self.cacheCmd:drawMesh(self.cropMesh, self.stModel, self.blitMaterial, 0, 0, self.block1)
            end
            if self.redoTexCache then
                self.redoTex = Amaz.RenderTexture()
                self.redoTex.width = cacheWidth
                self.redoTex.height = cacheHeight
                self.redoTexCache:setTexture(self.redoTex)
                self.cacheCmd:setRenderTexture(self.redoTex)
                self.block2:setTexture("_MainTex",target)
                self.cacheCmd:setGlobalTexture("_MainTex", target)
                self.cacheCmd:drawMesh(self.cropMesh, self.stModel, self.blitMaterial, 0, 0, self.block2)
            end
            comp.entity.scene:commitCommandBuffer(self.cacheCmd)
            dirty = Amaz.Brush2DDirtyFlag.Cache
            self.cacheFlag = true
        elseif self.cacheTex then
            local block = Amaz.MaterialPropertyBlock()
            block:setTexture("_MainTex", self.cacheTex)
            self.renderCmd:setRenderTexture(target)
            self.renderCmd:drawMesh(self.cacheMesh, self.stModel, self.blitMaterial, 0, 0, block)
            comp.entity.scene:commitCommandBuffer(self.renderCmd)
            dirty = Amaz.Brush2DDirtyFlag.Cache
        end
    end

    self.stroke.dirtyFlag = dirty
end

function stroke_default:onStrokeFinishExternal()

    Amaz.LOGE(AE_EFFECT_TAG, ' onStrokeFinishExternal()')
    self.cacheMesh = Amaz.Mesh()
    Amaz.Brush2DUtils.generateBBoxMesh(self.strokeBBox, self.cacheMesh, true, false)

    self.resolution = nil
    self.config = nil
    self.targetCache = nil
    self.undoTex = nil
    self.redoTex = nil
    self.strokeMesh = nil
    self.cropMesh = nil
    self.block1=nil
    self.block2=nil
    collectgarbage("collect")
end


exports.stroke_default = stroke_default
return exports