precision highp float;
varying highp vec2 uv0;

uniform sampler2D inputImageTexture;
uniform sampler2D lut_max;
uniform sampler2D lut_min;

uniform vec3 hsl_param_0;
uniform vec3 hsl_param_1;
uniform vec3 hsl_param_2;
uniform vec3 hsl_param_3;
uniform vec3 hsl_param_4;
uniform vec3 hsl_param_5;
uniform vec3 hsl_param_6;

vec4 filterFun(vec4 baseColor, sampler2D minTex, sampler2D maxTex, float intensity)
{   
    float slider_progress = abs(intensity);

    vec4 curColor = baseColor;
    vec4 textureColor = curColor;
    float blueColor = curColor.b * (17.0 - 1.0);
    vec2 standardTableSize = vec2(289.0, 17.0);
    vec2 pixelSize = 1.0 / standardTableSize;
    vec2 quad1 = vec2(0.0);
    quad1.y = floor(floor(blueColor) / 17.0);
    quad1.x = floor(blueColor) - (quad1.y * 1.0);
    vec2 quad2;
    quad2.y = floor(ceil(blueColor) / 17.0);
    quad2.x = ceil(blueColor) - (quad2.y * 1.0);
    vec2 texPos1;
    texPos1.x = (quad1.x * 1.0 / 17.0) + 0.5 / standardTableSize.x + ((1.0 / 17.0 - 1.0 / standardTableSize.x) * textureColor.r);
    texPos1.y = (quad1.y * 1.0 / 1.0) + 0.5 / standardTableSize.y +((1.0 / 1.0 - 1.0 / standardTableSize.y) * textureColor.g);
    vec2 texPos2;
    texPos2.x = (quad2.x * 1.0 / 17.0) + 0.5 / standardTableSize.x + ((1.0 / 17.0 - 1.0 / standardTableSize.x) * textureColor.r);
    texPos2.y = (quad2.y * 1.0 / 1.0) + 0.5 / standardTableSize.y +((1.0 / 1.0 - 1.0 / standardTableSize.y) * textureColor.g);
    float alpha = fract(blueColor);

    vec4 newColor = vec4(0.0);
    if (intensity < 0.0){
        vec4 newColor1 = texture2D(minTex, texPos1);
        vec4 newColor2 = texture2D(minTex, texPos2);
        newColor = mix(newColor1, newColor2, alpha);
    } else {
        vec4 newColor1 = texture2D(maxTex, texPos1);
        vec4 newColor2 = texture2D(maxTex, texPos2);
        newColor = mix(newColor1, newColor2, alpha);
    }
    newColor = mix(curColor,newColor,slider_progress);
    return newColor;
}

float skinIntensity(float h, float left_left, float left, float right, float right_right)
{
    float intensity = 0.;
    if (left_left < left && left > right && right < right_right) {
        if (h >= left && h <= 360.) {
            intensity = 1.0;
        }
        if (h >= 0. && h <= right) {
            intensity = 1.0;
        }
        if (h >= left_left && h <= left) {
            intensity = (h - left_left) / (left - left_left);
        }
        if (h >= right && h <= right_right) {
            intensity = (right_right - h) / (right_right - right);
        }
    }
    if (left_left > left && left < right && right < right_right) {
        if (h >= left && h <= right) {
            intensity = 1.0;
        }
        if (h >= 0. && h <= left) {
            intensity = (h + 360. - left_left) / (left + 360. - left_left);
        }
        if (h >= left_left && h <= 360.) {
            intensity = (h - left_left) / (left + 360. - left_left);
        }
        if (h >= right && h <= right_right) {
            intensity = (right_right - h) / (right_right - right);
        }
    }
    if (left_left <= left && left < right && right <= right_right) {
        if (h >= left && h <= right) {
            intensity = 1.0;
        }
        if (h >= left_left && h <= left) {
            intensity = (h - left_left) / (left - left_left);
        }
        if (h >= right && h <= right_right) {
            intensity = (right_right - h) / (right_right - right);
        }
    }
    if (left_left < left && left < right && right > right_right) {
        if (h >= left && h <= right) {
            intensity = 1.0;
        }
        if (h >= left_left && h <= left) {
            intensity = (h - left_left) / (left - left_left);
        }
        if (h >= right && h <= 360.) {
            intensity = (right_right + 360. - h) / (right_right + 360. - right);
        }
        if (h >= 0. && h <= right_right) {
            intensity = (right_right - h) / (right_right + 360. - right);
        }
    }
    return intensity;
}

vec3 rgb2hsl(vec3 rgb) {
    float h = 0., s = 0., l = 0.;
    float r = rgb.r;
    float g = rgb.g;
    float b = rgb.b;
    float cmax = max(r, max(g, b));
    float cmin = min(r, min(g, b));
    float delta = cmax - cmin;
    l = (cmax + cmin) / 2.;
    if (delta < .00001) {
        s = 0.;
        h = 0.;
    } else {
        if (l <= .5)
            s = delta / (cmax + cmin);
        else
            s = delta / (2. - (cmax + cmin));
        if (cmax - r < .00001) {
            if (g >= b)
                h = 60. * (g - b) / delta;
            else
                h = 60. * (g - b) / delta + 360.;
        } else if (cmax - g < .00001) {
            h = 60. * (b - r) / delta + 120.;
        } else {
            h = 60. * (r - g) / delta + 240.;
        }
    }
    return vec3(h, s, l);
}

float hueToRgb(float p, float q, float t) {
    if (t < 0.)
        t += 1.;
    if (t > 1.)
        t -= 1.;
    if (t < 1. / 6.)
        return p + (q - p) * 6. * t;
    if (t < 1. / 2.)
        return q;
    if (t < 2. / 3.)
        return p + (q - p) * (2. / 3. - t) * 6.;
    return p;
}

vec3 hsl2rgb(vec3 hsl) {
    float r, g, b;
    float h = hsl.x / 360.;
    if (hsl.y == 0.) {
        r = g = b = hsl.z; // gray
    } else {
        float q = hsl.z < .5 ? hsl.z * (1. + hsl.y) : (hsl.z + hsl.y - hsl.z * hsl.y);
        float p = 2. * hsl.z - q;
        r = hueToRgb(p, q, h + 1. / 3.);
        g = hueToRgb(p, q, h);
        b = hueToRgb(p, q, h - 1. / 3.);
    }
    return vec3(r, g, b);
}

vec3 pixel_adjust(float h, float hue, float saturation, float brightness, float left_left, float left, float right, float right_right, vec3 delta_hsb) {
    if (left_left < left && left > right && right < right_right) {
        if (h >= left && h <= 360.) {
            delta_hsb.x += hue;
            delta_hsb.y += saturation;
            delta_hsb.z += brightness;
            return delta_hsb;
        }
        if (h >= 0. && h <= right) {
            delta_hsb.x += hue;
            delta_hsb.y += saturation;
            delta_hsb.z += brightness;
            return delta_hsb;
        }
        if (h >= left_left && h <= left) {
            delta_hsb.x += hue * (h - left_left) / (left - left_left);
            delta_hsb.y += saturation * (h - left_left) / (left - left_left);
            delta_hsb.z += brightness * (h - left_left) / (left - left_left);
            return delta_hsb;
        }
        if (h >= right && h <= right_right) {
            delta_hsb.x += hue * (right_right - h) / (right_right - right);
            delta_hsb.y += saturation * (right_right - h) / (right_right - right);
            delta_hsb.z += brightness * (right_right - h) / (right_right - right);
            return delta_hsb;
        }
    }
    if (left_left > left && left < right && right < right_right) {
        if (h >= left && h <= right) {
            delta_hsb.x += hue;
            delta_hsb.y += saturation;
            delta_hsb.z += brightness;
            return delta_hsb;
        }
        if (h >= 0. && h <= left) {
            delta_hsb.x += hue * (h + 360. - left_left) / (left + 360. - left_left);
            delta_hsb.y += saturation * (h + 360. - left_left) / (left + 360. - left_left);
            delta_hsb.z += brightness * (h + 360. - left_left) / (left + 360. - left_left);
            return delta_hsb;
        }
        if (h >= left_left && h <= 360.) {
            delta_hsb.x += hue * (h - left_left) / (left + 360. - left_left);
            delta_hsb.y += saturation * (h - left_left) / (left + 360. - left_left);
            delta_hsb.z += brightness * (h - left_left) / (left + 360. - left_left);
            return delta_hsb;
        }
        if (h >= right && h <= right_right) {
            delta_hsb.x += hue * (right_right - h) / (right_right - right);
            delta_hsb.y += saturation * (right_right - h) / (right_right - right);
            delta_hsb.z += brightness * (right_right - h) / (right_right - right);
            return delta_hsb;
        }
    }
    if (left_left <= left && left < right && right <= right_right) {

        if (h >= left && h <= right) {
            delta_hsb.x += hue;
            delta_hsb.y += saturation;
            delta_hsb.z += brightness;
            return delta_hsb;
        }
        if (h >= left_left && h <= left) {
            delta_hsb.x += hue * (h - left_left) / (left - left_left);
            delta_hsb.y += saturation * (h - left_left) / (left - left_left);
            delta_hsb.z += brightness * (h - left_left) / (left - left_left);
            return delta_hsb;
        }
        if (h >= right && h <= right_right) {
            delta_hsb.x += hue * (right_right - h) / (right_right - right);
            delta_hsb.y += saturation * (right_right - h) / (right_right - right);
            delta_hsb.z += brightness * (right_right - h) / (right_right - right);
            return delta_hsb;
        }
    }
    if (left_left < left && left < right && right > right_right) {
        if (h >= left && h <= right) {
            delta_hsb.x += hue;
            delta_hsb.y += saturation;
            delta_hsb.z += brightness;
            return delta_hsb;
        }
        if (h >= left_left && h <= left) {
            delta_hsb.x += hue * (h - left_left) / (left - left_left);
            delta_hsb.y += saturation * (h - left_left) / (left - left_left);
            delta_hsb.z += brightness * (h - left_left) / (left - left_left);
            return delta_hsb;
        }
        if (h >= right && h <= 360.) {
            delta_hsb.x += hue * (right_right + 360. - h) / (right_right + 360. - right);
            delta_hsb.y += saturation * (right_right + 360. - h) / (right_right + 360. - right);
            delta_hsb.z += brightness * (right_right + 360. - h) / (right_right + 360. - right);
            return delta_hsb;
        }
        if (h >= 0. && h <= right_right) {
            delta_hsb.x += hue * (right_right - h) / (right_right + 360. - right);
            delta_hsb.y += saturation * (right_right - h) / (right_right + 360. - right);
            delta_hsb.z += brightness * (right_right - h) / (right_right + 360. - right);
            return delta_hsb;
        }
    }
    return delta_hsb;
}

vec3 HSLadjust(vec3 src) {
    //RGB to HSL conversion
    vec3 hsb = rgb2hsl(src);

    //adjust each channel
    vec3 delta_hsb = vec3(0.);
    delta_hsb = pixel_adjust(hsb.x, hsl_param_0.x, hsl_param_0.y, hsl_param_0.z, 315., 335., 0., 20., delta_hsb);
    delta_hsb = pixel_adjust(hsb.x, hsl_param_1.x, hsl_param_1.y, hsl_param_1.z, 0., 20., 30., 40., delta_hsb);
    delta_hsb = pixel_adjust(hsb.x, hsl_param_2.x, hsl_param_2.y, hsl_param_2.z, 25., 50., 70., 90., delta_hsb);
    delta_hsb = pixel_adjust(hsb.x, hsl_param_3.x, hsl_param_3.y, hsl_param_3.z, 70., 90., 160., 180., delta_hsb);
    delta_hsb = pixel_adjust(hsb.x, hsl_param_4.x, hsl_param_4.y, hsl_param_4.z, 145., 180., 235., 270., delta_hsb);
    delta_hsb = pixel_adjust(hsb.x, hsl_param_5.x, hsl_param_5.y, hsl_param_5.z, 250., 270., 315., 335., delta_hsb);
    delta_hsb = pixel_adjust(hsb.x, 0., hsl_param_6.y, hsl_param_6.z, 315., 345., 45., 75., delta_hsb);
    float skin_Intensity = skinIntensity(hsb.x, 315., 345., 45., 75.) * hsl_param_6.x;

    //adjust hue
    hsb.x = hsb.x + delta_hsb.x;
    while (hsb.x > 360.) {
        hsb.x -= 360.;
    }
    while (hsb.x < 0.) {
        hsb.x += 360.;
    }

    //adjust saturation
    delta_hsb.y = clamp(delta_hsb.y / 100., -1., 1.);
    if (delta_hsb.y < 0.) {
        hsb.y = hsb.y * (1. + delta_hsb.y);
    } else {
        float temp = hsb.y * (1. - delta_hsb.y);
        hsb.y = hsb.y + (hsb.y - temp);
    }

    //adjust brightness
    delta_hsb.z = clamp(delta_hsb.z / 100., -1., 1.);
    if (delta_hsb.z < 0.) {
        float radio = hsb.y;
        if (hsb.z >= .5) {
            radio = hsb.y * 1.;
        }
        if (hsb.z < .5) {
            radio = hsb.y * 2. * hsb.z;
        }
        float temp = hsb.z - radio * (1. - hsb.z) * delta_hsb.z;
        hsb.z = hsb.z + (hsb.z - temp);
        hsb.y = hsb.y * (1. + delta_hsb.z);
    } else {
        float radio = hsb.y;
        if (hsb.z >= .5) {
            radio = hsb.y * 1.;
        }
        if (hsb.z < .5) {
            radio = hsb.y * 2. * hsb.z;
        }
        hsb.z = hsb.z + radio * (1. - hsb.z) * delta_hsb.z;
        hsb.y = hsb.y * (1. - delta_hsb.z);
    }
    hsb.y = clamp(hsb.y, 0., 1.);
    hsb.z = clamp(hsb.z, 0., 1.);

    //output
    vec4 out_rgba = vec4(hsl2rgb(hsb), 1.0);
    return filterFun(out_rgba, lut_min, lut_max, skin_Intensity).rgb;
}

void main(void) {
    vec4 curColor = texture2D(inputImageTexture, uv0);
    if (curColor.a > 0.)
        curColor.rgb /= curColor.a;

    vec3 resultColor = HSLadjust(curColor.rgb);

    gl_FragColor = vec4(resultColor, 1.) * curColor.a;
}
