precision highp float;
varying vec2 v_texcoord;
varying vec4 v_opacity;
uniform float hardness;
uniform float strokeSize;

void main()
{
    float dist = distance(v_texcoord, vec2(0.5));
    // feather version 1.0
    float shapeMask = 1.0 - smoothstep(0.15 + 0.35 * hardness - 1.0 / strokeSize, 0.5, dist);
    // feather version 2.0
    // float border_size = 0.1 + 0.4 * hardness - 1.0 / strokeSize;
    // float shapeMask = 1.0 - clamp(0.0, 1.0, (dist - border_size) / (0.5 - border_size));
    gl_FragColor = shapeMask * v_opacity;
}
