local initFlag = true
local featurePath = "GESticker_Faceu_Beauty"
local ge = nil
local feature = nil
local globalTimerId = 3214349

local smoothSkin = 0.6
local sharpness = 0.05
local needDisableSmoothSkin = false


local function updateSmoothSkinStatus(this)

    local effect_manager = this:getEffectManager()
    local facedata    = effect_manager:getBundleInfo()
    local maxFaceNum = 5

    local vertexName =  "cv248points_"
    local detectFaceCount = 0    
    for i = 0, maxFaceNum - 1 do
        local vertex_data   = facedata:GetFloatArray(vertexName..i)
        if(vertex_data == nil) then                      
            break
        end
        detectFaceCount = detectFaceCount + 1
    end
    -- 后置未识别到人脸时禁用磨皮
    local cameraPosition = effect_manager:getCameraPosition()
    if detectFaceCount <= 0 and cameraPosition == 1 then
        needDisableSmoothSkin = true
    else
        needDisableSmoothSkin = false
    end

end


EventHandles =
{
    handleEffectEvent = function (this, eventCode)
                            this:addTimer( globalTimerId, EffectSdk.BEF_TIMER_EVENT_CIRCLE, 10)
                            if initFlag then
                                feature = this:getFeature(featurePath)
                                ge = EffectSdk.castGeneralEffectFeature(feature)                                
                                        
                                initFlag = false
                                -- print("init complete!")
                            end
                            return true
                        end,
    handleTimerEvent = function (this, timerId, milliSeconds)
        if timerId ~= globalTimerId or initFlag then
            return
        end
   
        ge:setUniformFloat("sharp", 1, "sharpen", sharpness)          
        
        updateSmoothSkinStatus(this)      
        
        if needDisableSmoothSkin then
            ge:setUniformFloat("sharp", 1, "blurAlpha", 0.0) 
            -- print("已禁用磨皮")             
        else
            local realProgress = smoothSkin
            local oldPoint = 0.6
            local newPoint = 0.7
            if(smoothSkin <= oldPoint) then
                realProgress = smoothSkin * newPoint / oldPoint
            else
                realProgress = newPoint + (smoothSkin - oldPoint) * (1.0- newPoint)/ (1.0 - oldPoint) 
            end              
            ge:setUniformFloat("sharp", 1, "blurAlpha", realProgress)
            -- print("已启用磨皮")  
        end          

    end,
    -- handleDeviceOrientedChangedEvent = function (this,isFront)
    --     if isFront then
    --         isFrontCamera = false
    --         -- print("已切换为后置摄像头！")         
    --     else
    --         isFrontCamera = true
    --         -- print("已切换为前置摄像头！")            
    --     end     
    -- end,   
    -- handleFaceInfoEvent = function(this, faceInfo)
    --                     detectedFaceCount = faceInfo:getFaceCount()            
    --                     -- print("face count:"..detectFaceCount)          
    --                     return true
    -- end,      
    handleComposerUpdateNodeEvent = function (this, path, tag, percentage)
        if tag == "smooth" then
            smoothSkin = percentage
            -- print("smooth skin degree: "..smoothSkin)
        elseif tag == "sharp" then
            sharpness = percentage
            -- print("sharpness degree: "..sharpness)
        end
    end    
}
