local featurePath = "ManualReshape/"
local totalCount = 0
local maxSlim = 20    --瘦身瘦腿浓度
local slimPos = 35 --瘦身极值-正向
local slimNeg = 35  --瘦身极值-负向
local maxHardnessPos = 60--放大缩小浓度-正向
local maxHardnessNeg = 100--放大缩小浓度-负向
local expandPos = 40 --放大缩小极值-正向
local expandNeg = 25  --放大缩小极值-负向

EventHandles = {
    handleEffectEvent = function(this, eventCode)
        EffectSdk.LOG_LEVEL(5,"DORISLOG:  handleEffectEvent started")

        local feature = this:getFeature(featurePath)
        if not feature then
            print("manualReshape feature nil")
            return
        end
        --瘦身瘦腿形变最大值
        local transValue = maxSlim / 100 * 3.0 --客户端滑杆为100，实际传值3.0
        feature:setIntensity("MANUAL_RESHAPE_SLIM_MAX_OFFSET", transValue)
        EffectSdk.LOG_LEVEL(5,"DORISLOG:  set slim maxValue init: "..transValue)

        --放大缩小浓度-正向
        transValue = maxHardnessPos / 100 * 3.0
        feature:setIntensity("MANUAL_RESHAPE_EXPAND_HARDNESS_POS", transValue)
        EffectSdk.LOG_LEVEL(5,"DORISLOG:  set expand hardnessPos init: "..transValue)
        --放大缩小浓度-负向
        transValue = maxHardnessNeg / 100 * 3.0
        feature:setIntensity("MANUAL_RESHAPE_EXPAND_HARDNESS_NEG", transValue)
        EffectSdk.LOG_LEVEL(5,"DORISLOG:  set expand hardnessNeg init: "..transValue)


        return true
    end,

    -- 滑竿控制大小、强度、浓度
    handleComposerUpdateNodeEvent = function(this, path, tag, percentage)

        -- EffectSdk.LOG_LEVEL(5,"DORISLOG: handleComposerUpdateNodeEvent tag: "..tag.." ,percentage: "..percentage)
        local feature = this:getFeature(featurePath)
        if not feature then
            print("manualReshape feature nil")
            return
        end
        if tag == "ManualReshape_Stretch" then
            percentage = percentage - 0.5
            feature:setIntensity("MANUAL_RESHAPE_INTENSITY_STRETCH", percentage)
        end
        if tag == "ManualReshape_Slim" then
            percentage = percentage - 0.5
            local transValue
            if percentage > 0 then
                transValue = slimPos / 200 / 0.5 * percentage
            else
                transValue = slimNeg / 200 / 0.5 * percentage
            end
            feature:setIntensity("MANUAL_RESHAPE_INTENSITY_SLIM", transValue)
        end
        if tag == "ManualReshape_Expand" then
            percentage = percentage - 0.5
            local transValue
            if percentage > 0 then
                transValue = expandPos / 200 / 0.5 * percentage
            else
                transValue = expandNeg / 200 / 0.5 * percentage
            end
            feature:setIntensity("MANUAL_RESHAPE_INTENSITY_EXPAND", transValue)
            -- EffectSdk.LOG_LEVEL(5,"DORISLOG: handleComposerUpdateNodeEvent MANUAL_RESHAPE_INTENSITY_EXPAND :" .. transValue)
        end
    end,
}
