local exports = exports or {}
local stroke_lua = stroke_lua or {}
stroke_lua.__index = stroke_lua

local AE_EFFECT_TAG = 'AE_EFFECT_TAG CutOut-Recognition'

function stroke_lua.new(construct, ...)
    local self = setmetatable({}, stroke_lua)
    if construct and stroke_lua.constructor then
        stroke_lua.constructor(self, ...)
    end
    return self
end

function stroke_lua:constructor()
end

function stroke_lua:onStrokeStart(comp, stroke, canvas)
    Amaz.LOGS(AE_EFFECT_TAG, 'onStrokeStart()')
    self.config = canvas.brushConfig
    self.blitMaterial = canvas.blitMaterial
    self.stroke = stroke
    self.resolution = stroke.resolution
    self.halfResolution = self.resolution * 0.5
    self.undoTexCache = stroke.undoTexCache
    self.redoTexCache = stroke.redoTexCache
    local entity = stroke.entity
    self.renderMaterial = self.config.brushMaterial
    local renderXshader = self.renderMaterial.xshader

    self.cacheFlag = false
    self.targetCache = Amaz.RenderTexture()
    self.targetCache.width = self.resolution.x
    self.targetCache.height = self.resolution.y
    self.renderCmd = Amaz.CommandBuffer()
    self.cacheCmd = Amaz.CommandBuffer()
    self.stModel = Amaz.Matrix4x4f():SetIdentity()
    self.cropMesh = Amaz.Mesh()
    self.block1 = Amaz.MaterialPropertyBlock()
    self.block2 = Amaz.MaterialPropertyBlock() 
    local properties = canvas.entity:getComponent("TableComponent")
    if properties then
        properties.table:set("interactive_matting_step_count", -1)
        Amaz.Algorithm.setAlgorithmParamInt("effectsdk_defaut_graph", "interactive_matting_0", "interactive_matting_reinit", 2)
    end
end

function stroke_lua:onStrokeUpdate(comp, deltaTime)
    local dirty = self.stroke.dirtyFlag
    local finished = self.stroke.finished
    if dirty == Amaz.Brush2DDirtyFlag.Increase then
        self.stroke.dirtyRect = self.stroke.boundingBox
        self.strokeBBox = self.stroke.boundingBox
        self.strokeMesh = Amaz.Mesh()
        Amaz.Brush2DUtils.alignBBoxToResolution(self.halfResolution, self.strokeBBox)
        Amaz.Brush2DUtils.generateBBoxMesh(self.strokeBBox, self.strokeMesh, true, true)
    elseif dirty == Amaz.Brush2DDirtyFlag.Undo or dirty == Amaz.Brush2DDirtyFlag.Redo then
        if not finished then
            dirty = Amaz.Brush2DDirtyFlag.Unchanged
        end
    end

    self.stroke.dirtyFlag = dirty
    self.renderCmd:clearAll()
    self.cacheCmd:clearAll()
    --self.blitMaterial:setTex("_MainTex", nil)
end

function stroke_lua:onStrokeRender(comp, target)
    local dirty = self.stroke.dirtyFlag
    if dirty == Amaz.Brush2DDirtyFlag.Unchanged and self.cacheFlag then
        return
    end

    if dirty == Amaz.Brush2DDirtyFlag.Increase then
        self.renderCmd:blit(target, self.targetCache)
        self.renderCmd:setRenderTexture(target)
        self.renderCmd:setGlobalTexture("strokeTexture", comp.properties:get("StrokeTexture"))
        self.renderCmd:drawMesh(self.strokeMesh, self.stModel, self.renderMaterial, 0, 0, nil)
        comp.entity.scene:commitCommandBuffer(self.renderCmd)
        self.stroke.finished = true
    elseif dirty == Amaz.Brush2DDirtyFlag.Undo then
        if self.undoTexCache then
            self.cacheTex = self.undoTexCache:getTexture()
            if not self.cacheTex then
                Amaz.LOGE(AE_EFFECT_TAG, 'onStrokeRender() cacheTex is invalid')
            end
        else
            Amaz.LOGE(AE_EFFECT_TAG, 'onStrokeRender() undoTexCache is invalid')
        end
    elseif dirty == Amaz.Brush2DDirtyFlag.Redo then
        if self.redoTexCache then
            self.cacheTex = self.redoTexCache:getTexture()
            if not self.cacheTex then
                Amaz.LOGE(AE_EFFECT_TAG, 'onStrokeRender() cacheTex is invalid')
            end
        else
            Amaz.LOGE(AE_EFFECT_TAG, 'onStrokeRender() redoTexCache is invalid')
        end
    elseif dirty == Amaz.Brush2DDirtyFlag.Cache then
        self.cacheTex = nil
        collectgarbage("collect")
    end
    dirty = Amaz.Brush2DDirtyFlag.Unchanged

    local finished = self.stroke.finished
    if finished then
        if not self.cacheFlag then
            Amaz.Brush2DUtils.generateBBoxMesh(self.strokeBBox, self.cropMesh, false, true)
            local cacheWidth = (self.strokeBBox.max_x - self.strokeBBox.min_x) * self.halfResolution.x
            local cacheHeight = (self.strokeBBox.max_y - self.strokeBBox.min_y) * self.halfResolution.y
            if self.undoTexCache then
                self.undoTex = Amaz.RenderTexture()
                self.undoTex.width = cacheWidth
                self.undoTex.height = cacheHeight
                self.undoTexCache:setTexture(self.undoTex)
                self.cacheCmd:setRenderTexture(self.undoTex)
                self.block1:setTexture("_MainTex",self.targetCache)
                self.cacheCmd:setGlobalTexture("_MainTex", self.targetCache)
                self.cacheCmd:drawMesh(self.cropMesh, self.stModel, self.blitMaterial, 0, 0, self.block1)
            end
            if self.redoTexCache then
                self.redoTex = Amaz.RenderTexture()
                self.redoTex.width = cacheWidth
                self.redoTex.height = cacheHeight
                self.redoTexCache:setTexture(self.redoTex)
                self.cacheCmd:setRenderTexture(self.redoTex)
                self.block2:setTexture("_MainTex",target)
                self.cacheCmd:setGlobalTexture("_MainTex", target)
                self.cacheCmd:drawMesh(self.cropMesh, self.stModel, self.blitMaterial, 0, 0, self.block2)
            end
            comp.entity.scene:commitCommandBuffer(self.cacheCmd)
            dirty = Amaz.Brush2DDirtyFlag.Cache
            self.cacheFlag = true
        elseif self.cacheTex then
            local block = Amaz.MaterialPropertyBlock()
            block:setTexture("_MainTex", self.cacheTex)
            self.renderCmd:setRenderTexture(target)
            self.renderCmd:drawMesh(self.cacheMesh, self.stModel, self.blitMaterial, 0, 0, block)
            comp.entity.scene:commitCommandBuffer(self.renderCmd)
            dirty = Amaz.Brush2DDirtyFlag.Cache
        end
    end

    self.stroke.dirtyFlag = dirty
end

function stroke_lua:onStrokeFinish()
    self.cacheMesh = Amaz.Mesh()
    Amaz.Brush2DUtils.generateBBoxMesh(self.strokeBBox, self.cacheMesh, true, false)

    self.resolution = nil
    self.config = nil
    self.targetCache = nil
    self.undoTex = nil
    self.redoTex = nil
    self.strokeMesh = nil
    self.cropMesh = nil
    self.block1=nil
    self.block2=nil
    collectgarbage("collect")
end

exports.stroke_lua = stroke_lua
return exports
