precision highp float;
varying vec2 v_texcoord;
uniform sampler2D strokeTexture;
uniform sampler2D layerTexture;
uniform vec3 colorRGB;
uniform float colorA;
uniform float threshold;
uniform int maskMode;

void main()
{
    vec4 layer = texture2D(layerTexture, v_texcoord);
    if (0 == maskMode)
    {
        vec4 simpleMask = texture2D(strokeTexture, v_texcoord);
        if (simpleMask.r > 0.0)
        {
            gl_FragColor = vec4(colorRGB, max(colorA * simpleMask.r, layer.a));
            gl_FragColor.rgb *= gl_FragColor.a;
        }
        else
        {
            gl_FragColor = layer;
        }
    }
    else
    {
        float alpha = smoothstep(threshold, 1.0 - threshold, texture2D(strokeTexture, vec2(v_texcoord.x, 1.0 - v_texcoord.y)).r);
        if (alpha > 0.0)
        {
            gl_FragColor = vec4(colorRGB, max(colorA * alpha, layer.w));
            gl_FragColor.rgb *= gl_FragColor.a;
        }
        else
        {
            gl_FragColor = layer;
        }
    }
}
