"use strict";Object.defineProperty(exports,"__esModule",{value:true});class EventHandler{constructor(){this._callbacks={};this._callbackActive={}}_addCallback(name,callback,scope,once=false){if(!name||typeof name!=="string"||!callback)return;if(!this._callbacks[name])this._callbacks[name]=[];if(this._callbackActive[name]&&this._callbackActive[name]===this._callbacks[name]){this._callbackActive[name]=this._callbackActive[name].slice()}this._callbacks[name].push({callback:callback,scope:scope||this,once:once})}on(name,callback,scope){this._addCallback(name,callback,scope,false);return this}off(name,callback,scope){if(name){if(this._callbackActive[name]&&this._callbackActive[name]===this._callbacks[name]){this._callbackActive[name]=this._callbackActive[name].slice()}}else{for(const key in this._callbackActive){if(!this._callbacks[key])continue;if(this._callbacks[key]!==this._callbackActive[key])continue;this._callbackActive[key]=this._callbackActive[key].slice()}}if(!name){this._callbacks={}}else if(!callback){if(this._callbacks[name])this._callbacks[name]=[]}else{const events=this._callbacks[name];if(!events)return this;let count=events.length;for(let i=0;i<count;i++){if(events[i].callback!==callback)continue;if(scope&&events[i].scope!==scope)continue;events[i--]=events[--count]}events.length=count}return this}fire(name,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8){if(!name||!this._callbacks[name])return this;let callbacks;if(!this._callbackActive[name]){this._callbackActive[name]=this._callbacks[name]}else{if(this._callbackActive[name]===this._callbacks[name]){this._callbackActive[name]=this._callbackActive[name].slice()}callbacks=this._callbacks[name].slice()}for(let i=0;(callbacks||this._callbackActive[name])&&i<(callbacks||this._callbackActive[name]).length;i++){const evt=(callbacks||this._callbackActive[name])[i];evt.callback.call(evt.scope,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);if(evt.once){const ind=this._callbacks[name].indexOf(evt);if(ind!==-1){if(this._callbackActive[name]===this._callbacks[name]){this._callbackActive[name]=this._callbackActive[name].slice()}this._callbacks[name].splice(ind,1)}}}if(!callbacks)this._callbackActive[name]=undefined;return this}once(name,callback,scope){this._addCallback(name,callback,scope,true);return this}hasEvent(name){return this._callbacks[name]&&this._callbacks[name].length!==0||false}}var Amaz$k=effect.Amaz;var Color$1=Amaz$k.Color;var AmazUtils;(function(AmazUtils){AmazUtils.swingTemplateUtils=new Amaz$k.SwingTemplateUtils;AmazUtils.initAmazEntity=function(entity){Object.defineProperty(entity,"transform",{get(){let trans=this.getComponent("Transform");if(!trans){trans=this.addComponent("Transform")}return trans},set(value){AmazUtils.setEntityTransform(this,value)}});Object.defineProperty(entity,"camera",{get(){let trans=this.getComponent("Camera");if(!trans){trans=this.addComponent("Camera")}return trans}})};AmazUtils.setEntityTransform=function(entity,options){let trans=entity.getComponent("Transform");if(!trans){trans=entity.addComponent("Transform")}trans.localPosition=options.position;trans.localEulerAngle=options.rotation;trans.localScale=options.scale};AmazUtils.createEntity=function(name,scene){const ent=scene.createEntity(name);AmazUtils.initAmazEntity(ent);return ent};AmazUtils.addChildEntity=function(parent,child){child.transform.parent=parent.transform;parent.transform.addTransform(child.transform)};AmazUtils.removeChildEntity=function(parent,child){parent.transform.removeTransform(child.transform)};AmazUtils.getRenderers=function(rootEntity){const renderers=new Amaz$k.Vector;if(null!==rootEntity){const renderersTmp=rootEntity.getComponentsRecursive("Renderer");if(!renderersTmp.empty()){const size=renderersTmp.size();for(let i=0;i<size;i++){renderers.pushBack(renderersTmp.get(i))}}}return renderers};AmazUtils.CastJsonArray4fToAmazVector4f=function(jsonArray){let result=null;if(jsonArray instanceof Array&&jsonArray.length===4){result=new Amaz$k.Vector4f(jsonArray[0],jsonArray[1],jsonArray[2],jsonArray[3])}return result};AmazUtils.CastJsonArray3fToAmazVector3f=function(jsonArray){let result=null;if(jsonArray instanceof Array&&jsonArray.length===3){result=new Amaz$k.Vector3f(jsonArray[0],jsonArray[1],jsonArray[2])}return result};AmazUtils.CastJsonArray2fToAmazVector2f=function(jsonArray){let result=null;if(jsonArray instanceof Array&&jsonArray.length===2){result=new Amaz$k.Vector2f(jsonArray[0],jsonArray[1])}return result};AmazUtils.CastJsonArrayToAmazVector=function(jsonArray){const result=new Amaz$k.Vector;if(jsonArray instanceof Array){for(let i=0;i<jsonArray.length;i++){const jsonValue=jsonArray[i];result.pushBack(jsonValue)}}return result};AmazUtils.CastJsonArray4fToColor=function(jsonArray){let result=null;if(jsonArray instanceof Array&&jsonArray.length===4){result=new Color$1(jsonArray[0],jsonArray[1],jsonArray[2],jsonArray[3])}return result};AmazUtils.CreateQuadMesh=function(){const fv=new Amaz$k.FloatVector;const ary=new Amaz$k.UInt16Vector;fv.pushBack(-1);fv.pushBack(-1);fv.pushBack(0);fv.pushBack(0);fv.pushBack(0);fv.pushBack(1);fv.pushBack(-1);fv.pushBack(0);fv.pushBack(1);fv.pushBack(0);fv.pushBack(1);fv.pushBack(1);fv.pushBack(0);fv.pushBack(1);fv.pushBack(1);fv.pushBack(-1);fv.pushBack(1);fv.pushBack(0);fv.pushBack(0);fv.pushBack(1);const quadMesh=new Amaz$k.Mesh;quadMesh.clearAfterUpload=true;quadMesh.vertices=fv;const posDesc=new Amaz$k.VertexAttribDesc;posDesc.semantic=Amaz$k.VertexAttribType.POSITION;const uvDesc=new Amaz$k.VertexAttribDesc;uvDesc.semantic=Amaz$k.VertexAttribType.TEXCOORD0;const vads=new Amaz$k.Vector;vads.pushBack(posDesc);vads.pushBack(uvDesc);quadMesh.vertexAttribs=vads;const aabb=new Amaz$k.AABB;aabb.min_x=-1;aabb.min_y=-1;aabb.min_z=0;aabb.max_x=1;aabb.max_y=1;aabb.max_z=0;quadMesh.boundingBox=aabb;const subMesh=new Amaz$k.SubMesh;ary.pushBack(0);ary.pushBack(1);ary.pushBack(2);ary.pushBack(3);subMesh.indices16=ary;subMesh.primitive=Amaz$k.Primitive.TRIANGLE_FAN;subMesh.boundingBox=aabb;quadMesh.addSubMesh(subMesh);return quadMesh};AmazUtils.TextWordMatchUtils=new Amaz$k.TextWordMatchUtils})(AmazUtils||(AmazUtils={}));var AmazUtils$1=AmazUtils;class TimeRange{constructor(startTime=0,duration=0){this.startTime=startTime;this.duration=duration}get endTime(){return this.startTime+this.duration}set endTime(endTime){if(this.endTime!=endTime){this.duration=endTime-this.startTime}}}const TIME_EPS=1e-5;const CUBIC_BEZIER_EPSILON=.001;const KEYFRAME_TIME_FACTOR=1e-6;const DEFAULT_FONT_SIZE=12;const TEMPLATE_TAG="AMAZINGTEMPLATE";function isJson(str){return str.length>=2&&str.charAt(0)=="{"}function deepCopy(obj){return JSON.parse(JSON.stringify(obj))}function getRelativeTime(start,end,anim_start,anim_end,time){const percent=(time-anim_start)/(anim_end-anim_start);return percent*(end-start)+start}class Group{constructor(){this._tweens={};this._tweensAddedDuringUpdate={}}getAll(){return Object.keys(this._tweens).map((tweenId=>this._tweens[tweenId]))}removeAll(){this._tweens={}}add(tween){this._tweens[tween.getId()]=tween;this._tweensAddedDuringUpdate[tween.getId()]=tween}remove(tween){delete this._tweens[tween.getId()];delete this._tweensAddedDuringUpdate[tween.getId()]}update(time=0,preserve=false,updateContext=null){let tweenIds=Object.keys(this._tweens);if(tweenIds.length===0){return false}let TIME_MATCHING_MODE;(function(TIME_MATCHING_MODE){TIME_MATCHING_MODE[TIME_MATCHING_MODE["ONCE"]=1]="ONCE";TIME_MATCHING_MODE[TIME_MATCHING_MODE["IN"]=2]="IN";TIME_MATCHING_MODE[TIME_MATCHING_MODE["OUT"]=3]="OUT";TIME_MATCHING_MODE[TIME_MATCHING_MODE["LOOP"]=4]="LOOP"})(TIME_MATCHING_MODE||(TIME_MATCHING_MODE={}));const WORD_COUNT_THRESHOLD=2;while(tweenIds.length>0){this._tweensAddedDuringUpdate={};for(let i=0;i<tweenIds.length;i++){const tween=this._tweens[tweenIds[i]];const autoStart=!preserve;let convertedTime=time;if(updateContext!=null){const timeMatchingMode=updateContext.wordCount>WORD_COUNT_THRESHOLD?TIME_MATCHING_MODE.IN:TIME_MATCHING_MODE.ONCE;if(timeMatchingMode==TIME_MATCHING_MODE.ONCE)convertedTime=getRelativeTime(tween.getStartTime(),tween.getEndTime(),updateContext.targetStart,updateContext.targetEnd,time);else if(timeMatchingMode==TIME_MATCHING_MODE.IN)convertedTime=time-updateContext.targetStart}if(tween&&tween.update(convertedTime,autoStart)===false&&!preserve){delete this._tweens[tweenIds[i]]}}tweenIds=Object.keys(this._tweensAddedDuringUpdate)}return true}}const Interpolation={Linear:function(v,k){const m=v.length-1;const f=m*k;const i=Math.floor(f);const fn=Interpolation.Utils.Linear;if(k<0){return fn(v[0],v[1],f)}if(k>1){return fn(v[m],v[m-1],m-f)}return fn(v[i],v[i+1>m?m:i+1],f-i)},Bezier:function(v,k){let b=0;const n=v.length-1;const pw=Math.pow;const bn=Interpolation.Utils.Bernstein;for(let i=0;i<=n;i++){b+=pw(1-k,n-i)*pw(k,i)*v[i]*bn(n,i)}return b},CatmullRom:function(v,k){const m=v.length-1;let f=m*k;let i=Math.floor(f);const fn=Interpolation.Utils.CatmullRom;if(v[0]===v[m]){if(k<0){i=Math.floor(f=m*(1+k))}return fn(v[(i-1+m)%m],v[i],v[(i+1)%m],v[(i+2)%m],f-i)}else{if(k<0){return v[0]-(fn(v[0],v[0],v[1],v[1],-f)-v[0])}if(k>1){return v[m]-(fn(v[m],v[m],v[m-1],v[m-1],f-m)-v[m])}return fn(v[i?i-1:0],v[i],v[m<i+1?m:i+1],v[m<i+2?m:i+2],f-i)}},Utils:{Linear:function(p0,p1,t){return(p1-p0)*t+p0},Bernstein:function(n,i){const fc=Interpolation.Utils.Factorial;return fc(n)/fc(i)/fc(n-i)},Factorial:function(){const a=[1];return function(n){let s=1;if(a[n]){return a[n]}for(let i=n;i>1;i--){s*=i}a[n]=s;return s}}(),CatmullRom:function(p0,p1,p2,p3,t){const v0=(p2-p0)*.5;const v1=(p3-p1)*.5;const t2=t*t;const t3=t*t2;return(2*p1-2*p2+v0+v1)*t3+(-3*p1+3*p2-2*v0-v1)*t2+v0*t+p1}}};const Easing=Object.freeze({Linear:Object.freeze({None(amount){return amount},In(amount){return this.None(amount)},Out(amount){return this.None(amount)},InOut(amount){return this.None(amount)}}),Quadratic:Object.freeze({In(amount){return amount*amount},Out(amount){return amount*(2-amount)},InOut(amount){if((amount*=2)<1){return.5*amount*amount}return-.5*(--amount*(amount-2)-1)}}),Cubic:Object.freeze({In(amount){return amount*amount*amount},Out(amount){return--amount*amount*amount+1},InOut(amount){if((amount*=2)<1){return.5*amount*amount*amount}return.5*((amount-=2)*amount*amount+2)}}),Quartic:Object.freeze({In(amount){return amount*amount*amount*amount},Out(amount){return 1- --amount*amount*amount*amount},InOut(amount){if((amount*=2)<1){return.5*amount*amount*amount*amount}return-.5*((amount-=2)*amount*amount*amount-2)}}),Quintic:Object.freeze({In(amount){return amount*amount*amount*amount*amount},Out(amount){return--amount*amount*amount*amount*amount+1},InOut(amount){if((amount*=2)<1){return.5*amount*amount*amount*amount*amount}return.5*((amount-=2)*amount*amount*amount*amount+2)}}),Sinusoidal:Object.freeze({In(amount){return 1-Math.sin((1-amount)*Math.PI/2)},Out(amount){return Math.sin(amount*Math.PI/2)},InOut(amount){return.5*(1-Math.sin(Math.PI*(.5-amount)))}}),Exponential:Object.freeze({In(amount){return amount===0?0:Math.pow(1024,amount-1)},Out(amount){return amount===1?1:1-Math.pow(2,-10*amount)},InOut(amount){if(amount===0){return 0}if(amount===1){return 1}if((amount*=2)<1){return.5*Math.pow(1024,amount-1)}return.5*(-Math.pow(2,-10*(amount-1))+2)}}),Circular:Object.freeze({In(amount){return 1-Math.sqrt(1-amount*amount)},Out(amount){return Math.sqrt(1- --amount*amount)},InOut(amount){if((amount*=2)<1){return-.5*(Math.sqrt(1-amount*amount)-1)}return.5*(Math.sqrt(1-(amount-=2)*amount)+1)}}),Elastic:Object.freeze({In(amount){if(amount===0){return 0}if(amount===1){return 1}return-Math.pow(2,10*(amount-1))*Math.sin((amount-1.1)*5*Math.PI)},Out(amount){if(amount===0){return 0}if(amount===1){return 1}return Math.pow(2,-10*amount)*Math.sin((amount-.1)*5*Math.PI)+1},InOut(amount){if(amount===0){return 0}if(amount===1){return 1}amount*=2;if(amount<1){return-.5*Math.pow(2,10*(amount-1))*Math.sin((amount-1.1)*5*Math.PI)}return.5*Math.pow(2,-10*(amount-1))*Math.sin((amount-1.1)*5*Math.PI)+1}}),Back:Object.freeze({In(amount){const s=1.70158;return amount===1?1:amount*amount*((s+1)*amount-s)},Out(amount){const s=1.70158;return amount===0?0:--amount*amount*((s+1)*amount+s)+1},InOut(amount){const s=1.70158*1.525;if((amount*=2)<1){return.5*(amount*amount*((s+1)*amount-s))}return.5*((amount-=2)*amount*((s+1)*amount+s)+2)}}),Bounce:Object.freeze({In(amount){return 1-Easing.Bounce.Out(1-amount)},Out(amount){if(amount<1/2.75){return 7.5625*amount*amount}else if(amount<2/2.75){return 7.5625*(amount-=1.5/2.75)*amount+.75}else if(amount<2.5/2.75){return 7.5625*(amount-=2.25/2.75)*amount+.9375}else{return 7.5625*(amount-=2.625/2.75)*amount+.984375}},InOut(amount){if(amount<.5){return Easing.Bounce.In(amount*2)*.5}return Easing.Bounce.Out(amount*2-1)*.5+.5}}),generatePow(power=4){power=power<Number.EPSILON?Number.EPSILON:power;power=power>1e4?1e4:power;return{In(amount){return Math.pow(amount,power)},Out(amount){return 1-Math.pow(1-amount,power)},InOut(amount){if(amount<.5){return Math.pow(amount*2,power)/2}return(1-Math.pow(2-amount*2,power))/2+.5}}}});const mainGroup=new Group;class Sequence{static nextId(){return Sequence._nextId++}}Sequence._nextId=0;var Amaz$j=effect.Amaz;function bezier_3(t,p0,p1,p2,p3){const it=1-t;return p0*it*it*it+3*p1*t*it*it+3*p2*t*t*it+p3*t*t*t}class ColorRGBA{constructor(r,g,b,a){this.r=0;this.g=0;this.b=0;this.a=0;this.r=r;this.g=g;this.b=b;this.a=a}static normalizedToByte(f){f=Math.max(f,0);f=Math.min(f,1);return Math.floor(f*255+.5)}static RGB2HSV(c){const r=ColorRGBA.normalizedToByte(c.r);const g=ColorRGBA.normalizedToByte(c.g);const b=ColorRGBA.normalizedToByte(c.b);const a=ColorRGBA.normalizedToByte(c.a);const max=Math.max(Math.max(r,g),b);const min=Math.min(Math.min(r,g),b);const v=max/255;const s=max==0?0:(max-min)/max;let h=0;if(max==min){h=0}else if(max==r&&g>=b){h=(g-b)*60/(max-min)+0}else if(max==r&&g<b){h=(g-b)*60/(max-min)+360}else if(max==g){h=(b-r)*60/(max-min)+120}else if(max==b){h=(r-g)*60/(max-min)+240}return new Amaz$j.Vector4f(h,s,v,a/255)}static HSV2RGB(hsv){const h=hsv.x;const s=hsv.y;const v=hsv.z;let r=0,g=0,b=0;const i=Math.floor(h/60%6);const f=h/60-i;const p=v*(1-s);const q=v*(1-f*s);const t=v*(1-(1-f)*s);switch(i){case 0:r=v;g=t;b=p;break;case 1:r=q;g=v;b=p;break;case 2:r=p;g=v;b=t;break;case 3:r=p;g=q;b=v;break;case 4:r=t;g=p;b=v;break;case 5:r=v;g=p;b=q;break}return new ColorRGBA(Math.floor(r*255)/255,Math.floor(g*255)/255,Math.floor(b*255)/255,Math.floor(hsv.w*255)/255)}static castJsonArray4fToColorRGBA(jsonArray){let result=null;if(jsonArray instanceof Array&&jsonArray.length===4){result=new ColorRGBA(jsonArray[0],jsonArray[1],jsonArray[2],jsonArray[3])}return result}add(otherColor){return new ColorRGBA(this.r+otherColor.r,this.g+otherColor.g,this.b+otherColor.b,this.a+otherColor.a)}}var Amaz$i=effect.Amaz;class BezierInfo{constructor(isCubic,p0,p1,p2,p3){this.isCubic=false;this.isCubic=isCubic;this.p0=p0;this.p1=p1;this.p2=p2;this.p3=p3}}class Motion{constructor(_object,_isCubic=false,_group=mainGroup){this._object=_object;this._isCubic=_isCubic;this._group=_group;this._isPaused=false;this._pauseStart=0;this._valuesStart={};this._valuesEnd=[];this._valuesStartRepeat={};this._duration=[];this._isDynamic=false;this._initialRepeat=0;this._repeat=0;this._yoyo=false;this._isPlaying=false;this._reversed=false;this._delayTime=0;this._startTime=0;this._easingFunction=Easing.Linear.None;this._interpolationFunction=Interpolation.Linear;this._chainedMotions=[];this._onStartCallbackFired=false;this._onEveryStartCallbackFired=false;this._id=Sequence.nextId();this._isChainStopped=false;this._propertiesAreSetUp=false;this._goToEnd=false}setBezierInfo(p0,p1,p2,p3){this._bezierInfo=[new BezierInfo(this._isCubic,p0,p1,p2,p3)];return this}getObject(){return this._object}getId(){return this._id}setId(id){this._id=id}isPlaying(){return this._isPlaying}isPaused(){return this._isPaused}to(target,duration=1e3){if(this._isPlaying)throw new Error("Can not call Motion.to() while Motion is already started or paused. Stop the Motion first.");this._valuesEnd=[target];this._propertiesAreSetUp=false;this._duration=[duration];return this}getKeyFrameCount(){return this._valuesEnd.length}getStartTime(){return this._startTime}getEndTime(){let t=this._startTime;for(let i=0;i<this._duration.length;i++)t+=this._duration[i];return t}seekTo(target,duration,bezierInfo,easingFunction){if(this._isPlaying)throw new Error("Can not call Motion.seekTo() while Motion is already started or paused. Stop the Motion first.");if(target.length!=duration.length)throw new Error("Can not call Motion.seekTo() because the length of target and duration not matching.");if(target.length!=bezierInfo.length)throw new Error("Can not call Motion.seekTo() because the length of target and bezierInfo not matching.");this._valuesEnd=target;this._propertiesAreSetUp=false;this._duration=duration;this._bezierInfo=bezierInfo;this._easingFunctionList=easingFunction;return this}duration(duration){this._duration.fill(duration);return this}durationAll(duration){if(this._duration.length!=duration.length){throw new Error("Can not call Motion.durationAll() because the length of duration is not matching.")}this._duration=duration;return this}dynamic(dynamic=false){this._isDynamic=dynamic;return this}start(time=0,overrideStartingValues=false){if(this._isPlaying){return this}this._group&&this._group.add(this);this._repeat=this._initialRepeat;if(this._reversed){this._reversed=false;for(const property in this._valuesStartRepeat){this._swapEndStartRepeatValues(property);this._valuesStart[property]=this._valuesStartRepeat[property]}}this._isPlaying=true;this._isPaused=false;this._onStartCallbackFired=false;this._onEveryStartCallbackFired=false;this._isChainStopped=false;this._startTime=time;this._startTime+=this._delayTime;if(!this._propertiesAreSetUp||overrideStartingValues){this._propertiesAreSetUp=true;if(!this._isDynamic){const tmp=[];for(const obj of this._valuesEnd){const transformedObj={};for(const prop in obj){transformedObj[prop]=obj[prop]}tmp.push(transformedObj)}this._valuesEnd=tmp}for(let i=0;i<this._valuesEnd.length;i++){this._setupProperties(this._object,this._valuesStart,this._valuesEnd[i],this._valuesStartRepeat,overrideStartingValues)}}return this}startFromCurrentValues(time){return this.start(time,true)}_setupProperties(_object,_valuesStart,_valuesEnd,_valuesStartRepeat,overrideStartingValues){for(const property in _valuesEnd){const startValue=_object[property];const startValueIsArray=Array.isArray(startValue);const propType=startValueIsArray?"array":typeof startValue;let isInterpolationList=!startValueIsArray&&Array.isArray(_valuesEnd[property]);if(propType==="undefined"||propType==="function"){continue}if(isInterpolationList){const endValues=_valuesEnd[property];if(endValues.length===0){continue}const temp=[];for(let i=0,l=endValues.length;i<l;i+=1){const value=this._handleRelativeValue(startValue,endValues[i]);if(!(value instanceof ColorRGBA)&&!Array.isArray(value)&&isNaN(value)){isInterpolationList=false;console.warn("Found invalid interpolation list. Skipping.");break}temp.push(value)}if(isInterpolationList){_valuesEnd[property]=temp}}if(typeof _valuesStart[property]==="undefined"||overrideStartingValues){_valuesStart[property]=startValue}if(isInterpolationList){_valuesStartRepeat[property]=_valuesEnd[property].slice().reverse()}else{_valuesStartRepeat[property]=_valuesStart[property]||0}}}stop(){if(!this._isChainStopped){this._isChainStopped=true;this.stopChainedMotions()}if(!this._isPlaying){return this}this._group&&this._group.remove(this);this._isPlaying=false;this._isPaused=false;if(this._onStopCallback){this._onStopCallback(this._object)}return this}end(){this._goToEnd=true;this.update(Infinity);return this}pause(time=0){if(this._isPaused||!this._isPlaying){return this}this._isPaused=true;this._pauseStart=time;this._group&&this._group.remove(this);return this}resume(time=0){if(!this._isPaused||!this._isPlaying){return this}this._isPaused=false;this._startTime+=time-this._pauseStart;this._pauseStart=0;this._group&&this._group.add(this);return this}stopChainedMotions(){for(let i=0,numChainedMotions=this._chainedMotions.length;i<numChainedMotions;i++){this._chainedMotions[i].stop()}return this}group(group=mainGroup){this._group=group;return this}delay(amount=0){this._delayTime=amount;return this}repeat(times=0){this._initialRepeat=times;this._repeat=times;return this}repeatDelay(amount){this._repeatDelayTime=amount;return this}yoyo(yoyo=false){this._yoyo=yoyo;return this}easing(easingFunction=Easing.Linear.None){this._easingFunction=easingFunction;return this}interpolation(interpolationFunction=Interpolation.Linear){this._interpolationFunction=interpolationFunction;return this}chain(...motions){this._chainedMotions=motions;return this}onStart(callback){this._onStartCallback=callback;return this}onEveryStart(callback){this._onEveryStartCallback=callback;return this}onUpdate(callback){this._onUpdateCallback=callback;return this}onRepeat(callback){this._onRepeatCallback=callback;return this}onComplete(callback){this._onCompleteCallback=callback;return this}onStop(callback){this._onStopCallback=callback;return this}update(time=0,autoStart=true){var _a,_b,_c,_d,_e,_f;if(this._isPaused)return true;let accumulate=0;let i=0;const dis=time-this._startTime;for(i;i<this._duration.length;i++){accumulate+=this._duration[i];if(accumulate>=dis){break}}if(i==this._duration.length){i--}const duration=this._duration[i];const startTime=this._startTime+accumulate-duration;let property;let elapsed;const endTime=startTime+duration;if(!this._goToEnd&&!this._isPlaying){if(time>endTime){return false}if(autoStart){this.start(time,true)}}this._goToEnd=false;if(time-this._startTime<-1*KEYFRAME_TIME_FACTOR){return true}if(this._onStartCallbackFired===false){if(this._onStartCallback){this._onStartCallback(this._object)}this._onStartCallbackFired=true}if(this._onEveryStartCallbackFired===false){if(this._onEveryStartCallback){this._onEveryStartCallback(this._object)}this._onEveryStartCallbackFired=true}elapsed=(time-startTime)/duration;elapsed=duration===0||elapsed>1?1:elapsed;let value;if(((_a=this._easingFunctionList)===null||_a===void 0?void 0:_a[i])!=undefined){value=(_b=this._easingFunctionList)===null||_b===void 0?void 0:_b[i](elapsed)}else{value=this._easingFunction(elapsed)}if(i>0&&((_c=this._bezierInfo)===null||_c===void 0?void 0:_c[i])!=undefined){this._updateProperties(this._object,this._valuesEnd[i-1],this._valuesEnd[i],value,(_d=this._bezierInfo)===null||_d===void 0?void 0:_d[i])}else if(((_e=this._bezierInfo)===null||_e===void 0?void 0:_e[i])!=undefined){this._updateProperties(this._object,this._valuesStart,this._valuesEnd[i],value,(_f=this._bezierInfo)===null||_f===void 0?void 0:_f[i])}if(this._onUpdateCallback){this._onUpdateCallback(this._object,elapsed)}if(i<this._duration.length-1){return true}if(elapsed===1){if(this._repeat>0){if(isFinite(this._repeat)){this._repeat--}for(property in this._valuesStartRepeat){if(!this._yoyo&&typeof this._valuesEnd[i][property]==="string"){this._valuesStartRepeat[property]=this._valuesStartRepeat[property]+parseFloat(this._valuesEnd[i][property])}if(this._yoyo){this._swapEndStartRepeatValues(property)}this._valuesStart[property]=this._valuesStartRepeat[property]}if(this._yoyo){this._reversed=!this._reversed}if(this._repeatDelayTime!==undefined){this._startTime=time+this._repeatDelayTime}else{this._startTime=time+this._delayTime}if(this._onRepeatCallback){this._onRepeatCallback(this._object)}this._onEveryStartCallbackFired=false;return true}else{if(this._onCompleteCallback){this._onCompleteCallback(this._object)}for(let j=0,numChainedMotions=this._chainedMotions.length;j<numChainedMotions;j++){this._chainedMotions[j].start(this._startTime+duration,false)}this._isPlaying=false;return false}}return true}_updateProperties(_object,_valuesStart,_valuesEnd,value,bezierInfo){for(const property in _valuesEnd){if(_valuesStart[property]===undefined){continue}const start=_valuesStart[property]||0;let end=_valuesEnd[property];const startIsArray=Array.isArray(_object[property]);const endIsArray=Array.isArray(end);const isInterpolationList=!startIsArray&&endIsArray;if(isInterpolationList){_object[property]=this._interpolationFunction(end,value)}else if(typeof end==="object"&&end&&!(end instanceof ColorRGBA)&&!(end instanceof Array)){this._updateProperties(_object[property],start,end,value)}else{if(typeof start==="number"&&(end instanceof String||typeof end==="number")){end=this._handleRelativeValue(start,end)}if(typeof end==="number"){_object[property]=this.numberInterpolate(value,bezierInfo)}else if(end instanceof ColorRGBA){_object[property]=this.colorInterpolate(value,bezierInfo)}else if(end instanceof Array){_object[property]=this.vectorInterpolate(value,bezierInfo)}else if(typeof end==="string"||typeof end==="boolean"){_object[property]=this.discreteInterpolate(value,bezierInfo)}else{console.warn("Motion object property has something wrong")}}}}_handleRelativeValue(start,end){if(typeof end!=="string"){return end}if(end.charAt(0)==="+"||end.charAt(0)==="-"){return start+parseFloat(end)}return parseFloat(end)}_swapEndStartRepeatValues(property){const tmp=this._valuesStartRepeat[property];for(let i=0;i<this._valuesEnd.length;i++){const endValue=this._valuesEnd[i][property];if(typeof endValue==="string"){this._valuesStartRepeat[property]=this._valuesStartRepeat[property]+parseFloat(endValue)}else{this._valuesStartRepeat[property]=this._valuesEnd[i][property]}this._valuesEnd[i][property]=tmp}}colorInterpolate(value,bezierInfo){const p0=bezierInfo.p0;const p3=bezierInfo.p3;const lhsv=ColorRGBA.RGB2HSV(new ColorRGBA(p0.r,p0.g,p0.b,1));const rhsv=ColorRGBA.RGB2HSV(new ColorRGBA(p3.r,p3.g,p3.b,1));if(!bezierInfo.isCubic){const t=value;if(Math.abs(lhsv.x-rhsv.x)>180){if(lhsv.x<rhsv.x)rhsv.x-=360;else lhsv.x-=360}const hsv=new Amaz$i.Vector4f(lhsv.x+(rhsv.x-lhsv.x)*t,lhsv.y+(rhsv.y-lhsv.y)*t,lhsv.z+(rhsv.z-lhsv.z)*t,lhsv.w+(rhsv.w-lhsv.w)*t);if(hsv.x<0){hsv.x+=360}const res=ColorRGBA.HSV2RGB(hsv);return[res.r,res.g,res.b,res.a]}const p1=bezierInfo.p1;const p2=bezierInfo.p2;const lctrl=ColorRGBA.RGB2HSV(new ColorRGBA(p1.r,p1.g,p1.b,1));const rctrl=ColorRGBA.RGB2HSV(new ColorRGBA(p2.r,p2.g,p2.b,1));if(Math.abs(lhsv.x-rhsv.x)>180){if(lhsv.x<rhsv.x){rhsv.x-=360;rctrl.x-=360}else{lhsv.x-=360;lctrl.x-=360}}const hsv=new Amaz$i.Vector4f(bezier_3(value,lhsv.x,lctrl.x,rctrl.x,rhsv.x),bezier_3(value,lhsv.y,lctrl.y,rctrl.y,rhsv.y),bezier_3(value,lhsv.z,lctrl.z,rctrl.z,rhsv.z),bezier_3(value,lhsv.w,lctrl.w,rctrl.w,rhsv.w));if(hsv.x<0){hsv.x+=360}const res=ColorRGBA.HSV2RGB(hsv);return[res.r,res.g,res.b,res.a]}numberInterpolate(value,bezierInfo){const p0=bezierInfo.p0;const p1=bezierInfo.p1;const p2=bezierInfo.p2;const p3=bezierInfo.p3;if(bezierInfo.isCubic&&bezierInfo.p0!=undefined){return bezier_3(value,p0,p1,p2,p3)}else{return p0+(p3-p0)*value}}vectorInterpolate(value,bezierInfo){const p0=bezierInfo.p0;const p1=bezierInfo.p1;const p2=bezierInfo.p2;const p3=bezierInfo.p3;const item=p0[0];const length=p0.length;const result=[];if(item instanceof Array){for(let i=0;i<length;i++){const p0Item=ColorRGBA.castJsonArray4fToColorRGBA(p0[i]);const p1Item=ColorRGBA.castJsonArray4fToColorRGBA(p1[i]);const p2Item=ColorRGBA.castJsonArray4fToColorRGBA(p2[i]);const p3Item=ColorRGBA.castJsonArray4fToColorRGBA(p3[i]);if(p0Item&&p1Item&&p2Item&&p3Item){const res=this.colorInterpolate(value,new BezierInfo(bezierInfo.isCubic,p0Item,p2Item,p1Item,p3Item));result.push(res)}}}else if(typeof item==="number"){for(let i=0;i<length;i++){result.push(this.numberInterpolate(value,new BezierInfo(bezierInfo.isCubic,p0[i],p1[i],p2[i],p3[i])))}}return result}discreteInterpolate(value,bezierInfo){if(value>=.5){return bezierInfo.p3}else{return bezierInfo.p0}}}let IDX=-1;const ColorNames=["tc","bc","sc","oc","tbc"];class keyframeUnitInfo{constructor(v,t,it){this.m_v=v;this.m_t=t;this.m_it=it;this.m_vti=0;this.m_vto=0;this.m_vi=v;this.m_vo=v}}class KeyframeAttrUtils{static getWordConvertedTime(word_start,word_end,anim_start,anim_end,time,delay){const percent=(time-anim_start)/(anim_end-anim_start);return percent*(word_end-word_start)+delay}static getRelativeTime(startTimeDst,endTimeDst,startTimeSrc,endTimeSrc,time){const percent=(time-startTimeSrc)/(endTimeSrc-startTimeSrc);return percent*(endTimeDst-startTimeDst)+startTimeDst}static cubicBezier(x,tvOld,tvNew){const vto=1*tvOld.m_vto/(tvNew.m_t-tvOld.m_t);const vti=1*tvNew.m_vti/(tvNew.m_t-tvOld.m_t)+1;const p1=[vto,0];const p2=[vti,1];const a=1-3*p2[0]+3*p1[0];const b=3*p2[0]-6*p1[0];const c=3*p1[0];if(x<0||Math.abs(x)<TIME_EPS){return 0}if(x>1||Math.abs(x-1)<TIME_EPS){return 1}let t2=x;for(let i=0;i<8;i++){const x2=((a*t2+b)*t2+c)*t2-x;if(Math.abs(x2)<CUBIC_BEZIER_EPSILON){return t2}const d2=(a*3*t2+b*2)*t2+c;if(Math.abs(d2)<TIME_EPS){break}t2=Math.max(0,Math.min(1,t2-x2/d2))}let t0=0;let t1=1;while(t0<t1&&Math.abs(t1-t0)>TIME_EPS){const t2=(t1-t0)*.5+t0;const x2=((a*t2+b)*t2+c)*t2;if(Math.abs(x2-x)<CUBIC_BEZIER_EPSILON)return t2;if(x>x2)t0=t2;else t1=t2}if(t2>1){t2=1}return t2}static createOneMotion(keyframes,updateFunc,_interp,motionContext,isFirst,group,propertyName){if(isFirst){++IDX}const motion=new Motion({v:keyframes[0].m_v,motionContext:motionContext,idx:IDX,propertyName:propertyName},false,group).onUpdate(updateFunc);motion.interpolation(Interpolation.Linear);motion.easing(Easing.Linear.None);if(isFirst&&keyframes[0].m_t>0)motion===null||motion===void 0?void 0:motion.delay(keyframes[0].m_t);const toList=[];const durationList=[];const bezierInfo=[];const easingList=[];for(let i=1;i<keyframes.length;i++){toList.push({v:keyframes[i].m_v});durationList.push(keyframes[i].m_t-keyframes[i-1].m_t);let isCubic=false;let easing=Easing.Linear.None;if(keyframes[i-1].m_it==="cubic"||keyframes[i].m_it==="cubic"){isCubic=true;easing=t=>KeyframeAttrUtils.cubicBezier(t,keyframes[i-1],keyframes[i])}bezierInfo.push(new BezierInfo(isCubic,keyframes[i-1].m_v,keyframes[i-1].m_vo,keyframes[i].m_vi,keyframes[i].m_v));easingList.push(easing)}motion===null||motion===void 0?void 0:motion.seekTo(toList,durationList,bezierInfo,easingList);return motion}static createKeyframes(keyframeJson,propertyName){const prop=keyframeJson.k[propertyName];const keyframes=[];{const t=0;let v=prop[0].v;if(prop[0].v instanceof Array&&prop[0].v.length===4){v=ColorRGBA.castJsonArray4fToColorRGBA(prop[0].v)}keyframes.push(new keyframeUnitInfo(v,t,prop[0].it))}for(let i=0;i<prop.length;i++){const t=prop[i].t;let v=prop[i].v;if(prop[i].v instanceof Array&&prop[i].v.length===4&&ColorNames.includes(propertyName)){v=ColorRGBA.castJsonArray4fToColorRGBA(prop[i].v)}const keyframeUnit=new keyframeUnitInfo(v,prop[i].t,prop[i].it);if(keyframeUnit.m_it==="cubic"){keyframeUnit.m_vti=prop[i].vti;keyframeUnit.m_vto=prop[i].vto;if(ColorNames.includes(propertyName)){const colorV=ColorRGBA.castJsonArray4fToColorRGBA(prop[i].v);const colorVi=ColorRGBA.castJsonArray4fToColorRGBA(prop[i].vi);const colorV0=ColorRGBA.castJsonArray4fToColorRGBA(prop[i].v0);if(null!==colorV&&null!==colorVi&&null!==colorV0){keyframeUnit.m_vi=colorV.add(colorVi);keyframeUnit.m_vo=colorV.add(colorV0)}}else{keyframeUnit.m_vi=prop[i].v+prop[i].vi;keyframeUnit.m_vo=prop[i].v+prop[i].vo}}if(t-keyframes[keyframes.length-1].m_t>TIME_EPS){keyframes.push(keyframeUnit)}}{const t=keyframeJson.e;if(t-keyframes[keyframes.length-1].m_t>TIME_EPS){let v=prop[prop.length-1].v;if(prop[prop.length-1].v instanceof Array&&prop[prop.length-1].v.length===4){v=ColorRGBA.castJsonArray4fToColorRGBA(prop[prop.length-1].v)}keyframes.push(new keyframeUnitInfo(v,t,prop[prop.length-1].it))}}return keyframes}static createOneMotionByRelativeTime(keyframes,updateFunc,interpolationFunc,motionContext,group,propertyName,startTimeDst,endTimeDst,startTimeSrc,endTimeSrc){const convertedTimes=[];for(let i=0;i<keyframes.length;i++){convertedTimes.push(KeyframeAttrUtils.getRelativeTime(startTimeDst,endTimeDst,startTimeSrc,endTimeSrc,keyframes[i].m_t))}const motion=new Motion({v:keyframes[0].m_v,motionContext:motionContext,propertyName:propertyName},false,group).onUpdate(updateFunc).interpolation(interpolationFunc).easing(Easing.Linear.None).delay(convertedTimes[0]);const toList=[];const durationList=[];const bezierInfo=[];const easingList=[];for(let i=1;i<keyframes.length;i++){toList.push({v:keyframes[i].m_v});durationList.push(convertedTimes[i]-convertedTimes[i-1]);let isCubic=false;let easing=Easing.Linear.None;if(keyframes[i-1].m_it==="cubic"||keyframes[i].m_it==="cubic"){isCubic=true;easing=t=>KeyframeAttrUtils.cubicBezier(t,keyframes[i-1],keyframes[i])}bezierInfo.push(new BezierInfo(isCubic,keyframes[i-1].m_v,keyframes[i-1].m_vo,keyframes[i].m_vi,keyframes[i].m_v));easingList.push(easing)}motion===null||motion===void 0?void 0:motion.seekTo(toList,durationList,bezierInfo,easingList);return motion}static isPostGroup(propertyName){const postGroupProperties=["sx","sy","px","py","rz"];return postGroupProperties.includes(propertyName)}static sortFn(obj1,obj2,keyLists){const index1=keyLists.findIndex((e=>e[0]===obj1.getObject().propertyName));const index2=keyLists.findIndex((e=>e[0]===obj2.getObject().propertyName));if(index1<0||index2<0)return 0;else return index1-index2}static sortKeyframesByAttributeSetter(group,attributeSetter){if(Object.prototype.hasOwnProperty.call(attributeSetter,"setterMap")){const motions=group.getAll();if(motions.length>1){const keyLists=Object.entries(attributeSetter.setterMap);motions.sort(((obj1,obj2)=>KeyframeAttrUtils.sortFn(obj1,obj2,keyLists)));group.removeAll();let idx=0;motions.forEach((motion=>{motion.setId(idx++);group.add(motion)}))}}}static isValidOverlayMode(overlayMode){if(["over","add","sub","mul"].includes(overlayMode)){return true}return false}}var Amaz$h=effect.Amaz;class RootAttributeSetter{static setRootScaleX(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="sx"){widget.scale=new Amaz$h.Vector3f(value,widget.scale.y,widget.scale.z)}}static setRootScaleY(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="sy"){widget.scale=new Amaz$h.Vector3f(widget.scale.x,value,widget.scale.z)}}static setRootRotationZ(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="rz"){widget.rotation=new Amaz$h.Vector3f(widget.rotation.x,widget.rotation.y,value)}}static setRootPosX(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="px"){widget.position=new Amaz$h.Vector3f(value,widget.position.y,widget.position.z)}}static setRootPosY(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="py"){widget.position=new Amaz$h.Vector3f(widget.position.x,value,widget.position.z)}}}RootAttributeSetter.setterMap={px:RootAttributeSetter.setRootPosX,py:RootAttributeSetter.setRootPosY,sx:RootAttributeSetter.setRootScaleX,sy:RootAttributeSetter.setRootScaleY,rz:RootAttributeSetter.setRootRotationZ};class BaseAnimationController{constructor(){this.m_startTimeInSegment=0;this.m_endTimeInSegment=0;this.m_keyframeParams=null;this.m_keyFramesDirty=true}setTimeRange(startTimeInSegment,endTimeInSegment){this.m_startTimeInSegment=startTimeInSegment;this.m_endTimeInSegment=endTimeInSegment}isEnable(timeInSegment){if(timeInSegment-this.m_startTimeInSegment>=-TIME_EPS&&timeInSegment-this.m_endTimeInSegment<=TIME_EPS){return true}return false}setKeyFrameParams(keyframeParams){this.m_keyframeParams=keyframeParams;this.m_keyFramesDirty=true}resetAnimation(){this.m_keyFramesDirty=true}checkIsDirty(){return this.m_keyFramesDirty}}class RootValueGeneratorContext{constructor(widget,overlayMode,propertyName){this.widget=null;this.widget=widget;this.overlayMode=overlayMode;this.propertyName=propertyName}}class RootAnimationController extends BaseAnimationController{constructor(widget){super();this.m_host=null;this.m_root_motion=new Group;this.m_host=widget}checkIsDirty(){if(this.m_keyFramesDirty==true){return true}if(this.m_keyFramesDirty==false&&this.m_endTimeInSegment<TIME_EPS){return true}return false}updateKeyFrames(){if(!this.checkIsDirty()){return}this.m_keyFramesDirty=false;this.m_root_motion.removeAll();if(this.m_keyframeParams==null){return}const keyframes=this.m_keyframeParams.keyframes;if(keyframes==null){return}for(let i=0;i<keyframes.length;i++){const keyframe=keyframes[i];let overlayMode="over";if(KeyframeAttrUtils.isValidOverlayMode(keyframe.overlay_mode))overlayMode=keyframe.overlay_mode;if(keyframe.k==null){console.error(TEMPLATE_TAG,"keyframe.k is undefined");return}const startTimeInSec=keyframe.s*KEYFRAME_TIME_FACTOR;const endTimeInSec=keyframe.e*KEYFRAME_TIME_FACTOR;if(endTimeInSec-startTimeInSec<TIME_EPS){console.error(TEMPLATE_TAG,"keyframe time range too short");return}this.setTimeRange(startTimeInSec,endTimeInSec);Object.keys(RootAttributeSetter.setterMap).forEach((key=>{if(keyframe.k[key]!=null){const rootMotionContext=new RootValueGeneratorContext(this.m_host,overlayMode,key);this.createMotionsRootProperty(keyframe,rootMotionContext,key)}}))}}createMotionsRootProperty(keyframeJson,motionContext,propertyName){const prop=keyframeJson.k[propertyName];const callback=RootAttributeSetter.setterMap[propertyName];if(prop==null){console.error(TEMPLATE_TAG,"prop is null");return}if(prop.length==0&&motionContext){console.error(TEMPLATE_TAG,"prop is empty");return}const interp=Interpolation.Linear;const keyframes=KeyframeAttrUtils.createKeyframes(keyframeJson,propertyName);KeyframeAttrUtils.createOneMotionByRelativeTime(keyframes,callback,interp,motionContext,this.m_root_motion,propertyName,this.m_startTimeInSegment,this.m_endTimeInSegment,keyframeJson.s,keyframeJson.e).start()}update(timeInSegment){if(this.m_keyframeParams!=null){this.m_root_motion.update(timeInSegment,true)}return 0}}var Amaz$g=effect.Amaz;var Vec3$6=Amaz$g.Vector3f;const TrackingMode={TRACKING_FOLLOW_POSITION:1<<0,TRACKING_FOLLOW_SCALE:1<<1,TRACKING_FOLLOW_ROTATION:1<<2,TRACKING_FOLLOW_POSITION_ABS:1<<3};class ClassicTRS{constructor(){this.position=new Vec3$6(0,0,0);this.rotation=new Vec3$6(0,0,0);this.scale=new Vec3$6(1,1,1)}setPosition(pos){this.position=pos}setRotation(rot){this.rotation=rot}setScale(s){this.scale=s}setTRS(pos,rot,s){this.position=pos;this.rotation=rot;this.scale=s}getPosition(){return this.position}getRotation(){return this.rotation}getScale(){return this.scale}getTRS(){return[this.position,this.rotation,this.scale]}}class TrackingTRSParams{constructor(){this.centerX=0;this.centerY=0;this.width=0;this.height=0;this.rotationZ=0}setParams(centerX,centerY,width,height,rotation){this.centerX=centerX;this.centerY=centerY;this.width=width;this.height=height;this.rotationZ=rotation}reset(){this.centerX=0;this.centerY=0;this.width=0;this.height=0;this.rotationZ=0}}class TrackingProcessor{constructor(){this.m_baseParams=null;this.m_trackingParams=null;this.m_trackingMode=0;this.m_needAdaptTrackingTRS=false;this.m_finalTRS=null;this.m_baseParams=new TrackingTRSParams;this.m_trackingParams=new TrackingTRSParams;this.m_trackingMode=0;this.m_needAdaptTrackingTRS=false}reset(){if(this.m_baseParams==null){this.m_baseParams=new TrackingTRSParams}else{this.m_baseParams.reset()}if(this.m_trackingParams==null){this.m_trackingParams=new TrackingTRSParams}else{this.m_trackingParams.reset()}this.m_trackingMode=0;this.m_needAdaptTrackingTRS=false}saveFinalTRS(position,rotation,scale){if(this.m_finalTRS==null){this.m_finalTRS=new ClassicTRS}this.m_finalTRS.setTRS(position,rotation,scale)}finalTRSIsAvaileble(){return this.m_finalTRS!=null}resetFinalTRS(){this.m_finalTRS=null}getFinalTRS(){var _a,_b,_c;const pos=(_a=this.m_finalTRS)===null||_a===void 0?void 0:_a.getPosition();const rot=(_b=this.m_finalTRS)===null||_b===void 0?void 0:_b.getRotation();const s=(_c=this.m_finalTRS)===null||_c===void 0?void 0:_c.getScale();this.m_finalTRS=null;return[pos,rot,s]}getFinalPosition(){var _a;return(_a=this.m_finalTRS)===null||_a===void 0?void 0:_a.getPosition()}getFinalRotation(){var _a;return(_a=this.m_finalTRS)===null||_a===void 0?void 0:_a.getRotation()}getFinalScale(){var _a;return(_a=this.m_finalTRS)===null||_a===void 0?void 0:_a.getScale()}updateTrackingData(seekParams){var _a,_b;if(seekParams.has("trackingParams")){const trackingParams=seekParams.get("trackingParams");if(trackingParams.has("baseTRS")){const baseTRS=trackingParams.get("baseTRS");(_a=this.m_baseParams)===null||_a===void 0?void 0:_a.setParams(baseTRS.get("centerX"),baseTRS.get("centerY"),baseTRS.get("width"),baseTRS.get("height"),baseTRS.get("rotation"))}if(trackingParams.has("trackingTRS")){const trackingTRS=trackingParams.get("trackingTRS");(_b=this.m_trackingParams)===null||_b===void 0?void 0:_b.setParams(trackingTRS.get("centerX"),trackingTRS.get("centerY"),trackingTRS.get("width"),trackingTRS.get("height"),trackingTRS.get("rotation"))}if(trackingParams.has("trackingMode")){this.m_trackingMode=trackingParams.get("trackingMode")}this.m_needAdaptTrackingTRS=true}else{this.m_needAdaptTrackingTRS=false;console.error("TrackingProcessor seekParams do not have trackingParams!")}}adaptTRS(position,rotation,scale){if(!this.m_needAdaptTrackingTRS||this.m_baseParams==null||this.m_trackingParams==null){return}const outPos=position.copy();const outScale=scale.copy();const outRot=rotation.copy();const scaleX=this.m_trackingParams.width/this.m_baseParams.width;const scaleY=this.m_trackingParams.height/this.m_baseParams.height;if(this.m_trackingMode&TrackingMode.TRACKING_FOLLOW_POSITION){outPos.x=this.m_trackingParams.centerX+scaleX*(outPos.x-this.m_baseParams.centerX);outPos.y=this.m_trackingParams.centerY+scaleY*(outPos.y-this.m_baseParams.centerY)}else if(this.m_trackingMode&TrackingMode.TRACKING_FOLLOW_POSITION_ABS){outPos.x=this.m_trackingParams.centerX+(outPos.x-this.m_baseParams.centerX);outPos.y=this.m_trackingParams.centerY+(outPos.y-this.m_baseParams.centerY)}if(this.m_trackingMode&TrackingMode.TRACKING_FOLLOW_SCALE){const uniformScale=(scaleX+scaleY)/2;outScale.x*=uniformScale;outScale.y*=uniformScale}if(this.m_trackingMode&TrackingMode.TRACKING_FOLLOW_ROTATION){outRot.z+=this.m_trackingParams.rotationZ-this.m_baseParams.rotationZ}this.m_needAdaptTrackingTRS=false;this.reset();this.saveFinalTRS(outPos,outRot,outScale)}}class BaseAssociationController{constructor(Widget){this.m_widget=null;this.m_associationParams=null;this.m_associationParamsDirty=true;this.m_widget=Widget}get widget(){return this.m_widget}set associationParams(params){if(this.m_associationParams==null||this.m_associationParams!=params){this.m_associationParams=params;this.m_associationParamsDirty=true}}get associationParams(){return this.m_associationParams}get paramsDirty(){return this.m_associationParamsDirty}}var Amaz$f=effect.Amaz;class RootAssociationController extends BaseAssociationController{constructor(){super(...arguments);this.m_oriWordInfo=null;this.m_curWordInfo=null;this.m_oriWordInfoStr="";this.m_dirty=false}set oriWordInfo(wordInfo){this.m_oriWordInfo=wordInfo}get oriWordInfo(){return this.m_oriWordInfo}set curWordInfo(wordInfo){this.m_curWordInfo=wordInfo}get curWordInfo(){return this.m_curWordInfo}set oriWordInfoStr(wordInfoStr){this.m_oriWordInfoStr=wordInfoStr}get oriWordInfoStr(){return this.m_oriWordInfoStr}set dirty(dirty){this.m_dirty=dirty}get dirty(){return this.m_dirty}setAssociationParams(params){super.associationParams=params;this.updateAssociationParams()}updateAssociationParams(){if(!this.m_associationParamsDirty)return;if("word_info"in super.associationParams){const oriWordInfoParam=super.associationParams.word_info;if(oriWordInfoParam==null){return}const oriWordInfoStr=JSON.stringify(oriWordInfoParam);if(oriWordInfoStr!=this.oriWordInfoStr){this.oriWordInfoStr=oriWordInfoStr;if(!this.oriWordInfo){this.oriWordInfo=new Amaz$f.TextWordInfo}if(!this.curWordInfo){this.curWordInfo=new Amaz$f.TextWordInfo}AmazUtils$1.TextWordMatchUtils.parseWordInfoByJsonStr(this.oriWordInfo,oriWordInfoStr);this.curWordInfo.initWith(this.oriWordInfo);this.m_dirty=true}}if("current_word_info"in super.associationParams){const curWordInfoParam=super.associationParams.current_word_info;if(curWordInfoParam==null){return}if(!this.curWordInfo){this.curWordInfo=new Amaz$f.TextWordInfo}const curWordInfoStr=JSON.stringify(curWordInfoParam);AmazUtils$1.TextWordMatchUtils.parseWordInfoByJsonStr(this.curWordInfo,curWordInfoStr);this.m_dirty=true}this.m_associationParamsDirty=false}updateByAssociation(_widgets){for(let wId=0;wId<_widgets.length;++wId){const widget=_widgets[wId];if(widget==null){continue}if(this.widget&&widget.widgetType==WidgetType.TEXT){const textWidget=widget;if(textWidget&&textWidget.textAssociationController&&textWidget.textAssociationController.wordInfoDirty==true){const textControl=textWidget.textAssociationController;if(textControl.wordIdRange.length>=2){if(!this.curWordInfo||!textControl.curWordInfo){continue}const wordIdOffset=textControl.wordIdRange[0];const msTimeOffset=(textControl.startTime-this.widget.startTime)*1e3;this.curWordInfo.merge(textControl.curWordInfo,wordIdOffset,msTimeOffset);this.dirty=true;break}}}}if(this.m_dirty==true){if(this.curWordInfo==null){return}for(let wId=0;wId<_widgets.length;++wId){const widget=_widgets[wId];if(widget==null){continue}if(widget.widgetType==WidgetType.TEXT){const textWidget=widget;if(textWidget&&textWidget.textAssociationController){const textControl=textWidget.textAssociationController;let canUpdate=true;if(textControl.wordIdRangeDirty==true||textControl.wordInfoDirty==true){textControl.wordIdRangeDirty=false;textControl.wordInfoDirty=false;canUpdate=false}if(canUpdate&&textControl.wordIdRange.length>=2){const startId=textControl.wordIdRange[0];const endId=textControl.wordIdRange[1];const dirtyVec=this.curWordInfo.dirtyIndex;for(let i=0;i<dirtyVec.size();++i){const dirtyId=dirtyVec.get(i);if(startId<=dirtyId&&dirtyId<=endId){textControl.dirty=true;textControl.updateAssociationParams();textControl.updateByAssociation();break}}}}}}this.curWordInfo.dirtyIndex.clear();this.m_dirty=false}}}var Amaz$e=effect.Amaz;var Vec2$4=Amaz$e.Vector2f;var Vec3$5=Amaz$e.Vector3f;var Vec4=Amaz$e.Vector4f;class LayoutInfo{constructor(){this.m_position=new Vec3$5(0,0,0);this.m_scale=new Vec3$5(1,1,1);this.m_rotation=new Vec3$5(0,0,0);this.m_widgetResolutionType=0;this.m_screenSize=new Vec2$4(720,1280);this.m_widgetOriginalPixelSize=new Vec2$4(0,0);this.m_layoutDirty=true;this.m_boundingBox=new Vec4(0,0,0,0);this.m_localBoundingBox=new Vec4(0,0,0,0)}copy(){const newInfo=new LayoutInfo;newInfo.m_position=this.m_position.copy();newInfo.m_scale=this.m_scale.copy();newInfo.m_rotation=this.m_rotation.copy();newInfo.m_widgetResolutionType=this.m_widgetResolutionType;newInfo.m_screenSize=this.m_screenSize.copy();newInfo.m_widgetOriginalPixelSize=this.m_widgetOriginalPixelSize.copy();return newInfo}isEqualTo(layoutInfo){return this.m_position.eq(layoutInfo.m_position)&&this.m_scale.eq(layoutInfo.m_scale)&&this.m_rotation.eq(layoutInfo.m_rotation)&&this.m_widgetResolutionType===layoutInfo.m_widgetResolutionType&&this.m_screenSize.eq(layoutInfo.m_screenSize)&&this.m_widgetOriginalPixelSize.eq(layoutInfo.m_widgetOriginalPixelSize)}}var Amaz$d=effect.Amaz;var Quat=Amaz$d.Quaternionf;var Vec2$3=Amaz$d.Vector2f;var Vec3$4=Amaz$d.Vector3f;const LAYER_SIZE=12e7;const ORDER_SIZE=4e4;const VEC3_UNIT_Z=new Vec3$4(0,0,1);var WidgetType;(function(WidgetType){WidgetType[WidgetType["ROOT"]=0]="ROOT";WidgetType[WidgetType["SPRITE"]=1]="SPRITE";WidgetType[WidgetType["SHAPE"]=2]="SHAPE";WidgetType[WidgetType["TEXT"]=3]="TEXT"})(WidgetType||(WidgetType={}));var WidgetResolutionType;(function(WidgetResolutionType){WidgetResolutionType[WidgetResolutionType["DESIGN"]=0]="DESIGN";WidgetResolutionType[WidgetResolutionType["DESIGN_HEIGHT"]=1]="DESIGN_HEIGHT";WidgetResolutionType[WidgetResolutionType["NORMALIZED"]=2]="NORMALIZED";WidgetResolutionType[WidgetResolutionType["ORIGINAL"]=3]="ORIGINAL"})(WidgetResolutionType||(WidgetResolutionType={}));const PI=3.141592653589793;class Widget{constructor(name,widgetType,scene){this.m_timeRange=new TimeRange(0,0);this.m_enable=true;this.m_cameraLayer=0;this.m_layer=0;this.m_localOrder=0;this.m_position=new Vec3$4(0,0,0);this.m_scale=new Vec3$4(1,1,1);this.m_rotation=new Vec3$4(0,0,0);this.m_rootEntity=null;this.m_constrainedWidgets=null;this.m_needUpdateConstrainedWidgets=false;this.m_widgetParamUpdated=true;this.m_updateOrder=true;this.m_needUpdateShapeBlendOrder=true;this.m_timeRangeUpdated=true;this.m_screenSizeChanged=true;this.m_widgetResolutionType=WidgetResolutionType.DESIGN;this.m_screenSize=new Vec2$3(720,1280);this.m_pixelRatio=640;this.m_extraScale=new Vec3$4(1,1,1);this.m_orthoScale=1;this.m_previewTime=1.5;this.m_rootAnimationController=null;this.m_rootKeyframeParams=null;this.m_rootAssociationController=null;this.m_rootWidget=null;this.m_actionType="";this.m_layoutInfo=new LayoutInfo;this.m_updateTrackingData=false;this.m_trackerHoldFinalTRS=false;this.m_trackingProcessor=new TrackingProcessor;this.m_name=name;this.m_widgetType=widgetType;this.m_scene=scene}get widgetName(){return this.m_name}set position(pos){if(!this.m_position.eq(pos)){this.m_position=pos;this.m_widgetParamUpdated=true}}get position(){return this.m_position}set scale(scale){if(!this.m_scale.eq(scale)){this.m_scale=scale;this.m_widgetParamUpdated=true}}get scale(){return this.m_scale}set rotation(rotate){if(!this.m_rotation.eq(rotate)){this.m_rotation=rotate;this.m_widgetParamUpdated=true}}get rotation(){return this.m_rotation}set duration(duration){if(this.duration!==duration&&duration>=0){this.endTime=this.startTime+duration;this.m_widgetParamUpdated=true;this.m_timeRangeUpdated=true}}get duration(){return this.m_timeRange.duration}set layer(layer){if(this.m_layer!==layer){this.m_layer=layer;this.m_widgetParamUpdated=true;this.m_updateOrder=true;this.m_needUpdateShapeBlendOrder=true}}get layer(){return this.m_layer}get cameraLayer(){return this.m_cameraLayer}set previewTime(timeStamp){if(this.m_previewTime!==timeStamp){this.m_previewTime=timeStamp}}get previewTime(){return this.m_previewTime}set localOrder(localOrder){if(this.m_localOrder!==localOrder){this.m_localOrder=localOrder;this.m_widgetParamUpdated=true;this.m_updateOrder=true;this.m_needUpdateShapeBlendOrder=true}}get localOrder(){return this.m_localOrder}set enable(enable){if(this.m_enable!==enable){this.m_enable=enable;this.m_widgetParamUpdated=true}}get enable(){return this.m_enable}get widgetType(){return this.m_widgetType}set widgetResolutionType(resolutionType){this.m_widgetResolutionType=resolutionType}get widgetResolutionType(){return this.m_widgetResolutionType}get scene(){return this.m_scene}set rootEntity(root){this.m_rootEntity=root}get rootEntity(){if(!this.m_rootEntity){this.createWidgetRootEntity(this.m_scene)}return this.m_rootEntity}set startTime(startTime){if(this.m_timeRange.startTime!==startTime){this.m_timeRange.startTime=startTime;this.m_timeRangeUpdated=true}}get startTime(){return this.m_timeRange.startTime}set endTime(endTime){if(this.m_timeRange.endTime!==endTime){this.m_timeRange.endTime=endTime;this.m_timeRangeUpdated=true}}get endTime(){return this.m_timeRange.endTime}get screenSize(){return this.m_screenSize}set extraScale(scale){if(!this.m_extraScale.eq(scale)){this.m_extraScale=scale;this.m_widgetParamUpdated=true}}get extraScale(){return this.m_extraScale}get trackFinalPosition(){return this.m_trackingProcessor.getFinalPosition()}get trackFinalRotation(){return this.m_trackingProcessor.getFinalRotation()}get trackFinalScale(){return this.m_trackingProcessor.getFinalScale()}set trackerHoldFinalTRS(hold){this.m_trackerHoldFinalTRS=hold}get trackerHoldFinalTRS(){return this.m_trackerHoldFinalTRS}setTimeRange(startTime,endTime){this.startTime=startTime;this.endTime=endTime}set actionType(type){this.m_actionType=type}get actionType(){return this.m_actionType}set layoutInfo(layoutInfo){this.layoutInfo=layoutInfo}get layoutInfo(){return this.m_layoutInfo}set layoutDirty(dirty){if(this.layoutInfo.m_layoutDirty!=dirty){this.layoutInfo.m_layoutDirty=dirty}}get layoutDirty(){return this.layoutInfo.m_layoutDirty}set boundingBox(bbox){if(!this.layoutInfo.m_boundingBox.eq(bbox)){this.layoutInfo.m_boundingBox=bbox}}get boundingBox(){return this.layoutInfo.m_boundingBox}set localBoundingBox(bbox){if(!this.layoutInfo.m_localBoundingBox.eq(bbox)){this.layoutInfo.m_localBoundingBox=bbox}}get localBoundingBox(){return this.layoutInfo.m_localBoundingBox}get rootWidget(){return this.m_rootWidget}set rootWidget(root){this.m_rootWidget=root}get rootAssociationController(){return this.m_rootAssociationController}set rootAnimationController(controller){this.m_rootAnimationController=controller}set parameters(jsonParam){if(jsonParam){if("position"in jsonParam){const configPosition=AmazUtils$1.CastJsonArray3fToAmazVector3f(jsonParam.position);if(null!==configPosition){this.position=configPosition}else{console.error("widget set parameters json config position is not vector3f!")}}if("scale"in jsonParam){const configScale=AmazUtils$1.CastJsonArray3fToAmazVector3f(jsonParam.scale);if(null!==configScale){this.scale=configScale}else{console.error("widget set parameters json config scale is not vector3f!")}}if("rotation"in jsonParam){const configRotation=AmazUtils$1.CastJsonArray3fToAmazVector3f(jsonParam.rotation);if(null!=configRotation){this.rotation=configRotation}else{console.error("widget set parameters json config rotation is not vector3f!")}}if("layer"in jsonParam){const configLayer=jsonParam.layer;this.layer=configLayer}if("preview_time"in jsonParam){const configPreTime=jsonParam.preview_time;this.previewTime=configPreTime}if("visible"in jsonParam){const configEnable=jsonParam.visible;this.enable=configEnable}if("order_in_layer"in jsonParam){const configLocalOrder=jsonParam.order_in_layer;this.localOrder=configLocalOrder}let needUpdateEndTime=false;if("start_time"in jsonParam){const configStart_time=jsonParam.start_time;this.startTime=configStart_time;needUpdateEndTime=true}if("duration"in jsonParam){const configDuration=jsonParam.duration;this.duration=configDuration;needUpdateEndTime=true}if(needUpdateEndTime){this.endTime=this.startTime+this.duration}if("keyframe_params"in jsonParam&&this.widgetType===WidgetType.ROOT){if(this.m_rootAnimationController==null){this.m_rootAnimationController=new RootAnimationController(this)}if(this.m_rootKeyframeParams!=jsonParam.keyframe_params){this.m_rootKeyframeParams=jsonParam.keyframe_params;this.m_rootAnimationController.setKeyFrameParams(this.m_rootKeyframeParams)}}if("bounding_box"in jsonParam){const configBbox=AmazUtils$1.CastJsonArray4fToAmazVector4f(jsonParam.bounding_box);if(null!==configBbox){this.boundingBox=configBbox}else{console.error("widget set parameters json config bounding_box is not vector4f!")}}if("local_boundingBox"in jsonParam){const configLocalBbox=AmazUtils$1.CastJsonArray4fToAmazVector4f(jsonParam.local_boundingBox);if(null!==configLocalBbox){this.localBoundingBox=configLocalBbox}else{console.error("widget set parameters json config local_boundingBox is not vector4f!")}}if("association_params"in jsonParam&&this.widgetType===WidgetType.ROOT){const configAssociationParams=jsonParam.association_params;if(configAssociationParams!=null){if(this.m_rootAssociationController==null){this.m_rootAssociationController=new RootAssociationController(this)}this.m_rootAssociationController.setAssociationParams(configAssociationParams)}else{console.error("root widget set parameters json config association_params is not json object!")}}if("action_type"in jsonParam){const action_type=jsonParam.action_type;this.m_actionType=action_type}}}get parameters(){const typeStr=this.getWidgetTypeStr();const widgetParam={name:this.m_name,type:typeStr,layer:this.layer,order_in_layer:this.localOrder,preview_time:this.previewTime,start_time:this.startTime,duration:this.duration,position:[this.position.x,this.position.y,this.position.z],scale:[this.scale.x,this.scale.y,this.scale.z],rotation:[this.rotation.x,this.rotation.y,this.rotation.z],action_type:this.m_actionType};if(this.rootAssociationController&&this.rootAssociationController.associationParams){widgetParam.association_params=this.rootAssociationController.associationParams}return widgetParam}getWidgetTypeStr(){let typeStr="";if(this.widgetType===WidgetType.ROOT){typeStr="root"}else if(this.widgetType===WidgetType.SPRITE){typeStr="sticker"}else if(this.widgetType===WidgetType.SHAPE){typeStr="shape"}else if(this.widgetType===WidgetType.TEXT){typeStr="text"}return typeStr}onResize(screenSize,pixelRatio,extraScale){this.m_screenSize=screenSize;this.m_pixelRatio=pixelRatio/this.m_orthoScale;this.m_extraScale=extraScale;this.m_screenSizeChanged=true;this.m_widgetParamUpdated=true}onUpdate(_timeStamp){if(this.m_rootAnimationController!=null&&this.widgetType===WidgetType.ROOT){this.m_rootAnimationController.updateKeyFrames();if(this.m_rootAnimationController.isEnable(_timeStamp)){this.m_rootAnimationController.update(_timeStamp-this.startTime)}}if(this.m_trackerHoldFinalTRS&&this.widgetType===WidgetType.ROOT){if(this.m_updateTrackingData){if(this.m_rootEntity){this.m_trackingProcessor.adaptTRS(this.m_position,this.m_rotation,this.m_scale)}this.m_updateTrackingData=false;this.m_widgetParamUpdated=true}else{this.m_trackerHoldFinalTRS=false;this.m_widgetParamUpdated=true;this.m_trackingProcessor.resetFinalTRS()}}this.updateRootEntityParam();if(this.widgetType===WidgetType.ROOT){this.checkLayoutDirty()}}onLateUpdate(_timeStamp){}getConstrainedWidgets(){return this.m_constrainedWidgets}createWidgetRootEntity(scene){this.m_rootEntity=AmazUtils$1.createEntity(this.m_name,scene);this.m_rootEntity.layer=this.m_cameraLayer;this.m_rootEntity.transform={position:new Vec3$4(0,0,0),scale:new Vec3$4(1,1,1),rotation:new Vec3$4(0,0,0)}}setWidgetRootEntity(root){this.m_rootEntity=root}createRoot(jsonParam,scene){this.parameters=jsonParam;this.createWidgetRootEntity(scene)}getWidgetRootEntity(){return this.m_rootEntity}removeWidgetRootEntity(scene){if(null!=this.m_rootEntity){scene.removeEntity(this.m_rootEntity);this.m_rootEntity=null}}updateConstrainedWidgets(name,widget){if(null===this.m_constrainedWidgets){this.m_constrainedWidgets=new Map;this.m_constrainedWidgets.set(name,widget)}else{if(!this.m_constrainedWidgets.has(name)){this.m_constrainedWidgets.set(name,widget)}}}updateOrder(rootSortingOrder){const renderers=AmazUtils$1.getRenderers(this.m_rootEntity);const size=renderers.size();for(let i=0;i<size;i++){const localOrder=0;const renderer=renderers.get(i);const sortingOrder=rootSortingOrder+localOrder;renderer.sortingOrder=sortingOrder}}updateTrackingProcessData(seekParams){var _a;this.m_trackerHoldFinalTRS=true;(_a=this.m_trackingProcessor)===null||_a===void 0?void 0:_a.updateTrackingData(seekParams);this.m_updateTrackingData=true}updateRootEntityParam(){if(this.m_widgetParamUpdated){{if(null!=this.m_rootEntity){if(this.canNotRender()){this.m_enable=false}this.m_rootEntity.visible=this.m_enable;let finalPosition=this.position.copy();let finalScale=this.scale.copy();let finalRotation=this.rotation.copy();if(this.m_trackerHoldFinalTRS&&this.m_name==="rootWidget"){finalPosition=this.trackFinalPosition.copy();finalScale=this.trackFinalScale.copy();finalRotation=this.trackFinalRotation.copy()}if(this.m_name==="rootWidget"){finalPosition.x=.5*finalPosition.x*this.m_screenSize.x/this.m_pixelRatio;finalPosition.y=.5*finalPosition.y*this.m_screenSize.y/this.m_pixelRatio}else{finalPosition.x=finalPosition.x/this.m_pixelRatio;finalPosition.y=finalPosition.y/this.m_pixelRatio}const trans=this.m_rootEntity.getComponent("Transform");trans.localPosition=finalPosition;trans.localScale=finalScale.scale(this.m_extraScale);let rotatationQ=new Quat;rotatationQ=rotatationQ.axisAngleToQuaternion(VEC3_UNIT_Z,finalRotation.z/180*PI);trans.localOrientation=rotatationQ;const sortlayer=this.m_layer*LAYER_SIZE+this.m_localOrder*ORDER_SIZE;if(this.m_name!=="rootWidget"&&this.m_updateOrder){this.updateOrder(sortlayer);this.m_updateOrder=false}}}this.m_widgetParamUpdated=false}}checkIsInRange(timeStamp){return this.compareFloatRange(this.m_timeRange.startTime,this.m_timeRange.endTime,timeStamp)}compareFloatRange(x,y,t,closedInterval=true){const precision=1e-6;const equal=(x,y)=>Math.abs(x-y)<precision;return closedInterval?t>=x&&t<=y||equal(t,x)||equal(t,y):t>x&&t<y&&!equal(t,x)&&!equal(t,y)}onUpdateAnimationDuration(_originTime,_newTime){}canNotRender(){return this.actionType==="can_not_render"}updateLayoutInfo(){const layoutInfo=this.layoutInfo;layoutInfo.m_position=this.position.copy();layoutInfo.m_scale=this.scale.copy();layoutInfo.m_rotation=this.rotation.copy();layoutInfo.m_widgetResolutionType=this.widgetResolutionType;layoutInfo.m_screenSize=this.screenSize.copy()}checkLayoutDirty(){if(Widget.m_isPostLayoutEnable==false){return}const oriLayoutInfo=this.layoutInfo.copy();this.updateLayoutInfo();if(this.widgetType==WidgetType.ROOT){if(!oriLayoutInfo.isEqualTo(this.layoutInfo)){this.layoutDirty=true}}}}Widget.m_isPostLayoutEnable=false;class AmazFileUtils{static utf8ArrayToStr(array){let out="";const len=array.length;let i=0;let char2=null;let char3=null;while(i<len){const c=array[i++];switch(c>>4){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:out+=String.fromCharCode(c);break;case 12:case 13:char2=array[i++];out+=String.fromCharCode((c&31)<<6|char2&63);break;case 14:char2=array[i++];char3=array[i++];out+=String.fromCharCode((c&15)<<12|(char2&63)<<6|(char3&63)<<0);break}}return out}static ab2str(buf){const array=new Uint8Array(buf);const resultStr=AmazFileUtils.utf8ArrayToStr(array);return resultStr}static readFileContent(filePath){try{const stateFile=fs.statSync(filePath);if(stateFile&&stateFile.isFile()){const content=fs.readFileSync(filePath);if(content){return AmazFileUtils.ab2str(content)}}}catch(e){console.error(TEMPLATE_TAG,"read file content error:",e)}return undefined}}var Amaz$c=effect.Amaz;var AnimationType;(function(AnimationType){AnimationType[AnimationType["none"]=0]="none";AnimationType[AnimationType["in"]=1]="in";AnimationType[AnimationType["out"]=2]="out";AnimationType[AnimationType["loop"]=3]="loop"})(AnimationType||(AnimationType={}));var ScriptType;(function(ScriptType){ScriptType[ScriptType["LUA"]=0]="LUA";ScriptType[ScriptType["JAVASCRIPT"]=1]="JAVASCRIPT"})(ScriptType||(ScriptType={}));const prefabName="anim.prefab";const contentFileName="/content.json";class Animation2D{constructor(path,resourceID,scriptType){this.m_animationType=AnimationType.none;this.m_animationTimeRange=new TimeRange(0,0);this.m_animationLoopDuration=0;this.m_needResetAnimation=false;this.m_scriptComponent=null;this.m_state={started:false,entered:false};this.m_prefabAnimComponent=undefined;this.m_animationPropertyKey=[];this.m_animationPropertyValue=[];this.m_animationPropertys=new Map;this.m_needMerge=false;this.m_animationPath=path;this.m_animationResourceID=resourceID;if(scriptType==="js"){this.m_scriptType=ScriptType.JAVASCRIPT}else{this.m_scriptType=ScriptType.LUA}}set animationPath(path){this.m_animationPath=path}get animationPath(){return this.m_animationPath}set animationType(ani_type){this.m_animationType=ani_type}get animationType(){return this.m_animationType}setAnimationProperty(animationPropertys){var _a;if(animationPropertys){this.m_animationPropertys=animationPropertys}for(const[key,value]of this.m_animationPropertys){(_a=this.script)===null||_a===void 0?void 0:_a.call("onSetProperty",[key,value])}}get animationScriptType(){return this.m_scriptType}get animationResourceID(){return this.m_animationResourceID}set animationStartTime(start){this.m_animationTimeRange.startTime=start}get animationStartTime(){return this.m_animationTimeRange.startTime}set animationEndTime(end){this.m_animationTimeRange.endTime=end}get animationEndTime(){return this.m_animationTimeRange.endTime}set animationLoopDuration(loop_duration){var _a;this.m_animationLoopDuration=loop_duration;if(this.state.entered&&this.animationType===AnimationType.loop&&loop_duration>0){(_a=this.script)===null||_a===void 0?void 0:_a.call("setDuration",[loop_duration])}}get animationLoopDuration(){return this.m_animationLoopDuration}set animationDuration(duration){var _a;this.m_animationTimeRange.duration=duration;if(this.state.entered&&this.animationType!==AnimationType.loop){(_a=this.script)===null||_a===void 0?void 0:_a.call("setDuration",[duration])}}get animationDuration(){return this.m_animationTimeRange.duration}get needResetAnimation(){return this.m_needResetAnimation}get script(){return this.m_scriptComponent}get state(){return this.m_state}onEnter(){var _a,_b,_c;if(!this.m_state.entered){if(this.animationType!==AnimationType.loop){(_a=this.script)===null||_a===void 0?void 0:_a.call("setDuration",[this.animationDuration])}else{if(this.animationLoopDuration>0){(_b=this.script)===null||_b===void 0?void 0:_b.call("setDuration",[this.animationLoopDuration])}}(_c=this.script)===null||_c===void 0?void 0:_c.call("onEnter");this.m_state.entered=true}}onLeave(){var _a,_b,_c;if(this.m_state.entered){if(this.m_animationType==AnimationType.in){(_a=this.script)===null||_a===void 0?void 0:_a.call("seek",[this.animationDuration])}else if(this.m_animationType==AnimationType.out){(_b=this.script)===null||_b===void 0?void 0:_b.call("seek",[0])}(_c=this.script)===null||_c===void 0?void 0:_c.call("onLeave");this.m_state.entered=false}}seek(timestamp){var _a;if(this.state.entered){let seekTime=timestamp-this.animationStartTime;if(seekTime<0)seekTime=0;(_a=this.script)===null||_a===void 0?void 0:_a.call("seek",[seekTime])}}onStart(){if(this.script&&!this.m_state.started){this.script.call("onStart");this.m_state.started=true}}onClear(){var _a;if(this.m_state.started){(_a=this.script)===null||_a===void 0?void 0:_a.call("clear");this.m_state.started=false;this.m_state.entered=false}}get loaded(){return this.m_scriptComponent!=null}loadAnimation(path,entity){const pm=Amaz$c.AmazingManager.getSingleton("PrefabManager");const anim=pm.loadPrefab(path,prefabName);if(anim){this.m_prefabAnimComponent=anim.getRootEntity().getComponent("ScriptComponent");if(this.m_prefabAnimComponent){this.m_scriptComponent=this.m_prefabAnimComponent.instantiate();const vec=new Amaz$c.Vector;vec.pushBack(this.m_scriptComponent);entity.components=vec}}else{const contentPath=path+contentFileName;const contentJsonStr=AmazFileUtils.readFileContent(contentPath);if(contentJsonStr!==undefined){const contentJson=JSON.parse(contentJsonStr);if(contentJson&&"filemap"in contentJson){const fileMapJson=contentJson.filemap;if(fileMapJson&&"prefab"in fileMapJson){const prefabFileName=fileMapJson.prefab;const anim=pm.loadPrefab(path,prefabFileName);if(anim){this.m_prefabAnimComponent=anim.getRootEntity().getComponent("ScriptComponent");if(this.m_prefabAnimComponent){this.m_scriptComponent=this.m_prefabAnimComponent.instantiate();const vec=new Amaz$c.Vector;vec.pushBack(this.m_scriptComponent);entity.components=vec}else{console.error(TEMPLATE_TAG,"loadAnimation failed!")}}else{console.error(TEMPLATE_TAG,"Animation loadPrefab failed!")}}else{console.error(TEMPLATE_TAG,"prefab key is not in filemap!")}}else{console.error(TEMPLATE_TAG,"filemap key is not in contentJson!")}}else{console.error(TEMPLATE_TAG,"contentJsonStr is undefined")}}return true}unloadAnmation(entity){if(null!=this.m_scriptComponent){this.onClear();entity.removeComponentCom(this.m_scriptComponent);this.m_scriptComponent=null}}reloadAnimation(entity){var _a;if(this.m_scriptComponent&&this.m_prefabAnimComponent){this.onClear();entity.removeComponentCom(this.m_scriptComponent);this.m_scriptComponent=this.m_prefabAnimComponent.instantiate();const vec=new Amaz$c.Vector;vec.pushBack(this.m_scriptComponent);entity.components=vec;for(const[key,value]of this.m_animationPropertys){(_a=this.script)===null||_a===void 0?void 0:_a.call("onSetProperty",[key,value])}}}resetAnimation(){if(this.m_needResetAnimation);}}var commonjsGlobal=typeof globalThis!=="undefined"?globalThis:typeof window!=="undefined"?window:typeof global!=="undefined"?global:typeof self!=="undefined"?self:{};var configValidator={exports:{}};configValidator.exports=validate20$5;configValidator.exports.default=validate20$5;function validate20$5(data,{instancePath:instancePath="",parentData:parentData,parentDataProperty:parentDataProperty,rootData:rootData=data}={}){let vErrors=null;let errors=0;{if(data&&typeof data=="object"&&!Array.isArray(data)){let missing0;if(data.type===undefined&&(missing0="type")){validate20$5.errors=[{instancePath:instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty:missing0},message:"must have required property '"+missing0+"'"}];return false}else{for(const key0 in data){if(!(key0==="type"||key0==="root"||key0==="children"||key0==="childrenOperation"||key0==="globals")){validate20$5.errors=[{instancePath:instancePath,schemaPath:"#/additionalProperties",keyword:"additionalProperties",params:{additionalProperty:key0},message:"must NOT have additional properties"}];return false}}{if(data.type!==undefined){const _errs2=errors;if(typeof data.type!=="string"){validate20$5.errors=[{instancePath:instancePath+"/type",schemaPath:"#/properties/type/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid0=_errs2===errors}else{var valid0=true}if(valid0){if(data.root!==undefined){let data1=data.root;const _errs4=errors;if(!(data1&&typeof data1=="object"&&!Array.isArray(data1))&&data1!==null){validate20$5.errors=[{instancePath:instancePath+"/root",schemaPath:"#/properties/root/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}{if(data1&&typeof data1=="object"&&!Array.isArray(data1)){let missing1;if(data1.name===undefined&&(missing1="name")||data1.preview_time===undefined&&(missing1="preview_time")||data1.duration===undefined&&(missing1="duration")){validate20$5.errors=[{instancePath:instancePath+"/root",schemaPath:"#/properties/root/required",keyword:"required",params:{missingProperty:missing1},message:"must have required property '"+missing1+"'"}];return false}else{if(data1.name!==undefined){const _errs7=errors;if(typeof data1.name!=="string"){validate20$5.errors=[{instancePath:instancePath+"/root/name",schemaPath:"#/properties/root/properties/name/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid1=_errs7===errors}else{var valid1=true}if(valid1){if(data1.preview_time!==undefined){let data3=data1.preview_time;const _errs9=errors;if(!(typeof data3=="number"&&isFinite(data3))){validate20$5.errors=[{instancePath:instancePath+"/root/preview_time",schemaPath:"#/properties/root/properties/preview_time/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid1=_errs9===errors}else{var valid1=true}if(valid1){if(data1.duration!==undefined){let data4=data1.duration;const _errs11=errors;if(!(typeof data4=="number"&&isFinite(data4))){validate20$5.errors=[{instancePath:instancePath+"/root/duration",schemaPath:"#/properties/root/properties/duration/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid1=_errs11===errors}else{var valid1=true}}}}}}var valid0=_errs4===errors}else{var valid0=true}if(valid0){if(data.children!==undefined){let data5=data.children;const _errs13=errors;if(!Array.isArray(data5)&&data5!==null){validate20$5.errors=[{instancePath:instancePath+"/children",schemaPath:"#/properties/children/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}{if(Array.isArray(data5)){var valid2=true;const len0=data5.length;for(let i0=0;i0<len0;i0++){let data6=data5[i0];const _errs16=errors;if(!(data6&&typeof data6=="object"&&!Array.isArray(data6))){validate20$5.errors=[{instancePath:instancePath+"/children/"+i0,schemaPath:"#/properties/children/items/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}var valid2=_errs16===errors;if(!valid2){break}}}}var valid0=_errs13===errors}else{var valid0=true}}}}}}else{validate20$5.errors=[{instancePath:instancePath,schemaPath:"#/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}}validate20$5.errors=vErrors;return errors===0}var spriteValidator={exports:{}};spriteValidator.exports=validate20$4;spriteValidator.exports.default=validate20$4;const schema22$4={type:"object",additionalProperties:true,required:["type"],properties:{name:{type:"string",nullable:false},type:{enum:["text","shape","sticker"]},position:{type:"array",items:{type:"number"},maxItems:3,minItems:3},rotation:{type:"array",items:{type:"number"},maxItems:3,minItems:3},scale:{type:"array",items:{type:"number"},maxItems:3,minItems:3},order_in_layer:{type:"integer"},start_time:{type:"number"},duration:{type:"number"},sticker_format:{enum:["png","jpeg","gif","mp4","seq"]},sticker_design_type:{enum:[0,1]},sticker_path:{type:"string"},sticker_resource_id:{type:"string"},resource_name_list:{type:"array",items:{type:"string",nullable:true}},sticker_alpha:{type:"number"},sticker_flipX:{type:"boolean"},sticker_flipY:{type:"boolean"},fps:{type:"number"},sticker_loop:{type:"boolean"},anims:{type:"array",nullable:true,items:{type:"object"}}}};function validate20$4(data,{instancePath:instancePath="",parentData:parentData,parentDataProperty:parentDataProperty,rootData:rootData=data}={}){let vErrors=null;let errors=0;{if(data&&typeof data=="object"&&!Array.isArray(data)){let missing0;if(data.type===undefined&&(missing0="type")){validate20$4.errors=[{instancePath:instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty:missing0},message:"must have required property '"+missing0+"'"}];return false}else{if(data.name!==undefined){const _errs2=errors;if(typeof data.name!=="string"){validate20$4.errors=[{instancePath:instancePath+"/name",schemaPath:"#/properties/name/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid0=_errs2===errors}else{var valid0=true}if(valid0){if(data.type!==undefined){let data1=data.type;const _errs5=errors;if(!(data1==="text"||data1==="shape"||data1==="sticker")){validate20$4.errors=[{instancePath:instancePath+"/type",schemaPath:"#/properties/type/enum",keyword:"enum",params:{allowedValues:schema22$4.properties.type.enum},message:"must be equal to one of the allowed values"}];return false}var valid0=_errs5===errors}else{var valid0=true}if(valid0){if(data.position!==undefined){let data2=data.position;const _errs6=errors;{if(Array.isArray(data2)){if(data2.length>3){validate20$4.errors=[{instancePath:instancePath+"/position",schemaPath:"#/properties/position/maxItems",keyword:"maxItems",params:{limit:3},message:"must NOT have more than 3 items"}];return false}else{if(data2.length<3){validate20$4.errors=[{instancePath:instancePath+"/position",schemaPath:"#/properties/position/minItems",keyword:"minItems",params:{limit:3},message:"must NOT have fewer than 3 items"}];return false}else{var valid1=true;const len0=data2.length;for(let i0=0;i0<len0;i0++){let data3=data2[i0];const _errs8=errors;if(!(typeof data3=="number"&&isFinite(data3))){validate20$4.errors=[{instancePath:instancePath+"/position/"+i0,schemaPath:"#/properties/position/items/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid1=_errs8===errors;if(!valid1){break}}}}}else{validate20$4.errors=[{instancePath:instancePath+"/position",schemaPath:"#/properties/position/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}}var valid0=_errs6===errors}else{var valid0=true}if(valid0){if(data.rotation!==undefined){let data4=data.rotation;const _errs10=errors;{if(Array.isArray(data4)){if(data4.length>3){validate20$4.errors=[{instancePath:instancePath+"/rotation",schemaPath:"#/properties/rotation/maxItems",keyword:"maxItems",params:{limit:3},message:"must NOT have more than 3 items"}];return false}else{if(data4.length<3){validate20$4.errors=[{instancePath:instancePath+"/rotation",schemaPath:"#/properties/rotation/minItems",keyword:"minItems",params:{limit:3},message:"must NOT have fewer than 3 items"}];return false}else{var valid2=true;const len1=data4.length;for(let i1=0;i1<len1;i1++){let data5=data4[i1];const _errs12=errors;if(!(typeof data5=="number"&&isFinite(data5))){validate20$4.errors=[{instancePath:instancePath+"/rotation/"+i1,schemaPath:"#/properties/rotation/items/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid2=_errs12===errors;if(!valid2){break}}}}}else{validate20$4.errors=[{instancePath:instancePath+"/rotation",schemaPath:"#/properties/rotation/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}}var valid0=_errs10===errors}else{var valid0=true}if(valid0){if(data.scale!==undefined){let data6=data.scale;const _errs14=errors;{if(Array.isArray(data6)){if(data6.length>3){validate20$4.errors=[{instancePath:instancePath+"/scale",schemaPath:"#/properties/scale/maxItems",keyword:"maxItems",params:{limit:3},message:"must NOT have more than 3 items"}];return false}else{if(data6.length<3){validate20$4.errors=[{instancePath:instancePath+"/scale",schemaPath:"#/properties/scale/minItems",keyword:"minItems",params:{limit:3},message:"must NOT have fewer than 3 items"}];return false}else{var valid3=true;const len2=data6.length;for(let i2=0;i2<len2;i2++){let data7=data6[i2];const _errs16=errors;if(!(typeof data7=="number"&&isFinite(data7))){validate20$4.errors=[{instancePath:instancePath+"/scale/"+i2,schemaPath:"#/properties/scale/items/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid3=_errs16===errors;if(!valid3){break}}}}}else{validate20$4.errors=[{instancePath:instancePath+"/scale",schemaPath:"#/properties/scale/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}}var valid0=_errs14===errors}else{var valid0=true}if(valid0){if(data.order_in_layer!==undefined){let data8=data.order_in_layer;const _errs18=errors;if(!(typeof data8=="number"&&!(data8%1)&&!isNaN(data8)&&isFinite(data8))){validate20$4.errors=[{instancePath:instancePath+"/order_in_layer",schemaPath:"#/properties/order_in_layer/type",keyword:"type",params:{type:"integer"},message:"must be integer"}];return false}var valid0=_errs18===errors}else{var valid0=true}if(valid0){if(data.start_time!==undefined){let data9=data.start_time;const _errs20=errors;if(!(typeof data9=="number"&&isFinite(data9))){validate20$4.errors=[{instancePath:instancePath+"/start_time",schemaPath:"#/properties/start_time/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid0=_errs20===errors}else{var valid0=true}if(valid0){if(data.duration!==undefined){let data10=data.duration;const _errs22=errors;if(!(typeof data10=="number"&&isFinite(data10))){validate20$4.errors=[{instancePath:instancePath+"/duration",schemaPath:"#/properties/duration/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid0=_errs22===errors}else{var valid0=true}if(valid0){if(data.sticker_format!==undefined){let data11=data.sticker_format;const _errs24=errors;if(!(data11==="png"||data11==="jpeg"||data11==="gif"||data11==="mp4"||data11==="seq")){validate20$4.errors=[{instancePath:instancePath+"/sticker_format",schemaPath:"#/properties/sticker_format/enum",keyword:"enum",params:{allowedValues:schema22$4.properties.sticker_format.enum},message:"must be equal to one of the allowed values"}];return false}var valid0=_errs24===errors}else{var valid0=true}if(valid0){if(data.sticker_design_type!==undefined){let data12=data.sticker_design_type;const _errs25=errors;if(!(data12===0||data12===1)){validate20$4.errors=[{instancePath:instancePath+"/sticker_design_type",schemaPath:"#/properties/sticker_design_type/enum",keyword:"enum",params:{allowedValues:schema22$4.properties.sticker_design_type.enum},message:"must be equal to one of the allowed values"}];return false}var valid0=_errs25===errors}else{var valid0=true}if(valid0){if(data.sticker_path!==undefined){const _errs26=errors;if(typeof data.sticker_path!=="string"){validate20$4.errors=[{instancePath:instancePath+"/sticker_path",schemaPath:"#/properties/sticker_path/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid0=_errs26===errors}else{var valid0=true}if(valid0){if(data.sticker_resource_id!==undefined){const _errs28=errors;if(typeof data.sticker_resource_id!=="string"){validate20$4.errors=[{instancePath:instancePath+"/sticker_resource_id",schemaPath:"#/properties/sticker_resource_id/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid0=_errs28===errors}else{var valid0=true}if(valid0){if(data.resource_name_list!==undefined){let data15=data.resource_name_list;const _errs30=errors;{if(Array.isArray(data15)){var valid4=true;const len3=data15.length;for(let i3=0;i3<len3;i3++){let data16=data15[i3];const _errs32=errors;if(typeof data16!=="string"&&data16!==null){validate20$4.errors=[{instancePath:instancePath+"/resource_name_list/"+i3,schemaPath:"#/properties/resource_name_list/items/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid4=_errs32===errors;if(!valid4){break}}}else{validate20$4.errors=[{instancePath:instancePath+"/resource_name_list",schemaPath:"#/properties/resource_name_list/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}}var valid0=_errs30===errors}else{var valid0=true}if(valid0){if(data.sticker_alpha!==undefined){let data17=data.sticker_alpha;const _errs35=errors;if(!(typeof data17=="number"&&isFinite(data17))){validate20$4.errors=[{instancePath:instancePath+"/sticker_alpha",schemaPath:"#/properties/sticker_alpha/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid0=_errs35===errors}else{var valid0=true}if(valid0){if(data.sticker_flipX!==undefined){const _errs37=errors;if(typeof data.sticker_flipX!=="boolean"){validate20$4.errors=[{instancePath:instancePath+"/sticker_flipX",schemaPath:"#/properties/sticker_flipX/type",keyword:"type",params:{type:"boolean"},message:"must be boolean"}];return false}var valid0=_errs37===errors}else{var valid0=true}if(valid0){if(data.sticker_flipY!==undefined){const _errs39=errors;if(typeof data.sticker_flipY!=="boolean"){validate20$4.errors=[{instancePath:instancePath+"/sticker_flipY",schemaPath:"#/properties/sticker_flipY/type",keyword:"type",params:{type:"boolean"},message:"must be boolean"}];return false}var valid0=_errs39===errors}else{var valid0=true}if(valid0){if(data.fps!==undefined){let data20=data.fps;const _errs41=errors;if(!(typeof data20=="number"&&isFinite(data20))){validate20$4.errors=[{instancePath:instancePath+"/fps",schemaPath:"#/properties/fps/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid0=_errs41===errors}else{var valid0=true}if(valid0){if(data.sticker_loop!==undefined){const _errs43=errors;if(typeof data.sticker_loop!=="boolean"){validate20$4.errors=[{instancePath:instancePath+"/sticker_loop",schemaPath:"#/properties/sticker_loop/type",keyword:"type",params:{type:"boolean"},message:"must be boolean"}];return false}var valid0=_errs43===errors}else{var valid0=true}if(valid0){if(data.anims!==undefined){let data22=data.anims;const _errs45=errors;if(!Array.isArray(data22)&&data22!==null){validate20$4.errors=[{instancePath:instancePath+"/anims",schemaPath:"#/properties/anims/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}{if(Array.isArray(data22)){var valid5=true;const len4=data22.length;for(let i4=0;i4<len4;i4++){let data23=data22[i4];const _errs48=errors;if(!(data23&&typeof data23=="object"&&!Array.isArray(data23))){validate20$4.errors=[{instancePath:instancePath+"/anims/"+i4,schemaPath:"#/properties/anims/items/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}var valid5=_errs48===errors;if(!valid5){break}}}}var valid0=_errs45===errors}else{var valid0=true}}}}}}}}}}}}}}}}}}}}}else{validate20$4.errors=[{instancePath:instancePath,schemaPath:"#/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}}validate20$4.errors=vErrors;return errors===0}var widgetValidator={exports:{}};widgetValidator.exports=validate20$3;widgetValidator.exports.default=validate20$3;const schema22$3={type:"object",additionalProperties:true,required:["type"],properties:{type:{enum:["text","shape","sticker"]},name:{type:"string",nullable:false}}};function validate20$3(data,{instancePath:instancePath="",parentData:parentData,parentDataProperty:parentDataProperty,rootData:rootData=data}={}){let vErrors=null;let errors=0;{if(data&&typeof data=="object"&&!Array.isArray(data)){let missing0;if(data.type===undefined&&(missing0="type")){validate20$3.errors=[{instancePath:instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty:missing0},message:"must have required property '"+missing0+"'"}];return false}else{if(data.type!==undefined){let data0=data.type;const _errs2=errors;if(!(data0==="text"||data0==="shape"||data0==="sticker")){validate20$3.errors=[{instancePath:instancePath+"/type",schemaPath:"#/properties/type/enum",keyword:"enum",params:{allowedValues:schema22$3.properties.type.enum},message:"must be equal to one of the allowed values"}];return false}var valid0=_errs2===errors}else{var valid0=true}if(valid0){if(data.name!==undefined){const _errs3=errors;if(typeof data.name!=="string"){validate20$3.errors=[{instancePath:instancePath+"/name",schemaPath:"#/properties/name/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid0=_errs3===errors}else{var valid0=true}}}}else{validate20$3.errors=[{instancePath:instancePath,schemaPath:"#/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}}validate20$3.errors=vErrors;return errors===0}var animValidator={exports:{}};animValidator.exports=validate20$2;animValidator.exports.default=validate20$2;const schema22$2={type:"object",required:["anim_type"],additionalProperties:false,properties:{anim_type:{enum:["in","out","loop","caption"]},anim_script_type:{enum:["lua","js"]},anim_resource_id:{type:"string"},anim_resource_path:{type:"string"},anim_start_time:{type:"number"},duration:{type:"number"},loop_duration:{type:"number"}}};function validate20$2(data,{instancePath:instancePath="",parentData:parentData,parentDataProperty:parentDataProperty,rootData:rootData=data}={}){let vErrors=null;let errors=0;{if(data&&typeof data=="object"&&!Array.isArray(data)){let missing0;if(data.anim_type===undefined&&(missing0="anim_type")){validate20$2.errors=[{instancePath:instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty:missing0},message:"must have required property '"+missing0+"'"}];return false}else{for(const key0 in data){if(!(key0==="anim_type"||key0==="anim_script_type"||key0==="anim_resource_id"||key0==="anim_resource_path"||key0==="anim_start_time"||key0==="duration"||key0==="loop_duration")){validate20$2.errors=[{instancePath:instancePath,schemaPath:"#/additionalProperties",keyword:"additionalProperties",params:{additionalProperty:key0},message:"must NOT have additional properties"}];return false}}{if(data.anim_type!==undefined){let data0=data.anim_type;const _errs2=errors;if(!(data0==="in"||data0==="out"||data0==="loop"||data0==="caption")){validate20$2.errors=[{instancePath:instancePath+"/anim_type",schemaPath:"#/properties/anim_type/enum",keyword:"enum",params:{allowedValues:schema22$2.properties.anim_type.enum},message:"must be equal to one of the allowed values"}];return false}var valid0=_errs2===errors}else{var valid0=true}if(valid0){if(data.anim_script_type!==undefined){let data1=data.anim_script_type;const _errs3=errors;if(!(data1==="lua"||data1==="js")){validate20$2.errors=[{instancePath:instancePath+"/anim_script_type",schemaPath:"#/properties/anim_script_type/enum",keyword:"enum",params:{allowedValues:schema22$2.properties.anim_script_type.enum},message:"must be equal to one of the allowed values"}];return false}var valid0=_errs3===errors}else{var valid0=true}if(valid0){if(data.anim_resource_id!==undefined){const _errs4=errors;if(typeof data.anim_resource_id!=="string"){validate20$2.errors=[{instancePath:instancePath+"/anim_resource_id",schemaPath:"#/properties/anim_resource_id/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid0=_errs4===errors}else{var valid0=true}if(valid0){if(data.anim_resource_path!==undefined){const _errs6=errors;if(typeof data.anim_resource_path!=="string"){validate20$2.errors=[{instancePath:instancePath+"/anim_resource_path",schemaPath:"#/properties/anim_resource_path/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid0=_errs6===errors}else{var valid0=true}if(valid0){if(data.anim_start_time!==undefined){let data4=data.anim_start_time;const _errs8=errors;if(!(typeof data4=="number"&&isFinite(data4))){validate20$2.errors=[{instancePath:instancePath+"/anim_start_time",schemaPath:"#/properties/anim_start_time/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid0=_errs8===errors}else{var valid0=true}if(valid0){if(data.duration!==undefined){let data5=data.duration;const _errs10=errors;if(!(typeof data5=="number"&&isFinite(data5))){validate20$2.errors=[{instancePath:instancePath+"/duration",schemaPath:"#/properties/duration/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid0=_errs10===errors}else{var valid0=true}if(valid0){if(data.loop_duration!==undefined){let data6=data.loop_duration;const _errs12=errors;if(!(typeof data6=="number"&&isFinite(data6))){validate20$2.errors=[{instancePath:instancePath+"/loop_duration",schemaPath:"#/properties/loop_duration/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid0=_errs12===errors}else{var valid0=true}}}}}}}}}}else{validate20$2.errors=[{instancePath:instancePath,schemaPath:"#/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}}validate20$2.errors=vErrors;return errors===0}var dependValidator={exports:{}};dependValidator.exports=validate20$1;dependValidator.exports.default=validate20$1;const schema22$1={type:"object",required:["depend_resource_list"],additionalProperties:false,properties:{depend_resource_list:{type:"array",nullable:true,items:{type:"object",required:["type","resource_id"],additionalProperties:false,properties:{type:{enum:["fonts","text_animation","sticker_animation","shape_animation","sticker_resource","flower"]},resource_id:{type:"string"},resource_path:{}}}}}};function validate20$1(data,{instancePath:instancePath="",parentData:parentData,parentDataProperty:parentDataProperty,rootData:rootData=data}={}){let vErrors=null;let errors=0;{if(data&&typeof data=="object"&&!Array.isArray(data)){let missing0;if(data.depend_resource_list===undefined&&(missing0="depend_resource_list")){validate20$1.errors=[{instancePath:instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty:missing0},message:"must have required property '"+missing0+"'"}];return false}else{for(const key0 in data){if(!(key0==="depend_resource_list")){validate20$1.errors=[{instancePath:instancePath,schemaPath:"#/additionalProperties",keyword:"additionalProperties",params:{additionalProperty:key0},message:"must NOT have additional properties"}];return false}}{if(data.depend_resource_list!==undefined){let data0=data.depend_resource_list;if(!Array.isArray(data0)&&data0!==null){validate20$1.errors=[{instancePath:instancePath+"/depend_resource_list",schemaPath:"#/properties/depend_resource_list/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}{if(Array.isArray(data0)){var valid1=true;const len0=data0.length;for(let i0=0;i0<len0;i0++){let data1=data0[i0];const _errs5=errors;{if(data1&&typeof data1=="object"&&!Array.isArray(data1)){let missing1;if(data1.type===undefined&&(missing1="type")||data1.resource_id===undefined&&(missing1="resource_id")){validate20$1.errors=[{instancePath:instancePath+"/depend_resource_list/"+i0,schemaPath:"#/properties/depend_resource_list/items/required",keyword:"required",params:{missingProperty:missing1},message:"must have required property '"+missing1+"'"}];return false}else{for(const key1 in data1){if(!(key1==="type"||key1==="resource_id"||key1==="resource_path")){validate20$1.errors=[{instancePath:instancePath+"/depend_resource_list/"+i0,schemaPath:"#/properties/depend_resource_list/items/additionalProperties",keyword:"additionalProperties",params:{additionalProperty:key1},message:"must NOT have additional properties"}];return false}}{if(data1.type!==undefined){let data2=data1.type;const _errs8=errors;if(!(data2==="fonts"||data2==="text_animation"||data2==="sticker_animation"||data2==="shape_animation"||data2==="sticker_resource"||data2==="flower")){validate20$1.errors=[{instancePath:instancePath+"/depend_resource_list/"+i0+"/type",schemaPath:"#/properties/depend_resource_list/items/properties/type/enum",keyword:"enum",params:{allowedValues:schema22$1.properties.depend_resource_list.items.properties.type.enum},message:"must be equal to one of the allowed values"}];return false}var valid2=_errs8===errors}else{var valid2=true}if(valid2){if(data1.resource_id!==undefined){const _errs9=errors;if(typeof data1.resource_id!=="string"){validate20$1.errors=[{instancePath:instancePath+"/depend_resource_list/"+i0+"/resource_id",schemaPath:"#/properties/depend_resource_list/items/properties/resource_id/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid2=_errs9===errors}else{var valid2=true}}}}}else{validate20$1.errors=[{instancePath:instancePath+"/depend_resource_list/"+i0,schemaPath:"#/properties/depend_resource_list/items/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}}var valid1=_errs5===errors;if(!valid1){break}}}}}}}}else{validate20$1.errors=[{instancePath:instancePath,schemaPath:"#/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}}validate20$1.errors=vErrors;return errors===0}var textValidator={exports:{}};textValidator.exports=validate20;textValidator.exports.default=validate20;const schema22={type:"object",additionalProperties:true,required:["type"],properties:{name:{type:"string",nullable:false},type:{enum:["text"]},position:{type:"array",items:{type:"number"},maxItems:3,minItems:3},rotation:{type:"array",items:{type:"number"},maxItems:3,minItems:3},scale:{type:"array",items:{type:"number"},maxItems:3,minItems:3},order_in_layer:{type:"integer"},start_time:{type:"number"},duration:{type:"number"},text_params:{type:"object",additionalProperties:true,properties:{richText:{type:"string"}}},anims:{type:"array",nullable:true,items:{type:"object"}}}};function validate20(data,{instancePath:instancePath="",parentData:parentData,parentDataProperty:parentDataProperty,rootData:rootData=data}={}){let vErrors=null;let errors=0;{if(data&&typeof data=="object"&&!Array.isArray(data)){let missing0;if(data.type===undefined&&(missing0="type")){validate20.errors=[{instancePath:instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty:missing0},message:"must have required property '"+missing0+"'"}];return false}else{if(data.name!==undefined){const _errs2=errors;if(typeof data.name!=="string"){validate20.errors=[{instancePath:instancePath+"/name",schemaPath:"#/properties/name/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}var valid0=_errs2===errors}else{var valid0=true}if(valid0){if(data.type!==undefined){const _errs5=errors;if(!(data.type==="text")){validate20.errors=[{instancePath:instancePath+"/type",schemaPath:"#/properties/type/enum",keyword:"enum",params:{allowedValues:schema22.properties.type.enum},message:"must be equal to one of the allowed values"}];return false}var valid0=_errs5===errors}else{var valid0=true}if(valid0){if(data.position!==undefined){let data2=data.position;const _errs6=errors;{if(Array.isArray(data2)){if(data2.length>3){validate20.errors=[{instancePath:instancePath+"/position",schemaPath:"#/properties/position/maxItems",keyword:"maxItems",params:{limit:3},message:"must NOT have more than 3 items"}];return false}else{if(data2.length<3){validate20.errors=[{instancePath:instancePath+"/position",schemaPath:"#/properties/position/minItems",keyword:"minItems",params:{limit:3},message:"must NOT have fewer than 3 items"}];return false}else{var valid1=true;const len0=data2.length;for(let i0=0;i0<len0;i0++){let data3=data2[i0];const _errs8=errors;if(!(typeof data3=="number"&&isFinite(data3))){validate20.errors=[{instancePath:instancePath+"/position/"+i0,schemaPath:"#/properties/position/items/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid1=_errs8===errors;if(!valid1){break}}}}}else{validate20.errors=[{instancePath:instancePath+"/position",schemaPath:"#/properties/position/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}}var valid0=_errs6===errors}else{var valid0=true}if(valid0){if(data.rotation!==undefined){let data4=data.rotation;const _errs10=errors;{if(Array.isArray(data4)){if(data4.length>3){validate20.errors=[{instancePath:instancePath+"/rotation",schemaPath:"#/properties/rotation/maxItems",keyword:"maxItems",params:{limit:3},message:"must NOT have more than 3 items"}];return false}else{if(data4.length<3){validate20.errors=[{instancePath:instancePath+"/rotation",schemaPath:"#/properties/rotation/minItems",keyword:"minItems",params:{limit:3},message:"must NOT have fewer than 3 items"}];return false}else{var valid2=true;const len1=data4.length;for(let i1=0;i1<len1;i1++){let data5=data4[i1];const _errs12=errors;if(!(typeof data5=="number"&&isFinite(data5))){validate20.errors=[{instancePath:instancePath+"/rotation/"+i1,schemaPath:"#/properties/rotation/items/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid2=_errs12===errors;if(!valid2){break}}}}}else{validate20.errors=[{instancePath:instancePath+"/rotation",schemaPath:"#/properties/rotation/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}}var valid0=_errs10===errors}else{var valid0=true}if(valid0){if(data.scale!==undefined){let data6=data.scale;const _errs14=errors;{if(Array.isArray(data6)){if(data6.length>3){validate20.errors=[{instancePath:instancePath+"/scale",schemaPath:"#/properties/scale/maxItems",keyword:"maxItems",params:{limit:3},message:"must NOT have more than 3 items"}];return false}else{if(data6.length<3){validate20.errors=[{instancePath:instancePath+"/scale",schemaPath:"#/properties/scale/minItems",keyword:"minItems",params:{limit:3},message:"must NOT have fewer than 3 items"}];return false}else{var valid3=true;const len2=data6.length;for(let i2=0;i2<len2;i2++){let data7=data6[i2];const _errs16=errors;if(!(typeof data7=="number"&&isFinite(data7))){validate20.errors=[{instancePath:instancePath+"/scale/"+i2,schemaPath:"#/properties/scale/items/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid3=_errs16===errors;if(!valid3){break}}}}}else{validate20.errors=[{instancePath:instancePath+"/scale",schemaPath:"#/properties/scale/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}}var valid0=_errs14===errors}else{var valid0=true}if(valid0){if(data.order_in_layer!==undefined){let data8=data.order_in_layer;const _errs18=errors;if(!(typeof data8=="number"&&!(data8%1)&&!isNaN(data8)&&isFinite(data8))){validate20.errors=[{instancePath:instancePath+"/order_in_layer",schemaPath:"#/properties/order_in_layer/type",keyword:"type",params:{type:"integer"},message:"must be integer"}];return false}var valid0=_errs18===errors}else{var valid0=true}if(valid0){if(data.start_time!==undefined){let data9=data.start_time;const _errs20=errors;if(!(typeof data9=="number"&&isFinite(data9))){validate20.errors=[{instancePath:instancePath+"/start_time",schemaPath:"#/properties/start_time/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid0=_errs20===errors}else{var valid0=true}if(valid0){if(data.duration!==undefined){let data10=data.duration;const _errs22=errors;if(!(typeof data10=="number"&&isFinite(data10))){validate20.errors=[{instancePath:instancePath+"/duration",schemaPath:"#/properties/duration/type",keyword:"type",params:{type:"number"},message:"must be number"}];return false}var valid0=_errs22===errors}else{var valid0=true}if(valid0){if(data.text_params!==undefined){let data11=data.text_params;const _errs24=errors;{if(data11&&typeof data11=="object"&&!Array.isArray(data11)){if(data11.richText!==undefined){if(typeof data11.richText!=="string"){validate20.errors=[{instancePath:instancePath+"/text_params/richText",schemaPath:"#/properties/text_params/properties/richText/type",keyword:"type",params:{type:"string"},message:"must be string"}];return false}}}else{validate20.errors=[{instancePath:instancePath+"/text_params",schemaPath:"#/properties/text_params/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}}var valid0=_errs24===errors}else{var valid0=true}if(valid0){if(data.anims!==undefined){let data13=data.anims;const _errs29=errors;if(!Array.isArray(data13)&&data13!==null){validate20.errors=[{instancePath:instancePath+"/anims",schemaPath:"#/properties/anims/type",keyword:"type",params:{type:"array"},message:"must be array"}];return false}{if(Array.isArray(data13)){var valid5=true;const len3=data13.length;for(let i3=0;i3<len3;i3++){let data14=data13[i3];const _errs32=errors;if(!(data14&&typeof data14=="object"&&!Array.isArray(data14))){validate20.errors=[{instancePath:instancePath+"/anims/"+i3,schemaPath:"#/properties/anims/items/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}var valid5=_errs32===errors;if(!valid5){break}}}}var valid0=_errs29===errors}else{var valid0=true}}}}}}}}}}}}else{validate20.errors=[{instancePath:instancePath,schemaPath:"#/type",keyword:"type",params:{type:"object"},message:"must be object"}];return false}}validate20.errors=vErrors;return errors===0}class TemplateConfigParser{static parseConfig(configStr){const config=configStringToObject(configStr);if(TemplateConfigParser.useValidator){const validator=configValidator.exports;if(validator(config,{rootData:config})){if(config.type==="ScriptTemplate"){return config}}else{console.error(TEMPLATE_TAG,"TemplateConfigParser",JSON.stringify(validator.errors));return undefined}}return config}static parseChildNode(configStr){const config=configStringToObject(configStr);if(TemplateConfigParser.useValidator){const validator=widgetValidator.exports;if(validator(config,{rootData:config})){return config}else{console.error(TEMPLATE_TAG,"parseChildNode",JSON.stringify(validator.errors));return undefined}}return config}static parseSpriteConfig(configStr){const config=configStringToObject(configStr);if(TemplateConfigParser.useValidator){const validator=spriteValidator.exports;if(validator(config,{rootData:config})){return config}else{console.error(TEMPLATE_TAG,"parseSpriteConfig",JSON.stringify(validator.errors));return undefined}}return config}static parseTextConfig(configStr){const config=configStringToObject(configStr);if(TemplateConfigParser.useValidator){const validator=textValidator.exports;if(validator(config,{rootData:config})){return config}else{console.error(TEMPLATE_TAG,"parseTextConfig",JSON.stringify(validator.errors));return undefined}}return config}static parseAnimationConfig(configStr){const config=configStringToObject(configStr);if(TemplateConfigParser.useValidator){const validator=animValidator.exports;if(validator(config,{rootData:config})){return config}else{console.error(TEMPLATE_TAG,"parseAnimationConfig",JSON.stringify(validator.errors));return undefined}}return config}static parseDependConfig(configStr){const config=configStringToObject(configStr);if(TemplateConfigParser.useValidator){const validator=dependValidator.exports;if(validator(config,{rootData:config})){return config}else{console.error(TEMPLATE_TAG,"parseDependConfig",JSON.stringify(validator.errors));return undefined}}return config}}TemplateConfigParser.useValidator=true;function configStringToObject(configStr){let config=configStr;if(typeof configStr=="string"){config=JSON.parse(configStr)}return config}var Amaz$b=effect.Amaz;var Rect$1=Amaz$b.Rect;var Vec2$2=Amaz$b.Vector2f;var Vec3$3=Amaz$b.Vector3f;class Widget2D extends Widget{constructor(name,widgetType,scene){super(name,widgetType,scene);this.m_anchor=new Vec2$2(0,0);this.m_layoutParams={};this.m_layoutUpdateFirst=true;this.m_bindingBox=new Rect$1(0,0,0,0);this.m_animations=null;this.m_animationsDirty=false;this.m_scriptPassthroughParamsDirty=false;this.m_renderEntity=null;this.m_widgetOriginalPixelSize=new Vec2$2(0,0);this.m_widgetOriginalSize=new Vec2$2(0,0);this.m_normalizedSize=new Vec2$2(0,0);this.m_originalPixelSizeDirty=false;this.m_scriptPassthroughParams=new Map}set anchor(anchor){this.m_anchor=anchor}get anchor(){return this.m_anchor}get bindingBox(){return this.m_bindingBox}set layoutUpdateFirst(isFirst){this.m_layoutUpdateFirst=isFirst}get layoutUpdateFirst(){return this.m_layoutUpdateFirst}set layoutParams(layout){this.m_layoutParams=layout}get layoutParams(){return this.m_layoutParams}set originalPixelSize(size){if(!this.m_widgetOriginalPixelSize.eq(size)){this.m_widgetOriginalPixelSize=size;this.m_originalPixelSizeDirty=true}}get originalPixelSize(){return this.m_widgetOriginalPixelSize}set originalSize(size){if(!this.m_widgetOriginalSize.eq(size)){this.m_widgetOriginalSize=size}}get originalSize(){return this.m_widgetOriginalSize}getTextureNormalizedScale(){const normalizedScale=new Vec2$2(0,0);if(this.m_normalizedSize.x<0||this.m_normalizedSize.y<0||this.m_widgetOriginalSize.x<=0||this.m_widgetOriginalSize.y<=0){return normalizedScale}normalizedScale.x=this.m_normalizedSize.x/this.m_widgetOriginalSize.x;normalizedScale.y=this.m_normalizedSize.y/this.m_widgetOriginalSize.y;return normalizedScale}updateOriginalSize(size,screenSize){this.m_widgetOriginalPixelSize=size;this.m_widgetOriginalSize.x=size.x/screenSize.x*2;this.m_widgetOriginalSize.y=size.y/screenSize.y*2}setAnimationParameters(animation_arr){if(animation_arr&&animation_arr instanceof Array){animation_arr.forEach((value=>{if(null!=value){const animParam=TemplateConfigParser.parseAnimationConfig(value);if((animParam===null||animParam===void 0?void 0:animParam.anim_type)==null)return;if((animParam===null||animParam===void 0?void 0:animParam.anim_type)=="caption"){animParam.anim_type="loop"}const animation_type=AnimationType[animParam===null||animParam===void 0?void 0:animParam.anim_type];if(animation_type!=null){this.setWidgetAnimation(animParam.anim_resource_path,animParam.anim_resource_id,animParam.anim_script_type,animParam.anim_start_time,animParam.duration,animParam.loop_duration,animation_type);this.m_animationsDirty=true}else{console.error(TEMPLATE_TAG,"widget setAnimationParameters error, has no anim_type in json")}}}))}}setAnimationProperties(animation_property_arr){if(animation_property_arr&&animation_property_arr instanceof Array){animation_property_arr.forEach((value=>{var _a,_b;if(null!=value){if("anim_type"in value){const animation_type=AnimationType[value.anim_type];if(animation_type!=null){if((_a=this.m_animations)===null||_a===void 0?void 0:_a.has(animation_type)){const anim=(_b=this.m_animations)===null||_b===void 0?void 0:_b.get(animation_type);if(anim){if("propert_key"in value&&"propert_value"in value){const propertKey=value.propert_key;const propertValue=value.propert_value;anim.setAnimationProperty(new Map([[propertKey,propertValue]]))}}else{console.error(TEMPLATE_TAG,"widget setAnimationProperties error,anim_type is null")}}}else{console.error(TEMPLATE_TAG,"widget setAnimationProperties error, has no anim_type in json")}}}}))}}setParameters(jsonParam){if(jsonParam){super.parameters=jsonParam;if("layout_params"in jsonParam){const layoutParamConfig=jsonParam.layout_params;this.layoutParams=layoutParamConfig}if("original_size"in jsonParam){const widgetPixelSize=AmazUtils$1.CastJsonArray2fToAmazVector2f(jsonParam.original_size);if(widgetPixelSize){this.originalPixelSize=widgetPixelSize}else{console.error(TEMPLATE_TAG,"original_size in json is not vector2f:",JSON.stringify(jsonParam.original_size))}}if("anims"in jsonParam){const animation_arr=jsonParam.anims;this.setAnimationParameters(animation_arr)}if("anims_properties"in jsonParam){const animation_property_arr=jsonParam.anims_properties;this.setAnimationProperties(animation_property_arr)}}}getParameters(){const widget2DAnims=[];if(this.m_animations){this.m_animations.forEach(((anima,key)=>{if(anima){const anima_typestr=AnimationType[key];const animaScriptType=anima.animationScriptType===ScriptType.LUA?"lua":"js";const animation={anim_type:anima_typestr,anim_script_type:animaScriptType,anim_resource_id:anima.animationResourceID,anim_resource_path:anima.animationPath,anim_start_time:anima.animationStartTime,duration:anima.animationDuration,loop_duration:anima.m_animationLoopDuration};widget2DAnims.push(animation)}}))}const widget2DParam={original_size:[this.originalPixelSize.x,this.originalPixelSize.y],layout_params:this.layoutParams,anims:widget2DAnims};return widget2DParam}setWidgetAnimation(path,resourceID,scriptType,startTime,duration,loopDuration,animType){var _a,_b,_c;if(((_a=this.m_animations)===null||_a===void 0?void 0:_a.has(animType))&&((_c=(_b=this.m_animations)===null||_b===void 0?void 0:_b.get(animType))===null||_c===void 0?void 0:_c.animationPath)===path){this.updateWidgetAnimation(startTime,duration,loopDuration,animType)}else{this.resetAnimation(animType);if(path!=null&&path!=""){this.addWidgetAnimation(path,resourceID,scriptType,startTime,duration,loopDuration,animType)}}this.m_animationsDirty=true;return true}updateWidgetAnimation(startTime,duration,loopDuration,animType){var _a;const anim=(_a=this.m_animations)===null||_a===void 0?void 0:_a.get(animType);if(anim){if(-1!==startTime){anim.animationStartTime=startTime}anim.animationDuration=Math.max(duration,0);anim.animationEndTime=anim.animationStartTime+anim.animationDuration;anim.animationLoopDuration=Math.max(loopDuration,0)}}addWidgetAnimation(path,resourceID,scriptType,startTime,duration,loopDuration,animType){const anim=new Animation2D(path,resourceID,scriptType);anim.animationStartTime=startTime;anim.animationEndTime=startTime+Math.max(duration,0);anim.animationDuration=Math.max(duration,0);anim.animationLoopDuration=Math.max(loopDuration,0);anim.animationType=animType;if(null!=this.m_animations){this.m_animations.set(anim.animationType,anim)}else{this.m_animations=new Map;this.m_animations.set(anim.animationType,anim)}if(animType==AnimationType.loop){const extraPath=anim.animationPath+"/extra.json";const extraJsonStr=AmazFileUtils.readFileContent(extraPath);if(extraJsonStr!==undefined){const contentJson=JSON.parse(extraJsonStr);if(contentJson&&"caption_setting"in contentJson){const captionSetting=contentJson.caption_setting;if(captionSetting&&"merge_key_style"in captionSetting){const needMerge=captionSetting.merge_key_style;anim.m_needMerge=needMerge;return}}}anim.m_needMerge=true}return true}resetAnimation(animType){if(null!=this.m_animations&&this.m_animations.has(animType)){const anim=this.m_animations.get(animType);if(anim!==undefined){if(this.m_renderEntity){anim.unloadAnmation(this.m_renderEntity);this.m_animations.delete(anim.animationType)}}}}reloadAllAnimation(){var _a;(_a=this.m_animations)===null||_a===void 0?void 0:_a.forEach((anim=>{if(anim!==undefined){if(this.m_renderEntity){anim.reloadAnimation(this.m_renderEntity);this._updatePassthroughParams(anim)}}}))}resetAllAnimation(){var _a;(_a=this.m_animations)===null||_a===void 0?void 0:_a.forEach((anim=>{if(anim!==undefined){if(this.m_renderEntity){anim.unloadAnmation(this.m_renderEntity)}}}))}onLeaveAllAnimation(){var _a;(_a=this.m_animations)===null||_a===void 0?void 0:_a.forEach((anim=>{if(anim!==undefined){anim.onLeave()}}))}onUpdate(_timeStamp){super.onUpdate(_timeStamp)}_setPassthroughParams(scriptComponent){this.m_scriptPassthroughParams.forEach(((value,key)=>{scriptComponent.properties.set(key,value)}));scriptComponent.properties.set("enable_infosticker_new_text_component",true)}_updatePassthroughParams(anim){if(null!==anim.m_scriptComponent){this._setPassthroughParams(anim.m_scriptComponent)}}seekAnimations(timestamp){const isInRange=this.compareFloatRange;let animTimestamp=timestamp-this.startTime;if(animTimestamp<0)animTimestamp=0;if(!this.m_animations||!this.renderEntity){return}let reEnter=false;Array.from(this.m_animations).map((([anim_type,anim])=>{if(anim&&anim_type&&!anim.loaded){anim.loadAnimation(anim.animationPath,this.renderEntity);anim.setAnimationProperty()}if(this.m_scriptPassthroughParamsDirty===true&&anim){this._updatePassthroughParams(anim)}if(anim.script){const inAnim=isInRange(anim.animationStartTime,anim.animationEndTime,animTimestamp,true);if(inAnim){anim.script.enabled=true}else{anim.script.enabled=false}if(anim.script.enabled&&anim.m_state.started==false){if(!anim.script.getScript()){const scriptSystem=this.m_scene.getSystem("ScriptSystem");scriptSystem.initAndStartScript(anim.script)}anim.m_state.started=true}}return anim})).map((anim=>{if(anim){const inAnim=isInRange(anim.animationStartTime,anim.animationEndTime,animTimestamp,true);if(!inAnim&&anim.state.entered===true){anim.onLeave();if(!reEnter){reEnter=true;this.resetParams()}}}return anim})).map((anim=>{if(anim){const inAnim=isInRange(anim.animationStartTime,anim.animationEndTime,animTimestamp,true);if(inAnim){if(anim.state.entered===false||reEnter){anim.onEnter();anim.state.entered=true}anim.seek(animTimestamp)}}}));this.m_scriptPassthroughParamsDirty=false}resetParams(){}static createRenderEntity(scene,rootEntity,name,layer){const renderEntityName=name;const renderEntity=AmazUtils$1.createEntity(renderEntityName,scene);renderEntity.layer=layer;const localPos=new Vec3$3(0,0,0);const scale=new Vec3$3(1,1,1);const rotate=new Vec3$3(0,0,0);renderEntity.transform={position:localPos,scale:scale,rotation:rotate};if(rootEntity)AmazUtils$1.addChildEntity(rootEntity,renderEntity);return renderEntity}static removeRenderEntity(rootEntity,renderEntity){if(!renderEntity)return false;const root=rootEntity;if(root)AmazUtils$1.removeChildEntity(root,renderEntity);return true}get renderEntity(){if(!this.m_renderEntity){this.m_renderEntity=Widget2D.createRenderEntity(this.m_scene,this.m_rootEntity,this.m_name+"renderEntity",this.m_cameraLayer)}return this.m_renderEntity}set renderEntity(entity){if(this.m_renderEntity){Widget2D.removeRenderEntity(this.m_rootEntity,this.m_renderEntity);this.m_renderEntity.scene.removeEntity(this.m_renderEntity);this.m_renderEntity=null}this.m_renderEntity=entity}onUpdateAnimationDuration(originTime,newTime){var _a;if(this.m_animations==null)return;const animTimeRanges=new Map(Array.from(this.m_animations).map((val=>{const ret=[val[0],new TimeRange(val[1].animationStartTime,val[1].animationDuration)];return ret})));(_a=this.calculateAnimDuration(originTime,newTime,animTimeRanges))===null||_a===void 0?void 0:_a.forEach(((animTime,type)=>{if(this.m_animations!=null&&this.m_animations.has(type)){this.m_animations.get(type).animationStartTime=animTime.startTime;this.m_animations.get(type).animationEndTime=animTime.endTime}}))}calculateAnimDuration(originTimeRange,newTimeRange,animTimeRanges){const animDuration=Array.from(animTimeRanges).reduce(((prev,val)=>prev+val[1].duration),0);if(animDuration<originTimeRange.duration&&animDuration<newTimeRange.duration&&originTimeRange.duration!==0){const durationScale=newTimeRange.duration/originTimeRange.duration;return new Map(Array.from(animTimeRanges).map((val=>{const ret=[val[0],new TimeRange(val[1].startTime*durationScale,val[1].duration*durationScale)];return ret})))}return undefined}hasAnimation(){return this.m_animations!=null&&this.m_animations.size>0}hasAnimationWithType(type){if(this.m_animations!=null&&this.m_animations.size>0){return this.m_animations.has(type)}return false}updateLayoutInfo(){super.updateLayoutInfo();this.layoutInfo.m_widgetOriginalPixelSize=this.originalPixelSize.copy()}checkLayoutDirty(){if(Widget.m_isPostLayoutEnable==false){return}const oriLayoutInfo=this.layoutInfo.copy();this.updateLayoutInfo();if(this.layoutUpdateFirst){this.layoutParams.dirty=true;this.layoutUpdateFirst=false}else if(!oriLayoutInfo.isEqualTo(this.layoutInfo)){this.layoutParams.dirty=true}}}var Amaz$a=effect.Amaz;class ShapeAttributeSetter{static setRootScaleX(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="sx"){widget.scale=new Amaz$a.Vector3f(value,widget.scale.y,widget.scale.z)}}static setRootScaleY(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="sy"){widget.scale=new Amaz$a.Vector3f(widget.scale.x,value,widget.scale.z)}}static setRootRotationZ(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="rz"){widget.rotation=new Amaz$a.Vector3f(widget.rotation.x,widget.rotation.y,value)}}static setRootPosX(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="px"){widget.position=new Amaz$a.Vector3f(value,widget.position.y,widget.position.z)}}static setRootPosY(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="py"){widget.position=new Amaz$a.Vector3f(widget.position.x,value,widget.position.z)}}}ShapeAttributeSetter.setterMap={px:ShapeAttributeSetter.setRootPosX,py:ShapeAttributeSetter.setRootPosY,sx:ShapeAttributeSetter.setRootScaleX,sy:ShapeAttributeSetter.setRootScaleY,rz:ShapeAttributeSetter.setRootRotationZ};class ShapeValueGeneratorContext{constructor(widget,overlayMode,propertyName){this.widget=null;this.widget=widget;this.overlayMode=overlayMode;this.propertyName=propertyName}}class shapeAnimationController extends BaseAnimationController{constructor(widget){super();this.m_host=null;this.m_shape_motion=new Group;this.m_host=widget}updateKeyFrames(){if(!this.checkIsDirty()){return}this.m_keyFramesDirty=false;this.m_shape_motion.removeAll();if(this.m_keyframeParams==null){return}const keyframes=this.m_keyframeParams.keyframes;if(keyframes==null){return}for(let i=0;i<keyframes.length;i++){const keyframe=keyframes[i];let overlayMode="over";if(KeyframeAttrUtils.isValidOverlayMode(keyframe.overlay_mode))overlayMode=keyframe.overlay_mode;if(keyframe.k==null){console.error(TEMPLATE_TAG,"keyframe.k is undefined");return}const startTimeInSec=keyframe.s*KEYFRAME_TIME_FACTOR;const endTimeInSec=keyframe.e*KEYFRAME_TIME_FACTOR;if(endTimeInSec-startTimeInSec<TIME_EPS){console.error(TEMPLATE_TAG,"keyframe time range too short");return}this.setTimeRange(startTimeInSec,endTimeInSec);Object.keys(ShapeAttributeSetter.setterMap).forEach((key=>{if(keyframe.k[key]!=null){const shapeMotionContext=new ShapeValueGeneratorContext(this.m_host,overlayMode,key);this.createMotionsShapeProperty(keyframe,shapeMotionContext,key)}}))}}createMotionsShapeProperty(keyframeJson,motionContext,propertyName){const prop=keyframeJson.k[propertyName];const callback=ShapeAttributeSetter.setterMap[propertyName];if(prop==null){console.error(TEMPLATE_TAG,"prop is null");return}if(prop.length==0&&motionContext){console.error(TEMPLATE_TAG,"prop is empty");return}const interp=Interpolation.Linear;const keyframes=KeyframeAttrUtils.createKeyframes(keyframeJson,propertyName);KeyframeAttrUtils.createOneMotionByRelativeTime(keyframes,callback,interp,motionContext,this.m_shape_motion,propertyName,this.m_startTimeInSegment,this.m_endTimeInSegment,keyframeJson.s,keyframeJson.e).start()}update(timeInSegment){if(this.m_keyframeParams!=null){this.m_shape_motion.update(timeInSegment,true)}return 0}}const SDK_VERSION="13.1.0";const SCRIPT_VERSION="1.0.0";const TEXT_LOCALE_VER="13.3.0";const TEXT_BLOOM_VER="13.6.0";const TEXT_CANVAS_WH_FIXED_VER="14.2.0";const TEXT_PATH_TYPESETTING_VER="14.9.0";const TEXT_DIRECTION_LEVEL_VER="15.7.0";const TEXT_BACK_GROUNDS_VER="16.2.0";const TEXT_SHADOW_DIFFUSE_VER="16.3.0";class VersionUtils{static version2Str(version){const majorStr=String(version.major);const minorStr=String(version.minor);const revisionStr=String(version.revision);return majorStr+"."+minorStr+"."+revisionStr}static str2Version(str){const version={major:0,minor:0,revision:0};const vers=str.split(".",3);if(vers.length<3){return version}version.major=Number(vers[0]),version.minor=Number(vers[1]),version.revision=Number(vers[2]);return version}static compareVersion(version1,version2){const v1=[version1.major,version1.minor,version1.revision];const v2=[version2.major,version2.minor,version2.revision];for(let i=0;i<v1.length;i++){if(v1[i]>v2[i]){return 1}else if(v1[i]<v2[i]){return-1}}return 0}static versionMax(version1,version2){if(this.compareVersion(version1,version2)>=0){return version1}else{return version2}}static versionMin(version1,version2){if(this.compareVersion(version1,version2)<=0){return version1}else{return version2}}}var Amaz$9=effect.Amaz;var Vec3$2=Amaz$9.Vector3f;var Vec2$1=Amaz$9.Vector2f;var Color=Amaz$9.Color;var ShapeType;(function(ShapeType){ShapeType[ShapeType["CONTOUR_RECT"]=0]="CONTOUR_RECT";ShapeType[ShapeType["CONTOUR_ELLIPSE"]=1]="CONTOUR_ELLIPSE";ShapeType[ShapeType["CONTOUR_STAR"]=2]="CONTOUR_STAR";ShapeType[ShapeType["CONTOUR_POLYGON"]=3]="CONTOUR_POLYGON";ShapeType[ShapeType["CUSTOM_CONTOUR_POLYGON"]=4]="CUSTOM_CONTOUR_POLYGON";ShapeType[ShapeType["LINE"]=5]="LINE";ShapeType[ShapeType["ARROW"]=6]="ARROW"})(ShapeType||(ShapeType={}));var ShapeLineType;(function(ShapeLineType){ShapeLineType[ShapeLineType["SOLID_LINE"]=0]="SOLID_LINE";ShapeLineType[ShapeLineType["BROKEN_LINE"]=1]="BROKEN_LINE";ShapeLineType[ShapeLineType["DOTTED_LINE"]=2]="DOTTED_LINE"})(ShapeLineType||(ShapeLineType={}));const inlineSideType=Amaz$9.IFShapeStrokeSideType.INSIDE;const outlineSideType=Amaz$9.IFShapeStrokeSideType.OUTSIDE;const bothSideType=Amaz$9.IFShapeStrokeSideType.CENTER;const arrowLineWidthRatio=3.14;class Shape extends Widget2D{constructor(name,widgetType,scene){super(name,widgetType,scene);this.m_needUpdateShape=true;this.m_shapeParameters=null;this.m_shapeCom=null;this.m_shapeBlendEntity=null;this.m_shapeBlendMeshRenderer=null;this.m_renderRTTexture=null;this.m_shapeType=ShapeType.CUSTOM_CONTOUR_POLYGON;this.m_globalAlpha=1;this.m_pointsNumber=0;this.m_points=[];this.m_pointsIn=[];this.m_pointsOut=[];this.m_arrowPoints=new Amaz$9.Vec2Vector;this.m_color=new Color(1,0,0,1);this.m_roundness=[];this.m_shadowEnable=false;this.m_shadowColor=new Color(1,0,0,1);this.m_shadowOffset=new Vec2$1(0,0);this.m_lineWidth=21;this.m_lineType=ShapeLineType.SOLID_LINE;this.m_lineLength=[];this.m_lineGap=[];this.m_centerlineEnable=false;this.m_centerlineColor=new Color(1,0,0,1);this.m_centerlineWidth=21;this.m_centerlineType=ShapeLineType.SOLID_LINE;this.m_centerlineLength=[];this.m_centerlineGap=[];this.m_outlineEnable=false;this.m_outlineColor=new Color(1,0,0,1);this.m_outlineWidth=21;this.m_outlineType=ShapeLineType.SOLID_LINE;this.m_outlineLength=[];this.m_outlineGap=[];this.m_inlineEnable=false;this.m_inlineColor=new Color(1,0,0,1);this.m_inlineWidth=21;this.m_inlineType=ShapeLineType.SOLID_LINE;this.m_inlineLength=[];this.m_inlineGap=[];this.m_shapeContourPath=null;this.m_shapeCotourPathArrow=null;this.m_shapeRoundCorner=null;this.m_shapeContourEllipse=null;this.m_shapeSolidFill=null;this.m_shapeLineStroke=null;this.m_shapeArrowSolidFill=null;this.m_shapeArrowGroup=null;this.m_shapeLineStrokeDash=null;this.m_shapeShadowContourPath=null;this.m_shapeShadowCotourPathArrow=null;this.m_shapeShadowContourEllipse=null;this.m_shapeShadowSolidFill=null;this.m_shapeShadowLineStroke=null;this.m_shapeShadowArrowSolidFill=null;this.m_shapeShadowArrowGroup=null;this.m_shapeShadowLineStrokeDash=null;this.m_shadowGroup=null;this.m_centerlineSolidStroke=null;this.m_centerlineSolidStrokeDash=null;this.m_inlineSolidStroke=null;this.m_inlineSolidStrokeDash=null;this.m_outlineSolidStroke=null;this.m_outlineSolidStrokeDash=null;this.m_shapeGroup=null;this.m_shapeAnimationController=null;this.m_shapeKeyframeParams=null}createShape(jsonParam,scene){this._createShapeEntity(scene);this._creatShapeBlendEntity(scene);this._createShapeGroup(jsonParam);this.parameters=jsonParam}set parameters(params){super.setParameters(params);this.m_shapeParameters=params;if(this.m_shapeParameters==null){console.error(TEMPLATE_TAG,"shape parameter is null");return}this.m_needUpdateShape=true;this.updateRootEntityParam();this.updateShapeBlendOrder();this.updateShape();if("keyframe_params"in params&&this.widgetType===WidgetType.SHAPE){if(this.m_shapeAnimationController==null){this.m_shapeAnimationController=new shapeAnimationController(this)}if(this.m_shapeKeyframeParams!=params.keyframe_params){this.m_shapeKeyframeParams=params.keyframe_params;this.m_shapeAnimationController.setKeyFrameParams(this.m_shapeKeyframeParams)}}}get parameters(){const shapeParams={shape_type:this.shapeType,global_alpha:this.globalAlpha,custom_points:{points_number:this.pointNum,custom_roundness:this.shapeRoundness,points:this.points,points_in:this.pointsIn,points_out:this.pointsOut},color:[this.shapeColor.r,this.shapeColor.g,this.shapeColor.b,this.shapeColor.a],lineType:this.lineType,lineWidth:this.lineWidth,lineLength:this.lineLength,lineGap:this.lineGap,shadow:this.shadowEnable,shadowColor:[this.shadowColor.r,this.shadowColor.g,this.shadowColor.b,this.shadowColor.a],shadowOffset:[this.shadowOffset.x,this.shadowOffset.y],outline:this.outlineEnable,outlineWidth:this.outlineWidth,outlineType:this.outlineType,outlineLength:this.outlineLength,outlineGap:this.outlineGap,outlineColor:[this.outlineColor.r,this.outlineColor.g,this.outlineColor.b,this.outlineColor.a],inline:this.inlineEnable,inlineWidth:this.inlineWidth,inlineType:this.inlineType,inlineLength:this.inlineLength,inlineGap:this.inlineGap,inlineColor:[this.inlineColor.r,this.inlineColor.g,this.inlineColor.b,this.inlineColor.a],centerline:this.centerlineEnable,centerlineType:this.centerlineType,centerlineLength:this.centerlineLength,centerlineGap:this.centerlineGap,centerlineWidth:this.centerlineWidth,centerlineColor:[this.centerlineColor.r,this.centerlineColor.g,this.centerlineColor.b,this.centerlineColor.a]};const widgetParam=super.parameters;const widget2DParam=super.getParameters();const shapeSegmentParam={name:widgetParam.name,type:widgetParam.type,position:widgetParam.position,rotation:widgetParam.rotation,scale:widgetParam.scale,order_in_layer:widgetParam.order_in_layer,start_time:widgetParam.start_time,duration:widgetParam.duration,layout_params:widget2DParam.layout_params,original_size:widget2DParam.original_size,shape_params:shapeParams,anims:widget2DParam.anims,action_type:widgetParam.action_type};return shapeSegmentParam}set shapeType(shape_type){if(shape_type!==this.m_shapeType){this.m_shapeType=shape_type}}get shapeType(){return this.m_shapeType}set globalAlpha(alpha){if(alpha!==this.m_globalAlpha){this.m_globalAlpha=alpha}}get globalAlpha(){return this.m_globalAlpha}updateShapeBlendOrder(){if(this.m_needUpdateShapeBlendOrder){this.m_needUpdateShapeBlendOrder=false;const blendOrder=this.m_layer*LAYER_SIZE+this.m_localOrder*ORDER_SIZE+1;if(this.m_shapeBlendMeshRenderer){this.m_shapeBlendMeshRenderer.sortingOrder=blendOrder}}}updateShapeWH(){if(this.shapeType!==ShapeType.CUSTOM_CONTOUR_POLYGON){if(this.m_shapeContourEllipse&&this.m_shapeShadowContourEllipse){this.m_shapeContourEllipse.size=new Vec2$1(this.originalPixelSize.x,this.originalPixelSize.y);this.m_shapeShadowContourEllipse.size=new Vec2$1(this.originalPixelSize.x,this.originalPixelSize.y)}}}set pointNum(point_num){if(point_num!==this.m_pointsNumber){this.m_pointsNumber=point_num}}get pointNum(){return this.m_pointsNumber}calculateArrowPoints(points){const arrow=new Vec2$1(points[0]-points[2],points[1]-points[3]);this.m_arrowPoints.clear();if(arrow.x===0&&arrow.y===0){return}const arrowEnd=new Vec2$1(points[0],points[1]);const arrowDir=arrow.normalizeFast();const arrowLDir=new Vec2$1(-arrowDir.y,arrowDir.x);const arrowRDir=new Vec2$1(arrowDir.y,-arrowDir.x);const P1=Vec2$1.add(arrowEnd,Vec2$1.mul(arrowLDir,this.lineWidth*.5));const P7=Vec2$1.add(arrowEnd,Vec2$1.mul(arrowRDir,this.lineWidth*.5));const P4=Vec2$1.add(arrowEnd,Vec2$1.mul(arrowDir,this.lineWidth*(.5+Math.sqrt(2))));const arrowLBDir=Vec2$1.div(Vec2$1.sub(arrowLDir,arrowDir),Math.sqrt(2));const arrowRBDir=Vec2$1.div(Vec2$1.sub(arrowRDir,arrowDir),Math.sqrt(2));const P2=Vec2$1.add(P1,Vec2$1.mul(arrowLBDir,this.lineWidth*(arrowLineWidthRatio-.5-Math.sqrt(2)*.5)));const P6=Vec2$1.add(P7,Vec2$1.mul(arrowRBDir,this.lineWidth*(arrowLineWidthRatio-.5-Math.sqrt(2)*.5)));const P3=Vec2$1.add(P4,Vec2$1.mul(arrowLBDir,this.lineWidth*(arrowLineWidthRatio+.5)));const P5=Vec2$1.add(P4,Vec2$1.mul(arrowRBDir,this.lineWidth*(arrowLineWidthRatio+.5)));this.m_arrowPoints.pushBack(P1);this.m_arrowPoints.pushBack(P2);this.m_arrowPoints.pushBack(P3);this.m_arrowPoints.pushBack(P4);this.m_arrowPoints.pushBack(P5);this.m_arrowPoints.pushBack(P6);this.m_arrowPoints.pushBack(P7)}updateShapeArrowPath(){if(this.m_shapeCotourPathArrow&&this.m_shapeShadowCotourPathArrow&&this.m_points.length===4){this.calculateArrowPoints(this.m_points);this.m_shapeCotourPathArrow.pathPoints=this.m_arrowPoints;const shadowPointVec=new Amaz$9.Vec2Vector;const arrowPointsVec=new Amaz$9.Vec2Vector;const pathInPoint=new Vec2$1(0,0);for(let i=0;i<this.m_arrowPoints.size();i++){const shadowPoint=Vec2$1.add(this.m_arrowPoints.get(i),this.shadowOffset);shadowPointVec.pushBack(shadowPoint);arrowPointsVec.pushBack(pathInPoint)}this.m_shapeCotourPathArrow.pathInDirs=arrowPointsVec;this.m_shapeCotourPathArrow.pathOutDirs=arrowPointsVec;this.m_shapeShadowCotourPathArrow.pathPoints=shadowPointVec;this.m_shapeShadowCotourPathArrow.pathInDirs=arrowPointsVec;this.m_shapeShadowCotourPathArrow.pathOutDirs=arrowPointsVec}}set points(points){this.m_points=points;const shadowOffset=this.shadowOffset;if(this.shapeType===ShapeType.CUSTOM_CONTOUR_POLYGON||this.shapeType===ShapeType.LINE||this.shapeType===ShapeType.ARROW){if(this.pointNum===this.m_points.length/2){const pointsVec2=new Amaz$9.Vec2Vector;const shadowPoints=new Amaz$9.Vec2Vector;for(let i=0;i<this.pointNum;i++){const point=new Vec2$1(this.m_points[2*i],this.m_points[2*i+1]);const shadow_point=new Vec2$1(this.m_points[2*i]+shadowOffset.x,this.m_points[2*i+1]+shadowOffset.y);pointsVec2.pushBack(point);shadowPoints.pushBack(shadow_point)}if(this.m_shapeContourPath&&this.m_shapeShadowContourPath){this.m_shapeContourPath.pathPoints=pointsVec2;this.m_shapeShadowContourPath.pathPoints=shadowPoints}this.updateShapeArrowPath()}else{console.error(TEMPLATE_TAG,"shape points array not match point number!")}}}get points(){return this.m_points}set pointsIn(points_in){this.m_pointsIn=points_in;if(this.shapeType===ShapeType.CUSTOM_CONTOUR_POLYGON||this.shapeType===ShapeType.LINE||this.shapeType===ShapeType.ARROW){if(this.pointNum===this.m_pointsIn.length/2){const pointsIn=new Amaz$9.Vec2Vector;const shadow_points_in=new Amaz$9.Vec2Vector;for(let i=0;i<this.pointNum;i++){const point=new Vec2$1(this.m_pointsIn[2*i],this.m_pointsIn[2*i+1]);pointsIn.pushBack(point);shadow_points_in.pushBack(point)}if(this.m_shapeContourPath&&this.m_shapeShadowContourPath){this.m_shapeContourPath.pathInDirs=pointsIn;this.m_shapeShadowContourPath.pathInDirs=shadow_points_in}}else{console.error(TEMPLATE_TAG,"shape points in array not match point number!")}}}get pointsIn(){return this.m_pointsIn}set pointsOut(points_out){this.m_pointsOut=points_out;if(this.shapeType===ShapeType.CUSTOM_CONTOUR_POLYGON||this.shapeType===ShapeType.LINE||this.shapeType===ShapeType.ARROW){if(this.pointNum===this.m_pointsOut.length/2){const pointsOut=new Amaz$9.Vec2Vector;const shadow_points_out=new Amaz$9.Vec2Vector;for(let i=0;i<this.pointNum;i++){const point=new Vec2$1(this.m_pointsOut[2*i],this.m_pointsOut[2*i+1]);pointsOut.pushBack(point);shadow_points_out.pushBack(point)}if(this.m_shapeContourPath&&this.m_shapeShadowContourPath){this.m_shapeContourPath.pathOutDirs=pointsOut;this.m_shapeShadowContourPath.pathOutDirs=shadow_points_out}}else{console.error(TEMPLATE_TAG,"shape points out array not match point number!")}}}get pointsOut(){return this.m_pointsOut}set shapeColor(color){if(!this.m_color.eq(color)){this.m_color=color;if(this.m_shapeSolidFill){this.m_shapeSolidFill.color=color}if(this.m_shapeLineStroke){this.m_shapeLineStroke.color=color}if(this.m_shapeArrowSolidFill){this.m_shapeArrowSolidFill.color=color}}}get shapeColor(){return this.m_color}set shapeRoundness(roundness){this.m_roundness=roundness;if(this.m_shapeRoundCorner){const roundessArr=new Amaz$9.FloatVector;for(let i=0;i<roundness.length;i++){roundessArr.pushBack(roundness[i])}this.m_shapeRoundCorner.radius=roundessArr}}get shapeRoundness(){return this.m_roundness}updateShapeLineDash(width){if(this.lineType===ShapeLineType.DOTTED_LINE){if(this.m_shapeLineStrokeDash){this.m_shapeLineStrokeDash.offset=-.5*width}if(this.m_shapeShadowLineStrokeDash){this.m_shapeShadowLineStrokeDash.offset=-.5*width}}else{if(this.m_shapeLineStrokeDash){this.m_shapeLineStrokeDash.offset=0}if(this.m_shapeShadowLineStrokeDash){this.m_shapeShadowLineStrokeDash.offset=0}}}set lineWidth(width){if(this.m_lineWidth!==width){this.m_lineWidth=width;if(this.m_shapeLineStroke){this.m_shapeLineStroke.width=width}if(this.m_shapeShadowLineStroke){this.m_shapeShadowLineStroke.width=width}this.updateShapeLineDash(width)}}get lineWidth(){return this.m_lineWidth}set shadowEnable(enable){if(this.m_shadowEnable!==enable){this.m_shadowEnable=enable;if(this.m_shadowGroup){this.m_shadowGroup.enable=enable}}}get shadowEnable(){return this.m_shadowEnable}set shadowColor(color){if(!this.m_shadowColor.eq(color)){this.m_shadowColor=color;if(this.m_shapeShadowSolidFill){this.m_shapeShadowSolidFill.color=color}if(this.m_shapeShadowLineStroke){this.m_shapeShadowLineStroke.color=color}if(this.m_shapeShadowArrowSolidFill){this.m_shapeShadowArrowSolidFill.color=color}}}get shadowColor(){return this.m_shadowColor}set shadowOffset(offset){if(!this.m_shadowOffset.eq(offset)){this.m_shadowOffset=offset;if((this.shapeType===ShapeType.CUSTOM_CONTOUR_POLYGON||this.shapeType===ShapeType.LINE||this.shapeType===ShapeType.ARROW)&&this.m_shapeShadowContourPath){const shadowPoints=new Amaz$9.Vec2Vector;for(let i=0;i<this.pointNum;i++){const shadow_point=new Vec2$1(this.points[2*i]+offset.x,this.points[2*i+1]+offset.y);shadowPoints.pushBack(shadow_point)}this.m_shapeShadowContourPath.pathPoints=shadowPoints;if(this.shapeType===ShapeType.ARROW&&this.m_shapeShadowCotourPathArrow){const shadowArrowPoints=new Amaz$9.Vec2Vector;for(let i=0;i<this.m_arrowPoints.size();i++){const shadowPoint=Vec2$1.add(this.m_arrowPoints.get(i),offset);shadowArrowPoints.pushBack(shadowPoint)}this.m_shapeShadowCotourPathArrow.pathPoints=shadowArrowPoints}}else if(this.shapeType===ShapeType.CONTOUR_ELLIPSE&&this.m_shapeShadowContourEllipse){this.m_shapeShadowContourEllipse.position=offset}}}get shadowOffset(){return this.m_shadowOffset}set lineType(lineType){if(this.m_lineType!==lineType){this.m_lineType=lineType;if(lineType===ShapeLineType.DOTTED_LINE){if(this.m_shapeLineStroke){this.m_shapeLineStroke.capType=Amaz$9.IFShapeStrokeCapType.ROUND}if(this.m_shapeShadowLineStroke){this.m_shapeShadowLineStroke.capType=Amaz$9.IFShapeStrokeCapType.ROUND;const len=this.m_centerlineLength.length;for(let i=0;i<len;i++){this.m_centerlineLength[i]=0}}}else{if(lineType===ShapeLineType.SOLID_LINE){this.lineLength=[];this.lineGap=[]}if(this.m_shapeLineStroke){this.m_shapeLineStroke.capType=Amaz$9.IFShapeStrokeCapType.FLAT}if(this.m_shapeShadowLineStroke){this.m_shapeShadowLineStroke.capType=Amaz$9.IFShapeStrokeCapType.FLAT}}this.updateShapeLineDash(this.lineWidth)}}get lineType(){return this.m_lineType}set lineLength(length){this.m_lineLength=length;if(this.lineType===ShapeLineType.SOLID_LINE){this.m_lineLength=[]}else if(this.lineType===ShapeLineType.DOTTED_LINE){const len=this.m_lineLength.length;for(let i=0;i<len;i++){this.m_lineLength[i]=0}}if(this.m_shapeLineStrokeDash&&this.m_shapeShadowLineStrokeDash){const lengthArr=new Amaz$9.FloatVector;const arrSize=this.m_lineLength.length;for(let i=0;i<arrSize;i++){lengthArr.pushBack(this.m_lineLength[i])}this.m_shapeLineStrokeDash.lenth=lengthArr;this.m_shapeShadowLineStrokeDash.lenth=lengthArr}}get lineLength(){return this.m_lineLength}set lineGap(gap){this.m_lineGap=gap;if(this.lineType===ShapeLineType.SOLID_LINE){this.m_lineGap=[]}if(this.m_shapeLineStrokeDash&&this.m_shapeShadowLineStrokeDash){const gapArr=new Amaz$9.FloatVector;const arrSize=this.m_lineGap.length;for(let i=0;i<arrSize;i++){gapArr.pushBack(this.m_lineGap[i])}this.m_shapeLineStrokeDash.gap=gapArr;this.m_shapeShadowLineStrokeDash.gap=gapArr}}get lineGap(){return this.m_lineGap}set centerlineEnable(enable){if(this.m_centerlineEnable!==enable){this.m_centerlineEnable=enable;if(this.m_centerlineSolidStroke){this.m_centerlineSolidStroke.enable=enable}}}get centerlineEnable(){return this.m_centerlineEnable}set centerlineType(lineType){if(this.m_centerlineType!==lineType){this.m_centerlineType=lineType;if(this.m_centerlineSolidStroke){if(lineType===ShapeLineType.DOTTED_LINE){this.m_centerlineSolidStroke.capType=Amaz$9.IFShapeStrokeCapType.ROUND;const len=this.m_centerlineLength.length;for(let i=0;i<len;i++){this.m_centerlineLength[i]=0}}else{if(lineType===ShapeLineType.SOLID_LINE){this.centerlineLength=[];this.centerlineGap=[]}this.m_centerlineSolidStroke.capType=Amaz$9.IFShapeStrokeCapType.FLAT}}}}get centerlineType(){return this.m_centerlineType}set centerlineLength(length){this.m_centerlineLength=length;if(this.centerlineType===ShapeLineType.SOLID_LINE){this.m_centerlineLength=[]}else if(this.centerlineType===ShapeLineType.DOTTED_LINE){const len=this.m_centerlineLength.length;for(let i=0;i<len;i++){this.m_centerlineLength[i]=0}}if(this.m_centerlineSolidStrokeDash){const lenghtArr=new Amaz$9.FloatVector;const arraySize=this.m_centerlineLength.length;for(let i=0;i<arraySize;i++){lenghtArr.pushBack(this.m_centerlineLength[i])}this.m_centerlineSolidStrokeDash.lenth=lenghtArr}}get centerlineLength(){return this.m_centerlineLength}set centerlineGap(gap){this.m_centerlineGap=gap;if(this.centerlineType===ShapeLineType.SOLID_LINE){this.m_centerlineGap=[]}if(this.m_centerlineSolidStrokeDash){const gapArr=new Amaz$9.FloatVector;const arraySize=this.m_centerlineGap.length;for(let i=0;i<arraySize;i++){gapArr.pushBack(this.m_centerlineGap[i])}this.m_centerlineSolidStrokeDash.gap=gapArr}}get centerlineGap(){return this.m_centerlineGap}set centerlineColor(color){if(!this.m_centerlineColor.eq(color)){this.m_centerlineColor=color;if(this.m_centerlineSolidStroke){this.m_centerlineSolidStroke.color=color}}}get centerlineColor(){return this.m_centerlineColor}set centerlineWidth(width){if(this.m_centerlineWidth!==width){this.m_centerlineWidth=width;if(this.m_centerlineSolidStroke){this.m_centerlineSolidStroke.width=width}}}get centerlineWidth(){return this.m_centerlineWidth}set outlineEnable(enable){if(this.m_outlineEnable!==enable){this.m_outlineEnable=enable;if(this.m_outlineSolidStroke){this.m_outlineSolidStroke.enable=enable}}}get outlineEnable(){return this.m_outlineEnable}set outlineType(lineType){if(this.m_outlineType!==lineType){this.m_outlineType=lineType;if(this.m_outlineSolidStroke){if(lineType===ShapeLineType.DOTTED_LINE){this.m_outlineSolidStroke.capType=Amaz$9.IFShapeStrokeCapType.ROUND;const len=this.m_centerlineLength.length;for(let i=0;i<len;i++){this.m_centerlineLength[i]=0}}else{if(lineType===ShapeLineType.SOLID_LINE){this.outlineLength=[];this.outlineGap=[]}this.m_outlineSolidStroke.capType=Amaz$9.IFShapeStrokeCapType.FLAT}}}}get outlineType(){return this.m_outlineType}set outlineLength(length){this.m_outlineLength=length;if(this.outlineType===ShapeLineType.SOLID_LINE){this.m_outlineLength=[]}else if(this.outlineType===ShapeLineType.DOTTED_LINE){const len=this.m_outlineLength.length;for(let i=0;i<len;i++){this.m_outlineLength[i]=0}}if(this.m_outlineSolidStrokeDash){const lenghtArr=new Amaz$9.FloatVector;const arraySize=this.m_outlineLength.length;for(let i=0;i<arraySize;i++){lenghtArr.pushBack(this.m_outlineLength[i])}this.m_outlineSolidStrokeDash.lenth=lenghtArr}}get outlineLength(){return this.m_outlineLength}set outlineGap(gap){this.m_outlineGap=gap;if(this.outlineType===ShapeLineType.SOLID_LINE){this.m_outlineGap=[]}if(this.m_outlineSolidStrokeDash){const gapArr=new Amaz$9.FloatVector;const arraySize=this.m_outlineGap.length;for(let i=0;i<arraySize;i++){gapArr.pushBack(this.m_outlineGap[i])}this.m_outlineSolidStrokeDash.gap=gapArr}}get outlineGap(){return this.m_outlineGap}set outlineColor(color){if(!this.m_outlineColor.eq(color)){this.m_outlineColor=color;if(this.m_outlineSolidStroke){this.m_outlineSolidStroke.color=color}}}get outlineColor(){return this.m_outlineColor}set outlineWidth(width){if(this.m_outlineWidth!==width){this.m_outlineWidth=width;if(this.m_outlineSolidStroke){this.m_outlineSolidStroke.width=width}}}get outlineWidth(){return this.m_outlineWidth}set inlineEnable(enable){if(this.m_inlineEnable!==enable){this.m_inlineEnable=enable;if(this.m_inlineSolidStroke){this.m_inlineSolidStroke.enable=enable}}}get inlineEnable(){return this.m_inlineEnable}set inlineType(lineType){if(this.m_inlineType!==lineType){this.m_inlineType=lineType;if(this.m_inlineSolidStroke){if(lineType===ShapeLineType.DOTTED_LINE){this.m_inlineSolidStroke.capType=Amaz$9.IFShapeStrokeCapType.ROUND;const len=this.m_centerlineLength.length;for(let i=0;i<len;i++){this.m_centerlineLength[i]=0}}else{if(lineType===ShapeLineType.SOLID_LINE){this.inlineLength=[];this.inlineGap=[]}this.m_inlineSolidStroke.capType=Amaz$9.IFShapeStrokeCapType.FLAT}}}}get inlineType(){return this.m_inlineType}set inlineLength(length){this.m_inlineLength=length;if(this.inlineType===ShapeLineType.SOLID_LINE){this.m_inlineLength=[]}else if(this.inlineType===ShapeLineType.DOTTED_LINE){const len=this.m_inlineLength.length;for(let i=0;i<len;i++){this.m_inlineLength[i]=0}}if(this.m_inlineSolidStrokeDash){const lenghtArr=new Amaz$9.FloatVector;const arraySize=this.m_inlineLength.length;for(let i=0;i<arraySize;i++){lenghtArr.pushBack(this.m_inlineLength[i])}this.m_inlineSolidStrokeDash.lenth=lenghtArr}}get inlineLength(){return this.m_inlineLength}set inlineGap(gap){this.m_inlineGap=gap;if(this.inlineType===ShapeLineType.SOLID_LINE){this.m_inlineGap=[]}if(this.m_inlineSolidStrokeDash){const gapArr=new Amaz$9.FloatVector;const arraySize=this.m_inlineGap.length;for(let i=0;i<arraySize;i++){gapArr.pushBack(this.m_inlineGap[i])}this.m_inlineSolidStrokeDash.gap=gapArr}}get inlineGap(){return this.m_inlineGap}set inlineColor(color){if(!this.m_inlineColor.eq(color)){this.m_inlineColor=color;if(this.m_inlineSolidStroke){this.m_inlineSolidStroke.color=color}}}get inlineColor(){return this.m_inlineColor}set inlineWidth(width){if(this.m_inlineWidth!==width){this.m_inlineWidth=width;if(this.m_inlineSolidStroke){this.m_inlineSolidStroke.width=width}}}get inlineWidth(){return this.m_inlineWidth}_updateShapeBaseParameters(jsonParam){if("global_alpha"in jsonParam){const alpha=jsonParam.global_alpha;this.globalAlpha=alpha}if("color"in jsonParam){const color=AmazUtils$1.CastJsonArray4fToColor(jsonParam.color);if(null!==color){this.shapeColor=color}else{console.error(TEMPLATE_TAG,"shape color json error:",JSON.stringify(jsonParam.color))}}if("lineWidth"in jsonParam){const lineWidthVal=jsonParam.lineWidth;this.lineWidth=lineWidthVal}if("lineType"in jsonParam){const lineType=jsonParam.lineType;this.lineType=lineType}if("lineLength"in jsonParam){const lineLengthArr=jsonParam.lineLength;this.lineLength=lineLengthArr}if("lineGap"in jsonParam){const lineGapArr=jsonParam.lineGap;this.lineGap=lineGapArr}}_updateShapeCustomPoints(jsonParam){if("custom_points"in jsonParam){const configCustomPoints=jsonParam.custom_points;if(configCustomPoints){let pointsNumber=this.pointNum;if("points_number"in configCustomPoints){pointsNumber=configCustomPoints.points_number;this.pointNum=pointsNumber}if("points"in configCustomPoints){const pointArray=configCustomPoints.points;const pointCount=pointArray.length/2;if(pointCount===pointsNumber){this.points=pointArray}else{console.error(TEMPLATE_TAG,"create custom points shape group: points number is not match the points array:",JSON.stringify(configCustomPoints.points));return false}}if("points_in"in configCustomPoints){const pointInArray=configCustomPoints.points_in;const pointCount=pointInArray.length/2;if(pointCount===pointsNumber){this.pointsIn=pointInArray}else{console.error(TEMPLATE_TAG,"create custom points shape group: points number is not match the points_in array:",JSON.stringify(configCustomPoints.points_in));return false}}if("points_out"in configCustomPoints){const pointOutArray=configCustomPoints.points_out;const pointCount=pointOutArray.length/2;if(pointCount===pointsNumber){this.pointsOut=pointOutArray}else{console.error(TEMPLATE_TAG,"create custom points shape group: points number is not match the points_out array:",JSON.stringify(configCustomPoints.points_out));return false}}if("custom_roundness"in configCustomPoints){const roundness=configCustomPoints.custom_roundness;const roundnessCount=roundness.length;if(pointsNumber===roundnessCount){this.shapeRoundness=roundness}else{console.error(TEMPLATE_TAG,"create custom points shape group: points number is not match the roundness array:",JSON.stringify(configCustomPoints.roundness))}}}}return true}_updateShapeCenterline(jsonParam){if("centerline"in jsonParam){const centerlineEnable=jsonParam.centerline;this.centerlineEnable=centerlineEnable}if("centerlineType"in jsonParam){const centerlineType=jsonParam.centerlineType;this.centerlineType=centerlineType}if("centerlineLength"in jsonParam){const lineLengthArr=jsonParam.centerlineLength;this.centerlineLength=lineLengthArr}if("centerlineGap"in jsonParam){const lineGapArr=jsonParam.centerlineGap;this.centerlineGap=lineGapArr}if("centerlineWidth"in jsonParam){const centerlineWidth=jsonParam.centerlineWidth;this.centerlineWidth=centerlineWidth}if("centerlineColor"in jsonParam){const centerlineColor=AmazUtils$1.CastJsonArray4fToColor(jsonParam.centerlineColor);if(null!==centerlineColor){this.centerlineColor=centerlineColor}else{console.error(TEMPLATE_TAG,"shape outline color json error:",JSON.stringify(jsonParam.centerlineColor))}}}_updateShapeOutline(jsonParam){if("outline"in jsonParam){const outlineEnable=jsonParam.outline;this.outlineEnable=outlineEnable}if("outlineType"in jsonParam){const outlineType=jsonParam.outlineType;this.outlineType=outlineType}if("outlineLength"in jsonParam){const lineLengthArr=jsonParam.outlineLength;this.outlineLength=lineLengthArr}if("outlineGap"in jsonParam){const lineGapArr=jsonParam.outlineGap;this.outlineGap=lineGapArr}if("outlineWidth"in jsonParam){const outlineWidth=jsonParam.outlineWidth;this.outlineWidth=outlineWidth}if("outlineColor"in jsonParam){const outlineColor=AmazUtils$1.CastJsonArray4fToColor(jsonParam.outlineColor);if(null!==outlineColor){this.outlineColor=outlineColor}else{console.error(TEMPLATE_TAG,"shape outline color json error:",JSON.stringify(jsonParam.outlineColor))}}}_updateShapeInline(jsonParam){if("inline"in jsonParam){const inlineEnable=jsonParam.inline;this.inlineEnable=inlineEnable}if("inlineType"in jsonParam){const inlineType=jsonParam.inlineType;this.inlineType=inlineType}if("inlineLength"in jsonParam){const lineLengthArr=jsonParam.inlineLength;this.inlineLength=lineLengthArr}if("inlineGap"in jsonParam){const lineGapArr=jsonParam.inlineGap;this.inlineGap=lineGapArr}if("inlineWidth"in jsonParam){const inlineWidth=jsonParam.inlineWidth;this.inlineWidth=inlineWidth}if("inlineColor"in jsonParam){const inlineColor=AmazUtils$1.CastJsonArray4fToColor(jsonParam.inlineColor);if(null!==inlineColor){this.inlineColor=inlineColor}else{console.error(TEMPLATE_TAG,"shape inline color json error:",JSON.stringify(jsonParam.inlineColor))}}}_updateShapeShadow(jsonParam){if("shadow"in jsonParam){const shadowEnable=jsonParam.shadow;this.shadowEnable=shadowEnable}if("shadowColor"in jsonParam){const shadowColor=AmazUtils$1.CastJsonArray4fToColor(jsonParam.shadowColor);if(null!=shadowColor){this.shadowColor=shadowColor}else{console.error(TEMPLATE_TAG,"shape shadow color json error:",JSON.stringify(jsonParam.shadowColor))}}if("shadowOffset"in jsonParam){const shadowOffset=AmazUtils$1.CastJsonArray2fToAmazVector2f(jsonParam.shadowOffset);if(null!=shadowOffset){this.shadowOffset=shadowOffset}else{console.error(TEMPLATE_TAG,"shape shadow offset json error:",JSON.stringify(jsonParam.shadowOffset))}}}_createCenterlineShape(){this.m_centerlineSolidStrokeDash=new Amaz$9.IFShapeStrokeDash;this.m_centerlineSolidStrokeDash.mode=Amaz$9.IFShapeStrokeDashMode.ADAPT;this.m_centerlineSolidStroke=new Amaz$9.IFShapeDrawSolidStroke;this.m_centerlineSolidStroke.sideType=bothSideType;this.m_centerlineSolidStroke.enable=false;this.m_centerlineSolidStroke.dash=this.m_centerlineSolidStrokeDash}_createInlineShape(){this.m_inlineSolidStrokeDash=new Amaz$9.IFShapeStrokeDash;this.m_inlineSolidStrokeDash.mode=Amaz$9.IFShapeStrokeDashMode.ADAPT;this.m_inlineSolidStroke=new Amaz$9.IFShapeDrawSolidStroke;this.m_inlineSolidStroke.sideType=inlineSideType;this.m_inlineSolidStroke.enable=false;this.m_inlineSolidStroke.dash=this.m_inlineSolidStrokeDash}_createOutlineShape(){this.m_outlineSolidStrokeDash=new Amaz$9.IFShapeStrokeDash;this.m_outlineSolidStrokeDash.mode=Amaz$9.IFShapeStrokeDashMode.ADAPT;this.m_outlineSolidStroke=new Amaz$9.IFShapeDrawSolidStroke;this.m_outlineSolidStroke.sideType=outlineSideType;this.m_outlineSolidStroke.enable=false;this.m_outlineSolidStroke.dash=this.m_outlineSolidStrokeDash}_createShapeRoundCorner(){this.m_shapeRoundCorner=new Amaz$9.IFShapeRoundCorner}_createCustomPointShapeGroup(){this.m_shapeContourPath=new Amaz$9.IFShapeContourPath;this.m_shapeSolidFill=new Amaz$9.IFShapeDrawSolidFill;this._createInlineShape();this._createCenterlineShape();this._createOutlineShape();this.m_shapeShadowContourPath=new Amaz$9.IFShapeContourPath;this.m_shapeShadowSolidFill=new Amaz$9.IFShapeDrawSolidFill;this.m_shadowGroup=new Amaz$9.IFShapeGroup;const shadowVector=new Amaz$9.Vector;shadowVector.pushBack(this.m_shapeShadowContourPath);shadowVector.pushBack(this.m_shapeShadowSolidFill);this.m_shadowGroup.shapeElements=shadowVector;this.m_shadowGroup.enable=false;this._createShapeRoundCorner();return true}_createEllipseShapeGroup(){this.m_shapeContourEllipse=new Amaz$9.IFShapeContourEllipse;this.m_shapeSolidFill=new Amaz$9.IFShapeDrawSolidFill;this._createInlineShape();this._createCenterlineShape();this._createOutlineShape();this.m_shapeShadowContourEllipse=new Amaz$9.IFShapeContourEllipse;this.m_shapeShadowSolidFill=new Amaz$9.IFShapeDrawSolidFill;this.m_shadowGroup=new Amaz$9.IFShapeGroup;const shadowVector=new Amaz$9.Vector;shadowVector.pushBack(this.m_shapeShadowContourEllipse);shadowVector.pushBack(this.m_shapeShadowSolidFill);this.m_shadowGroup.shapeElements=shadowVector;this.m_shadowGroup.enable=false}_createLine(){this.m_shapeContourPath=new Amaz$9.IFShapeContourPath;this.m_shapeContourPath.closed=false;this.m_shapeLineStrokeDash=new Amaz$9.IFShapeStrokeDash;this.m_shapeLineStroke=new Amaz$9.IFShapeDrawSolidStroke;this.m_shapeLineStroke.sideType=bothSideType;this.m_shapeLineStroke.dash=this.m_shapeLineStrokeDash;this.m_shapeShadowContourPath=new Amaz$9.IFShapeContourPath;this.m_shapeShadowContourPath.closed=false;this.m_shapeShadowLineStrokeDash=new Amaz$9.IFShapeStrokeDash;this.m_shapeShadowLineStroke=new Amaz$9.IFShapeDrawSolidStroke;this.m_shapeShadowLineStroke.sideType=bothSideType;this.m_shapeShadowLineStroke.dash=this.m_shapeShadowLineStrokeDash;this.m_shadowGroup=new Amaz$9.IFShapeGroup;const shadowVector=new Amaz$9.Vector;shadowVector.pushBack(this.m_shapeShadowContourPath);shadowVector.pushBack(this.m_shapeShadowLineStroke);this.m_shadowGroup.shapeElements=shadowVector;this.m_shadowGroup.enable=false}_createArrow(){const arrowPointsVec=new Amaz$9.Vec2Vector;this.m_shapeContourPath=new Amaz$9.IFShapeContourPath;this.m_shapeContourPath.closed=false;this.m_shapeCotourPathArrow=new Amaz$9.IFShapeContourPath;this.m_shapeCotourPathArrow.pathInDirs=arrowPointsVec;this.m_shapeCotourPathArrow.pathOutDirs=arrowPointsVec;this.m_shapeArrowSolidFill=new Amaz$9.IFShapeDrawSolidFill;this.m_shapeArrowGroup=new Amaz$9.IFShapeGroup;const shapeArrowArr=new Amaz$9.Vector;shapeArrowArr.pushBack(this.m_shapeCotourPathArrow);shapeArrowArr.pushBack(this.m_shapeArrowSolidFill);this.m_shapeArrowGroup.shapeElements=shapeArrowArr;this.m_shapeLineStrokeDash=new Amaz$9.IFShapeStrokeDash;this.m_shapeLineStroke=new Amaz$9.IFShapeDrawSolidStroke;this.m_shapeLineStroke.sideType=bothSideType;this.m_shapeLineStroke.dash=this.m_shapeLineStrokeDash;this.m_shapeShadowContourPath=new Amaz$9.IFShapeContourPath;this.m_shapeShadowContourPath.closed=false;this.m_shapeShadowCotourPathArrow=new Amaz$9.IFShapeContourPath;this.m_shapeShadowCotourPathArrow.pathInDirs=arrowPointsVec;this.m_shapeShadowCotourPathArrow.pathOutDirs=arrowPointsVec;this.m_shapeShadowArrowSolidFill=new Amaz$9.IFShapeDrawSolidFill;this.m_shapeShadowArrowGroup=new Amaz$9.IFShapeGroup;const shapeShadowArrowArr=new Amaz$9.Vector;shapeShadowArrowArr.pushBack(this.m_shapeShadowCotourPathArrow);shapeShadowArrowArr.pushBack(this.m_shapeShadowArrowSolidFill);this.m_shapeShadowArrowGroup.shapeElements=shapeShadowArrowArr;this.m_shapeShadowLineStrokeDash=new Amaz$9.IFShapeStrokeDash;this.m_shapeShadowLineStroke=new Amaz$9.IFShapeDrawSolidStroke;this.m_shapeShadowLineStroke.sideType=bothSideType;this.m_shapeShadowLineStroke.dash=this.m_shapeShadowLineStrokeDash;this.m_shadowGroup=new Amaz$9.IFShapeGroup;const shadowVector=new Amaz$9.Vector;shadowVector.pushBack(this.m_shapeShadowContourPath);shadowVector.pushBack(this.m_shapeShadowLineStroke);shadowVector.pushBack(this.m_shapeShadowArrowGroup);this.m_shadowGroup.shapeElements=shadowVector;this.m_shadowGroup.enable=false}_packageShape(shapeType){this.m_shapeGroup=new Amaz$9.IFShapeGroup;const shapeVector=new Amaz$9.Vector;if(shapeType===ShapeType.CUSTOM_CONTOUR_POLYGON||shapeType===ShapeType.LINE){if(this.m_shapeContourPath){shapeVector.pushBack(this.m_shapeContourPath)}if(this.m_shapeLineStroke&&shapeType===ShapeType.LINE){shapeVector.pushBack(this.m_shapeLineStroke)}}else if(shapeType===ShapeType.CONTOUR_ELLIPSE){if(this.m_shapeContourEllipse){shapeVector.pushBack(this.m_shapeContourEllipse)}}else if(shapeType===ShapeType.ARROW){if(this.m_shapeContourPath&&this.m_shapeArrowGroup&&this.m_shapeLineStroke){shapeVector.pushBack(this.m_shapeContourPath);shapeVector.pushBack(this.m_shapeLineStroke);shapeVector.pushBack(this.m_shapeArrowGroup)}}if(this.m_outlineSolidStroke){shapeVector.pushBack(this.m_outlineSolidStroke)}if(this.m_centerlineSolidStroke){shapeVector.pushBack(this.m_centerlineSolidStroke)}if(this.m_inlineSolidStroke){shapeVector.pushBack(this.m_inlineSolidStroke)}if(this.m_shapeSolidFill){shapeVector.pushBack(this.m_shapeSolidFill)}if(this.m_shadowGroup){shapeVector.pushBack(this.m_shadowGroup)}if(this.m_shapeRoundCorner){shapeVector.pushBack(this.m_shapeRoundCorner)}this.m_shapeGroup.shapeElements=shapeVector;this.m_shapeGroup.alpha=this.globalAlpha;if(this.m_shapeCom){const shape=new Amaz$9.Vector;shape.pushBack(this.m_shapeGroup);this.m_shapeCom.shapeElements=shape}}_createShapeGroup(jsonParameters){if(null!==jsonParameters){const jsonParam=jsonParameters;if("shape_params"in jsonParam){const configJson=jsonParam.shape_params;if(configJson){if("shape_type"in configJson){const shapeType=configJson.shape_type;this.shapeType=shapeType;if(shapeType===ShapeType.CUSTOM_CONTOUR_POLYGON){this._createCustomPointShapeGroup()}else if(shapeType===ShapeType.CONTOUR_ELLIPSE){this._createEllipseShapeGroup()}else if(shapeType===ShapeType.LINE){this._createLine()}else if(shapeType===ShapeType.ARROW){this._createArrow()}this._packageShape(this.shapeType)}else{console.error(TEMPLATE_TAG,"createShapeGroup failed, parameters not have shape_type!")}}else{console.error(TEMPLATE_TAG,"createShapeGroup failed, parameters shape_params is null or undefined!")}}else{console.error(TEMPLATE_TAG,"createShapeGroup failed, parameters not have shape_params!")}}}static createShapeBlendMat(){const semantics=new Amaz$9.Map;semantics.insert("position",Amaz$9.VertexAttribType.POSITION);semantics.insert("texcoord0",Amaz$9.VertexAttribType.TEXCOORD0);const rs=new Amaz$9.RenderState;rs.depthstencil=new Amaz$9.DepthStencilState;rs.depthstencil.depthTestEnable=false;rs.depthstencil.depthWriteEnable=false;rs.colorBlend=new Amaz$9.ColorBlendState;const colorAtt=new Amaz$9.ColorBlendAttachmentState;colorAtt.colorWriteMask=15;colorAtt.blendEnable=true;colorAtt.srcColorBlendFactor=Amaz$9.BlendFactor.ONE;colorAtt.dstColorBlendFactor=Amaz$9.BlendFactor.ONE_MINUS_SRC_ALPHA;colorAtt.srcAlphaBlendFactor=Amaz$9.BlendFactor.ONE;colorAtt.dstAlphaBlendFactor=Amaz$9.BlendFactor.ONE_MINUS_SRC_ALPHA;const attVec=new Amaz$9.Vector;attVec.pushBack(colorAtt);rs.colorBlend.attachments=attVec;const vertex_shaders=`\n        precision highp float;\n        attribute vec3 position;\n        attribute vec2 texcoord0;\n        varying vec2 uv0;\n        void main() \n        {\n                gl_Position = vec4(position.xyz, 1.0);\n                uv0 = texcoord0;\n        }\n\n    `;const fragment_shaders=`\n        precision lowp float;\n        varying vec2 uv0;\n        uniform sampler2D _MainTex;\n        uniform float u_alpha;\n        void main()\n        {\n            vec4 u_color = texture2D(_MainTex, uv0);\n            gl_FragColor = vec4(u_color.rgb * u_alpha, u_color.a * u_alpha);\n        }\n    `;const xs=new Amaz$9.XShader;const vs=new Amaz$9.Shader;vs.type=Amaz$9.ShaderType.VERTEX;vs.source=vertex_shaders;const fs=new Amaz$9.Shader;fs.type=Amaz$9.ShaderType.FRAGMENT;fs.source=fragment_shaders;const shaderVec=new Amaz$9.Vector;shaderVec.pushBack(vs);shaderVec.pushBack(fs);const platShaderMap=new Amaz$9.Map;platShaderMap.insert("gles2",shaderVec);const pass=new Amaz$9.Pass;pass.semantics=semantics;pass.shaders=platShaderMap;pass.renderState=rs;const passVec=new Amaz$9.Vector;passVec.pushBack(pass);xs.passes=passVec;const material=new Amaz$9.Material;material.xshader=xs;material.renderQueue=1;return material}_creatShapeBlendEntity(scene){const renderEntityName=this.m_name+"shapeBlendRenderEntity";this.m_shapeBlendEntity=AmazUtils$1.createEntity(renderEntityName,scene);this.m_shapeBlendEntity.layer=this.m_cameraLayer;const localPos=new Vec3$2(0,0,0);const scale=new Vec3$2(1,1,1);const rotate=new Vec3$2(0,0,0);this.m_shapeBlendEntity.transform={position:localPos,scale:scale,rotation:rotate};this.m_shapeBlendMeshRenderer=this.m_shapeBlendEntity.addComponent("MeshRenderer");const quadMesh=AmazUtils$1.CreateQuadMesh();this.m_shapeBlendMeshRenderer.mesh=quadMesh;const material=Shape.createShapeBlendMat();this.m_shapeBlendMeshRenderer.sharedMaterial=material;this.m_shapeBlendMeshRenderer.sortingOrder=this.m_layer*LAYER_SIZE+this.m_localOrder*ORDER_SIZE+1;if(null!=this.m_rootEntity){AmazUtils$1.addChildEntity(this.m_rootEntity,this.m_shapeBlendEntity)}}_createShapeEntity(scene){const renderEntityName=this.m_name+"renderEntity";this.m_renderEntity=AmazUtils$1.createEntity(renderEntityName,scene);this.m_renderEntity.layer=this.m_cameraLayer;const localPos=new Vec3$2(0,0,0);const scale=new Vec3$2(1,1,1);const rotate=new Vec3$2(0,0,0);this.m_renderEntity.transform={position:localPos,scale:scale,rotation:rotate};this.m_renderEntity.addComponent("IFShape");this.m_renderEntity.addComponent("MeshRenderer");this.m_shapeCom=this.m_renderEntity.getComponent("IFShape");this.m_renderRTTexture=new Amaz$9.RenderTexture;this.m_renderRTTexture.massMode=Amaz$9.MSAAMode._4X;this.m_shapeCom.setRenderTexture(this.m_renderRTTexture);this.createWidgetRootEntity(scene);if(null!=this.m_rootEntity){AmazUtils$1.addChildEntity(this.m_rootEntity,this.m_renderEntity)}}updateShapeParameters(jsonParam,shapeType){if("shape_params"in jsonParam){const configJson=jsonParam.shape_params;this._updateShapeBaseParameters(configJson);if(this.m_originalPixelSizeDirty){this.updateShapeWH();this.m_originalPixelSizeDirty=false}if(shapeType===ShapeType.CUSTOM_CONTOUR_POLYGON||shapeType===ShapeType.LINE||shapeType===ShapeType.ARROW){this._updateShapeCustomPoints(configJson)}if(shapeType===ShapeType.CUSTOM_CONTOUR_POLYGON||shapeType===ShapeType.CONTOUR_ELLIPSE){this._updateShapeInline(configJson);this._updateShapeCenterline(configJson);this._updateShapeOutline(configJson)}this._updateShapeShadow(configJson)}}updateShape(){if(this.m_needUpdateShape&&this.m_shapeCom){if(this.m_shapeParameters){this.updateShapeParameters(this.m_shapeParameters,this.shapeType)}else{console.error(TEMPLATE_TAG,"shape json parameters is null or undefined!")}this.m_needUpdateShape=false}}onUpdate(timeStamp){if(!this.m_enable||!this.checkIsInRange(timeStamp)){super.onUpdate(timeStamp);if(this.m_rootEntity&&this.m_rootEntity.visible){this.m_rootEntity.visible=false;this.resetAllAnimation()}if(this.m_shapeBlendEntity&&this.m_shapeBlendEntity.visible){this.m_shapeBlendEntity.visible=false}this.checkLayoutDirty();return}else{if(this.m_shapeAnimationController!=null&&this.widgetType===WidgetType.SHAPE){this.m_shapeAnimationController.updateKeyFrames();if(this.m_shapeAnimationController.isEnable(timeStamp)){this.m_shapeAnimationController.update(timeStamp-this.startTime)}}if(this.m_rootEntity&&!this.m_rootEntity.visible){this.m_rootEntity.visible=true}if(this.m_shapeBlendEntity&&!this.m_shapeBlendEntity.visible){this.m_shapeBlendEntity.visible=true}super.onUpdate(timeStamp);if(this.m_screenSizeChanged){if(this.m_renderRTTexture){this.m_renderRTTexture.width=this.m_screenSize.x;this.m_renderRTTexture.height=this.m_screenSize.y}this.m_screenSizeChanged=false}this.seekAnimations(timeStamp);let shapeGlobalAlpha=1;if(this.m_shapeCom){shapeGlobalAlpha=this.m_shapeCom.shapeGlobalAlpha}if(this.m_renderRTTexture&&this.m_shapeBlendMeshRenderer){const material=this.m_shapeBlendMeshRenderer.sharedMaterial;if(material){material.setTex("_MainTex",this.m_renderRTTexture);material.setFloat("u_alpha",this.globalAlpha*shapeGlobalAlpha)}}this.checkLayoutDirty()}}getCapabilityVersion(){const shapeVersion=VersionUtils.str2Version(SDK_VERSION);return shapeVersion}}var Amaz$8=effect.Amaz;class SpriteAttributeSetter{static setRootScaleX(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="sx"){widget.scale=new Amaz$8.Vector3f(value,widget.scale.y,widget.scale.z)}}static setRootScaleY(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="sy"){widget.scale=new Amaz$8.Vector3f(widget.scale.x,value,widget.scale.z)}}static setRootRotationZ(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="rz"){widget.rotation=new Amaz$8.Vector3f(widget.rotation.x,widget.rotation.y,value)}}static setRootPosX(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="px"){widget.position=new Amaz$8.Vector3f(value,widget.position.y,widget.position.z)}}static setRootPosY(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="py"){widget.position=new Amaz$8.Vector3f(widget.position.x,value,widget.position.z)}}}SpriteAttributeSetter.setterMap={px:SpriteAttributeSetter.setRootPosX,py:SpriteAttributeSetter.setRootPosY,sx:SpriteAttributeSetter.setRootScaleX,sy:SpriteAttributeSetter.setRootScaleY,rz:SpriteAttributeSetter.setRootRotationZ};class SpriteValueGeneratorContext{constructor(widget,overlayMode,propertyName){this.widget=null;this.widget=widget;this.overlayMode=overlayMode;this.propertyName=propertyName}}class SpriteAnimationController extends BaseAnimationController{constructor(widget){super();this.m_host=null;this.m_sprite_motion=new Group;this.m_host=widget}updateKeyFrames(){if(!this.checkIsDirty()){return}this.m_keyFramesDirty=false;this.m_sprite_motion.removeAll();if(this.m_keyframeParams==null){return}const keyframes=this.m_keyframeParams.keyframes;if(keyframes==null){return}for(let i=0;i<keyframes.length;i++){const keyframe=keyframes[i];let overlayMode="over";if(KeyframeAttrUtils.isValidOverlayMode(keyframe.overlay_mode))overlayMode=keyframe.overlay_mode;if(keyframe.k==null){console.error(TEMPLATE_TAG,"keyframe.k is undefined");return}const startTimeInSec=keyframe.s*KEYFRAME_TIME_FACTOR;const endTimeInSec=keyframe.e*KEYFRAME_TIME_FACTOR;if(endTimeInSec-startTimeInSec<TIME_EPS){console.error(TEMPLATE_TAG,"keyframe time range too short");return}this.setTimeRange(startTimeInSec,endTimeInSec);Object.keys(SpriteAttributeSetter.setterMap).forEach((key=>{if(keyframe.k[key]!=null){const spriteMotionContext=new SpriteValueGeneratorContext(this.m_host,overlayMode,key);this.createMotionsShapeProperty(keyframe,spriteMotionContext,key)}}))}}createMotionsShapeProperty(keyframeJson,motionContext,propertyName){const prop=keyframeJson.k[propertyName];const callback=SpriteAttributeSetter.setterMap[propertyName];if(prop==null){console.error(TEMPLATE_TAG,"prop is null");return}if(prop.length==0&&motionContext){console.error(TEMPLATE_TAG,"prop is empty");return}const interp=Interpolation.Linear;const keyframes=KeyframeAttrUtils.createKeyframes(keyframeJson,propertyName);KeyframeAttrUtils.createOneMotionByRelativeTime(keyframes,callback,interp,motionContext,this.m_sprite_motion,propertyName,this.m_startTimeInSegment,this.m_endTimeInSegment,keyframeJson.s,keyframeJson.e).start()}update(timeInSegment){if(this.m_keyframeParams!=null){this.m_sprite_motion.update(timeInSegment,true)}return 0}}var Amaz$7=effect.Amaz;var Vec3$1=Amaz$7.Vector3f;const pipe=(...fns)=>x=>fns.reduce(((v,f)=>f(v)),x);function syncLoadPrefabEntity(path,scene){const prefab=AmazUtils$1.swingTemplateUtils.parseInfoSticker(path,0,false,0);if(!prefab)return undefined;const nativeEntity=scene.addInstantiatedPrefab(prefab);const renderer=nativeEntity.getComponent("Sprite2DRenderer");renderer.setTextureSize(prefab.getRootEntity().getComponent("Sprite2DRenderer").getTextureSize());AmazUtils$1.initAmazEntity(nativeEntity);return nativeEntity}class SpriteUtils{static recursiveSetLayer(entity,layer_id){if(entity==null)return;entity.layer=layer_id;const trans=entity.getComponent("Transform");for(let i=0;i=trans.children.size();++i){SpriteUtils.recursiveSetLayer(trans.children.get(i).entity,layer_id)}}static loadSeqAnimSticker(sprite,path){const animSeqs=[];if(!sprite.scene)return animSeqs;const rootEntity=sprite.rootEntity;const nativeScene=sprite.scene;const rootDir=nativeScene.assetMgr.rootDir;let tryPath=path;if(!AmazUtils$1.swingTemplateUtils.isFileExist(path)&&!AmazUtils$1.swingTemplateUtils.isDir(path)){tryPath=rootDir+path}const prefabEntity=syncLoadPrefabEntity(tryPath,nativeScene);if(prefabEntity==undefined||rootEntity==null)return[];prefabEntity.name="prefab_entity";SpriteUtils.recursiveSetLayer(prefabEntity,sprite.cameraLayer);AmazUtils$1.addChildEntity(rootEntity,prefabEntity);sprite.renderEntity=prefabEntity;const AnimSeqTypes=["AnimSeqComponent","GifAnimSeq","VideoAnimSeq"];AnimSeqTypes.forEach((type=>{const comp=prefabEntity===null||prefabEntity===void 0?void 0:prefabEntity.getComponent(type);if(comp){animSeqs.push(comp)}}));return animSeqs}static setSpriteDataProperties(inputState,targetState,propName,dirtyCallback=undefined){if(inputState.data!=null&&inputState.data[propName]!=null&&targetState[propName]!=inputState.data[propName]){targetState[propName]=inputState.data[propName];if(dirtyCallback!=null){return dirtyCallback(inputState.data[propName])}}return true}}class Sprite extends Widget2D{constructor(name,widgetType,scene,params){super(name,widgetType,scene);this.m_spriteAnimationController=null;this.m_spriteKeyframeParams=null;this.props={timestamp:0,data:{name:"",type:"sticker"},layer:0};this.animseqs=[];this.pendingStateClosure=[];this.pipeline=undefined;this.parameters=params;this.pipeline=this.generatePipline();this.collectStates()}makeStateClosure(param){return()=>{this.updateStates(param)}}set state(param){if(param)this.pendingStateClosure.push(this.makeStateClosure(param))}get state(){return this.props}set parameters(params){var _a;super.setParameters(params);if(params instanceof String){params=JSON.parse(params)}let timestamp;if("timestamp"in params){timestamp=params.timestamp}const configData=TemplateConfigParser.parseSpriteConfig(params);this.state={data:configData,timestamp:timestamp};(_a=configData===null||configData===void 0?void 0:configData.anims)===null||_a===void 0?void 0:_a.forEach((animData=>{const anim=TemplateConfigParser.parseAnimationConfig(animData);if(anim){const anim_script_type=anim.anim_script_type;if(anim){super.setWidgetAnimation(anim.anim_resource_path,anim.anim_resource_id,anim_script_type,anim.anim_start_time,anim.duration,anim.loop_duration,AnimationType[anim.anim_type])}}}));if("keyframe_params"in params&&this.widgetType===WidgetType.SPRITE){if(this.m_spriteAnimationController==null){this.m_spriteAnimationController=new SpriteAnimationController(this)}if(this.m_spriteKeyframeParams!=params.keyframe_params){this.m_spriteKeyframeParams=params.keyframe_params;this.m_spriteAnimationController.setKeyFrameParams(this.m_spriteKeyframeParams)}}}get parameters(){const widget2DParam=super.getParameters();const data=this.props.data;data.original_size=widget2DParam.original_size;data.anims=widget2DParam.anims;data.action_type=this.actionType;return data}onInit(){}onUpdate(_timestamp){if(this.m_spriteAnimationController!=null&&this.widgetType===WidgetType.SPRITE){this.m_spriteAnimationController.updateKeyFrames();if(this.m_spriteAnimationController.isEnable(_timestamp)){this.m_spriteAnimationController.update(_timestamp-this.startTime)}}this.state={timestamp:_timestamp};this.collectStates();this.checkLayoutDirty()}onDestroy(){}onRender(){}collectStates(){const pendings=this.pendingStateClosure;this.pendingStateClosure=[];pendings.forEach((closure=>closure()))}generatePipline(){const setSpriteDataProperties=SpriteUtils.setSpriteDataProperties;const setGuid=inputState=>(setSpriteDataProperties(inputState,this.props.data,"name"),inputState);const setLayer=inputState=>(setSpriteDataProperties(inputState,this.props.data,"layer",(layer=>this.layer=layer)),inputState);const setOrder=inputState=>(setSpriteDataProperties(inputState,this.props.data,"order_in_layer",(order=>this.localOrder=order)),inputState);const setVisible=inputState=>(setSpriteDataProperties(inputState,this.props.data,"visible",(enable=>this.enable=enable)),inputState);const setTimeLogic=inputState=>{setSpriteDataProperties(inputState,this.props.data,"start_time",(val=>this.startTime=val));setSpriteDataProperties(inputState,this.props.data,"duration",(val=>this.duration=val));if(inputState.timestamp!=null&&inputState.timestamp!=this.props.timestamp){this.props.timestamp=inputState.timestamp}if(!this.checkIsInRange(this.props.timestamp)||!this.enable){super.onUpdate(this.props.timestamp);if(this.m_rootEntity&&this.m_rootEntity.visible){this.m_rootEntity.visible=false;this.resetAllAnimation()}}else{if(this.m_rootEntity&&!this.m_rootEntity.visible){this.m_rootEntity.visible=true}super.onUpdate(this.props.timestamp);const seekTime=this.props.timestamp-this.startTime;this.animseqs.forEach((seq=>seq.seekToTime(seekTime)));this.seekAnimations(this.props.timestamp)}return inputState};const setTransform=inputState=>{setSpriteDataProperties(inputState,this.props.data,"position",(pos=>{this.props.data.position=pos;this.position=new Vec3$1(pos[0],pos[1],pos[2]);return true}));setSpriteDataProperties(inputState,this.props.data,"rotation",(rot=>{this.props.data.rotation=rot;this.rotation=new Vec3$1(rot[0],rot[1],rot[2]);return true}));setSpriteDataProperties(inputState,this.props.data,"scale",(sca=>{this.props.data.scale=sca;this.scale=new Vec3$1(sca[0],sca[1],sca[2]);return true}));return inputState};const setSticker=inputState=>{setSpriteDataProperties(inputState,this.props.data,"sticker_design_type",(design_type=>{if(design_type===0||design_type===1){setSpriteDataProperties(inputState,this.props.data,"sticker_path",(path=>{this.animseqs=SpriteUtils.loadSeqAnimSticker(this,path);return true}));return true}else{console.error(TEMPLATE_TAG,"not implemented yet:  ",design_type)}return false}));setSpriteDataProperties(inputState,this.props.data,"sticker_loop",(loop=>{var _a;(_a=this.animseqs)===null||_a===void 0?void 0:_a.forEach((anim=>anim.playmode=loop?Amaz$7.PlayMode.loop:Amaz$7.PlayMode.once));return true}));return inputState};const setStickerRenderState=inputState=>{setSpriteDataProperties(inputState,this.props.data,"sticker_alpha",(alpha=>{var _a;const renderers=(_a=this.renderEntity)===null||_a===void 0?void 0:_a.getComponentsRecursive("Renderer");if(renderers!=null){for(let i=0;i<(renderers===null||renderers===void 0?void 0:renderers.size());++i){const renderer=renderers.get(i);if(renderer instanceof Amaz$7.Sprite2DRenderer){renderer.color=new Amaz$7.Vector4f(alpha,alpha,alpha,alpha)}}}return true}));setSpriteDataProperties(inputState,this.props.data,"sticker_flipX",(mirror=>{var _a;const renderer=(_a=this.renderEntity)===null||_a===void 0?void 0:_a.getComponent("Renderer");if(renderer!=null&&renderer instanceof Amaz$7.Sprite2DRenderer){renderer.mirror=mirror}return true}));setSpriteDataProperties(inputState,this.props.data,"sticker_flipY",(flip=>{var _a;const renderer=(_a=this.renderEntity)===null||_a===void 0?void 0:_a.getComponent("Renderer");if(renderer!=null&&renderer instanceof Amaz$7.Sprite2DRenderer){renderer.flip=flip}return true}));return inputState};return pipe(setGuid,setSticker,setStickerRenderState,setLayer,setOrder,setTransform,setVisible,setTimeLogic)}updateStates(stateData){var _a;(_a=this.pipeline)===null||_a===void 0?void 0:_a.call(this,stateData)}getCapabilityVersion(){const spriteVersion=VersionUtils.str2Version(SDK_VERSION);return spriteVersion}}var SelectorUnit;(function(SelectorUnit){SelectorUnit["CHAR"]="char";SelectorUnit["SYLLABLE"]="syllable";SelectorUnit["WORD"]="word";SelectorUnit["LINE"]="line";SelectorUnit["PAGE"]="page";SelectorUnit["WORD_UNREAD"]="word_unread";SelectorUnit["LINE_UNREAD"]="line_unread";SelectorUnit["KEYWORD"]="keyword"})(SelectorUnit||(SelectorUnit={}));var SelectorScope;(function(SelectorScope){SelectorScope["WORD"]="word";SelectorScope["LINE"]="line";SelectorScope["PAGE"]="page"})(SelectorScope||(SelectorScope={}));var SelectorType;(function(SelectorType){SelectorType[SelectorType["CAPTION"]=0]="CAPTION";SelectorType[SelectorType["TEXT"]=1]="TEXT"})(SelectorType||(SelectorType={}));var SelectorMode;(function(SelectorMode){SelectorMode[SelectorMode["EVERY"]=0]="EVERY";SelectorMode[SelectorMode["CUSTOM"]=1]="CUSTOM"})(SelectorMode||(SelectorMode={}));var SelectorBaseOn;(function(SelectorBaseOn){SelectorBaseOn[SelectorBaseOn["PERCENT"]=0]="PERCENT";SelectorBaseOn[SelectorBaseOn["INDEX"]=1]="INDEX"})(SelectorBaseOn||(SelectorBaseOn={}));const CaptionExpressionFunctions={["current_word_start"]:(timeInPage,captionPage)=>{var _a;const postWords=captionPage===null||captionPage===void 0?void 0:captionPage.getPostWords(timeInPage);const word=postWords===null||postWords===void 0?void 0:postWords[postWords.length-1];return(_a=word===null||word===void 0?void 0:word.startIndex)!==null&&_a!==void 0?_a:0},["current_word_end"]:(timeInPage,captionPage)=>{var _a;const postWords=captionPage===null||captionPage===void 0?void 0:captionPage.getPostWords(timeInPage);const word=postWords===null||postWords===void 0?void 0:postWords[postWords.length-1];return(_a=word===null||word===void 0?void 0:word.endIndex)!==null&&_a!==void 0?_a:0},["current_line_start"]:(timeInPage,captionPage)=>{var _a,_b;const postLines=captionPage===null||captionPage===void 0?void 0:captionPage.getPostLines(timeInPage);const line=postLines===null||postLines===void 0?void 0:postLines[postLines.length-1];return(_b=(_a=line===null||line===void 0?void 0:line.startWord)===null||_a===void 0?void 0:_a.startIndex)!==null&&_b!==void 0?_b:0},["current_line_end"]:(timeInPage,captionPage)=>{var _a,_b;const postLines=captionPage===null||captionPage===void 0?void 0:captionPage.getPostLines(timeInPage);const line=postLines===null||postLines===void 0?void 0:postLines[postLines.length-1];return(_b=(_a=line===null||line===void 0?void 0:line.endWord)===null||_a===void 0?void 0:_a.endIndex)!==null&&_b!==void 0?_b:0},["current_page_start"]:(_,captionPage)=>{var _a;const word=captionPage===null||captionPage===void 0?void 0:captionPage.getFirstNormalWord();return(_a=word===null||word===void 0?void 0:word.startIndex)!==null&&_a!==void 0?_a:0},["current_page_end"]:(_,captionPage)=>{var _a;const word=captionPage===null||captionPage===void 0?void 0:captionPage.getLastNormalWord();return(_a=word===null||word===void 0?void 0:word.endIndex)!==null&&_a!==void 0?_a:0}};class SelectorRange{constructor(start,end){this.m_startIndex=0;this.m_endIndex=0;this.m_converted=false;this.m_startIndex=start;this.m_endIndex=end}empty(){return this.m_startIndex==0&&this.m_endIndex==0}}var CAPITAL;(function(CAPITAL){CAPITAL[CAPITAL["NONE"]=1]="NONE";CAPITAL[CAPITAL["UPPER"]=2]="UPPER";CAPITAL[CAPITAL["LOWER"]=3]="LOWER";CAPITAL[CAPITAL["MIXED"]=4]="MIXED"})(CAPITAL||(CAPITAL={}));class CaptionWord{constructor(str,startTimeInSegment,endTimeInSegment,isKey,lineBreak,pageBreak){this.m_globalIndex=-1;this.m_charIndexInPage=0;this.m_string=str;this.m_startTimeInSegment=startTimeInSegment;this.m_endTimeInSegment=endTimeInSegment;this.m_isKey=isKey;this.m_lineBreak=lineBreak;this.m_pageBreak=pageBreak}isLineBreak(){return this.m_lineBreak}isPageBreak(){return this.m_pageBreak}isSpace(){return this.m_string==" "}isNormal(){return this.m_string!=null&&!this.isSpace()}toJson(){const json={start_time:this.m_startTimeInSegment*1e3,text:this.m_string,end_time:this.m_endTimeInSegment*1e3};if(this.m_pageBreak)Object.assign(json,{new_page:true});if(this.m_isKey)Object.assign(json,{is_key:true});return json}get startIndex(){return this.m_charIndexInPage}get endIndex(){return this.m_charIndexInPage+this.m_string.length}}class CaptionLine{constructor(words){this.m_globalIndex=-1;this.m_words=words;this.m_string="";for(let i=0;i<this.m_words.length;i++){this.m_string+=this.m_words[i].m_string}if(words.length>0){this.m_startTimeInSegment=words[0].m_startTimeInSegment;this.m_endTimeInSegment=words[words.length-1].m_endTimeInSegment}else{this.m_startTimeInSegment=0;this.m_endTimeInSegment=0}}static _replaceChar(str,index,ch){return str.slice(0,index)+ch+str.slice(index+1)}get startWord(){if(this.m_words.length>0)return this.m_words[0];return null}get endWord(){if(this.m_words.length>0)return this.m_words[this.m_words.length-1];return null}get endCommonWord(){for(let i=this.m_words.length-1;i>=0;i--){const word=this.m_words[i];if(!word.isLineBreak()){return word}}return null}isPageBreak(){return this.endWord!=null&&this.endWord.isPageBreak()}}class CaptionPage{constructor(lines){this.m_words=[];this.m_lines=[];this.m_utf16StartLetterIndex=-1;this.m_utf16EndLetterIndex=-1;this.m_globalIndex=-1;this.m_lines=lines;this.m_string="";for(let i=0;i<lines.length;i++){this.m_string+=lines[i].m_string;this.m_words=this.m_words.concat(lines[i].m_words)}if(lines.length>0){this.m_startTimeInSegment=lines[0].m_startTimeInSegment;this.m_endTimeInSegment=lines[lines.length-1].m_endTimeInSegment}else{this.m_startTimeInSegment=0;this.m_endTimeInSegment=0}let index=0;this.m_words.forEach((word=>{word.m_charIndexInPage=index;index+=word.m_string.length}))}get stringTrimEnd(){return this.m_string.trimEnd()}get startWord(){if(this.m_words.length>0)return this.m_words[0];return null}get endWord(){if(this.m_words.length>0)return this.m_words[this.m_words.length-1];return null}get endCommonWord(){for(let i=this.m_words.length-1;i>=0;i--){const word=this.m_words[i];if(!word.isLineBreak()){return word}}return null}getUnreadWords(timeInPage){const words=[];for(let i=0;i<this.m_words.length;i++){const word=this.m_words[i];if(word.isNormal()&&timeInPage+this.m_startTimeInSegment<word.m_startTimeInSegment){words.push(word)}}return words}getUnreadLines(timeInPage){const lines=[];for(let i=0;i<this.m_lines.length;i++){const line=this.m_lines[i];if(timeInPage+this.m_startTimeInSegment<line.m_startTimeInSegment){lines.push(line)}}return lines}getCurrentWord(timeInPage){const timeInSegment=timeInPage+this.m_startTimeInSegment;let maxStartTimeBeforeTimeStamp=-1;let index=-1;for(let i=0;i<this.m_words.length;i++){if(this.m_words[i].isNormal()&&timeInSegment>=this.m_words[i].m_startTimeInSegment){if(timeInSegment<this.m_words[i].m_endTimeInSegment)return this.m_words[i];else if(this.m_words[i].m_startTimeInSegment>maxStartTimeBeforeTimeStamp){maxStartTimeBeforeTimeStamp=this.m_words[i].m_startTimeInSegment;index=i}}}if(index>=0)return this.m_words[index];return null}getPostWords(timeInPage){const timeInSegment=timeInPage+this.m_startTimeInSegment;const postWords=[];if(timeInSegment<this.m_startTimeInSegment||timeInSegment>=this.m_endTimeInSegment)return null;for(let i=0;i<this.m_words.length;i++){if(this.m_words[i].isNormal()&&timeInSegment>=this.m_words[i].m_startTimeInSegment){postWords.push(this.m_words[i])}}return postWords}getCurrentLine(timeInPage){const timeInSegment=timeInPage+this.m_startTimeInSegment;let maxStartTimeBeforeTimeStamp=-1;let index=-1;for(let i=0;i<this.m_lines.length;i++){if(timeInSegment>=this.m_lines[i].m_startTimeInSegment){if(timeInSegment<this.m_lines[i].m_endTimeInSegment)return this.m_lines[i];else{if(this.m_lines[i].m_startTimeInSegment>maxStartTimeBeforeTimeStamp){maxStartTimeBeforeTimeStamp=this.m_lines[i].m_startTimeInSegment;index=i}}}}if(index>=0)return this.m_lines[index];return null}getPostLines(timeInPage){const timeInSegment=timeInPage+this.m_startTimeInSegment;const postLines=[];if(timeInSegment<this.m_startTimeInSegment||timeInSegment>=this.m_endTimeInSegment)return null;for(let i=0;i<this.m_lines.length;i++){if(timeInSegment>=this.m_lines[i].m_startTimeInSegment){postLines.push(this.m_lines[i])}}return postLines}getFirstNormalWord(){for(let i=0;i<this.m_words.length;i++){const word=this.m_words[i];if(word.isNormal()){return word}}return null}getLastNormalWord(){for(let i=this.m_words.length-1;i>=0;i--){const word=this.m_words[i];if(word.isNormal()){return word}}return null}getCurrentCharIndex(timeInPage){const currentWord=this.getCurrentWord(timeInPage);if(currentWord!=null){const timeInSegment=timeInPage+this.m_startTimeInSegment;const progress=(timeInSegment-currentWord.m_startTimeInSegment)/(currentWord.m_endTimeInSegment-currentWord.m_startTimeInSegment);let index=Math.floor(currentWord.startIndex+(currentWord.endIndex-currentWord.startIndex)*progress);index=Math.min(Math.max(index,currentWord.startIndex),currentWord.endIndex-1);return index}console.error(TEMPLATE_TAG,"getCurrentCharIndex error",timeInPage);return null}getTimeInPage(timeInSegment){return timeInSegment-this.m_startTimeInSegment}}class CaptionInfo{constructor(){this.m_caption_duration_info_raw=null;this.m_caption_duration_info_capital=null;this.m_caption_duration_info_original=null;this.m_caption_duration_info=null;this.m_caption_params={};this.m_keyword_font_size=-1;this.m_startTimeInSegment=0;this.m_endTimeInSegment=0;this.m_pages=[];this.m_lines=[];this.m_words=[];this.m_capital=CAPITAL.NONE;this.m_keywordCapitalDirty=false;this.m_onlyForKeyword=false;this.reset()}get pages(){return this.m_pages}set pages(value){this.m_pages=value}get lines(){return this.m_lines}get words(){return this.m_words}get caption_duration_info(){return this.m_caption_duration_info==null?this.m_caption_duration_info_original:this.m_caption_duration_info}get caption_duration_info_raw(){return this.m_caption_duration_info_raw}get caption_duration_info_capital(){return this.m_caption_duration_info_capital}get splitting_result(){return CaptionInfo.convertToCaptionDurationInfo(this.m_words,this.caption_duration_info.text)}get capitalStr(){const dic={[CAPITAL.NONE]:"none",[CAPITAL.UPPER]:"upper",[CAPITAL.LOWER]:"lower",[CAPITAL.MIXED]:"mixed"};return dic[this.m_capital]}get caption_params(){return this.m_caption_params}get keyword_font_size(){return this.m_keyword_font_size}set keyword_font_size(size){this.m_keyword_font_size=size}getKeywordRichTextWithSize(){let keyword_rich_text_str=this.m_caption_params.keyword_rich_text;if(keyword_rich_text_str!=null&&isJson(keyword_rich_text_str)){const keyword_rich_text=JSON.parse(keyword_rich_text_str);const fontSize=this.keyword_font_size;if(keyword_rich_text!=null&&keyword_rich_text.styles!=null&&keyword_rich_text.styles[0]!=null&&fontSize!=null&&fontSize>0){keyword_rich_text.styles[0].size=fontSize;keyword_rich_text_str=JSON.stringify(keyword_rich_text)}}return this.m_caption_params.keyword_rich_text}isRelative(){return this.m_caption_params.keyword_supersize!=null&&this.m_caption_params.keyword_supersize>0}getKeywordRichText(){return this.m_caption_params.keyword_rich_text}get keywordCapitalDirty(){return this.m_keywordCapitalDirty}set keywordCapitalDirty(dirty){this.m_keywordCapitalDirty=dirty}get onlyForKeyword(){return this.m_onlyForKeyword}getPageIndex(timeInSegment){if(timeInSegment<this.m_startTimeInSegment||timeInSegment>=this.m_endTimeInSegment)return-1;if(this.m_pages.length==0)return-1;for(let i=0;i<this.m_pages.length;i++){if(timeInSegment>=this.m_pages[i].m_startTimeInSegment&&timeInSegment<this.m_pages[i].m_endTimeInSegment){return i}else if(timeInSegment<this.m_pages[i].m_startTimeInSegment&&i>0){return i-1}}return-1}getPage(timeInSegment){const index=this.getPageIndex(timeInSegment);return index<0?null:this.m_pages[index]}reset(){this.m_caption_duration_info=null;this.m_caption_duration_info_original=null;this.m_startTimeInSegment=0;this.m_endTimeInSegment=0;this.m_words=[];this.m_lines=[];this.m_pages=[];this.m_onlyForKeyword=false}callSplitLinePage(caption_duration_info,caption_params){if(caption_params&&caption_duration_info){const child={caption_params:caption_params,text_params:{caption_duration_info:caption_duration_info}};const outJsonStr=AmazUtils$1.swingTemplateUtils.splitLinePage(JSON.stringify(child),true);if(outJsonStr!=""){return JSON.parse(outJsonStr).caption_duration_info}}return caption_duration_info}updateCaptionDurationInfos(){this.m_caption_duration_info_capital=CaptionInfo.applyCapital(this.m_caption_duration_info_raw,this.m_capital);this.m_caption_duration_info_original=this.callSplitLinePage(this.m_caption_duration_info_capital,this.m_caption_params);this.m_caption_duration_info=deepCopy(this.m_caption_duration_info_original)}setCaptionDurationInfo(caption_duration_info){if(caption_duration_info==null||Object.keys(caption_duration_info).length==0){this.reset();return}if(caption_duration_info==this.m_caption_duration_info_original){return}this.m_caption_duration_info_raw=caption_duration_info;this.updateCaptionDurationInfos();this.m_startTimeInSegment=this.m_caption_duration_info_original.start_time/1e3;this.m_endTimeInSegment=this.m_caption_duration_info_original.end_time/1e3;this.m_keywordCapitalDirty=true;if("only_for_keyword"in this.m_caption_duration_info_raw){this.m_onlyForKeyword=this.m_caption_duration_info_raw.only_for_keyword}else{this.m_onlyForKeyword=false}}setCaptionParams(captionParams){if(Object.keys(captionParams).length==0){this.m_caption_params={};return}const oldKeywordCapital=this.m_caption_params.keyword_capital;const oldSplitInfo={max_lines_per_page:this.m_caption_params.max_lines_per_page,max_units_per_line:this.m_caption_params.max_units_per_line,unit_type:this.m_caption_params.unit_type,ignore_AI_punctuation:this.m_caption_params.ignore_AI_punctuation,keyword_isolation:this.m_caption_params.keyword_isolation};Object.assign(this.m_caption_params,captionParams);if(this.m_caption_params.max_lines_per_page!=oldSplitInfo.max_lines_per_page||this.m_caption_params.max_units_per_line!=oldSplitInfo.max_units_per_line||this.m_caption_params.unit_type!=oldSplitInfo.unit_type||this.m_caption_params.ignore_AI_punctuation!=oldSplitInfo.ignore_AI_punctuation||this.m_caption_params.keyword_isolation!=oldSplitInfo.keyword_isolation){this.updateCaptionDurationInfos()}if(oldKeywordCapital!=this.m_caption_params.keyword_capital)this.m_keywordCapitalDirty=true;return}setCapital(capital){const old_capital=this.m_capital;switch(capital){case"none":this.m_capital=CAPITAL.NONE;break;case"upper":this.m_capital=CAPITAL.UPPER;break;case"lower":this.m_capital=CAPITAL.LOWER;break;case"mixed":this.m_capital=CAPITAL.MIXED;break;default:console.error(TEMPLATE_TAG,"invalid capital:"+capital);return false}if(old_capital!=this.m_capital){this.m_keywordCapitalDirty=true;this.updateCaptionDurationInfos();return true}return false}static applyCapital(caption_duration_info,capital){const caption_duration_info_capital=deepCopy(caption_duration_info);if(!caption_duration_info)return caption_duration_info_capital;if(![CAPITAL.NONE,CAPITAL.UPPER,CAPITAL.LOWER,CAPITAL.MIXED].includes(capital))return caption_duration_info_capital;if(CAPITAL.NONE==capital){for(let i=0;i<caption_duration_info.words.length;i++){caption_duration_info_capital.words[i].text=caption_duration_info.words[i].text}caption_duration_info_capital.text=caption_duration_info.text;return caption_duration_info_capital}let str="";for(let i=0;i<caption_duration_info.words.length;i++){str+=caption_duration_info.words[i].text}const dic={[CAPITAL.UPPER]:0,[CAPITAL.LOWER]:1,[CAPITAL.MIXED]:2};const out=AmazUtils$1.swingTemplateUtils.convertTextCase(str,dic[capital]);if(out.length!=str.length){console.error(TEMPLATE_TAG,"case of no text is converted!");return}let p=0;for(let i=0;i<caption_duration_info_capital.words.length;i++){const word=caption_duration_info_capital.words[i];word.text=out.slice(p,p+word.text.length);p+=word.text.length}caption_duration_info_capital.text=out;return caption_duration_info_capital}applyKeywordCapital(){if(!this.m_keywordCapitalDirty||!this.m_caption_duration_info_original||!this.m_caption_params.enable_keyword)return;const keyword_capital=this.m_caption_params.keyword_capital;if(!["upper","lower","mixed","none"].includes(keyword_capital))return;if("none"==keyword_capital){let text="";for(let i=0;i<this.m_caption_duration_info.words.length;i++){const word=this.m_caption_duration_info.words[i];if(word.is_key){word.text=this.m_caption_duration_info_original.words[i].text}text+=word.text}this.m_caption_duration_info.text=text;return}let str="";for(let i=0;i<this.m_caption_duration_info_original.words.length;i++){if(this.m_caption_duration_info_original.words[i].is_key)str+=this.m_caption_duration_info_original.words[i].text+" "}const dic={["upper"]:0,["lower"]:1,["mixed"]:2};const out=AmazUtils$1.swingTemplateUtils.convertTextCase(str,dic[keyword_capital]);if(out.length!=str.length){console.error(TEMPLATE_TAG,"case of no text is converted in applyKeywordCapital!");return}let p=0;let text="";for(let i=0;i<this.m_caption_duration_info.words.length;i++){const word=this.m_caption_duration_info.words[i];if(word.is_key){word.text=out.slice(p,p+word.text.length);p+=word.text.length+1}text+=word.text}this.m_caption_duration_info.text=text}static _generateWords(caption_params,caption_duration_info){const maxLinesPerPage=caption_params.max_lines_per_page;const INFINITY=1e5;const maxUnitsPerLine=caption_params.max_units_per_line==0?INFINITY:caption_params.max_units_per_line;const ignoreAIPunctuation=caption_params.ignore_AI_punctuation==true;const keywordIsolation=caption_params.keyword_isolation;let words=[];let curUnitNum=0;let curLineNum=0;function increaseLineNum(word){if(!word.m_lineBreak){curLineNum++;word.m_lineBreak=true;if(curLineNum>=maxLinesPerPage){word.m_pageBreak=true;curLineNum=0}}}for(let i=0;i<caption_duration_info.words.length;i++){const wordInfo=caption_duration_info.words[i];if(ignoreAIPunctuation){if(wordInfo.text=="\n"){wordInfo.text=" "}}const word=new CaptionWord(wordInfo.text,wordInfo.start_time/1e3,wordInfo.end_time/1e3,wordInfo.is_key==true,wordInfo.text=="\n",false);if(maxUnitsPerLine==0){words.push(word);continue}if(wordInfo.text==" ");else if(wordInfo.text=="\n"){if(words.length>0){const lastWord=words[words.length-1];increaseLineNum(lastWord)}curUnitNum=0;continue}else{curUnitNum++;if(word.m_isKey&&keywordIsolation=="page"){if(words.length>0){words[words.length-1].m_pageBreak=true;words[words.length-1].m_lineBreak=true}word.m_pageBreak=true;word.m_lineBreak=true;curUnitNum=0;curLineNum=0}else if(word.m_isKey&&keywordIsolation=="line"){if(words.length>0){const lastWord=words[words.length-1];increaseLineNum(lastWord)}curUnitNum=0;increaseLineNum(word)}else if(curUnitNum>=maxUnitsPerLine){curUnitNum=0;increaseLineNum(word)}}words.push(word)}const ws=words;words=[];for(let i=0;i<ws.length;i++){const w=ws[i];if(w.isLineBreak()&&!w.isPageBreak()&&w.m_string!="\n"){w.m_lineBreak=false;w.m_pageBreak=false;words.push(w);const word=new CaptionWord("\n",w.m_endTimeInSegment,w.m_endTimeInSegment,false,true,false);words.push(word)}else words.push(w)}return words}static convertToCaptionDurationInfo(words,text){const ret={};ret.text=text;ret.words=[];for(let i=0;i<words.length;i++){ret.words.push(words[i].toJson())}return ret}static splitLinePage(caption_params,caption_duration_info){const words=CaptionInfo._generateWords(caption_params,caption_duration_info);return CaptionInfo.convertToCaptionDurationInfo(words,caption_duration_info.text)}_generateLines(){const words=this.m_words;const lines=[];function createLine(index){if(index<lineStart)return;const lineWords=words.slice(lineStart,index+1);const line=new CaptionLine(lineWords);line.m_globalIndex=lineGlobalIndex;lineGlobalIndex++;lines.push(line);lineStart=index+1}let lineStart=0;let lineGlobalIndex=0;for(let i=0;i<words.length;i++){if(words[i].isLineBreak()||words[i].isPageBreak()||i==words.length-1){createLine(i)}}this.m_lines=lines}_generatePages(){const lines=this.m_lines;const pages=[];function createPage(index){const pageLines=lines.slice(pageStart,index+1);const page=new CaptionPage(pageLines);page.m_globalIndex=pageGlobalIndex;pageGlobalIndex++;pages.push(page);pageStart=index+1}let pageStart=0;let pageGlobalIndex=0;for(let i=0;i<lines.length;i++){if(lines[i].isPageBreak()||i==lines.length-1){createPage(i)}}this.m_pages=pages}updatePagesJS(){const caption_duration_info=this.caption_duration_info;if(caption_duration_info==null||caption_duration_info.words==null||this.caption_params.max_lines_per_page==null||this.caption_params.max_units_per_line==null){this.m_pages=[];return}this.m_words=CaptionInfo._generateWords(this.m_caption_params,this.m_caption_duration_info_original);this._generateLines();this._generatePages()}static generateOnePage(caption_duration_info_raw){const words=[];let wordGlobalIndex=0;for(let i=0;i<caption_duration_info_raw.words.length;i++){const wordParam=caption_duration_info_raw.words[i];let isKey=false;if("is_key"in wordParam){isKey=wordParam.is_key}const word=new CaptionWord(wordParam.text,wordParam.start_time/1e3,wordParam.end_time/1e3,isKey,false,false);if(word.isNormal()&&word.m_startTimeInSegment!=word.m_endTimeInSegment){word.m_globalIndex=wordGlobalIndex;wordGlobalIndex++}words.push(word)}const lines=new CaptionLine(words);const page=new CaptionPage([lines]);return page}updatePages(){const caption_duration_info=this.caption_duration_info;if(caption_duration_info==null||caption_duration_info.words==null){this.m_pages=[];return}const words=[];let wordGlobalIndex=0;for(let i=0;i<caption_duration_info.words.length;i++){const wordParam=caption_duration_info.words[i];let isKey=false;if("is_key"in wordParam){isKey=wordParam.is_key}const word=new CaptionWord(wordParam.text,wordParam.start_time/1e3,wordParam.end_time/1e3,isKey,wordParam.isLineBreak||wordParam.text=="\n",wordParam.new_page);if(word.isNormal()&&word.m_startTimeInSegment!=word.m_endTimeInSegment){word.m_globalIndex=wordGlobalIndex;wordGlobalIndex++}words.push(word)}const lines=[];let lineStart=0;let lineGlobalIndex=0;for(let i=0;i<words.length;i++){if(words[i].isLineBreak()||words[i].isPageBreak()||i==words.length-1){const lineWords=words.slice(lineStart,i+1);const line=new CaptionLine(lineWords);line.m_globalIndex=lineGlobalIndex;lineGlobalIndex++;lines.push(line);lineStart=i+1}}this.m_lines=lines;this.m_pages=[];let pageStart=0;let pageGlobalIndex=0;for(let i=0;i<lines.length;i++){if(lines[i].isPageBreak()||i==lines.length-1){const pageLines=lines.slice(pageStart,i+1);const page=new CaptionPage(pageLines);page.m_globalIndex=pageGlobalIndex;pageGlobalIndex++;this.m_pages.push(page);pageStart=i+1}}}static getWordUnreadRange(time,captionPage){const wordUnreadArray=captionPage.getUnreadWords(time);if(wordUnreadArray.length>0){return new SelectorRange(wordUnreadArray[0].startIndex,wordUnreadArray[wordUnreadArray.length-1].endIndex)}return new SelectorRange(0,0)}static getLineUnreadRange(timeInPage,captionPage){var _a,_b;const lineUnreadArray=captionPage.getUnreadLines(timeInPage);const lineFirstWord=(_a=lineUnreadArray[0])===null||_a===void 0?void 0:_a.startWord;const lineLastWord=(_b=lineUnreadArray[lineUnreadArray.length-1])===null||_b===void 0?void 0:_b.endWord;if(lineUnreadArray.length>0&&lineFirstWord!==null&&lineLastWord!==null){return new SelectorRange(lineFirstWord.startIndex,lineLastWord.endIndex)}console.error(TEMPLATE_TAG,"getLineUnreadRange error",timeInPage);return new SelectorRange(0,0)}static getPageRange(captionPage){if(captionPage.startWord!=null&&captionPage.endCommonWord!=null){return new SelectorRange(captionPage.startWord.startIndex,captionPage.endCommonWord.endIndex)}else{console.warn(TEMPLATE_TAG,"getPageRange warning");return new SelectorRange(0,0)}}static getWordRange(timeInPage,captionPage){const currentWord=captionPage.getCurrentWord(timeInPage);return this.getRangeFromWord(currentWord)}static getRangeFromWord(currentWord){if(currentWord!=null){return new SelectorRange(currentWord.startIndex,currentWord.endIndex)}else{return new SelectorRange(0,0)}}static getLineRange(timeInPage,captionPage){const currentLine=captionPage.getCurrentLine(timeInPage);return this.getRangeFromLine(currentLine)}static getRangeFromLine(currentLine){if(currentLine!=null&&currentLine.startWord!=null&&currentLine.endCommonWord!=null){return new SelectorRange(currentLine.startWord.startIndex,currentLine.endCommonWord.endIndex)}else{console.error(TEMPLATE_TAG,"getLineRange error");return new SelectorRange(0,0)}}static getLetterRange(timeInPage,captionPage){const index=captionPage.getCurrentCharIndex(timeInPage);if(index!=null){return new SelectorRange(index,index+1)}else{console.error(TEMPLATE_TAG,"getLetterRange error",timeInPage);return new SelectorRange(0,0)}}}class Selector{constructor(selectorInfo){this.id="";this.basedOn=SelectorBaseOn.INDEX;this.scope=SelectorScope.PAGE;this.start=0;this.end=1;this.range=new SelectorRange(0,0);this.mode=SelectorMode.EVERY;this.captionPage=null;this.unit=SelectorUnit.CHAR;this.selectorType=SelectorType.TEXT;this.id=selectorInfo.id;this.selectorType=this.getType(selectorInfo.type);this.basedOn=this.getBasedOn(selectorInfo.base_on);this.mode=this.getMode(selectorInfo.selector_mode);this.start=selectorInfo.selector_start;this.end=selectorInfo.selector_end;this.scope=this.getScope(selectorInfo.selector_scope);this.unit=this.getUnit(selectorInfo.selector_unit)}getUnit(unitStr){switch(unitStr){case"char":return SelectorUnit.CHAR;case"word":return SelectorUnit.WORD;case"line":return SelectorUnit.LINE;case"page":return SelectorUnit.PAGE;case"word_unread":this.start="${current_word_end}";this.end="${current_page_end}";this.mode=SelectorMode.CUSTOM;this.scope=SelectorScope.PAGE;return SelectorUnit.WORD_UNREAD;case"line_unread":this.start="${current_line_end}";this.end="${current_page_end}";this.scope=SelectorScope.PAGE;this.mode=SelectorMode.CUSTOM;return SelectorUnit.LINE_UNREAD;case"keyword":return SelectorUnit.KEYWORD;default:return SelectorUnit.CHAR}}getType(typeStr){switch(typeStr){case"caption":return SelectorType.CAPTION;case"text":return SelectorType.TEXT;default:return SelectorType.CAPTION}}getBasedOn(baseOnStr){switch(baseOnStr){case"percent":return SelectorBaseOn.PERCENT;case"index":return SelectorBaseOn.INDEX;default:return SelectorBaseOn.INDEX}}getScope(scopeStr){switch(scopeStr){case"word":return SelectorScope.WORD;case"line":return SelectorScope.LINE;case"page":return SelectorScope.PAGE;default:return SelectorScope.PAGE}}getMode(modeStr){switch(modeStr){case"every":return SelectorMode.EVERY;case"custom":return SelectorMode.CUSTOM;default:return SelectorMode.EVERY}}update(timeInPage){if(!this.captionPage){console.error(TEMPLATE_TAG,"Selector update captionPage is null!");return timeInPage}if(this.selectorType==SelectorType.TEXT){return timeInPage}if(this.selectorType==SelectorType.CAPTION){if(this.mode==SelectorMode.EVERY){this.range=this.getSelectedRange(timeInPage);return timeInPage}if(this.mode==SelectorMode.CUSTOM){if(this.scope==SelectorScope.PAGE){const startIndex=this._parse(this.start,timeInPage);const endIndex=this._parse(this.end,timeInPage);if(typeof startIndex==="number"&&typeof endIndex==="number"||startIndex>=endIndex){this.range=new SelectorRange(startIndex,endIndex);return timeInPage}else{console.error(TEMPLATE_TAG,`illegal range in selector: [${this.id}], please check out!`)}}return timeInPage}}return timeInPage}_parse(value,time){if(typeof value==="number"){return value}const captionPage=this.captionPage;if(!captionPage){console.error(TEMPLATE_TAG,"Selector parse captionPage is null!");return 0}function evaluateCaptionExpression(expression){const replacedExpression=expression.replace(/\$\{([^}]+)\}/g,((_,match)=>{var _a;if(match in CaptionExpressionFunctions&&captionPage){return((_a=CaptionExpressionFunctions[match](time,captionPage))!==null&&_a!==void 0?_a:0).toString()}console.error(TEMPLATE_TAG,"Selector parse expression not support: [%s]",match);return"0"}));return Function('"use strict"; return ('+replacedExpression+");")()}return evaluateCaptionExpression(value)}getSelectedRange(timeInPage){const captionPage=this.captionPage;if(!captionPage){console.error(TEMPLATE_TAG,"Selector getSelectedRange captionPage is null!");return new SelectorRange(0,0)}let range=new SelectorRange(0,0);const unit=this.unit;switch(unit){case SelectorUnit.CHAR:{range=CaptionInfo.getLetterRange(timeInPage,captionPage);break}case SelectorUnit.WORD:{range=CaptionInfo.getWordRange(timeInPage,captionPage);break}case SelectorUnit.LINE:{range=CaptionInfo.getLineRange(timeInPage,captionPage);break}case SelectorUnit.PAGE:{range=CaptionInfo.getPageRange(captionPage);break}case SelectorUnit.WORD_UNREAD:{range=CaptionInfo.getWordUnreadRange(timeInPage,captionPage);break}case SelectorUnit.LINE_UNREAD:{range=CaptionInfo.getLineUnreadRange(timeInPage,captionPage);break}}return range}}class CaptionAttributeSetter{static getValueCallback(propertyName){return function(obj){const value=obj.v;const motionContext=obj.motionContext;const selectorRange=motionContext.selector.range;const selectorUnit=obj.motionContext.selector.unit;motionContext.callbackParams.values.push({name:propertyName,value:value,start:selectorRange.m_startIndex,end:selectorRange.m_endIndex,overlayMode:motionContext.overlayMode,selectorUnit:selectorUnit})}}}class TextBaseAnimationController extends BaseAnimationController{constructor(){super()}updateKeyFrames(timeInSegment){}update(timeInSegment){return timeInSegment}}var alea$1={exports:{}};(function(module){(function(global,module,define){function Alea(seed){var me=this,mash=Mash();me.next=function(){var t=2091639*me.s0+me.c*2.3283064365386963e-10;me.s0=me.s1;me.s1=me.s2;return me.s2=t-(me.c=t|0)};me.c=1;me.s0=mash(" ");me.s1=mash(" ");me.s2=mash(" ");me.s0-=mash(seed);if(me.s0<0){me.s0+=1}me.s1-=mash(seed);if(me.s1<0){me.s1+=1}me.s2-=mash(seed);if(me.s2<0){me.s2+=1}mash=null}function copy(f,t){t.c=f.c;t.s0=f.s0;t.s1=f.s1;t.s2=f.s2;return t}function impl(seed,opts){var xg=new Alea(seed),state=opts&&opts.state,prng=xg.next;prng.int32=function(){return xg.next()*4294967296|0};prng.double=function(){return prng()+(prng()*2097152|0)*11102230246251565e-32};prng.quick=prng;if(state){if(typeof state=="object")copy(state,xg);prng.state=function(){return copy(xg,{})}}return prng}function Mash(){var n=4022871197;var mash=function(data){data=String(data);for(var i=0;i<data.length;i++){n+=data.charCodeAt(i);var h=.02519603282416938*n;n=h>>>0;h-=n;h*=n;n=h>>>0;h-=n;n+=h*4294967296}return(n>>>0)*2.3283064365386963e-10};return mash}if(module&&module.exports){module.exports=impl}else if(define&&define.amd){define((function(){return impl}))}else{this.alea=impl}})(commonjsGlobal,module,typeof undefined=="function")})(alea$1);var xor128$1={exports:{}};(function(module){(function(global,module,define){function XorGen(seed){var me=this,strseed="";me.x=0;me.y=0;me.z=0;me.w=0;me.next=function(){var t=me.x^me.x<<11;me.x=me.y;me.y=me.z;me.z=me.w;return me.w^=me.w>>>19^t^t>>>8};if(seed===(seed|0)){me.x=seed}else{strseed+=seed}for(var k=0;k<strseed.length+64;k++){me.x^=strseed.charCodeAt(k)|0;me.next()}}function copy(f,t){t.x=f.x;t.y=f.y;t.z=f.z;t.w=f.w;return t}function impl(seed,opts){var xg=new XorGen(seed),state=opts&&opts.state,prng=function(){return(xg.next()>>>0)/4294967296};prng.double=function(){do{var top=xg.next()>>>11,bot=(xg.next()>>>0)/4294967296,result=(top+bot)/(1<<21)}while(result===0);return result};prng.int32=xg.next;prng.quick=prng;if(state){if(typeof state=="object")copy(state,xg);prng.state=function(){return copy(xg,{})}}return prng}if(module&&module.exports){module.exports=impl}else if(define&&define.amd){define((function(){return impl}))}else{this.xor128=impl}})(commonjsGlobal,module,typeof undefined=="function")})(xor128$1);var xorwow$1={exports:{}};(function(module){(function(global,module,define){function XorGen(seed){var me=this,strseed="";me.next=function(){var t=me.x^me.x>>>2;me.x=me.y;me.y=me.z;me.z=me.w;me.w=me.v;return(me.d=me.d+362437|0)+(me.v=me.v^me.v<<4^(t^t<<1))|0};me.x=0;me.y=0;me.z=0;me.w=0;me.v=0;if(seed===(seed|0)){me.x=seed}else{strseed+=seed}for(var k=0;k<strseed.length+64;k++){me.x^=strseed.charCodeAt(k)|0;if(k==strseed.length){me.d=me.x<<10^me.x>>>4}me.next()}}function copy(f,t){t.x=f.x;t.y=f.y;t.z=f.z;t.w=f.w;t.v=f.v;t.d=f.d;return t}function impl(seed,opts){var xg=new XorGen(seed),state=opts&&opts.state,prng=function(){return(xg.next()>>>0)/4294967296};prng.double=function(){do{var top=xg.next()>>>11,bot=(xg.next()>>>0)/4294967296,result=(top+bot)/(1<<21)}while(result===0);return result};prng.int32=xg.next;prng.quick=prng;if(state){if(typeof state=="object")copy(state,xg);prng.state=function(){return copy(xg,{})}}return prng}if(module&&module.exports){module.exports=impl}else if(define&&define.amd){define((function(){return impl}))}else{this.xorwow=impl}})(commonjsGlobal,module,typeof undefined=="function")})(xorwow$1);var xorshift7$1={exports:{}};(function(module){(function(global,module,define){function XorGen(seed){var me=this;me.next=function(){var X=me.x,i=me.i,t,v;t=X[i];t^=t>>>7;v=t^t<<24;t=X[i+1&7];v^=t^t>>>10;t=X[i+3&7];v^=t^t>>>3;t=X[i+4&7];v^=t^t<<7;t=X[i+7&7];t=t^t<<13;v^=t^t<<9;X[i]=v;me.i=i+1&7;return v};function init(me,seed){var j,X=[];if(seed===(seed|0)){X[0]=seed}else{seed=""+seed;for(j=0;j<seed.length;++j){X[j&7]=X[j&7]<<15^seed.charCodeAt(j)+X[j+1&7]<<13}}while(X.length<8)X.push(0);for(j=0;j<8&&X[j]===0;++j);if(j==8)X[7]=-1;else X[j];me.x=X;me.i=0;for(j=256;j>0;--j){me.next()}}init(me,seed)}function copy(f,t){t.x=f.x.slice();t.i=f.i;return t}function impl(seed,opts){if(seed==null)seed=+new Date;var xg=new XorGen(seed),state=opts&&opts.state,prng=function(){return(xg.next()>>>0)/4294967296};prng.double=function(){do{var top=xg.next()>>>11,bot=(xg.next()>>>0)/4294967296,result=(top+bot)/(1<<21)}while(result===0);return result};prng.int32=xg.next;prng.quick=prng;if(state){if(state.x)copy(state,xg);prng.state=function(){return copy(xg,{})}}return prng}if(module&&module.exports){module.exports=impl}else if(define&&define.amd){define((function(){return impl}))}else{this.xorshift7=impl}})(commonjsGlobal,module,typeof undefined=="function")})(xorshift7$1);var xor4096$1={exports:{}};(function(module){(function(global,module,define){function XorGen(seed){var me=this;me.next=function(){var w=me.w,X=me.X,i=me.i,t,v;me.w=w=w+1640531527|0;v=X[i+34&127];t=X[i=i+1&127];v^=v<<13;t^=t<<17;v^=v>>>15;t^=t>>>12;v=X[i]=v^t;me.i=i;return v+(w^w>>>16)|0};function init(me,seed){var t,v,i,j,w,X=[],limit=128;if(seed===(seed|0)){v=seed;seed=null}else{seed=seed+"\0";v=0;limit=Math.max(limit,seed.length)}for(i=0,j=-32;j<limit;++j){if(seed)v^=seed.charCodeAt((j+32)%seed.length);if(j===0)w=v;v^=v<<10;v^=v>>>15;v^=v<<4;v^=v>>>13;if(j>=0){w=w+1640531527|0;t=X[j&127]^=v+w;i=0==t?i+1:0}}if(i>=128){X[(seed&&seed.length||0)&127]=-1}i=127;for(j=4*128;j>0;--j){v=X[i+34&127];t=X[i=i+1&127];v^=v<<13;t^=t<<17;v^=v>>>15;t^=t>>>12;X[i]=v^t}me.w=w;me.X=X;me.i=i}init(me,seed)}function copy(f,t){t.i=f.i;t.w=f.w;t.X=f.X.slice();return t}function impl(seed,opts){if(seed==null)seed=+new Date;var xg=new XorGen(seed),state=opts&&opts.state,prng=function(){return(xg.next()>>>0)/4294967296};prng.double=function(){do{var top=xg.next()>>>11,bot=(xg.next()>>>0)/4294967296,result=(top+bot)/(1<<21)}while(result===0);return result};prng.int32=xg.next;prng.quick=prng;if(state){if(state.X)copy(state,xg);prng.state=function(){return copy(xg,{})}}return prng}if(module&&module.exports){module.exports=impl}else if(define&&define.amd){define((function(){return impl}))}else{this.xor4096=impl}})(commonjsGlobal,module,typeof undefined=="function")})(xor4096$1);var tychei$1={exports:{}};(function(module){(function(global,module,define){function XorGen(seed){var me=this,strseed="";me.next=function(){var b=me.b,c=me.c,d=me.d,a=me.a;b=b<<25^b>>>7^c;c=c-d|0;d=d<<24^d>>>8^a;a=a-b|0;me.b=b=b<<20^b>>>12^c;me.c=c=c-d|0;me.d=d<<16^c>>>16^a;return me.a=a-b|0};me.a=0;me.b=0;me.c=2654435769|0;me.d=1367130551;if(seed===Math.floor(seed)){me.a=seed/4294967296|0;me.b=seed|0}else{strseed+=seed}for(var k=0;k<strseed.length+20;k++){me.b^=strseed.charCodeAt(k)|0;me.next()}}function copy(f,t){t.a=f.a;t.b=f.b;t.c=f.c;t.d=f.d;return t}function impl(seed,opts){var xg=new XorGen(seed),state=opts&&opts.state,prng=function(){return(xg.next()>>>0)/4294967296};prng.double=function(){do{var top=xg.next()>>>11,bot=(xg.next()>>>0)/4294967296,result=(top+bot)/(1<<21)}while(result===0);return result};prng.int32=xg.next;prng.quick=prng;if(state){if(typeof state=="object")copy(state,xg);prng.state=function(){return copy(xg,{})}}return prng}if(module&&module.exports){module.exports=impl}else if(define&&define.amd){define((function(){return impl}))}else{this.tychei=impl}})(commonjsGlobal,module,typeof undefined=="function")})(tychei$1);var seedrandom$1={exports:{}};(function(module){(function(global,pool,math){var width=256,chunks=6,digits=52,rngname="random",startdenom=math.pow(width,chunks),significance=math.pow(2,digits),overflow=significance*2,mask=width-1,nodecrypto;function seedrandom(seed,options,callback){var key=[];options=options==true?{entropy:true}:options||{};var shortseed=mixkey(flatten(options.entropy?[seed,tostring(pool)]:seed==null?autoseed():seed,3),key);var arc4=new ARC4(key);var prng=function(){var n=arc4.g(chunks),d=startdenom,x=0;while(n<significance){n=(n+x)*width;d*=width;x=arc4.g(1)}while(n>=overflow){n/=2;d/=2;x>>>=1}return(n+x)/d};prng.int32=function(){return arc4.g(4)|0};prng.quick=function(){return arc4.g(4)/4294967296};prng.double=prng;mixkey(tostring(arc4.S),pool);return(options.pass||callback||function(prng,seed,is_math_call,state){if(state){if(state.S){copy(state,arc4)}prng.state=function(){return copy(arc4,{})}}if(is_math_call){math[rngname]=prng;return seed}else return prng})(prng,shortseed,"global"in options?options.global:this==math,options.state)}function ARC4(key){var t,keylen=key.length,me=this,i=0,j=me.i=me.j=0,s=me.S=[];if(!keylen){key=[keylen++]}while(i<width){s[i]=i++}for(i=0;i<width;i++){s[i]=s[j=mask&j+key[i%keylen]+(t=s[i])];s[j]=t}(me.g=function(count){var t,r=0,i=me.i,j=me.j,s=me.S;while(count--){t=s[i=mask&i+1];r=r*width+s[mask&(s[i]=s[j=mask&j+t])+(s[j]=t)]}me.i=i;me.j=j;return r})(width)}function copy(f,t){t.i=f.i;t.j=f.j;t.S=f.S.slice();return t}function flatten(obj,depth){var result=[],typ=typeof obj,prop;if(depth&&typ=="object"){for(prop in obj){try{result.push(flatten(obj[prop],depth-1))}catch(e){}}}return result.length?result:typ=="string"?obj:obj+"\0"}function mixkey(seed,key){var stringseed=seed+"",smear,j=0;while(j<stringseed.length){key[mask&j]=mask&(smear^=key[mask&j]*19)+stringseed.charCodeAt(j++)}return tostring(key)}function autoseed(){try{var out;if(nodecrypto&&(out=nodecrypto.randomBytes)){out=out(width)}else{out=new Uint8Array(width);(global.crypto||global.msCrypto).getRandomValues(out)}return tostring(out)}catch(e){var browser=global.navigator,plugins=browser&&browser.plugins;return[+new Date,global,plugins,global.screen,tostring(pool)]}}function tostring(a){return String.fromCharCode.apply(0,a)}mixkey(math.random(),pool);if(module.exports){module.exports=seedrandom;try{nodecrypto=require("crypto")}catch(ex){}}else{math["seed"+rngname]=seedrandom}})(typeof self!=="undefined"?self:commonjsGlobal,[],Math)})(seedrandom$1);var alea=alea$1.exports;var xor128=xor128$1.exports;var xorwow=xorwow$1.exports;var xorshift7=xorshift7$1.exports;var xor4096=xor4096$1.exports;var tychei=tychei$1.exports;var sr=seedrandom$1.exports;sr.alea=alea;sr.xor128=xor128;sr.xorwow=xorwow;sr.xorshift7=xorshift7;sr.xor4096=xor4096;sr.tychei=tychei;var seedrandom=sr;class RandomMechanism{static createSequentialSelector(values){return values}static createRandomSelector(values){const resValues=[];const originValues=values.slice();const seed="randomSelector";const random=seedrandom(seed);while(originValues.length>0){const randomValue=random();const randomNumber=Math.floor(randomValue*originValues.length);resValues.push(originValues[randomNumber]);originValues.splice(randomNumber,1)}return resValues}}class ValueFromListInfo{constructor(valueType,values,selector=""){this.m_valueType="";this.m_values=[];this.m_selector="";this.m_valueType=valueType;this.m_values=values;this.m_selector=selector}get valueType(){return this.m_valueType}set valueType(valueType){this.m_valueType=valueType}get values(){return this.m_values}set values(values){this.m_values=values}get selector(){return this.m_selector}set selector(selector){this.m_selector=selector}}class ExpressionCalculator{constructor(mode){this.m_mode=mode}calculate(){}}class ValueFromList extends ExpressionCalculator{constructor(mode,info){super(mode);this.m_values=[];this.m_info=info}calculate(){if(this.m_info.selector=="sequential"){this.m_values=RandomMechanism.createSequentialSelector(this.m_info.values)}else if(this.m_info.selector=="random"){this.m_values=RandomMechanism.createRandomSelector(this.m_info.values)}return this.m_values}}const regex=/(\w+)\((.*?)\)/;class ExpressionInfo{constructor(mode,paramsString){this.m_mode=mode;this.m_paramsString=paramsString}}class ExpressionParser{static parse(expressionStr){const match=expressionStr.trim().match(regex);if(!match){console.error(TEMPLATE_TAG,"parse expression failed",expressionStr);return null}const mode=match[1];const paramsString=match[2];return new ExpressionInfo(mode,paramsString)}static parseValueFromListInfo(paramsString){const typeMatch=paramsString.match(/type="([^"]*)"/);const valueMatch=paramsString.match(/value="(\[.*?\])"/);const modeMatch=paramsString.match(/mode="([^"]*)"/);const dataType=typeMatch?typeMatch[1]:null;const jsonPart=valueMatch?valueMatch[1]:null;const mode=modeMatch?modeMatch[1]:null;if(dataType==null||jsonPart==null||mode==null){return new ValueFromListInfo("",[],"")}return new ValueFromListInfo(dataType,this.parseValues(jsonPart),mode)}static parseValues(valueString){const values=[];const jsonArray=JSON.parse(valueString);jsonArray.forEach((jsonArrayItem=>{values.push(jsonArrayItem)}));return values}}class Expression{constructor(expression){this.m_calculator=null;this.m_expressionStr=expression}parse(){const expressionInfo=ExpressionParser.parse(this.m_expressionStr);if(expressionInfo==null){console.error(TEMPLATE_TAG,"ExpressionParser parse failed",this.m_expressionStr);return}let expressionParas;switch(expressionInfo.m_mode){case"valueFromList":expressionParas=ExpressionParser.parseValueFromListInfo(expressionInfo.m_paramsString);this.m_calculator=new ValueFromList(expressionInfo.m_mode,expressionParas);break;default:console.error(TEMPLATE_TAG,"There is no matching mode in expression",this.m_expressionStr)}}update(){if(!this.m_calculator){console.error(TEMPLATE_TAG,"The m_calculator is null in expression ",this.m_expressionStr);return[]}return this.m_calculator.calculate()}static isValid(jsonStr){const content=JSON.parse(jsonStr);const color=content.styles[0].fill.content.solid.color;if(typeof color==="string"){return true}else{return false}}}var TextCommandType;(function(TextCommandType){TextCommandType[TextCommandType["CT_ENTER_EDIT_STATE"]=0]="CT_ENTER_EDIT_STATE";TextCommandType[TextCommandType["CT_EXIT_EDIT_STATE"]=1]="CT_EXIT_EDIT_STATE";TextCommandType[TextCommandType["CT_INPUT_STR"]=2]="CT_INPUT_STR";TextCommandType[TextCommandType["CT_INPUT_RICH_STR"]=3]="CT_INPUT_RICH_STR";TextCommandType[TextCommandType["CT_BACK_DELETE"]=4]="CT_BACK_DELETE";TextCommandType[TextCommandType["CT_FORWARD_DELETE"]=5]="CT_FORWARD_DELETE";TextCommandType[TextCommandType["CT_START_COMPOSE"]=6]="CT_START_COMPOSE";TextCommandType[TextCommandType["CT_PREEDIT_COMPOSE"]=7]="CT_PREEDIT_COMPOSE";TextCommandType[TextCommandType["CT_END_COMPOSE"]=8]="CT_END_COMPOSE";TextCommandType[TextCommandType["CT_FORCE_REFRESH"]=9]="CT_FORCE_REFRESH";TextCommandType[TextCommandType["CT_MOVE_CURSOR_LR"]=16]="CT_MOVE_CURSOR_LR";TextCommandType[TextCommandType["CT_MOVE_CURSOR_UPDOWN"]=17]="CT_MOVE_CURSOR_UPDOWN";TextCommandType[TextCommandType["CT_MOVE_CURSOR_LINE_BEGIN_END"]=18]="CT_MOVE_CURSOR_LINE_BEGIN_END";TextCommandType[TextCommandType["CT_MOVE_CURSOR_BY_INDEX"]=19]="CT_MOVE_CURSOR_BY_INDEX";TextCommandType[TextCommandType["CT_MOVE_CURSOR_BY_POS"]=20]="CT_MOVE_CURSOR_BY_POS";TextCommandType[TextCommandType["CT_MOVE_SELECT_HANDLE_BY_POS"]=21]="CT_MOVE_SELECT_HANDLE_BY_POS";TextCommandType[TextCommandType["CT_SELECT_CONTENT"]=32]="CT_SELECT_CONTENT";TextCommandType[TextCommandType["CT_SELECT_LR_CONTENT"]=33]="CT_SELECT_LR_CONTENT";TextCommandType[TextCommandType["CT_SELECT_UPDOWN_CONTENT"]=34]="CT_SELECT_UPDOWN_CONTENT";TextCommandType[TextCommandType["CT_SELECT_MOUSE_CONTENT"]=35]="CT_SELECT_MOUSE_CONTENT";TextCommandType[TextCommandType["CT_SELECT_ALL_CONTENT"]=36]="CT_SELECT_ALL_CONTENT";TextCommandType[TextCommandType["CT_EDIT_FONT"]=48]="CT_EDIT_FONT";TextCommandType[TextCommandType["CT_EDIT_COLOR"]=49]="CT_EDIT_COLOR";TextCommandType[TextCommandType["CT_EDIT_ALPHA"]=50]="CT_EDIT_ALPHA";TextCommandType[TextCommandType["CT_EDIT_BGCOLOR"]=51]="CT_EDIT_BGCOLOR";TextCommandType[TextCommandType["CT_EDIT_BG_ALPHA"]=52]="CT_EDIT_BG_ALPHA";TextCommandType[TextCommandType["CT_EDIT_SIZE"]=53]="CT_EDIT_SIZE";TextCommandType[TextCommandType["CT_EDIT_BOLD"]=54]="CT_EDIT_BOLD";TextCommandType[TextCommandType["CT_EDIT_ITALIC"]=55]="CT_EDIT_ITALIC";TextCommandType[TextCommandType["CT_EDIT_UNDERLINE"]=56]="CT_EDIT_UNDERLINE";TextCommandType[TextCommandType["CT_EDIT_OUTLINE"]=57]="CT_EDIT_OUTLINE";TextCommandType[TextCommandType["CT_EDIT_OUTLINE_COLOR"]=58]="CT_EDIT_OUTLINE_COLOR";TextCommandType[TextCommandType["CT_EDIT_OUTLINE_ALPHA"]=59]="CT_EDIT_OUTLINE_ALPHA";TextCommandType[TextCommandType["CT_EDIT_OUTLINE_WIDTH"]=60]="CT_EDIT_OUTLINE_WIDTH";TextCommandType[TextCommandType["CT_EDIT_SHADOW"]=61]="CT_EDIT_SHADOW";TextCommandType[TextCommandType["CT_EDIT_SHADOW_COLOR"]=62]="CT_EDIT_SHADOW_COLOR";TextCommandType[TextCommandType["CT_EDIT_SHADOW_ALPHA"]=63]="CT_EDIT_SHADOW_ALPHA";TextCommandType[TextCommandType["CT_EDIT_SHADOW_SMOOTH"]=64]="CT_EDIT_SHADOW_SMOOTH";TextCommandType[TextCommandType["CT_EDIT_SHADOW_OFFSET"]=65]="CT_EDIT_SHADOW_OFFSET";TextCommandType[TextCommandType["CT_EDIT_EFFECT_STYLE"]=66]="CT_EDIT_EFFECT_STYLE";TextCommandType[TextCommandType["CT_EDIT_TEXT_PRESET_STYLE_PARAM"]=67]="CT_EDIT_TEXT_PRESET_STYLE_PARAM";TextCommandType[TextCommandType["CT_EDIT_TEXT_PARAM"]=68]="CT_EDIT_TEXT_PARAM";TextCommandType[TextCommandType["CT_EDIT_TEMPLATE_TEXT_STYLE"]=69]="CT_EDIT_TEMPLATE_TEXT_STYLE";TextCommandType[TextCommandType["CT_EDIT_RESET_TEXT_CONTEXT"]=70]="CT_EDIT_RESET_TEXT_CONTEXT";TextCommandType[TextCommandType["CT_EDIT_DEFAULT_STYLE"]=71]="CT_EDIT_DEFAULT_STYLE";TextCommandType[TextCommandType["CT_EDIT_CONVERT_CASE"]=72]="CT_EDIT_CONVERT_CASE";TextCommandType[TextCommandType["CT_EDIT_FILL"]=73]="CT_EDIT_FILL";TextCommandType[TextCommandType["CT_EDIT_MULTI_STROKE"]=74]="CT_EDIT_MULTI_STROKE";TextCommandType[TextCommandType["CT_EDIT_MULTI_SHADOW"]=75]="CT_EDIT_MULTI_SHADOW";TextCommandType[TextCommandType["CT_EDIT_MULTI_SHADOW_STROKE"]=76]="CT_EDIT_MULTI_SHADOW_STROKE";TextCommandType[TextCommandType["CT_EDIT_MULTI_INNER_SHADOW"]=77]="CT_EDIT_MULTI_INNER_SHADOW";TextCommandType[TextCommandType["CT_EDIT_KEY_WORD_INFO"]=78]="CT_EDIT_KEY_WORD_INFO";TextCommandType[TextCommandType["CT_EDIT_BLOOM_STYLE"]=79]="CT_EDIT_BLOOM_STYLE";TextCommandType[TextCommandType["CT_EDIT_BACKGROUND_STYLE"]=80]="CT_EDIT_BACKGROUND_STYLE";TextCommandType[TextCommandType["CT_COMMAND_BATCH_PROCESS"]=128]="CT_COMMAND_BATCH_PROCESS";TextCommandType[TextCommandType["CT_GET_PLAIN_STR"]=256]="CT_GET_PLAIN_STR";TextCommandType[TextCommandType["CT_GET_RICH_STR"]=257]="CT_GET_RICH_STR";TextCommandType[TextCommandType["CT_GET_CURSOR_RECT"]=258]="CT_GET_CURSOR_RECT";TextCommandType[TextCommandType["CT_GET_CURSOR_CHAR_INDEX"]=259]="CT_GET_CURSOR_CHAR_INDEX";TextCommandType[TextCommandType["CT_GET_CHAR_RECT"]=260]="CT_GET_CHAR_RECT";TextCommandType[TextCommandType["CT_GET_SELECT_RANGE"]=261]="CT_GET_SELECT_RANGE";TextCommandType[TextCommandType["CT_GET_ERROR_INFO"]=262]="CT_GET_ERROR_INFO";TextCommandType[TextCommandType["CT_GET_EDIT_CONTEXT_INFO"]=263]="CT_GET_EDIT_CONTEXT_INFO";TextCommandType[TextCommandType["CT_GET_SELECT_HANDLE_RECT"]=264]="CT_GET_SELECT_HANDLE_RECT";TextCommandType[TextCommandType["CT_GET_TEXT_BASE_STYLE"]=267]="CT_GET_TEXT_BASE_STYLE";TextCommandType[TextCommandType["CT_NONE"]=512]="CT_NONE"})(TextCommandType||(TextCommandType={}));var Amaz$6=effect.Amaz;const PAGE_POST_MOTION=new Group;const LINE_POST_MOTION=new Group;const WORD_POST_MOTION=new Group;const WORD_UNREAD_POST_MOTION=new Group;const LINE_UNREAD_POST_MOTION=new Group;const PAGE_MOTION=new Group;const LINE_MOTION=new Group;const WORD_MOTION=new Group;const WORD_UNREAD_MOTION=new Group;const LINE_UNREAD_MOTION=new Group;class InitValues{constructor(textComp,start=-1,end=-1){this.selectStart=-1;this.selectEnd=-1;textComp.typeSettingDirty=true;textComp.forceTypeSetting();this.letters=textComp.letters.clone();this.backgrounds=textComp.backgrounds.clone();this.textStr=textComp.str;this.selectStart=start;this.selectEnd=end}}var ValueGeneratorType;(function(ValueGeneratorType){ValueGeneratorType["EXPRESSION"]="expression";ValueGeneratorType["KEYFRAME"]="keyFrame";ValueGeneratorType["TEMP"]="temp"})(ValueGeneratorType||(ValueGeneratorType={}));class ValueGeneratorContext{constructor(textComp,initValues,selector,overlayMode,callbackParams,targetAttribute,generatoType,context){this.textComp=null;this.initValues=null;this.selector=null;this.callbackParams=null;this.generatoType=ValueGeneratorType.KEYFRAME;this.textComp=textComp;this.initValues=initValues;this.selector=selector;this.overlayMode=overlayMode;this.callbackParams=callbackParams;this.targetAttribute=targetAttribute;this.generatoType=generatoType;this.generator=context}}class CaptionAnimationController extends TextBaseAnimationController{constructor(textComp){super();this.m_captionInfo=new CaptionInfo;this.m_captionInfoDirty=false;this.m_currentCaptionPage=null;this.m_enabled=false;this.m_callbackParams={};this.m_pageAnimations=[];this.m_lineAnimations=[];this.m_wordAnimations=[];this.m_keywordAnimations=[];this.m_selectors={};this.m_needMerge=false;this.m_richText=null;this.m_textComp=textComp;this.m_initValues=new InitValues(textComp);textComp.typeSettingParam.lineSpacingMode=Amaz$6.LineSpacingMode.ADAPTIVE}get enabled(){return this.m_enabled}set enabled(value){this.m_enabled=value}set needMerge(value){this.m_needMerge=value}get needMerge(){return this.m_needMerge}get keywordAnimations(){return this.m_keywordAnimations}set richText(richText){this.m_richText=richText}get richText(){return this.m_richText}get captionInfo(){return this.m_captionInfo}setAnimsParameters(animationArr){var _a;(_a=this.m_richText)===null||_a===void 0?void 0:_a.setAnimationParameters(animationArr)}setRichTextParameters(paras){if(this.m_richText){this.m_richText.parameters=paras}}setCaptionDurationInfo(captionDurationInfo){const words=captionDurationInfo.words;const validWords=[];for(let i=0;i<words.length;i++){if(words[i].start_time!=words[i].end_time)validWords.push(words[i])}for(let i=0;i<validWords.length-1;i++){validWords[i].end_time=validWords[i+1].start_time}for(let i=words.length-2;i>=0;i--){if(words[i].start_time==words[i].end_time){words[i].start_time=words[i+1].start_time;words[i].end_time=words[i+1].start_time}}this.m_captionInfo.setCaptionDurationInfo(captionDurationInfo);this.m_captionInfoDirty=true;this.m_enabled=true}_getBasicKeywordSize(){let index=0;let letterIndex=0;if(this.m_captionInfo.caption_duration_info!=null){const words=this.m_captionInfo.caption_duration_info.words;let found=false;for(let i=0;i<words.length;i++){const text=words[i].text;for(let j=0;j<text.length;j++){if(!["\n",""].includes(words[i].text)){if(words[i].is_key){letterIndex=index;found=true;break}index++}}if(found)break}}index=0;const letters=this.m_initValues.letters;for(let i=0;i<letters.size();i++){const letter=letters.get(i);if(letter.utf8!="\n"&&letter.utf8!=""){if(index==letterIndex){return letter.letterStyle.fontSize}index++}}return DEFAULT_FONT_SIZE}static _getAbsoluteKeywordSize(caption_params){var _a;const keyword_rich_text_str=caption_params.keyword_rich_text;if(keyword_rich_text_str!=null&&isJson(keyword_rich_text_str)){const keyword_rich_text=JSON.parse(keyword_rich_text_str);if(((_a=keyword_rich_text===null||keyword_rich_text===void 0?void 0:keyword_rich_text.styles[0])===null||_a===void 0?void 0:_a.size)!=null){return keyword_rich_text.styles[0].size}}return-1}_getKeywordSupersize(){const caption_params=this.m_captionInfo.caption_params;if(caption_params.keyword_supersize==null)return 1;else return caption_params.keyword_supersize}_getSupersize(){const caption_params=this.m_captionInfo.caption_params;if(caption_params.keyword_supersize==null)return 1;let supersize=caption_params.keyword_supersize;if(["line","page"].includes(caption_params.keyword_isolation)&&caption_params.keyword_isolation_supersize!=null&&caption_params.keyword_isolation_supersize>0){supersize*=caption_params.keyword_isolation_supersize}return supersize}getKeywordFontSize(){this.updateCaptionInfo();return{keyword_supersize:this._getKeywordSupersize(),keyword_font_size:this._getBasicKeywordSize()*this._getSupersize()}}_updateKeywordSupersize(){const caption_params=this.m_captionInfo.caption_params;const absoluteKeywordSize=CaptionAnimationController._getAbsoluteKeywordSize(caption_params);if(absoluteKeywordSize>0){let size=absoluteKeywordSize/this._getBasicKeywordSize();if(["line","page"].includes(caption_params.keyword_isolation)&&caption_params.keyword_isolation_supersize!=null&&caption_params.keyword_isolation_supersize>0){size/=caption_params.keyword_isolation_supersize}caption_params.keyword_supersize=size}}getSplittingResult(){this.updateCaptionInfo();return{splitting_result:this.m_captionInfo.splitting_result}}query(queries){const outJson={queries:{}};if(queries.includes("keyword_supersize")||queries.includes("keyword_font_size")){const sizes=this.getKeywordFontSize();Object.assign(outJson.queries,sizes)}if(queries.includes("splitting_result")){const caption_duration_info=this.getSplittingResult();Object.assign(outJson.queries,caption_duration_info)}return outJson}setTextCapital(capital){if(capital==null){return}const changed=this.m_captionInfo.setCapital(capital);if(changed){this.m_captionInfoDirty=true}this.m_enabled=true}setKeyFrameParams(keyframeParams){super.setKeyFrameParams(keyframeParams);this.m_enabled=true}setCaptionParams(captionParams){var _a;this.m_captionInfoDirty=true;this.m_keyFramesDirty=true;this.m_enabled=true;this.m_captionInfo.setCaptionParams(captionParams);if(captionParams.keyword_supersize_mode=="absolute"){this._updateKeywordSupersize()}if(this.m_captionInfo.isRelative()){const keyword_rich_text_str=this.m_captionInfo.caption_params.keyword_rich_text;if(keyword_rich_text_str!=null&&isJson(keyword_rich_text_str)){const keyword_rich_text=JSON.parse(keyword_rich_text_str);if(((_a=keyword_rich_text===null||keyword_rich_text===void 0?void 0:keyword_rich_text.styles[0])===null||_a===void 0?void 0:_a.size)!=null){this.m_captionInfo.keyword_font_size=keyword_rich_text.styles[0].size;delete keyword_rich_text.styles[0].size;this.m_captionInfo.caption_params.keyword_rich_text=JSON.stringify(keyword_rich_text)}}}}updateCaptionInfo(){if(!this.m_captionInfoDirty)return;this.m_captionInfoDirty=false;this.m_captionInfo.applyKeywordCapital();this.m_captionInfo.updatePages()}findSelector(selectorId){if(this.m_selectors[selectorId]){return this.m_selectors[selectorId]}return null}refreshInitValues(){const range=this.m_textComp.getSelectRange();const VALID=3;if(range.x==VALID)this.m_initValues=new InitValues(this.m_textComp,range.y,range.z);else this.m_initValues=new InitValues(this.m_textComp)}_sortKeyframes(){const groups=[PAGE_POST_MOTION,LINE_POST_MOTION,WORD_UNREAD_POST_MOTION,LINE_UNREAD_POST_MOTION,WORD_POST_MOTION,PAGE_MOTION,LINE_MOTION,WORD_UNREAD_MOTION,LINE_UNREAD_MOTION,WORD_MOTION];for(let i=0;i<groups.length;i++){const group=groups[i];KeyframeAttrUtils.sortKeyframesByAttributeSetter(group,CaptionAttributeSetter)}}updateKeyFrames(){PAGE_POST_MOTION.removeAll();LINE_POST_MOTION.removeAll();WORD_UNREAD_POST_MOTION.removeAll();LINE_UNREAD_POST_MOTION.removeAll();WORD_POST_MOTION.removeAll();PAGE_MOTION.removeAll();LINE_MOTION.removeAll();WORD_UNREAD_MOTION.removeAll();LINE_UNREAD_MOTION.removeAll();WORD_MOTION.removeAll();this.m_callbackParams={};if(this.m_keyframeParams==null){return}const keyframes=this.m_keyframeParams.keyframes;if(keyframes==null){return}for(let i=0;i<keyframes.length;i++){const keyframe=keyframes[i];if(keyframe.selector_id==null){continue}const selector=this.findSelector(keyframe.selector_id);if(selector==null){console.error(TEMPLATE_TAG,"keyframe_params error keyframe "+i+" selector is null");continue}let overlayMode="over";if(KeyframeAttrUtils.isValidOverlayMode(keyframe.overlay_mode))overlayMode=keyframe.overlay_mode;const motionContext=new ValueGeneratorContext(this.m_textComp,this.m_initValues,selector,overlayMode,this.m_callbackParams,"",ValueGeneratorType.KEYFRAME,keyframe);motionContext.callbackParams=this.m_callbackParams;const firstPage=this.m_captionInfo.getPage(0);if(firstPage)this.createMotions(keyframe,motionContext,firstPage)}this._sortKeyframes()}createMotions(keyframe,motionContext,firstPage){if(keyframe.k==undefined){console.error(TEMPLATE_TAG,"keyframe.k is undefined");return}if((keyframe.e-keyframe.s)*KEYFRAME_TIME_FACTOR<TIME_EPS){console.error(TEMPLATE_TAG,"keyframe time range too short");return}for(const key in keyframe.k)this.createMotionsForOneProperty(keyframe,motionContext,firstPage,key)}createMotionsForOneProperty(keyframe,motionContext,firstPage,propertyName){const prop=keyframe.k[propertyName];const callback=CaptionAttributeSetter.getValueCallback(propertyName);if(prop==undefined){console.error(TEMPLATE_TAG,"prop is undefined");return}if(prop.length==0){console.error(TEMPLATE_TAG,"prop is empty");return}const interp=Interpolation.Linear;let group=WORD_MOTION;const selectorUnit=motionContext.selector.unit;let startTime=0;let endTime=0;if(selectorUnit=="word"){const currentWord=firstPage.getCurrentWord(0);if(currentWord!=null){startTime=currentWord.m_startTimeInSegment;endTime=currentWord.m_endTimeInSegment}group=KeyframeAttrUtils.isPostGroup(propertyName)?WORD_POST_MOTION:WORD_MOTION}else if(selectorUnit=="line"){const currentLine=firstPage.getCurrentLine(0);if(currentLine!=null){startTime=currentLine.m_startTimeInSegment;endTime=currentLine.m_endTimeInSegment}group=KeyframeAttrUtils.isPostGroup(propertyName)?LINE_POST_MOTION:LINE_MOTION}else if(selectorUnit=="page"){startTime=firstPage.m_startTimeInSegment;endTime=firstPage.m_endTimeInSegment;group=KeyframeAttrUtils.isPostGroup(propertyName)?PAGE_POST_MOTION:PAGE_MOTION}else if(selectorUnit=="word_unread"){startTime=firstPage.m_startTimeInSegment;endTime=firstPage.m_endTimeInSegment;group=KeyframeAttrUtils.isPostGroup(propertyName)?WORD_UNREAD_POST_MOTION:WORD_UNREAD_MOTION}else if(selectorUnit=="line_unread"){startTime=firstPage.m_startTimeInSegment;endTime=firstPage.m_endTimeInSegment;group=KeyframeAttrUtils.isPostGroup(propertyName)?LINE_UNREAD_POST_MOTION:LINE_UNREAD_MOTION}const keyframes=[];let v=prop[0].v;if(prop[0].v instanceof Array&&prop[0].v.length===4&&ColorNames.includes(propertyName)){v=ColorRGBA.castJsonArray4fToColorRGBA(prop[0].v)}keyframes.push(new keyframeUnitInfo(v,startTime,prop[0].it));for(let i=0;i<prop.length;i++){const t=prop[i].t*KEYFRAME_TIME_FACTOR;let v=prop[i].v;if(prop[i].v instanceof Array&&prop[i].v.length===4&&ColorNames.includes(propertyName)){v=ColorRGBA.castJsonArray4fToColorRGBA(prop[i].v)}const keyframeUnit=new keyframeUnitInfo(v,t,prop[i].it);if(keyframeUnit.m_it==="cubic"){keyframeUnit.m_vti=prop[i].vti*KEYFRAME_TIME_FACTOR;keyframeUnit.m_vto=prop[i].vto*KEYFRAME_TIME_FACTOR;if(ColorNames.includes(propertyName)){const colorV=ColorRGBA.castJsonArray4fToColorRGBA(prop[i].v);const colorVi=ColorRGBA.castJsonArray4fToColorRGBA(prop[i].vi);const colorV0=ColorRGBA.castJsonArray4fToColorRGBA(prop[i].v0);if(null!==colorV&&null!==colorVi&&null!==colorV0){keyframeUnit.m_vi=colorV.add(colorVi);keyframeUnit.m_vo=colorV.add(colorV0)}}else{keyframeUnit.m_vi=prop[i].v+prop[i].vi;keyframeUnit.m_vo=prop[i].v+prop[i].vo}}if(t-keyframes[keyframes.length-1].m_t>TIME_EPS){keyframes.push(keyframeUnit)}}if(endTime-keyframes[keyframes.length-1].m_t>TIME_EPS){let v=prop[prop.length-1].v;if(prop[prop.length-1].v instanceof Array&&prop[prop.length-1].v.length===4){v=ColorRGBA.castJsonArray4fToColorRGBA(prop[prop.length-1].v)}keyframes.push(new keyframeUnitInfo(v,endTime,prop[prop.length-1].it))}KeyframeAttrUtils.createOneMotion(keyframes,callback,interp,motionContext,true,group,propertyName).start()}applyKeywordSupersize(range,keyword_supersize){for(let i=0;i<range.length;i+=2){this.m_callbackParams.values.push({name:"s",value:keyword_supersize,start:range[i],end:range[i+1],overlayMode:"mul",selectorUnit:"word"})}}updateKeyword(currentPage){if(currentPage==undefined||currentPage==null){console.error(TEMPLATE_TAG,"updateKeyword currentPage is null")}if(!this.m_captionInfo.caption_params.keyword_rich_text||!this.m_captionInfo.caption_params.enable_keyword){return}const rangeInPage=[];for(let i=0;i<currentPage.m_words.length;i++){if(currentPage.m_words[i].m_isKey){rangeInPage.push(currentPage.m_words[i].startIndex,currentPage.m_words[i].endIndex)}}if(rangeInPage.length>1){if(this.m_captionInfo.isRelative()){const supersize=this._getSupersize();this.applyKeywordSupersize(rangeInPage,supersize)}const keyword_rich_text_str=this.m_captionInfo.getKeywordRichText();this.m_textComp.applyTextStyle(keyword_rich_text_str,rangeInPage)}this.updateExpressions(this.m_keywordAnimations,0)}get currentCaptionPage(){if(this.m_currentCaptionPage)return this.m_currentCaptionPage;else{return null}}resetCurrentCaptionPage(){this.m_currentCaptionPage=null}initFrame(){this.m_textComp.setString(this.m_initValues.textStr,false);const oldLetters=this.m_initValues.letters;const letters=this.m_textComp.letters;if(oldLetters.size()!=letters.size()){console.error(TEMPLATE_TAG,"oldLetters.size() != letters.size()",oldLetters.size(),letters.size())}for(let i=0;i<letters.size();i++){const letter=letters.get(i);const oldLetter=oldLetters.get(i);letter.letterStyle=oldLetter.letterStyle.clone()}this.m_textComp.bloomDirty=true;this.m_textComp.forceTypeSetting();for(let i=0;i<letters.size();i++){const letter=letters.get(i);const oldLetter=oldLetters.get(i);letter.position=oldLetter.position;letter.scale=oldLetter.scale;letter.rotate=oldLetter.rotate;letter.extraMatrix=oldLetter.extraMatrix;letter.instanceColor=oldLetter.instanceColor}const backgrounds=this.m_textComp.backgrounds;const oldBackgrounds=this.m_initValues.backgrounds;if(oldBackgrounds.size()==0){this.m_textComp.backgrounds.clear()}else{for(let i=0;i<backgrounds.size();i++){const oldBg=oldBackgrounds.get(i);backgrounds.set(i,oldBg.clone())}}this.m_keyFramesDirty=true}static convertToLetterIndices(charIndices,lettersVec){const letterIndices=[];if(charIndices.length==0)return letterIndices;let utf16Size=0;const letters=this.getLettersWithoutReturn(lettersVec);const letterSize=letters.length;let charPos=0;let charIndex=charIndices[charPos];for(let i=0;i<letterSize;i++){const letter=letters[i];const curUtf16Size=utf16Size+letter.getUTF16Size();if(curUtf16Size>charIndex){letterIndices.push(i);if(charPos>=charIndices.length-1)break;charIndex=charIndices[++charPos]}utf16Size=curUtf16Size}const count=charIndices.length-letterIndices.length;for(let i=0;i<count;i++)letterIndices.push(letterSize);return letterIndices}updateLetterIndices(){const startPageIndexInSegment=0;const endPageIndexInSegment=this.m_captionInfo.pages.length-1;const charIndices=[0];let charCount=0;let returnCount=0;for(let pageIndex=startPageIndexInSegment;pageIndex<=endPageIndexInSegment;pageIndex++){const page=this.m_captionInfo.pages[pageIndex];charCount+=page.m_string.length;for(let j=0;j<page.m_string.length;j++)if(["\n",""].includes(page.m_string[j]))returnCount++;charIndices.push(charCount-returnCount)}const letterIndices=CaptionAnimationController.convertToLetterIndices(charIndices,this.m_initValues.letters);for(let pageIndex=startPageIndexInSegment;pageIndex<=endPageIndexInSegment;pageIndex++){const page=this.m_captionInfo.pages[pageIndex];page.m_utf16StartLetterIndex=letterIndices[pageIndex-startPageIndexInSegment];page.m_utf16EndLetterIndex=letterIndices[pageIndex-startPageIndexInSegment+1]}}static getLettersWithoutReturn(letters){const lettersWithoutReturn=[];for(let i=0;i<letters.size();i++){const letter=letters.get(i);if(letter.utf8!="\n"&&letter.utf8!=""){lettersWithoutReturn.push(letter)}}return lettersWithoutReturn}recoverLetters(str,startIndex=0){this.m_textComp.setString(str,false);const oldLetters=CaptionAnimationController.getLettersWithoutReturn(this.m_initValues.letters);const letters=CaptionAnimationController.getLettersWithoutReturn(this.m_textComp.letters);if(oldLetters.length<letters.length+startIndex){console.error(TEMPLATE_TAG,"without returns, oldLetters.length < letters.length + startIndex",oldLetters.length,letters.length,startIndex)}for(let i=0;i<letters.length;i++){const letter=letters[i];const oldLetter=oldLetters[i+startIndex];letter.letterStyle=oldLetter.letterStyle.clone()}}switchPage(currentPage){this.m_currentCaptionPage=currentPage;this.updateLetterIndices();if(this.m_currentCaptionPage.m_utf16StartLetterIndex<0){console.error(TEMPLATE_TAG,"utf16StartLetterIndex < 0");return}this.recoverLetters(this.m_currentCaptionPage.stringTrimEnd,this.m_currentCaptionPage.m_utf16StartLetterIndex)}updateSelectors(timeInPage){this.m_selectors={};if(this.m_keyframeParams==null){return}const selectors=this.m_keyframeParams.selectors;if(selectors==null){return}for(let i=0;i<selectors.length;i++){const selector=new Selector(selectors[i]);this.m_selectors[selector.id]=selector}Object.values(this.m_selectors).forEach((selector=>{selector.captionPage=this.currentCaptionPage;selector.update(timeInPage)}))}doesAnimEffectExist(){if(this.m_keyframeParams==null){return false}if(this.m_captionInfo.caption_params.max_units_per_line!=null&&this.m_captionInfo.caption_params.max_units_per_line>0){return true}if(this.m_keyframeParams.selectors==null){return false}if("keyframes"in this.m_keyframeParams&&this.m_keyframeParams.keyframes.length>0){return true}if("value_generators"in this.m_keyframeParams&&this.m_keyframeParams.value_generators.length>0){return true}return false}update(timeInSegment){var _a,_b,_c,_d,_e;if(!this.m_enabled)return timeInSegment;this.updateCaptionInfo();const currentPage=this.m_captionInfo.getPage(timeInSegment);let timeInPage=timeInSegment;if(!((_a=this.m_richText)===null||_a===void 0?void 0:_a.hasAnimation())&&!this.m_needMerge&&!this.m_captionInfo.onlyForKeyword){if(currentPage!=null){timeInPage=currentPage.getTimeInPage(timeInSegment);this.switchPage(currentPage)}else{const pageLength=this.m_captionInfo.pages.length;const wordEndtime=this.m_captionInfo.pages[pageLength-1].m_endTimeInSegment;if(!Number.isNaN(wordEndtime)&&timeInSegment>=wordEndtime&&this.doesAnimEffectExist()){console.log("[CaptionAnimationController] time exceeds limit and contains anim effect, clear text!");this.m_textComp.setString("",false)}}}if(this.m_keyframeParams!=null){if(this.m_keyFramesDirty==true){this.m_keyFramesDirty=false;this.updateSelectors(timeInPage);this.updateKeyFrames()}}this.m_callbackParams.values=[];if(this.m_keyframeParams&&"value_generators"in this.m_keyframeParams){this.updateValueGenerators(this.m_keyframeParams.value_generators)}if(this.m_needMerge||this.m_captionInfo.onlyForKeyword){const page=CaptionInfo.generateOnePage(this.m_captionInfo.caption_duration_info_capital);this.m_captionInfo.pages.push(page);this.m_currentCaptionPage=page;const range=[];const wordLength=this.m_currentCaptionPage.m_words.length;for(let i=0;i<wordLength;i++){if(this.m_currentCaptionPage.m_words[i].m_isKey){range.push(this.m_currentCaptionPage.m_words[i].startIndex,this.m_currentCaptionPage.m_words[i].endIndex)}}if(range.length>1){this.m_textComp.applyTextStyle(this.m_captionInfo.getKeywordRichTextWithSize(),range)}this.updateExpressions(this.m_keywordAnimations,0);this.flushCallbackQueue();this.m_textComp.forceTypeSetting();this.m_needMerge=false;if((_b=this.m_richText)===null||_b===void 0?void 0:_b.hasAnimation()){(_c=this.m_richText)===null||_c===void 0?void 0:_c.onUpdate(timeInSegment)}return timeInSegment}if((_d=this.m_richText)===null||_d===void 0?void 0:_d.hasAnimation()){(_e=this.m_richText)===null||_e===void 0?void 0:_e.onUpdate(timeInSegment);return timeInSegment}this.m_textComp.forceTypeSetting();let wordCountInPage=-1;let wordCountInLine=-1;let currentLine=null;let currentWord=null;if(currentPage){const startTimeInPage=currentPage.m_startTimeInSegment;currentLine=currentPage.getCurrentLine(timeInPage);currentWord=currentPage.getCurrentWord(timeInPage);const max_lines_per_page=this.m_captionInfo.caption_params.max_lines_per_page;let max_units_per_line=this.m_captionInfo.caption_params.max_units_per_line;max_units_per_line=max_units_per_line==0?1e5:max_units_per_line;wordCountInPage=max_lines_per_page*max_units_per_line;wordCountInLine=max_units_per_line;this.updatePageAnimations(timeInPage,wordCountInPage,currentPage,startTimeInPage);if(currentLine)this.updateLineAnimations(timeInPage,wordCountInLine,currentLine,startTimeInPage);WORD_UNREAD_MOTION.update(timeInPage,true,{wordCount:wordCountInPage,targetStart:currentPage.m_startTimeInSegment-startTimeInPage,targetEnd:currentPage.m_endTimeInSegment-startTimeInPage});LINE_UNREAD_MOTION.update(timeInPage,true,{wordCount:wordCountInLine,targetStart:currentPage.m_startTimeInSegment-startTimeInPage,targetEnd:currentPage.m_endTimeInSegment-startTimeInPage});this.flushCallbackQueue();this.updateKeyword(currentPage);this.m_textComp.forceTypeSetting();if(currentWord)this.updateWordAnimations(timeInPage,1,currentWord,startTimeInPage);this.flushCallbackQueue();this.m_textComp.forceTypeSetting();this.updatePagePostAnimations(timeInPage,wordCountInPage,currentPage,startTimeInPage);if(currentLine)this.updateLinePostAnimations(timeInPage,wordCountInLine,currentLine,startTimeInPage);WORD_UNREAD_POST_MOTION.update(timeInPage,true,{wordCount:wordCountInPage,targetStart:currentPage.m_startTimeInSegment-startTimeInPage,targetEnd:currentPage.m_endTimeInSegment-startTimeInPage});LINE_UNREAD_POST_MOTION.update(timeInPage,true,{wordCount:wordCountInLine,targetStart:currentPage.m_startTimeInSegment-startTimeInPage,targetEnd:currentPage.m_endTimeInSegment-startTimeInPage});if(currentWord)this.updateWordPostAnimations(timeInPage,1,currentWord,startTimeInPage);this.flushCallbackQueue()}return timeInPage}updateValueGenerators(valueGenerators){this.m_pageAnimations=[];this.m_lineAnimations=[];this.m_wordAnimations=[];this.m_keywordAnimations=[];if(valueGenerators==null){return}for(let i=0;i<valueGenerators.length;i++){const valueGenerator=valueGenerators[i];const selector=this.findSelector(valueGenerator.selector_id);if(selector==null){console.error(TEMPLATE_TAG,"updateValueGenerators error valueGenerator "+i+" selector is null");continue}const generator=valueGenerator.generator;const expression=new Expression(generator);const targetAttribute=valueGenerator.target_attribute;const valueGeneratorContext=new ValueGeneratorContext(this.m_textComp,this.m_initValues,selector,"over",this.m_callbackParams,targetAttribute,ValueGeneratorType.EXPRESSION,expression);const selectorUnit=selector.unit;switch(selectorUnit){case SelectorUnit.WORD:this.m_wordAnimations.push(valueGeneratorContext);break;case SelectorUnit.LINE:this.m_lineAnimations.push(valueGeneratorContext);break;case SelectorUnit.PAGE:this.m_pageAnimations.push(valueGeneratorContext);break;case SelectorUnit.KEYWORD:this.m_keywordAnimations.push(valueGeneratorContext);break;default:console.error(TEMPLATE_TAG,"");continue}}}updateExpressions(valueGeneratorContext,timeInPage){var _a,_b,_c,_d;if(!this.m_currentCaptionPage){return}const vgLen=valueGeneratorContext.length;for(let i=0;i<vgLen;i++){const vg=valueGeneratorContext[i];if(vg.generatoType!="expression"){continue}const expression=vg.generator;expression.parse();const expressionRes=expression.update();const seletor=vg.selector;const selectorUnit=seletor===null||seletor===void 0?void 0:seletor.unit;switch(selectorUnit){case SelectorUnit.WORD:const currentWord=this.m_currentCaptionPage.getCurrentWord(timeInPage);if(currentWord!=null){const globalIndex=currentWord.m_globalIndex;const value=expressionRes[globalIndex%expressionRes.length];this.m_callbackParams.values.push({name:vg.targetAttribute,value:value,start:currentWord.startIndex,end:currentWord.endIndex,overlayMode:vg.overlayMode,selectorUnit:selectorUnit})}break;case SelectorUnit.LINE:const currentLine=this.m_currentCaptionPage.getCurrentLine(timeInPage);if(currentLine){const globalIndex=currentLine.m_globalIndex;const value=expressionRes[globalIndex%expressionRes.length];this.m_callbackParams.values.push({name:vg.targetAttribute,value:value,start:(_a=currentLine.startWord)===null||_a===void 0?void 0:_a.startIndex,end:(_b=currentLine.endWord)===null||_b===void 0?void 0:_b.endIndex,overlayMode:vg.overlayMode,selectorUnit:selectorUnit})}break;case SelectorUnit.PAGE:const globalIndex=this.m_currentCaptionPage.m_globalIndex;const value=expressionRes[globalIndex%expressionRes.length];this.m_callbackParams.values.push({name:vg.targetAttribute,value:value,start:(_c=this.m_currentCaptionPage.startWord)===null||_c===void 0?void 0:_c.startIndex,end:(_d=this.m_currentCaptionPage.endWord)===null||_d===void 0?void 0:_d.endIndex,overlayMode:vg.overlayMode,selectorUnit:selectorUnit});break;case SelectorUnit.KEYWORD:const expressionResLength=expressionRes.length;let keywordIndex=0;for(let pageIndex=0;pageIndex<this.m_captionInfo.pages.length;pageIndex++){const curPage=this.m_captionInfo.pages[pageIndex];for(let i=0;i<curPage.m_words.length;i++){if(curPage.m_words[i].m_isKey&&![" ","\n",""].includes(curPage.m_words[i].m_string)){if(curPage==this.m_currentCaptionPage||this.needMerge){const value=expressionRes[keywordIndex%expressionResLength];this.m_callbackParams.values.push({name:vg.targetAttribute,value:value,start:curPage.m_words[i].startIndex,end:curPage.m_words[i].endIndex,overlayMode:vg.overlayMode,selectorUnit:selectorUnit})}keywordIndex++}}}break;default:console.error(TEMPLATE_TAG,"");continue}}}updatePageAnimations(timeInPage,wordCount,currentPage,startTimeInPage){PAGE_MOTION.update(timeInPage,true,{wordCount:wordCount,targetStart:currentPage.m_startTimeInSegment-startTimeInPage,targetEnd:currentPage.m_endTimeInSegment-startTimeInPage});this.updateExpressions(this.m_pageAnimations,timeInPage)}updateLineAnimations(timeInPage,wordCount,currentLine,startTimeInPage){LINE_MOTION.update(timeInPage,true,{wordCount:wordCount,targetStart:currentLine.m_startTimeInSegment-startTimeInPage,targetEnd:currentLine.m_endTimeInSegment-startTimeInPage});this.updateExpressions(this.m_lineAnimations,timeInPage)}updateWordAnimations(timeInPage,wordCount,currentWord,startTimeInPage){WORD_MOTION.update(timeInPage,true,{wordCount:wordCount,targetStart:currentWord.m_startTimeInSegment-startTimeInPage,targetEnd:currentWord.m_endTimeInSegment-startTimeInPage});this.updateExpressions(this.m_wordAnimations,timeInPage)}updatePagePostAnimations(timeInPage,wordCount,currentPage,startTimeInPage){PAGE_POST_MOTION.update(timeInPage,true,{wordCount:wordCount,targetStart:currentPage.m_startTimeInSegment-startTimeInPage,targetEnd:currentPage.m_endTimeInSegment-startTimeInPage})}updateLinePostAnimations(timeInPage,wordCount,currentLine,startTimeInPage){LINE_POST_MOTION.update(timeInPage,true,{wordCount:wordCount,targetStart:currentLine.m_startTimeInSegment-startTimeInPage,targetEnd:currentLine.m_endTimeInSegment-startTimeInPage})}updateWordPostAnimations(timeInPage,wordCount,currentWord,startTimeInPage){WORD_POST_MOTION.update(timeInPage,true,{wordCount:wordCount,targetStart:currentWord.m_startTimeInSegment-startTimeInPage,targetEnd:currentWord.m_endTimeInSegment-startTimeInPage})}flushCallbackQueue(){if(this.m_callbackParams.values.length>0){const jsonStr=JSON.stringify(this.m_callbackParams);AmazUtils$1.swingTemplateUtils.captionSetParamsBatch(this.m_textComp,jsonStr);this.m_callbackParams.values=[]}}setSelectRange(start,end){if(start>=0&&end>=0){const textCmd=new Amaz$6.TextCommand;textCmd.type=TextCommandType.CT_SELECT_CONTENT;textCmd.iParam1=start;textCmd.iParam2=end-start;this.m_textComp.pushCommand(textCmd);this.m_textComp.forceFlushCommandQueue()}}postUpdate(timeInSegment){var _a;if((_a=this.m_richText)===null||_a===void 0?void 0:_a.hasAnimation()){return timeInSegment}if(!this.m_enabled)return timeInSegment;if(this.m_keyframeParams!=null||this.m_captionInfo.onlyForKeyword){this.initFrame()}this.setSelectRange(this.m_initValues.selectStart,this.m_initValues.selectEnd);return timeInSegment}onTextChangeForScript(){this.resetAnimation();this.resetCurrentCaptionPage();this.refreshInitValues()}}var Amaz$5=effect.Amaz;class TextAttributeSetter{static setRootScaleX(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="sx"){widget.scale=new Amaz$5.Vector3f(value,widget.scale.y,widget.scale.z)}}static setRootScaleY(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="sy"){widget.scale=new Amaz$5.Vector3f(widget.scale.x,value,widget.scale.z)}}static setRootRotationZ(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="rz"){widget.rotation=new Amaz$5.Vector3f(widget.rotation.x,widget.rotation.y,value)}}static setRootPosX(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="px"){widget.position=new Amaz$5.Vector3f(value,widget.position.y,widget.position.z)}}static setRootPosY(obj){const widget=obj.motionContext.widget;const value=obj.v;const propertyName=obj.propertyName;if(propertyName==="py"){widget.position=new Amaz$5.Vector3f(widget.position.x,value,widget.position.z)}}static getValueCallback(propertyName){return function(obj){const value=obj.v;const motionContext=obj.motionContext;motionContext.callbackParams.values.push({name:propertyName,value:value,overlayMode:motionContext.overlayMode})}}}TextAttributeSetter.setterMap={px:TextAttributeSetter.setRootPosX,py:TextAttributeSetter.setRootPosY,sx:TextAttributeSetter.setRootScaleX,sy:TextAttributeSetter.setRootScaleY,rz:TextAttributeSetter.setRootRotationZ};class TextValueGeneratorContext{constructor(widget,textComp,overlayMode,callbackParams){this.widget=null;this.textComp=null;this.callbackParams=null;this.widget=widget;this.textComp=textComp;this.overlayMode=overlayMode;this.callbackParams=callbackParams}}class TextAnimationController extends TextBaseAnimationController{constructor(widget,textComp){super();this.m_host=null;this.m_textComp=null;this.m_callbackParams={};this.m_text_trs_motion=new Group;this.m_text_pre_motion=new Group;this.m_text_style_motion=new Group;this.m_host=widget;this.m_textComp=textComp}setKeyFrameParams(keyframeParams){super.setKeyFrameParams(keyframeParams)}updateKeyFrames(){if(!this.checkIsDirty()){return}this.m_keyFramesDirty=false;this.m_text_trs_motion.removeAll();this.m_text_pre_motion.removeAll();this.m_text_style_motion.removeAll();this.m_callbackParams={};if(this.m_keyframeParams==null){return}const keyframes=this.m_keyframeParams.text_keyframes;if(keyframes==null){return}for(let i=0;i<keyframes.length;i++){const keyframe=keyframes[i];let overlayMode="over";if(KeyframeAttrUtils.isValidOverlayMode(keyframe.overlay_mode))overlayMode=keyframe.overlay_mode;if(keyframe.k==null){console.error(TEMPLATE_TAG,"keyframe.k is undefined");return}const startTimeInSec=keyframe.s*KEYFRAME_TIME_FACTOR;const endTimeInSec=keyframe.e*KEYFRAME_TIME_FACTOR;if(endTimeInSec-startTimeInSec<TIME_EPS){console.error(TEMPLATE_TAG,"keyframe time range too short");return}this.setTimeRange(startTimeInSec,endTimeInSec);const motionContext=new TextValueGeneratorContext(this.m_host,this.m_textComp,overlayMode,this.m_callbackParams);motionContext.callbackParams=this.m_callbackParams;for(const key in keyframe.k){if(keyframe.k[key]!=null){this.createMotionsForOneProperty(keyframe,motionContext,key)}}}this._sortKeyframes()}_sortKeyframes(){const groups=[this.m_text_trs_motion,this.m_text_pre_motion,this.m_text_style_motion];for(let i=0;i<groups.length;i++){const group=groups[i];KeyframeAttrUtils.sortKeyframesByAttributeSetter(group,TextAttributeSetter)}}createMotionsForOneProperty(keyframeJson,motionContext,propertyName){const isPreGroup=propertyName=>{if(propertyName==="s"){return true}return false};const prop=keyframeJson.k[propertyName];if(prop==undefined){console.error(TEMPLATE_TAG,"prop is undefined");return}if(prop.length==0){console.error(TEMPLATE_TAG,"prop is empty");return}const interp=Interpolation.Linear;let group=this.m_text_trs_motion;const keyframes=KeyframeAttrUtils.createKeyframes(keyframeJson,propertyName);if(propertyName in TextAttributeSetter.setterMap){const trsCallback=TextAttributeSetter.setterMap[propertyName];KeyframeAttrUtils.createOneMotionByRelativeTime(keyframes,trsCallback,interp,motionContext,group,propertyName,this.m_startTimeInSegment,this.m_endTimeInSegment,keyframeJson.s,keyframeJson.e).start()}else{group=isPreGroup(propertyName)?this.m_text_pre_motion:this.m_text_style_motion;const styleCallback=TextAttributeSetter.getValueCallback(propertyName);KeyframeAttrUtils.createOneMotionByRelativeTime(keyframes,styleCallback,interp,motionContext,group,propertyName,this.m_startTimeInSegment,this.m_endTimeInSegment,keyframeJson.s,keyframeJson.e).start()}}update(timeInSegment){var _a;if(this.m_keyframeParams!=null){this.m_callbackParams.values=[];this.m_text_trs_motion.update(timeInSegment,true);this.m_text_pre_motion.update(timeInSegment,true);if(this.m_callbackParams.values.length>0){const jsonStr=JSON.stringify(this.m_callbackParams);AmazUtils$1.swingTemplateUtils.textKeyframeCallback(this.m_textComp,jsonStr);this.m_callbackParams.values=[]}(_a=this.m_textComp)===null||_a===void 0?void 0:_a.forceTypeSetting();this.m_text_style_motion.update(timeInSegment,true);if(this.m_callbackParams.values.length>0){const jsonStr=JSON.stringify(this.m_callbackParams);AmazUtils$1.swingTemplateUtils.textKeyframeCallback(this.m_textComp,jsonStr);this.m_callbackParams.values=[]}}return timeInSegment}}var Amaz$4=effect.Amaz;class TextAssociationController extends BaseAssociationController{constructor(){super(...arguments);this.m_oriWordInfo=null;this.m_curWordInfo=null;this.m_dirty=false;this.m_startTime=0;this.m_wordIdRange=[];this.m_wordIdRangeDirty=false;this.m_wordInfoDirty=false;this.m_reuseStyleStr=""}set oriWordInfo(wordInfo){this.m_oriWordInfo=wordInfo}get oriWordInfo(){return this.m_oriWordInfo}set curWordInfo(wordInfo){this.m_curWordInfo=wordInfo}get curWordInfo(){return this.m_curWordInfo}set dirty(dirty){this.m_dirty=dirty}get dirty(){return this.m_dirty}set startTime(startTime){this.m_startTime=startTime}get startTime(){return this.m_startTime}set wordIdRange(wordIdRange){this.m_wordIdRange=wordIdRange}get wordIdRange(){return this.m_wordIdRange}set wordIdRangeDirty(wordIdRangeDirty){this.m_wordIdRangeDirty=wordIdRangeDirty}get wordIdRangeDirty(){return this.m_wordIdRangeDirty}set wordInfoDirty(wordInfoDirty){this.m_wordInfoDirty=wordInfoDirty}get wordInfoDirty(){return this.m_wordInfoDirty}getTextWidget(){if(this.widget&&this.widget.widgetType===WidgetType.TEXT){return this.widget}return null}setAssociationParams(params){super.associationParams=params;this.updateAssociationParams()}updateAssociationParams(){var _a,_b;const text=this.getTextWidget();if(text&&((_a=text.jsonParams)===null||_a===void 0?void 0:_a.start_time)){const startTime=text.jsonParams.start_time;if(this.startTime!=startTime){this.startTime=startTime;this.m_wordIdRangeDirty=true}}if("word_id_range"in super.associationParams){const wordIdRange=super.associationParams.word_id_range;let isEqual=true;if(this.m_wordIdRange.length!=wordIdRange.length){isEqual=false}else{for(let i=0;i<this.m_wordIdRange.length;i++){if(this.m_wordIdRange[i]!=wordIdRange[i]){isEqual=false;break}}}if(!isEqual){this.m_wordIdRange.length=0;if(wordIdRange.length<2){this.m_oriWordInfo=null;this.m_curWordInfo=null;const textWidget=this.getTextWidget();if(textWidget&&textWidget.textComp){textWidget.textComp.oriTextWordInfo=null;textWidget.textComp.curTextWordInfo=null}this.m_wordIdRangeDirty=false}else{this.m_wordIdRange.push(wordIdRange[0]);this.m_wordIdRange.push(wordIdRange[1]);this.m_wordIdRangeDirty=true}}}if(((_b=this.widget)===null||_b===void 0?void 0:_b.rootWidget)!=null&&(this.m_wordIdRangeDirty||this.m_dirty)&&this.m_wordIdRange.length>=2){const rootController=this.widget.rootWidget.rootAssociationController;if(rootController&&rootController&&rootController.oriWordInfo&&rootController.curWordInfo){if(!this.oriWordInfo){this.oriWordInfo=new Amaz$4.TextWordInfo}if(!this.curWordInfo){this.curWordInfo=new Amaz$4.TextWordInfo}const wordIdRangeVec=new Amaz$4.Vector;wordIdRangeVec.pushBack(this.wordIdRange[0]);wordIdRangeVec.pushBack(this.wordIdRange[1]);const msTimeOffset=(this.m_startTime-this.widget.rootWidget.startTime)*-1e3;this.oriWordInfo.initWith(rootController.oriWordInfo,wordIdRangeVec,msTimeOffset);this.curWordInfo.initWith(rootController.curWordInfo,wordIdRangeVec,msTimeOffset);this.oriWordInfo.dirtyIndex.clear();this.curWordInfo.dirtyIndex.clear();this.curWordInfo.isUpdateEnable=true;const textWidget=this.getTextWidget();if(textWidget&&textWidget.textComp){textWidget.textComp.oriTextWordInfo=this.oriWordInfo;textWidget.textComp.curTextWordInfo=this.curWordInfo}}}this.m_associationParamsDirty=false}updateByAssociation(){var _a;if(((_a=this.widget)===null||_a===void 0?void 0:_a.rootWidget)!=null&&this.m_wordIdRange.length>=2){const textWidget=this.getTextWidget();if(this.curWordInfo&&(this.m_wordIdRangeDirty||this.m_dirty)){const text=this.curWordInfo.text;if(textWidget&&textWidget.textComp){let templateStyle=textWidget.textComp.getRichStr(0,0,0,0,true);if(text.length==0&&templateStyle.length!=0){this.m_reuseStyleStr=templateStyle}if(text.length!=0&&templateStyle.length==0){templateStyle=this.m_reuseStyleStr}const jsonParam5={text:text,templateStyle:templateStyle};const textOP={m_iOpCode:69,m_fParam1:1,m_fParam2:0,m_fParam3:0,m_fParam4:0,m_sParam:JSON.stringify(jsonParam5)};textWidget.setRichTextByOPCode(textOP);textWidget.captionDurationInfoDirty=true;textWidget.captionParamsDirty=true}this.updateCaptionDurationInfo();this.m_dirty=false}if(textWidget&&textWidget.textComp){const text=textWidget.textComp.getPlainStr(0,0,0);if(this.oriWordInfo&&this.curWordInfo&&text!=this.curWordInfo.text){AmazUtils$1.TextWordMatchUtils.matchWordInfoByText(this.oriWordInfo,this.curWordInfo,text);this.curWordInfo.dirtyIndex.clear();this.updateCaptionDurationInfo();this.wordInfoDirty=true}if(this.curWordInfo&&this.curWordInfo.dirtyIndex.size()>0){this.curWordInfo.dirtyIndex.clear();this.updateCaptionDurationInfo();this.wordInfoDirty=true}}}}updateCaptionDurationInfo(){var _a,_b;const textWidget=this.getTextWidget();if(!textWidget||!textWidget.textComp||!this.curWordInfo){return}if((_b=(_a=textWidget.jsonParams)===null||_a===void 0?void 0:_a.text_params)===null||_b===void 0?void 0:_b.caption_duration_info){if(textWidget.hasAnimationWithType(AnimationType.loop)||textWidget.captionAnimationController!=null&&textWidget.captionAnimationController.captionInfo.onlyForKeyword){const captionDurationInfoStr=AmazUtils$1.TextWordMatchUtils.generateCaptionDurationInfo(this.curWordInfo);const captionDurationInfo=JSON.parse(captionDurationInfoStr);textWidget.jsonParams.text_params.caption_duration_info=captionDurationInfo;textWidget.setCaptionDurationInfo(captionDurationInfo)}}}}var Amaz$3=effect.Amaz;var Rect=Amaz$3.Rect;var Vec3=Amaz$3.Vector3f;var Vec2=Amaz$3.Vector2f;var ObjectModelType;(function(ObjectModelType){ObjectModelType[ObjectModelType["OBJECT_MODEL_RTTI"]=0]="OBJECT_MODEL_RTTI";ObjectModelType[ObjectModelType["OBJECT_MODEL_STATIC"]=1]="OBJECT_MODEL_STATIC"})(ObjectModelType||(ObjectModelType={}));class RichText extends Widget2D{constructor(name,widgetType,scene){super(name,widgetType,scene);this.m_jsonParams=null;this.m_textComp=null;this.m_needUpdateTextCom=true;this.m_lineMaxWidth=-1;this.m_textInfoLayerWidth=-1;this.m_ktvColor=new Amaz$3.Vector4f;this.m_ktvOutlineColor=new Amaz$3.Vector4f;this.m_ktvShadowColor=new Amaz$3.Vector4f;this.m_captionDurationInfo=null;this.m_captionDurationInfoDirty=false;this.m_captionParamsCache=null;this.m_captionParamsDirty=false;this.m_captionAnimationController=null;this.m_textAnimationController=null;this.m_keyframeParams=null;this.m_cachePixelSize=new Vec2;this.m_textAssociationController=null}createRichText(jsonParams,scene){this._createTextEntity(scene);this.parameters=jsonParams}get textComp(){return this.m_textComp}set textComp(text){this.m_textComp=text}get cachePixelSize(){return this.m_cachePixelSize}set captionDurationInfoDirty(dirty){this.m_captionDurationInfoDirty=dirty}set captionParamsDirty(dirty){this.m_captionParamsDirty=dirty}get textAssociationController(){return this.m_textAssociationController}set captionAnimationController(captionAnimationController){this.m_captionAnimationController=captionAnimationController}getOrCreateAnimationController(){if(this.m_captionAnimationController==null&&this.m_textComp!=null){this.m_captionAnimationController=new CaptionAnimationController(this.m_textComp)}return this.m_captionAnimationController}get jsonParams(){return this.m_jsonParams}setParamsToAnims(){var _a,_b,_c,_d,_e,_f,_g,_h,_j;(_a=this.m_captionAnimationController)===null||_a===void 0?void 0:_a.updateCaptionInfo();const properties=new Map;const captionParams=(_c=(_b=this.m_captionAnimationController)===null||_b===void 0?void 0:_b.captionInfo)===null||_c===void 0?void 0:_c.caption_params;if((this.m_animationsDirty||this.m_captionParamsDirty)&&this.m_captionAnimationController&&captionParams){if(captionParams.keyword_rich_text!=null&&captionParams.enable_keyword){const keyword_rich_text_str=this.m_captionAnimationController.captionInfo.getKeywordRichTextWithSize();properties.set("keyword_rich_text",keyword_rich_text_str)}properties.set("caption_params",JSON.stringify(captionParams));properties.set("text_capital",this.m_captionAnimationController.captionInfo.capitalStr)}if(this.m_animationsDirty||this.m_captionDurationInfoDirty||this.m_captionParamsDirty){if((_e=(_d=this.m_captionAnimationController)===null||_d===void 0?void 0:_d.captionInfo)===null||_e===void 0?void 0:_e.caption_duration_info_capital){properties.set("caption_duration_info",JSON.stringify((_g=(_f=this.m_captionAnimationController)===null||_f===void 0?void 0:_f.captionInfo)===null||_g===void 0?void 0:_g.caption_duration_info_capital))}}if(this.m_animations==null||this.m_animations.size==0){if(this.m_captionAnimationController!=null){this.m_captionAnimationController.needMerge=false}return}if(this.m_captionAnimationController!=null){if((this.m_animationsDirty||this.m_captionAnimationController.checkIsDirty())&&this.m_keyframeParams&&"value_generators"in this.m_keyframeParams){this.m_captionAnimationController.updateSelectors(0);this.m_captionAnimationController.updateValueGenerators(this.m_keyframeParams.value_generators);const keywordValueGeneration=(_h=this.getOrCreateAnimationController())===null||_h===void 0?void 0:_h.keywordAnimations;if(keywordValueGeneration&&captionParams&&"keyword_rich_text"in captionParams&&captionParams.keyword_rich_text!=""){const keywordStyles=[];for(let i=0;i<keywordValueGeneration.length;i++){const vg=keywordValueGeneration[i];if(vg.generatoType!="expression"){continue}if(vg.targetAttribute=="tc"){const expression=vg.generator;expression.parse();const expressionRes=expression.update();for(let index=0;index<expressionRes.length;index++){const value=expressionRes[index];const content=JSON.parse(captionParams.keyword_rich_text);content.styles[0].fill.content.solid.color=[value[0],value[1],value[2],value[3]];keywordStyles.push(content)}}else if(vg.targetAttribute=="object"){const expression=vg.generator;expression.parse();const expressionRes=expression.update();for(let index=0;index<expressionRes.length;index++){const value=expressionRes[index];const content=JSON.parse(captionParams.keyword_rich_text);if(this.m_textComp){const letters=this.m_textComp.letters.clone();const callbackParams={values:[{name:vg.targetAttribute,value:value,start:0,end:1,overlayMode:vg.overlayMode,selectorUnit:"word"}]};const jsonStr=JSON.stringify(callbackParams);AmazUtils$1.swingTemplateUtils.captionSetParamsBatch(this.m_textComp,jsonStr);const richTextStr=this.m_textComp.getRichStr(2,0,1,1,true);const newStyle=JSON.parse(richTextStr);if(content.styles[0]&&content.styles[0].fill&&content.styles[0].fill.content){content.styles[0].fill.content=newStyle.styles[0].fill.content}keywordStyles.push(content);this.m_textComp.letters=letters}}}}if(keywordStyles.length>0){properties.set("keyword_rich_text",JSON.stringify(keywordStyles))}}}}if(properties.size<1){return}(_j=this.m_animations)===null||_j===void 0?void 0:_j.forEach((anim=>{if(anim!==undefined&&anim.animationType==AnimationType.loop){anim.setAnimationProperty(properties);this.m_captionParamsDirty=false;this.m_captionDurationInfoDirty=false;this.m_animationsDirty=false;if(this.m_captionAnimationController!=null){this.m_captionAnimationController.needMerge=anim.m_needMerge}anim.onClear()}}))}set parameters(jsonParams){var _a,_b,_c,_d,_e,_f,_g;if(this.m_textAnimationController==null){this.m_textAnimationController=new TextAnimationController(this,this.textComp)}if(this.m_jsonParams!=jsonParams&&jsonParams){this.m_jsonParams=jsonParams;this.m_needUpdateTextCom=true;super.setParameters(this.m_jsonParams);this.updateRootEntityParam();this.updateAssociationParam(this.m_jsonParams);this.updateText();(_a=this.m_textAssociationController)===null||_a===void 0?void 0:_a.updateByAssociation();const caption_duration_info=(_b=jsonParams===null||jsonParams===void 0?void 0:jsonParams.text_params)===null||_b===void 0?void 0:_b.caption_duration_info;this.setCaptionDurationInfo(caption_duration_info);const capital=(_c=jsonParams===null||jsonParams===void 0?void 0:jsonParams.text_params)===null||_c===void 0?void 0:_c.capital;if(capital!=null){(_d=this.getOrCreateAnimationController())===null||_d===void 0?void 0:_d.setTextCapital(capital)}const keyframe_params=jsonParams===null||jsonParams===void 0?void 0:jsonParams.keyframe_params;let keyframeContent;if(keyframe_params!=null){if("resource_path"in keyframe_params){const contentJson=AmazFileUtils.readFileContent(keyframe_params.resource_path);if(contentJson!=undefined){keyframeContent=JSON.parse(contentJson)}}else{keyframeContent=keyframe_params}if(keyframeContent!=null&&this.m_keyframeParams!=keyframeContent){this.m_keyframeParams=keyframeContent;(_e=this.m_textAnimationController)===null||_e===void 0?void 0:_e.setKeyFrameParams(keyframeContent);(_f=this.getOrCreateAnimationController())===null||_f===void 0?void 0:_f.setKeyFrameParams(keyframeContent)}}const caption_params=jsonParams===null||jsonParams===void 0?void 0:jsonParams.caption_params;if(caption_params!=null&&this.m_captionParamsCache!=caption_params){this.m_captionParamsCache=caption_params;this.m_captionParamsDirty=true;(_g=this.getOrCreateAnimationController())===null||_g===void 0?void 0:_g.setCaptionParams(caption_params)}this.setParamsToAnims()}}query(queries){if(this.m_captionAnimationController){return this.m_captionAnimationController.query(queries)}else{return{}}}get parameters(){var _a,_b;if(this.textComp){const textCanvasColor=this.textComp.canvas.canvasColor;const canvasType=(_a=this.textComp.canvas)===null||_a===void 0?void 0:_a.canvasType;let tmpShapeType="";if(canvasType===effect.Amaz.CanvasStyle.BOUNDING_BOX){tmpShapeType="bounding"}else if(canvasType===effect.Amaz.CanvasStyle.WRAP_MERGED){tmpShapeType="wrapMerged"}else if(canvasType===effect.Amaz.CanvasStyle.WRAP_SEPARATE){tmpShapeType="wrapSeparate"}else if(canvasType===effect.Amaz.CanvasStyle.WRAP_INDEPENDENT){tmpShapeType="wrapIndependent"}const tmpFillInfo=JSON.parse((_b=this.textComp.globalBackground)===null||_b===void 0?void 0:_b.getFillInfoStr());const tmpCanvasAdvancedInfo={shapeType:tmpShapeType,fill:tmpFillInfo};const textSelectColor=this.textComp.selectColor;const textBloomColor=this.textComp.bloomColor;const textParam={version:"2",richText:this.textComp.getRichStr(0,0,0,0,false),typeSettingKind:this.textComp.typeSettingParam.typeSettingKind,typeSettingAlign:this.textComp.typeSettingParam.typeSettingAlign,typeSettingPathEnable:this.textComp.typeSettingParam.enablePathTypeSetting,enableMergeLines:this.textComp.typeSettingParam.mergingIntoOneLine,canvas:this.textComp.canvas.canvasEnabled,canvasColor:[textCanvasColor.x,textCanvasColor.y,textCanvasColor.z,textCanvasColor.w],canvasRoundCorner:this.textComp.canvas.canvasRoundCornerEnabled,canvasRoundRadius:this.textComp.canvas.canvasRoundRadius,canvasRoundRadiusScale:this.textComp.canvas.canvasRoundRadiusScale,canvasWrapped:this.textComp.canvas.canvasWrappText,canvasCustomized:this.textComp.canvas.canvasCustomizedEnabled,canvasWHCustomized:[this.textComp.canvas.canvasWHCustomized.x,this.textComp.canvas.canvasWHCustomized.y],canvasOffsetCustomized:[this.textComp.canvas.canvasOffsetCustomized.x,this.textComp.canvas.canvasOffsetCustomized.y],canvasAdvancedInfo:tmpCanvasAdvancedInfo,boldValue:this.textComp.activeTextStyle.boldValue,italicDegree:this.textComp.activeTextStyle.italicAngle,decorationWidth:this.textComp.activeTextStyle.decorationWidth,decorationOffset:this.textComp.activeTextStyle.decorationOffset,lineSpacing:this.textComp.typeSettingParam.lineSpacing,letterSpacing:this.textComp.typeSettingParam.letterSpacing,innerPadding:this.textComp.typeSettingParam.verticalPadding,lineMaxWidth:this.m_lineMaxWidth,canvasWHFixed:[this.textComp.typeSettingParam.canvasWHFixed.x,this.textComp.typeSettingParam.canvasWHFixed.y],fallbackFontPathList:[],oneLineCutOff:this.textComp.typeSettingParam.lineBreakType===Amaz$3.LineBreakType.CUT_OFF,cutOffPostfix:this.textComp.cutOffPostfix,shapePath:" ",shapeFlipX:false,shapeFlipY:false,ktvColor:[this.m_ktvColor.x,this.m_ktvColor.y,this.m_ktvColor.z,this.m_ktvColor.w],ktvOutlineColor:[this.m_ktvOutlineColor.x,this.m_ktvOutlineColor.y,this.m_ktvOutlineColor.z,this.m_ktvOutlineColor.w],ktvShadowColor:[this.m_ktvShadowColor.x,this.m_ktvShadowColor.y,this.m_ktvShadowColor.z,this.m_ktvShadowColor.w],autoAdaptDpiEnabled:this.textComp.typeSettingParam.autoAdaptDpiEnabled,globalAlpha:this.textComp.globalAlpha,selectedColor:[textSelectColor.x,textSelectColor.y,textSelectColor.z,textSelectColor.w],rootPath:this.textComp.rootPath,bloomPath:this.textComp.bloomPath,bloomColorCustomized:this.textComp.bloomColorCustomized,bloomColor:[textBloomColor.x,textBloomColor.y,textBloomColor.z,textBloomColor.w],bloomStrength:this.textComp.bloomStrength,bloomRange:this.textComp.bloomRange,bloomDirX:this.textComp.bloomDirX,bloomDirY:this.textComp.bloomDirY,bloomBlurDegree:this.textComp.bloomBlurDegree,sdfTextAlpha:this.textComp.sdfTextAlpha,textLocale:this.textComp.textLocale,directionLevel:this.textComp.textDirectionLevel};const typeSettingPathParam=this.textComp.typeSettingParam.pathTypeSettingParam;if(typeSettingPathParam!=null){const pathInfoData={curvesInfo:[]};for(let curveId=0;curveId<typeSettingPathParam.curvesInfoAry.size();++curveId){const curveInfomParam=typeSettingPathParam.curvesInfoAry.get(curveId);const curveInfoData={curveType:curveInfomParam.curveType,curveAngle:curveInfomParam.curveAngle,offsetOnCurve:curveInfomParam.curveOffset,points:[]};const pointsNum=curveInfomParam.curvePoints.size();for(let pointId=0;pointId<pointsNum;++pointId){const pointParam=curveInfomParam.curvePoints.get(pointId);curveInfoData.points.push(pointParam.x);curveInfoData.points.push(pointParam.y)}pathInfoData.curvesInfo.push(curveInfoData)}textParam.typeSettingPathParam=pathInfoData}const fallbackFontPaths=this.textComp.fallbackFontPaths;for(let i=0;i<fallbackFontPaths.size();i++){const fontPath=fallbackFontPaths.get(i);textParam.fallbackFontPathList.push(fontPath)}if(this.m_captionDurationInfo!=null){textParam.caption_duration_info=this.m_captionDurationInfo}const widgetParam=super.parameters;const widget2DParam=super.getParameters();const richTextParamData={name:widgetParam.name,type:widgetParam.type,position:widgetParam.position,rotation:widgetParam.rotation,scale:widgetParam.scale,order_in_layer:widgetParam.order_in_layer,start_time:widgetParam.start_time,duration:widgetParam.duration,layout_params:widget2DParam.layout_params,original_size:widget2DParam.original_size,text_params:textParam,anims:widget2DParam.anims,action_type:widgetParam.action_type};if(this.m_keyframeParams!=null){richTextParamData.keyframe_params=this.m_keyframeParams}if(this.textAssociationController&&this.textAssociationController.associationParams){richTextParamData.association_params=this.textAssociationController.associationParams}return richTextParamData}else{return"{}"}}set needUpdateTextCom(needed){this.m_needUpdateTextCom=needed}get needUpdateTextCom(){return this.m_needUpdateTextCom}setCaptionDurationInfo(captionDurationInfo){var _a;if(captionDurationInfo!=null&&this.m_captionDurationInfo!=captionDurationInfo){this.m_captionDurationInfo=captionDurationInfo;this.m_captionDurationInfoDirty=true;(_a=this.getOrCreateAnimationController())===null||_a===void 0?void 0:_a.setCaptionDurationInfo(captionDurationInfo)}}_setRichStr(richStr){var _a;if(this.textComp!=null){this.textComp.richStr=richStr;this.textComp.updateLetters()}(_a=this.m_captionAnimationController)===null||_a===void 0?void 0:_a.onTextChangeForScript()}_convertPosBetweenRect(srcPos,srcRect,dstRect){const srcRectCenter=new Vec2(srcRect.x+.5*srcRect.width,srcRect.y+.5*srcRect.height);const dstRectCenter=new Vec2(dstRect.x+.5*dstRect.width,dstRect.y+.5*dstRect.height);const real_pos=new Vec2(srcRectCenter.x+srcPos.x*srcRect.width*.5,srcRectCenter.y+srcPos.y*srcRect.height*.5);if(dstRect.width!==0&&dstRect.height!==0){const dstPos=new Vec2((real_pos.x-dstRectCenter.x)/(dstRect.width*.5),(real_pos.y-dstRectCenter.y)/(dstRect.height*.5));return dstPos}else{console.error(TEMPLATE_TAG,"_convertPosBetweenRect dstRect error.");const dstPos=new Vec2(srcPos.x,srcPos.y);return dstPos}}_getTextUIRect(){let textRect=new Rect(0,0,0,0);if(this.textComp){textRect=this.textComp.canvas.UIRect}return textRect}_updateCachePixelSize(){if(this.textComp&&this.hasAnimation()){this.textComp.forceTypeSetting();let rect=this._getTextUIRect();if(!(rect.width>0&&rect.height>0)){rect=this.textComp.getCanvasCustomizedExpanded()}this.m_cachePixelSize.x=rect.width;this.m_cachePixelSize.y=rect.height}}_isCommandStrChanged(cmdType){return cmdType==TextCommandType.CT_INPUT_STR||cmdType==TextCommandType.CT_INPUT_RICH_STR||cmdType==TextCommandType.CT_BACK_DELETE||cmdType==TextCommandType.CT_FORWARD_DELETE||cmdType==TextCommandType.CT_PREEDIT_COMPOSE||cmdType==TextCommandType.CT_END_COMPOSE||cmdType==TextCommandType.CT_EDIT_TEMPLATE_TEXT_STYLE||cmdType==TextCommandType.CT_EDIT_RESET_TEXT_CONTEXT||cmdType==TextCommandType.CT_EDIT_CONVERT_CASE||cmdType==TextCommandType.CT_COMMAND_BATCH_PROCESS}_isCommandCursorOrSelectionChanged(cmdType){return cmdType>=TextCommandType.CT_ENTER_EDIT_STATE||cmdType>=TextCommandType.CT_MOVE_CURSOR_LR&&cmdType<=TextCommandType.CT_SELECT_ALL_CONTENT}_isCommandStyleChanged(cmdType){return cmdType==TextCommandType.CT_FORCE_REFRESH||cmdType>=TextCommandType.CT_EDIT_FONT&&cmdType<=TextCommandType.CT_EDIT_BACKGROUND_STYLE||cmdType==TextCommandType.CT_COMMAND_BATCH_PROCESS}_updateBeforeTextCommand(cmd){if(!cmd){console.error(TEMPLATE_TAG,"_updateBeforeTextCommand: update command with a nullptr!");return}if(this.textComp==null){return}if(cmd.type==TextCommandType.CT_EDIT_TEXT_PARAM||cmd.type==TextCommandType.CT_EDIT_TEXT_PRESET_STYLE_PARAM){const config=JSON.parse(cmd.sParam1);if(!config){console.error(TEMPLATE_TAG,"_updateBeforeTextCommand: CT_EDIT_TEXT_PARAM/PRESET_STYLE_PARAM cmd read json failed!");return}if(cmd.type==TextCommandType.CT_EDIT_TEXT_PRESET_STYLE_PARAM){console.debug(TEMPLATE_TAG,"_updateBeforeTextCommand: CT_EDIT_TEXT_PRESET_STYLE_PARAM, param:",cmd.sParam1);cmd.sParam1="";if("richText"in config){cmd.sParam1=config.richText;delete config.richText}}if(cmd.type==TextCommandType.CT_EDIT_TEXT_PARAM){if("richText"in config&&cmd.iParam1<.5){this.textComp.resetEditContextState()}}this._updateTextParams(config)}else if(cmd.type==TextCommandType.CT_MOVE_CURSOR_BY_POS||cmd.type==TextCommandType.CT_SELECT_MOUSE_CONTENT){if(null==this.m_textComp)return;const x=-.5*this.m_widgetOriginalPixelSize.x;const y=-.5*this.m_widgetOriginalPixelSize.y;const text_rect=new Amaz$3.Rect(x,y,this.m_widgetOriginalPixelSize.x,this.m_widgetOriginalPixelSize.y);const canvas_rect=this.m_textComp.getCanvasCustomizedExpanded();const srcPos=new Vec2(cmd.iParam1,cmd.iParam2);const dstPos=this._convertPosBetweenRect(srcPos,text_rect,canvas_rect);cmd.iParam1=dstPos.x;cmd.iParam2=dstPos.y}}_updateAfterTextCommand(cmd){if(!cmd){console.error(TEMPLATE_TAG,"_updateAfterTextCommand: update command with a nullptr!");return}}_forceFlushCommandQueue(cmdList){if(null==this.m_textComp){console.error(TEMPLATE_TAG,"_forceFlushCommandQueue: textComp in nullptr!");return}if(this.m_textComp.isLetterDirty()){this.m_textComp.updateLetters()}for(let cmdId=0;cmdId<cmdList.length;cmdId++){const cmd=cmdList[cmdId];this._updateBeforeTextCommand(cmd);if(!this.m_textComp){console.error(TEMPLATE_TAG,"_forceFlushCommandQueue: editing textComp in nullptr!");break}this.m_textComp.executeOneEditCommand(cmd);this._updateAfterTextCommand(cmd)}}setRichTextByOPCode(textOP){if(null==this.m_textComp){console.error(TEMPLATE_TAG,"setRichTextByOPCode: text component is null!");return}const commandStr=textOP.m_sParam;const cmdList=[];if(textOP.m_iOpCode===TextCommandType.CT_COMMAND_BATCH_PROCESS){const config=JSON.parse(commandStr);if(!("commands"in config)){console.error(TEMPLATE_TAG,"setRichTextByOPCode: CT_COMMAND_BATCH_PROCESS cmd read nothing!");return}const cmdVec=config.commands;if(cmdVec instanceof Array&&cmdVec.length>0){for(let cmdId=0;cmdId<cmdVec.length;++cmdId){const cmdInfo=cmdVec[cmdId];if(!("cmdCode"in cmdInfo)){continue}const cmd=new Amaz$3.TextCommand;cmd.type=cmdInfo.cmdCode;if("iParams"in cmdInfo){const iParams=cmdInfo.iParams;if(iParams instanceof Array&&iParams.length>=4){cmd.iParam1=iParams[0];cmd.iParam2=iParams[1];cmd.iParam3=iParams[2];cmd.iParam4=iParams[3]}}if("sParams"in cmdInfo){cmd.sParam1=cmdInfo.sParams}cmdList.push(cmd)}}console.debug(TEMPLATE_TAG,"setRichTextByOPCode: CT_COMMAND_BATCH_PROCESS cmd executing: ",commandStr)}else{const cmd=new Amaz$3.TextCommand;cmd.type=textOP.m_iOpCode;cmd.iParam1=textOP.m_fParam1;cmd.iParam2=textOP.m_fParam2;cmd.iParam3=textOP.m_fParam3;cmd.iParam4=textOP.m_fParam4;cmd.sParam1=commandStr;cmdList.push(cmd)}let isStrChanged=false;let isStyleChanged=false;for(let cmdId=0;cmdId<cmdList.length;++cmdId){const cmd=cmdList[cmdId];isStrChanged=isStrChanged||this._isCommandStrChanged(cmd.type);isStrChanged=isStrChanged||this.hasAnimation()&&this._isCommandCursorOrSelectionChanged(cmd.type);isStyleChanged=isStyleChanged||this._isCommandStyleChanged(cmd.type)}if(isStrChanged||isStyleChanged){this.reloadAllAnimation()}this._forceFlushCommandQueue(cmdList);const needUpdateRect=isStrChanged||isStyleChanged;if(needUpdateRect){this.updateTextRect()}if(this.m_captionAnimationController){this.m_captionAnimationController.onTextChangeForScript()}}getRichTextByOPCode(textOP){const resultTextOp={m_iOpCode:TextCommandType.CT_NONE,m_fParam1:0,m_fParam2:0,m_fParam3:0,m_fParam4:0,m_sParam:""};if(null==this.m_textComp){console.error(TEMPLATE_TAG,"getRichTextByOPCode: text component is null!");return resultTextOp}if(textOP.m_iOpCode===TextCommandType.CT_GET_PLAIN_STR||textOP.m_iOpCode===TextCommandType.CT_GET_RICH_STR){let resultStr="";const range=this.m_textComp.convertIdUincodesToLetter(textOP.m_fParam2,textOP.m_fParam3);if(textOP.m_iOpCode===TextCommandType.CT_GET_PLAIN_STR){resultStr=this.m_textComp.getPlainStr(textOP.m_fParam1,range.x,range.y);resultTextOp.m_iOpCode=TextCommandType.CT_GET_PLAIN_STR}else{resultStr=this.m_textComp.getRichStr(textOP.m_fParam1,range.x,range.y,textOP.m_fParam4,false);resultTextOp.m_iOpCode=TextCommandType.CT_GET_RICH_STR}resultTextOp.m_sParam=resultStr}else if(textOP.m_iOpCode===TextCommandType.CT_GET_CURSOR_RECT){const cursor_rect=this.m_textComp.getCursorRect();const canvas_rect=this.m_textComp.canvas.canvasRect;const x=cursor_rect.x+(canvas_rect.x+.5*canvas_rect.width);const y=cursor_rect.y+(canvas_rect.y+.5*canvas_rect.height);cursor_rect.x=x;cursor_rect.y=y;const sticker_rect=new Rect(-.5*this.m_widgetOriginalPixelSize.x,-.5*this.m_widgetOriginalPixelSize.y,this.m_widgetOriginalPixelSize.x,this.m_widgetOriginalPixelSize.y);const sticker_center=new Amaz$3.Vector2f(0,0);resultTextOp.m_iOpCode=TextCommandType.CT_GET_CURSOR_RECT;resultTextOp.m_fParam1=sticker_rect.width===0?0:(cursor_rect.x-sticker_center.x)/(sticker_rect.width*.5);resultTextOp.m_fParam2=sticker_rect.height===0?0:(cursor_rect.y-sticker_center.y)/(sticker_rect.height*.5);resultTextOp.m_fParam3=sticker_rect.width===0?0:cursor_rect.width/sticker_rect.width;resultTextOp.m_fParam4=sticker_rect.height===0?0:cursor_rect.height/sticker_rect.height}else if(textOP.m_iOpCode===TextCommandType.CT_GET_CHAR_RECT){const letter_id=this.m_textComp.convertIdUToL(textOP.m_fParam1);const char_rect=this.m_textComp.getTextRect(letter_id,letter_id);const canvas_rect=this.m_textComp.getCanvasCustomizedExpanded();const canvas_center=new Amaz$3.Vector2f(canvas_rect.x+canvas_rect.width*.5,canvas_rect.y+canvas_rect.height*.5);resultTextOp.m_iOpCode=TextCommandType.CT_GET_CHAR_RECT;resultTextOp.m_fParam1=canvas_rect.width===0?0:(char_rect.x-canvas_center.x)/(canvas_rect.width*.5);resultTextOp.m_fParam2=canvas_rect.height===0?0:(char_rect.y-canvas_center.y)/(canvas_rect.height*.5);resultTextOp.m_fParam3=canvas_rect.width===0?0:char_rect.width/canvas_rect.width;resultTextOp.m_fParam4=canvas_rect.height===0?0:char_rect.height/canvas_rect.height}else if(textOP.m_iOpCode===TextCommandType.CT_GET_CURSOR_CHAR_INDEX){resultTextOp.m_iOpCode=TextCommandType.CT_GET_CURSOR_CHAR_INDEX;const letter_id=this.m_textComp.getLetterIndexByCursor(textOP.m_fParam1);let utf16_id=this.m_textComp.convertIdLToU(letter_id);const cursor_id=this.m_textComp.getTextEditCursorIndex();if(letter_id===0&&cursor_id==letter_id&&textOP.m_fParam1===-1){utf16_id-=1}else if(letter_id===this.m_textComp.letters.size()-1&&cursor_id===letter_id+1&&textOP.m_fParam1===1){utf16_id+=1;const last_letter=this.m_textComp.letters.back();if(last_letter instanceof Amaz$3.Letter){utf16_id+=last_letter.getUTF16Size()}}resultTextOp.m_fParam1=utf16_id}else if(textOP.m_iOpCode===TextCommandType.CT_GET_SELECT_RANGE){resultTextOp.m_iOpCode=TextCommandType.CT_GET_SELECT_RANGE;const ret=this.m_textComp.getSelectRange();resultTextOp.m_fParam1=ret.x;resultTextOp.m_fParam2=this.m_textComp.convertIdLToU(ret.y);resultTextOp.m_fParam3=this.m_textComp.convertIdLToU(ret.z)}else if(textOP.m_iOpCode===TextCommandType.CT_GET_ERROR_INFO){resultTextOp.m_iOpCode=TextCommandType.CT_GET_ERROR_INFO;resultTextOp.m_fParam1=this.m_textComp.getEditErrorCode();resultTextOp.m_sParam=this.m_textComp.getEditErrorLog()}else if(textOP.m_iOpCode===TextCommandType.CT_GET_EDIT_CONTEXT_INFO){resultTextOp.m_iOpCode=TextCommandType.CT_GET_EDIT_CONTEXT_INFO;resultTextOp.m_fParam1=this.m_textComp.getTextEditEnable()?1:0;resultTextOp.m_fParam2=this.m_textComp.convertIdLToU(this.m_textComp.getTextEditCursorIndex());resultTextOp.m_fParam3=this.m_textComp.getTextEditHasSelected()?1:0;resultTextOp.m_fParam4=this.m_textComp.getTextEditIsInputMethord()?1:0;const range=this.m_textComp.getSelectRange();range.y=this.m_textComp.convertIdLToU(range.y);range.z=this.m_textComp.convertIdLToU(range.z);const cursor_rect=this.m_textComp.getCursorRect().copy();const canvas_rect=this.m_textComp.canvas.canvasRect;cursor_rect.x=cursor_rect.x+canvas_rect.x+.5*canvas_rect.width;cursor_rect.y=cursor_rect.y+canvas_rect.y+.5*canvas_rect.height;const sticker_rect=new Rect(-.5*this.m_widgetOriginalPixelSize.x,-.5*this.m_widgetOriginalPixelSize.y,this.m_widgetOriginalPixelSize.x,this.m_widgetOriginalPixelSize.x);const sticker_center=new Amaz$3.Vector2f(0,0);const x=sticker_rect.width===0?0:(cursor_rect.x-sticker_center.x)/(sticker_rect.width*.5);const y=sticker_rect.height===0?0:(cursor_rect.y-sticker_center.y)/(sticker_rect.height*.5);const width=sticker_rect.width===0?0:cursor_rect.width/sticker_rect.width;const height=sticker_rect.height===0?0:cursor_rect.height/sticker_rect.height;const richTextStr=this.m_textComp.getRichStr(0,0,0,0,false);const errorInfoStr=this.m_textComp.getEditErrorLog();const jsonObj={selectRange:[range.x,range.y,range.z],cursorRect:[x,y,width,height],richText:richTextStr,errorInfo:errorInfoStr};const retStr=JSON.stringify(jsonObj);resultTextOp.m_sParam=retStr}else if(textOP.m_iOpCode===TextCommandType.CT_GET_SELECT_HANDLE_RECT){resultTextOp.m_iOpCode=TextCommandType.CT_GET_SELECT_HANDLE_RECT;if(this.m_textComp.getSelectHandleVisible()){const indexRet=this.m_textComp.getSelectHandleIndex();const rectRet=this.m_textComp.getSelectHandleRect();const sticker_rect=new Rect(-.5*this.m_widgetOriginalPixelSize.x,-.5*this.m_widgetOriginalPixelSize.y,this.m_widgetOriginalPixelSize.x,this.m_widgetOriginalPixelSize.y);const sticker_center=new Amaz$3.Vector2f(0,0);const canvas_rect=this.m_textComp.canvas.canvasRect;const rect_1=rectRet.get(0);const rect_2=rectRet.get(1);let x_1=0,y_1=0,width_1=0,height_1=0;let x_2=0,y_2=0,width_2=0,height_2=0;if(rect_1 instanceof Rect){rect_1.x=rect_1.x+canvas_rect.x+.5*canvas_rect.width;rect_1.y=rect_1.y+canvas_rect.y+.5*canvas_rect.height;x_1=sticker_rect.width===0?0:(rect_1.x-sticker_center.x)/(sticker_rect.width*.5);y_1=sticker_rect.height===0?0:(rect_1.y-sticker_center.y)/(sticker_rect.height*.5);width_1=sticker_rect.width===0?0:rect_1.width/sticker_rect.width;height_1=sticker_rect.height===0?0:rect_1.height/sticker_rect.height}if(rect_2 instanceof Rect){rect_2.x=rect_2.x+canvas_rect.x+.5*canvas_rect.width;rect_2.y=rect_2.y+canvas_rect.y+.5*canvas_rect.height;x_2=sticker_rect.width===0?0:(rect_2.x-sticker_center.x)/(sticker_rect.width*.5);y_2=sticker_rect.height===0?0:(rect_2.y-sticker_center.y)/(sticker_rect.height*.5);width_2=sticker_rect.width===0?0:rect_2.width/sticker_rect.width;height_2=sticker_rect.height===0?0:rect_2.height/sticker_rect.height}resultTextOp.m_fParam1=this.m_textComp.convertIdLToU(indexRet.x);resultTextOp.m_fParam2=this.m_textComp.convertIdLToU(indexRet.y);const jsonObj={selectHandleRect_0:[x_1,y_1,width_1,height_1],selectHandleRect_1:[x_2,y_2,width_2,height_2]};const retStr=JSON.stringify(jsonObj);resultTextOp.m_sParam=retStr}}return resultTextOp}_createTextEntity(scene){const renderEntityName=this.m_name+"renderEntity";this.m_renderEntity=AmazUtils$1.createEntity(renderEntityName,scene);this.m_renderEntity.layer=this.m_cameraLayer;const localPos=new Vec3(0,0,0);const scale=new Vec3(1,1,1);const rotate=new Vec3(0,0,0);this.m_renderEntity.transform={position:localPos,scale:scale,rotation:rotate};this.m_renderEntity.addComponent("Text");this.m_renderEntity.addComponent("MeshRenderer");this.m_textComp=this.m_renderEntity.getComponent("Text");this.createWidgetRootEntity(scene);if(null!=this.m_rootEntity){AmazUtils$1.addChildEntity(this.m_rootEntity,this.m_renderEntity)}}_updateTextLineMaxWidth(screenSize,extraScale){if(this.m_textComp){if(this.m_lineMaxWidth>0){this.m_textComp.typeSettingParam.wordWrapWidth=extraScale.x===0?0:screenSize.x*this.m_lineMaxWidth/extraScale.x}else{this.m_textComp.typeSettingParam.wordWrapWidth=1e7}}}_setTextLineMaxWidth(lineMaxWidth){const DEGSIN_SIZE=new Amaz$3.Vector2f(720,1280);this.m_lineMaxWidth=lineMaxWidth;let extraScale=new Amaz$3.Vector2f(1,1);if(this.widgetResolutionType===WidgetResolutionType.NORMALIZED){const normalizedScale=this.getTextureNormalizedScale();this._updateTextLineMaxWidth(this.screenSize,normalizedScale)}else if(this.widgetResolutionType===WidgetResolutionType.ORIGINAL){if(this.m_textInfoLayerWidth>0){const screenSize=new Amaz$3.Vector2f(this.m_textInfoLayerWidth,this.m_textInfoLayerWidth);this._updateTextLineMaxWidth(screenSize,extraScale)}else{this._updateTextLineMaxWidth(this.screenSize,extraScale)}}else if(this.widgetResolutionType===WidgetResolutionType.DESIGN_HEIGHT){const scale=this.screenSize.y/DEGSIN_SIZE.y;extraScale=new Amaz$3.Vector2f(scale,scale);this._updateTextLineMaxWidth(this.screenSize,extraScale)}else{const scale=this.screenSize.x/DEGSIN_SIZE.x;extraScale=new Amaz$3.Vector2f(scale,scale);this._updateTextLineMaxWidth(this.screenSize,extraScale)}}_updateRichTextShapeParams(richTextConfig){}_updatePathTypeSettingParam(configJson){const pathInfoRet=new Amaz$3.PathInfo;if("curvesInfo"in configJson){const curvesArray=configJson.curvesInfo;if(curvesArray instanceof Array){for(let curveId=0;curveId<curvesArray.length;curveId++){const curve=curvesArray[curveId];const curveInfoRet=new Amaz$3.CurveInfo;if("curveType"in curve){curveInfoRet.curveType=curve.curveType}if("curveAngle"in curve){curveInfoRet.curveAngle=curve.curveAngle}if("offsetOnCurve"in curve){curveInfoRet.curveOffset=curve.offsetOnCurve}if("points"in curve){const pointsArray=curve.points;if(pointsArray instanceof Array){const pointsNum=pointsArray.length/2;for(let pointId=0;pointId<pointsNum;pointId++){const pointInfoRet=new Amaz$3.Vector2f(pointsArray[2*pointId],pointsArray[2*pointId+1]);curveInfoRet.curvePoints.pushBack(pointInfoRet)}}}pathInfoRet.curvesInfoAry.pushBack(curveInfoRet)}}}return pathInfoRet}_updateTextJsonParams(configJson){const textComp=this.m_textComp;if(!configJson||null==textComp){return}{if("richText"in configJson){const configRichText=configJson.richText;this._setRichStr(configRichText)}}{if("rootPath"in configJson){const configRootPath=configJson.rootPath;textComp.rootPath=configRootPath}}{if("globalAlpha"in configJson){const configGlobalAlpha=configJson.globalAlpha;textComp.globalAlpha=configGlobalAlpha}if("sdfTextAlpha"in configJson){const configSDFTextAlpha=configJson.sdfTextAlpha;textComp.sdfTextAlpha=configSDFTextAlpha}}{if("selectedColor"in configJson){const configSelectedColor=AmazUtils$1.CastJsonArray4fToAmazVector4f(configJson.selectedColor);if(null!==configSelectedColor){textComp.selectColor=configSelectedColor}else{console.error(TEMPLATE_TAG,"_updateTextParams config json selectedColor is not vector4f!")}}}{if("typeSettingKind"in configJson){const configTypeSettingKind=configJson.typeSettingKind;textComp.typeSettingParam.typeSettingKind=configTypeSettingKind}if("typeSettingAlign"in configJson){const configTypeSettingAlign=configJson.typeSettingAlign;textComp.typeSettingParam.typeSettingAlign=configTypeSettingAlign}if("lineSpacing"in configJson){const configLineSpacing=configJson.lineSpacing;textComp.typeSettingParam.lineSpacing=configLineSpacing}if("letterSpacing"in configJson){const configLetterSpacing=configJson.letterSpacing;textComp.typeSettingParam.letterSpacing=configLetterSpacing}if("innerPadding"in configJson){const configLetterSpacing=configJson.innerPadding;textComp.typeSettingParam.horizontalPadding=configLetterSpacing;textComp.typeSettingParam.verticalPadding=configLetterSpacing}if("lineMaxWidth"in configJson){const configLineMaxWidth=configJson.lineMaxWidth;this._setTextLineMaxWidth(configLineMaxWidth)}if("canvasWHFixed"in configJson){const configCanvasWHFixed=AmazUtils$1.CastJsonArray2fToAmazVector2f(configJson.canvasWHFixed);if(null!==configCanvasWHFixed){textComp.typeSettingParam.canvasWHFixed=configCanvasWHFixed}else{console.error(TEMPLATE_TAG,"_updateTextParams config json canvasWHFixed is not vector2f!")}}if("oneLineCutOff"in configJson){const configFlag=configJson.oneLineCutOff;if(configFlag){textComp.typeSettingParam.lineBreakType=Amaz$3.LineBreakType.CUT_OFF}else{textComp.typeSettingParam.lineBreakType=Amaz$3.LineBreakType.AUTO_LINEBREAK}}if("cutOffPostfix"in configJson){const configCutOffPostfix=configJson.cutOffPostfix;textComp.cutOffPostfix=configCutOffPostfix}if("autoAdaptDpiEnabled"in configJson){const configAutoAdaptDpiEnabled=configJson.autoAdaptDpiEnabled;textComp.typeSettingParam.autoAdaptDpiEnabled=configAutoAdaptDpiEnabled}if("typeSettingPathEnable"in configJson){const configTypeSettingPathEnable=configJson.typeSettingPathEnable;textComp.typeSettingParam.enablePathTypeSetting=configTypeSettingPathEnable}if("enableMergeLine"in configJson){const configEnableMergeLine=configJson.enableMergeLine;textComp.typeSettingParam.mergingIntoOneLine=configEnableMergeLine}if("typeSettingPathParam"in configJson){const configTypeSettingPathParam=this._updatePathTypeSettingParam(configJson.typeSettingPathParam);textComp.typeSettingParam.pathTypeSettingParam=configTypeSettingPathParam}}{if("canvas"in configJson){const configCanvas=configJson.canvas;textComp.canvas.canvasEnabled=configCanvas}if("canvasColor"in configJson){const configCanvasColor=AmazUtils$1.CastJsonArray4fToAmazVector4f(configJson.canvasColor);if(null!==configCanvasColor){textComp.canvas.canvasColor=configCanvasColor}else{console.error(TEMPLATE_TAG,"_updateTextParams config json canvasColor is not vector4f!")}}if("canvasRoundCorner"in configJson){const configCanvasRoundCorner=configJson.canvasRoundCorner;textComp.canvas.canvasRoundCornerEnabled=configCanvasRoundCorner}if("canvasRoundRadius"in configJson){const configCanvasRoundRadius=configJson.canvasRoundRadius;textComp.canvas.canvasRoundRadius=configCanvasRoundRadius}if("canvasRoundRadiusScale"in configJson){const configCanvasRoundRadiusScale=configJson.canvasRoundRadiusScale;textComp.canvas.canvasRoundRadiusScale=configCanvasRoundRadiusScale}if("canvasWrapped"in configJson){const configCanvasWrapped=configJson.canvasWrapped;textComp.canvas.canvasWrappText=configCanvasWrapped}if("canvasCustomized"in configJson){const configCanvasCustomized=configJson.canvasCustomized;textComp.canvas.canvasCustomizedEnabled=configCanvasCustomized}if("canvasWHCustomized"in configJson){const configCanvasWHCustomized=AmazUtils$1.CastJsonArray2fToAmazVector2f(configJson.canvasWHCustomized);if(null!==configCanvasWHCustomized){textComp.canvas.canvasWHCustomized=configCanvasWHCustomized}else{console.error(TEMPLATE_TAG,"_updateTextParams config json canvasWHCustomized is not vector2f!")}}if("canvasOffsetCustomized"in configJson){const configCanvasOffsetCustomized=AmazUtils$1.CastJsonArray2fToAmazVector2f(configJson.canvasOffsetCustomized);if(null!==configCanvasOffsetCustomized){textComp.canvas.canvasOffsetCustomized=configCanvasOffsetCustomized}else{console.error(TEMPLATE_TAG,"_updateTextParams config json canvasOffsetCustomized is not vector2f!")}}if("canvasAdvancedInfo"in configJson){if("shapeType"in configJson.canvasAdvancedInfo&&textComp.canvas!==null){const type=configJson.canvasAdvancedInfo.shapeType;if(type==="bounding"){textComp.canvas.canvasType=effect.Amaz.CanvasStyle.BOUNDING_BOX}else if(type==="wrapMerged"){textComp.canvas.canvasType=effect.Amaz.CanvasStyle.WRAP_MERGED}else if(type==="wrapSeparate"){textComp.canvas.canvasType=effect.Amaz.CanvasStyle.WRAP_SEPARATE}else if(type==="wrapIndependent"){textComp.canvas.canvasType=effect.Amaz.CanvasStyle.WRAP_INDEPENDENT}}if("fill"in configJson.canvasAdvancedInfo&&textComp.globalBackground!==null){textComp.globalBackground.setFillInfoStr(JSON.stringify(configJson.canvasAdvancedInfo))}}}{if("italicDegree"in configJson){const configItalicDegree=configJson.italicDegree;textComp.activeTextStyle.italicAngle=configItalicDegree}if("boldValue"in configJson){const configBoldValue=configJson.boldValue;textComp.activeTextStyle.boldValue=configBoldValue}if("decorationWidth"in configJson){const configDecorationWidth=configJson.decorationWidth;textComp.activeTextStyle.decorationWidth=configDecorationWidth}if("decorationOffset"in configJson){const configDecorationOffset=configJson.decorationOffset;textComp.activeTextStyle.decorationOffset=configDecorationOffset}if("fallbackFontPathList"in configJson){const configFontPaths=AmazUtils$1.CastJsonArrayToAmazVector(configJson.fallbackFontPathList);textComp.fallbackFontPaths=configFontPaths}}{if("ktvColor"in configJson){const configKTVColor=AmazUtils$1.CastJsonArray4fToAmazVector4f(configJson.ktvColor);if(null!==configKTVColor){this.m_ktvColor=configKTVColor;const configKTVColorVec=AmazUtils$1.CastJsonArrayToAmazVector(configJson.ktvColor);this.m_scriptPassthroughParams.set("ktvColor",configKTVColorVec);this.m_scriptPassthroughParams.set("sdfTextDirty",true);this.m_scriptPassthroughParamsDirty=true}else{console.error(TEMPLATE_TAG,"_updateTextParams config json ktvColor is not vector4f!")}}if("ktvOutlineColor"in configJson){const configKTVOutlineColor=AmazUtils$1.CastJsonArray4fToAmazVector4f(configJson.ktvOutlineColor);if(null!==configKTVOutlineColor){this.m_ktvOutlineColor=configKTVOutlineColor;const configKTVOutlineColorVec=AmazUtils$1.CastJsonArrayToAmazVector(configJson.ktvOutlineColor);this.m_scriptPassthroughParams.set("ktvOutlineColor",configKTVOutlineColorVec);this.m_scriptPassthroughParams.set("sdfTextDirty",true);this.m_scriptPassthroughParamsDirty=true}else{console.error(TEMPLATE_TAG,"_updateTextParams config json ktvOutlineColor is not vector4f!")}}if("ktvShadowColor"in configJson){const configKTVShadowColor=AmazUtils$1.CastJsonArray4fToAmazVector4f(configJson.ktvShadowColor);if(null!==configKTVShadowColor){this.m_ktvShadowColor=configKTVShadowColor;const configKTVShadowColorVec=AmazUtils$1.CastJsonArrayToAmazVector(configJson.ktvShadowColor);this.m_scriptPassthroughParams.set("ktvShadowColor",configKTVShadowColorVec);this.m_scriptPassthroughParams.set("sdfTextDirty",true);this.m_scriptPassthroughParamsDirty=true}else{console.error(TEMPLATE_TAG,"_updateTextParams config json ktvShadowColor is not vector4f!")}}}if("textLocale"in configJson){const configTextLocale=configJson.textLocale;textComp.textLocale=configTextLocale}if("directionLevel"in configJson){const configDirectionLevel=configJson.directionLevel;textComp.textDirectionLevel=configDirectionLevel}{if("bloomPath"in configJson){const configBloomPath=configJson.bloomPath;textComp.updateBloomInfoByPath(configBloomPath)}if("bloomColorCustomized"in configJson){const configBloomColorCustomized=configJson.bloomColorCustomized;textComp.bloomColorCustomized=configBloomColorCustomized}if("bloomColor"in configJson){const configBloomColor=AmazUtils$1.CastJsonArray4fToAmazVector4f(configJson.bloomColor);if(null!==configBloomColor){textComp.bloomColor=configBloomColor}else{console.error(TEMPLATE_TAG,"_updateTextParams config json bloomColor is not vector4f!")}}if("bloomStrength"in configJson){const configBloomStrength=configJson.bloomStrength;textComp.bloomStrength=configBloomStrength}if("bloomRange"in configJson){const configBloomRange=configJson.bloomRange;textComp.bloomRange=configBloomRange}if("bloomDirX"in configJson){const configBloomDirX=configJson.bloomDirX;textComp.bloomDirX=configBloomDirX}if("bloomDirY"in configJson){const configBloomDirY=configJson.bloomDirY;textComp.bloomDirY=configBloomDirY}if("bloomBlurDegree"in configJson){const configBloomBlurDegree=configJson.bloomBlurDegree;textComp.bloomBlurDegree=configBloomBlurDegree}}{let textShapeConfig="";if("textShape"in configJson){textShapeConfig=configJson.textShape}if(textShapeConfig!==""){this._updateRichTextShapeParams(configJson)}else{const letterPosChanged=textComp.typeSettingDirty;this.updateTextRect();if(letterPosChanged){this.reloadAllAnimation()}}}if("fixFontSize"in configJson){const configFixFontSize=configJson.fixFontSize;textComp.fixFontSize=configFixFontSize}}_updateTextParams(configJson){if(!configJson){return}if(null==this.m_textComp){console.error(TEMPLATE_TAG,"_updateTextComp text component is null!");return}this.reloadAllAnimation();this._updateTextJsonParams(configJson)}updateAssociationParam(jsonParam){if("association_params"in jsonParam){const associationParams=jsonParam.association_params;if(associationParams!=null){if(this.m_textAssociationController==null){this.m_textAssociationController=new TextAssociationController(this)}this.m_textAssociationController.setAssociationParams(associationParams)}else{console.error("text widget set parameters json config association_params is not json object!")}}}updateText(){if(this.m_needUpdateTextCom){if(!this.m_jsonParams){console.error(TEMPLATE_TAG,"_updateTextComp config json is empty!");return}else if("rich_text_edit"in this.m_jsonParams){const richTextEditConfig=this.m_jsonParams.rich_text_edit;const textOP={m_iOpCode:richTextEditConfig.op_code,m_fParam1:richTextEditConfig.fparam1,m_fParam2:richTextEditConfig.fparam2,m_fParam3:richTextEditConfig.fparam3,m_fParam4:richTextEditConfig.fparam4,m_sParam:richTextEditConfig.sparam};this.setRichTextByOPCode(textOP);this.m_captionDurationInfoDirty=true;this.m_captionParamsDirty=true}else{let configJson=null;if("text_params"in this.m_jsonParams){configJson=this.m_jsonParams.text_params}this._updateTextParams(configJson)}this.m_needUpdateTextCom=false}}reloadAllAnimation(){var _a,_b;super.reloadAllAnimation();(_a=this.m_captionAnimationController)===null||_a===void 0?void 0:_a.resetAnimation();(_b=this.m_textAnimationController)===null||_b===void 0?void 0:_b.resetAnimation()}onUpdate(timeInTrack){if(!this.m_enable||!this.checkIsInRange(timeInTrack)){super.onUpdate(timeInTrack);if(this.m_rootEntity&&this.m_rootEntity.visible){this.m_rootEntity.visible=false;this.resetAllAnimation()}this.checkLayoutDirty();return}else{if(this.m_rootEntity&&!this.m_rootEntity.visible){this.m_rootEntity.visible=true}const eps=1e-5;if(this.m_timeRange.endTime-this.m_timeRange.startTime<eps){console.warn("time range is too short, please check!");return}if(this.m_captionAnimationController!=null&&(this.m_animations==null||this.m_animations.size==0||this.m_captionAnimationController.needMerge||this.m_captionAnimationController.captionInfo.onlyForKeyword)){this.m_captionAnimationController.update(timeInTrack-this.startTime)}if(this.m_textAnimationController!=null){this.m_textAnimationController.updateKeyFrames();if(this.m_textAnimationController.isEnable(timeInTrack)){this.m_textAnimationController.update(timeInTrack-this.startTime)}}super.onUpdate(timeInTrack);this.seekAnimations(timeInTrack);this.updateBloomIfNeeded(timeInTrack);this._updateCachePixelSize()}}updateBloomIfNeeded(timeStamp){if(this.textComp&&this.textComp.bloomPath.length>0&&this.textComp.bloomScriptComp){if(!this.textComp.bloomScriptComp.getScript()){const scriptSystem=this.m_scene.getSystem("ScriptSystem");scriptSystem.initAndStartScript(this.textComp.bloomScriptComp);this.textComp.bloomScriptComp.call("onUpdate",[this.textComp,timeStamp])}else if(this.hasAnimation()||this.m_captionAnimationController!=null){this.textComp.bloomScriptComp.call("onUpdate",[this.textComp,timeStamp])}this.checkLayoutDirty()}}onLateUpdate(timeInTrack){var _a;if(this.m_animations==null||this.m_animations.size==0){(_a=this.m_captionAnimationController)===null||_a===void 0?void 0:_a.postUpdate(timeInTrack-this.startTime)}}updateTextRect(){if(this.m_textComp){this.m_textComp.forceTypeSetting();const rect=this.m_textComp.getCanvasCustomizedExpanded();const pixelSize=new Vec2(rect.width,rect.height);this.updateOriginalSize(pixelSize,this.m_screenSize)}}getCapabilityVersion(){let textVersion=VersionUtils.str2Version(SDK_VERSION);if(null!==this.m_textComp){if(this.m_textComp.textLocale==Amaz$3.TextLocale.RTL_LOCALE){const capVersion=VersionUtils.str2Version(TEXT_LOCALE_VER);textVersion=VersionUtils.versionMax(textVersion,capVersion);if(this.m_textComp.textDirectionLevel!==Amaz$3.TextDirectionLevel.DEFAULT_LTR){const capVersion=VersionUtils.str2Version(TEXT_DIRECTION_LEVEL_VER);textVersion=VersionUtils.versionMax(textVersion,capVersion)}}if(this.m_textComp.bloomPath!==""){const capVersion=VersionUtils.str2Version(TEXT_BLOOM_VER);textVersion=VersionUtils.versionMax(textVersion,capVersion)}if(this.m_textComp.typeSettingParam.canvasWHFixed.x>=0||this.m_textComp.typeSettingParam.canvasWHFixed.y>=0){const capVersion=VersionUtils.str2Version(TEXT_CANVAS_WH_FIXED_VER);textVersion=VersionUtils.versionMax(textVersion,capVersion)}if(this.m_textComp.typeSettingParam.enablePathTypeSetting===true){const capVersion=VersionUtils.str2Version(TEXT_PATH_TYPESETTING_VER);textVersion=VersionUtils.versionMax(textVersion,capVersion)}if(!this.m_textComp.backgrounds.empty()){const capVersion=VersionUtils.str2Version(TEXT_BACK_GROUNDS_VER);textVersion=VersionUtils.versionMax(textVersion,capVersion)}let hasShadowDiffuse=false;const letters=this.m_textComp.letters;for(let letterId=0;letterId<letters.size();letterId++){const style=letters.get(letterId).letterStyle;if(style!=null&&!style.shadows.empty()){for(let shadowId=0;shadowId<style.shadows.size();shadowId++){const shadow=style.shadows.get(shadowId);if(shadow.enable&&shadow.shadowDiffuse>=0){hasShadowDiffuse=true;break}}}}if(hasShadowDiffuse){const capVersion=VersionUtils.str2Version(TEXT_SHADOW_DIFFUSE_VER);textVersion=VersionUtils.versionMax(textVersion,capVersion)}}return textVersion}}var ScriptSegment;(function(ScriptSegment){function CreateWidget(name,jsonParam,widgetType,scene){let widget=null;if(jsonParam){if(widgetType===WidgetType.ROOT){widget=new Widget(name,widgetType,scene);widget.createRoot(jsonParam,scene)}else if(widgetType===WidgetType.SPRITE){widget=new Sprite(name,widgetType,scene,jsonParam)}else if(widgetType===WidgetType.SHAPE){widget=new Shape(name,widgetType,scene);widget.createShape(jsonParam,scene)}else if(widgetType===WidgetType.TEXT){widget=new RichText(name,widgetType,scene);widget.createRichText(jsonParam,scene)}}else{console.error(TEMPLATE_TAG,"create widget error, jsonParam is null or undefined!")}return widget}ScriptSegment.CreateWidget=CreateWidget;function RemoveWidget(widget,scene){widget.removeWidgetRootEntity(scene);return true}ScriptSegment.RemoveWidget=RemoveWidget;function GetWidgetName(widget){return widget.widgetName}ScriptSegment.GetWidgetName=GetWidgetName;function SetResolutionType(widget,resolutionType){widget.widgetResolutionType=resolutionType}ScriptSegment.SetResolutionType=SetResolutionType;function GetResolutionType(widget){return widget.widgetResolutionType}ScriptSegment.GetResolutionType=GetResolutionType;function OnResize(widget,screenSize,pixelRatio,extraScale){widget.onResize(screenSize,pixelRatio,extraScale)}ScriptSegment.OnResize=OnResize;function AddToRootWidget(rootwidget,renderWidget){renderWidget.rootWidget=rootwidget;const renderWidgetEntity=renderWidget.rootEntity;const rootWidgetEntity=rootwidget.rootEntity;if(renderWidgetEntity&&rootWidgetEntity){AmazUtils$1.addChildEntity(rootWidgetEntity,renderWidgetEntity)}}ScriptSegment.AddToRootWidget=AddToRootWidget;function RemoveFromRootWidget(rootwidget,renderWidget){var _a;renderWidget.rootWidget=null;const renderWidgetEntity=renderWidget.rootEntity;const rootWidgetEntity=rootwidget.rootEntity;if(renderWidgetEntity&&rootWidgetEntity){AmazUtils$1.removeChildEntity(rootWidgetEntity,renderWidgetEntity);(_a=renderWidget.scene)===null||_a===void 0?void 0:_a.removeEntity(renderWidgetEntity)}}ScriptSegment.RemoveFromRootWidget=RemoveFromRootWidget;function SetWidgetPosition(widget,position){widget.position=position}ScriptSegment.SetWidgetPosition=SetWidgetPosition;function GetWidgetPosition(widget){return widget.position}ScriptSegment.GetWidgetPosition=GetWidgetPosition;function SetWidgetScale(widget,scale){widget.scale=scale}ScriptSegment.SetWidgetScale=SetWidgetScale;function GetWidgetScale(widget){return widget.scale}ScriptSegment.GetWidgetScale=GetWidgetScale;function SetWidgetRotation(widget,rotation){widget.rotation=rotation}ScriptSegment.SetWidgetRotation=SetWidgetRotation;function GetWidgetRotation(widget){return widget.rotation}ScriptSegment.GetWidgetRotation=GetWidgetRotation;function GetWidgetDuration(widget){return widget.duration}ScriptSegment.GetWidgetDuration=GetWidgetDuration;function SetWidgetLayer(widget,layer){widget.layer=layer}ScriptSegment.SetWidgetLayer=SetWidgetLayer;function GetWidgetLayer(widget){return widget.layer}ScriptSegment.GetWidgetLayer=GetWidgetLayer;function SetWidgetLocalOrderInLayer(widget,order){widget.localOrder=order}ScriptSegment.SetWidgetLocalOrderInLayer=SetWidgetLocalOrderInLayer;function SetWidgetTimeRange(widget,startTime,endTime){widget.setTimeRange(startTime,endTime)}ScriptSegment.SetWidgetTimeRange=SetWidgetTimeRange;function UpdateWidgetRootEntity(widget){widget.updateRootEntityParam()}ScriptSegment.UpdateWidgetRootEntity=UpdateWidgetRootEntity;function OnUpdate(widget,timeStamp){widget.onUpdate(timeStamp)}ScriptSegment.OnUpdate=OnUpdate;function GetWidgetBindingBox(widget){return widget.bindingBox}ScriptSegment.GetWidgetBindingBox=GetWidgetBindingBox;function SetWidgetEnable(widget,enable){widget.enable=enable}ScriptSegment.SetWidgetEnable=SetWidgetEnable;function SetWidgetParams(widget,jsonParam){widget.parameters=jsonParam;return true}ScriptSegment.SetWidgetParams=SetWidgetParams;function GetWidgetParams(widget){return widget.parameters}ScriptSegment.GetWidgetParams=GetWidgetParams;function SetRichTextParams(widget,iOpcode,fParam1,fParam2,fParam3,fParam4,sParam){const textOP={m_iOpCode:iOpcode,m_fParam1:fParam1,m_fParam2:fParam2,m_fParam3:fParam3,m_fParam4:fParam4,m_sParam:sParam};widget.setRichTextByOPCode(textOP)}ScriptSegment.SetRichTextParams=SetRichTextParams;function GetRichTextParams(widget,iOpcode,fParam1,fParam2,fParam3,fParam4,sParam){const textOP={m_iOpCode:iOpcode,m_fParam1:fParam1,m_fParam2:fParam2,m_fParam3:fParam3,m_fParam4:fParam4,m_sParam:sParam};return widget.getRichTextByOPCode(textOP)}ScriptSegment.GetRichTextParams=GetRichTextParams;function SetWidgetAnimation(widget,path,resourceID,scriptType,animaType,startTime,duration,loopDuration){return widget.setWidgetAnimation(path,resourceID,scriptType,startTime,duration,loopDuration,animaType)}ScriptSegment.SetWidgetAnimation=SetWidgetAnimation;function updateSeekParamsToJS(widget,jsonParam){widget.updateTrackingProcessData(jsonParam)}ScriptSegment.updateSeekParamsToJS=updateSeekParamsToJS})(ScriptSegment||(ScriptSegment={}));var Amaz$2=effect.Amaz;const HALF=.5;class LayoutUtils{static isTemplateLayoutDirty(_root,_widgets){if(_root&&_root.layoutDirty==true){return true}if(_widgets){for(let i=0;i<_widgets.length;++i){const widget2d=_widgets[i];if(widget2d&&widget2d.layoutParams.dirty==true){return true}}}return false}static setTemplateLayoutDirty(_root,_widgets,dirty){if(_root){_root.layoutDirty=dirty}_widgets===null||_widgets===void 0?void 0:_widgets.forEach((widget=>{if(widget){const widget2d=widget;if(widget2d){widget2d.layoutParams.dirty=dirty}}}))}static updateTemplateBoundingBox(_root,_widgets){if(Widget.m_isPostLayoutEnable==true){return}const widgetBboxVec=[];if(_root&&_widgets){for(let i=0;i<_widgets.length;++i){let localBbox={x:0,y:0,z:0,w:0};const widget2d=_widgets[i];if(widget2d){if(widget2d.canNotRender())continue;localBbox=this.getRenderWidgetLocalBBox(widget2d);const bbox=this.transformLocalBboxToWorld(_root,localBbox);widget2d.layoutParams.extra_scale=[_root.extraScale.x,_root.extraScale.y,_root.extraScale.z];widget2d.layoutParams.local_boundingBox=[localBbox.x,localBbox.y,localBbox.z,localBbox.w];widget2d.layoutParams.bounding_box=[bbox.x,bbox.y,bbox.z,bbox.w]}widgetBboxVec.push(localBbox)}}if(_root){const localBbox=this.getRootWidgetLocalBBox(_root,_widgets,widgetBboxVec);const bbox=this.transformLocalBboxToWorld(_root,localBbox);_root.localBoundingBox=new Amaz$2.Vector4f(localBbox.x,localBbox.y,localBbox.z,localBbox.w);_root.boundingBox=new Amaz$2.Vector4f(bbox.x,bbox.y,bbox.z,bbox.w)}}static getRootWidgetLocalBBox(_root,_widgets,_widgetBboxVec){if(!_root||!_widgets||_widgets.length<1){return{x:0,y:0,z:0,w:0}}let rootLocalBbox={x:Number.MAX_VALUE,y:Number.MAX_VALUE,z:Number.NEGATIVE_INFINITY,w:Number.NEGATIVE_INFINITY};const pointRotateOpt=(point,axis,angle)=>{const radFactor=PI/180;const pointRotate={x:(point.x-axis.x)*Math.cos(angle*radFactor)-(point.y-axis.y)*Math.sin(angle*radFactor)+axis.x,y:(point.y-axis.y)*Math.cos(angle*radFactor)+(point.x-axis.x)*Math.sin(angle*radFactor)+axis.y};return pointRotate};for(let i=0;i<_widgets.length;++i){const widget2d=_widgets[i];const localBbox=_widgetBboxVec[i];if(widget2d&&localBbox){if(widget2d.canNotRender())continue;const localBboxCenter={x:(localBbox.x+localBbox.z)*HALF,y:(localBbox.y+localBbox.w)*HALF};const localBboxPoints=[[localBbox.x,localBbox.y],[localBbox.x,localBbox.w],[localBbox.z,localBbox.w],[localBbox.z,localBbox.y]];for(let i=0;i<localBboxPoints.length;++i){let point={x:localBboxPoints[i][0],y:localBboxPoints[i][1]};point=pointRotateOpt(point,localBboxCenter,widget2d.rotation.z);rootLocalBbox.x=Math.min(rootLocalBbox.x,point.x);rootLocalBbox.y=Math.min(rootLocalBbox.y,point.y);rootLocalBbox.z=Math.max(rootLocalBbox.z,point.x);rootLocalBbox.w=Math.max(rootLocalBbox.w,point.y)}}}const halfWidth=Math.max(Math.abs(rootLocalBbox.x),Math.abs(rootLocalBbox.z));const halfHeight=Math.max(Math.abs(rootLocalBbox.y),Math.abs(rootLocalBbox.w));rootLocalBbox={x:-halfWidth,y:-halfHeight,z:halfWidth,w:halfHeight};return rootLocalBbox}static getRenderWidgetLocalBBox(widget){const originPixelSize={x:widget.originalPixelSize.x,y:widget.originalPixelSize.y};if(widget.widgetType===WidgetType.TEXT&&widget.hasAnimation()){const text=widget;if(text){originPixelSize.x=text.cachePixelSize.x;originPixelSize.y=text.cachePixelSize.y}}const localBbox={x:widget.position.x-originPixelSize.x*widget.scale.x*HALF,y:widget.position.y-originPixelSize.y*widget.scale.y*HALF,z:widget.position.x+originPixelSize.x*widget.scale.x*HALF,w:widget.position.y+originPixelSize.y*widget.scale.y*HALF};return localBbox}static transformLocalBboxToWorld(root,localBbox){const position=new Amaz$2.Vector3f(root.position.x*root.screenSize.x*HALF,root.position.y*root.screenSize.y*HALF,0);let rotation=new Amaz$2.Quaternionf;rotation=rotation.eulerToQuaternion(new Amaz$2.Vector3f(0,0,0));const scale=new Amaz$2.Vector3f(root.scale.x*root.extraScale.x,root.scale.y*root.extraScale.y,root.scale.z*root.extraScale.z);if(root.trackerHoldFinalTRS){position.x=root.trackFinalPosition.x*root.screenSize.x*HALF;position.y=root.trackFinalPosition.y*root.screenSize.y*HALF;scale.x=root.trackFinalScale.x*root.extraScale.x;scale.y=root.trackFinalScale.y*root.extraScale.y}const matrix=new Amaz$2.Matrix4x4f;matrix.setTRS(position,rotation,scale);const leftBottom=matrix.multiplyPoint3(new Amaz$2.Vector3f(localBbox.x,localBbox.y,0));const rightTop=matrix.multiplyPoint3(new Amaz$2.Vector3f(localBbox.z,localBbox.w,0));const bbox={x:leftBottom.x,y:leftBottom.y,z:rightTop.x,w:rightTop.y};return bbox}static getAllWidgetLayoutParams(_root,_widgets){const jsonParam={};jsonParam.type="ScriptTemplate";if(_root){jsonParam.root=this.getWidgetLayoutParams(_root)}const children=[];if(_widgets!==undefined){for(let i=0;i<_widgets.length;++i){const widget=_widgets[i];if(!widget)continue;const widgetParam=this.getWidgetLayoutParams(widget);children.push(widgetParam)}}jsonParam.children=children;return jsonParam}static getWidgetLayoutParams(_widget){const typeStr=_widget.getWidgetTypeStr();const widgetParam={name:_widget.widgetName,type:typeStr,position:[_widget.position.x,_widget.position.y,_widget.position.z],scale:[_widget.scale.x,_widget.scale.y,_widget.scale.z],rotation:[_widget.rotation.x,_widget.rotation.y,_widget.rotation.z]};if(_widget.widgetType===WidgetType.ROOT){if(_widget.trackerHoldFinalTRS){const finalPosition=_widget.trackFinalPosition.copy();const finalScale=_widget.trackFinalScale.copy();const finalRotation=_widget.trackFinalRotation.copy();widgetParam.position=[finalPosition.x,finalPosition.y,finalPosition.z];widgetParam.rotation=[finalRotation.x,finalRotation.y,finalRotation.z];widgetParam.scale=[finalScale.x,finalScale.y,finalScale.z]}widgetParam.extra_scale=[_widget.extraScale.x,_widget.extraScale.y,_widget.extraScale.z],widgetParam.local_boundingBox=[_widget.localBoundingBox.x,_widget.localBoundingBox.y,_widget.localBoundingBox.z,_widget.localBoundingBox.w],widgetParam.bounding_box=[_widget.boundingBox.x,_widget.boundingBox.y,_widget.boundingBox.z,_widget.boundingBox.w]}else{const _widget2d=_widget;if(_widget2d){widgetParam.layout_params=_widget2d.layoutParams;widgetParam.original_size=[_widget2d.originalPixelSize.x,_widget2d.originalPixelSize.y];widgetParam.action_type=_widget2d.actionType}}return widgetParam}}var Amaz$1=effect.Amaz;const DEGSIN_SIZE=new Amaz$1.Vector2f(720,1280);class TemplateUtils{static createChildren(data,scene,screenSize){return data.map((childData=>{const node=TemplateConfigParser.parseChildNode(childData);if(node==null)return null;const widgetName=node.name;let widget=null;if((node===null||node===void 0?void 0:node.type)==="sticker"){widget=ScriptSegment.CreateWidget(widgetName,node,WidgetType.SPRITE,scene)}else if((node===null||node===void 0?void 0:node.type)==="text"){widget=ScriptSegment.CreateWidget(widgetName,node,WidgetType.TEXT,scene)}else if((node===null||node===void 0?void 0:node.type)==="shape"){widget=ScriptSegment.CreateWidget(widgetName,node,WidgetType.SHAPE,scene)}if(widget&&screenSize.length===2){const screenSizeVec=new Amaz$1.Vector2f(screenSize[0],screenSize[1]);const pixelRatio=.5*screenSize[1];const extraScale=new Amaz$1.Vector3f(1,1,1);ScriptSegment.OnResize(widget,screenSizeVec,pixelRatio,extraScale)}return widget})).filter((v=>v!=null))}static createLayer(_layerName,layerParam,screenWidth,screenHeight,options){const jsonParam=JSON.parse(layerParam);if(options.mainScene!=null&&options.rootWidget){const[widget]=TemplateUtils.createChildren([jsonParam],options.mainScene,[screenWidth,screenHeight]);if(widget!=null){if(options.rootWidget){widget.widgetResolutionType=options.rootWidget.widgetResolutionType;ScriptSegment.AddToRootWidget(options.rootWidget,widget);this.updateWidgetAssociationParams(widget)}return widget}}return null}static removeLayer(layerNamem,mainScene,rootWidget,renderWidgets){return renderWidgets.filter((value=>{if(null!==value&&undefined!==mainScene&&undefined!==rootWidget){if(layerNamem===ScriptSegment.GetWidgetName(value)){ScriptSegment.RemoveWidget(value,mainScene);return false}}return true}))}static setTemplateTimeRange(startTime,endTime,options){if(undefined!==options.rootWidget&&null!==options.rootWidget&&undefined!==options.mainScene){ScriptSegment.SetWidgetTimeRange(options.rootWidget,startTime,endTime)}}static replaceDependentResource(config,depends){return AmazUtils$1.swingTemplateUtils.replaceDependResource(config,depends)}static constructWidgetsFromConfig(config,depends,scene,screenSize,resolutionType){if(config!=null&&depends!=null&&depends.length!==0){config=TemplateUtils.replaceDependentResource(config,depends)}const data=TemplateConfigParser.parseConfig(config);let root=undefined;if(data!=null){root=ScriptSegment.CreateWidget("rootWidget",data.root,WidgetType.ROOT,scene)}else{console.error(TEMPLATE_TAG,"create root widgent error, causeof data parse error",config)}if(root&&screenSize.length===2){ScriptSegment.SetResolutionType(root,resolutionType);const screenSizeVec=new Amaz$1.Vector2f(screenSize[0],screenSize[1]);const pixelRatio=.5*screenSize[1];let extraScale=new Amaz$1.Vector3f(1,1,1);if(WidgetResolutionType.DESIGN===resolutionType){const scale=screenSize[0]/DEGSIN_SIZE.x;extraScale=new Amaz$1.Vector3f(scale,scale,1)}else if(WidgetResolutionType.DESIGN_HEIGHT===resolutionType){const scale=screenSize[1]/DEGSIN_SIZE.y;extraScale=new Amaz$1.Vector3f(scale,scale,1)}ScriptSegment.OnResize(root,screenSizeVec,pixelRatio,extraScale)}if((data===null||data===void 0?void 0:data.children)!=null&&root!=null){const children=TemplateUtils.createChildren(data.children,scene,screenSize);children.map((value=>{if(value!==null&&root){value.widgetResolutionType=resolutionType;ScriptSegment.AddToRootWidget(root,value);this.updateWidgetAssociationParams(value)}}));return[root,children]}return root?[root,[]]:undefined}static updateWidgetParams(_root,_widgets,_params){var _a;const jsonParam=JSON.parse(_params);let rootLayer=-1;if("root"in jsonParam){if(_root){const rootJosnOBject=jsonParam.root;ScriptSegment.SetWidgetParams(_root,rootJosnOBject);if(rootJosnOBject&&"layer"in rootJosnOBject){rootLayer=rootJosnOBject.layer}}}if("children"in jsonParam){const widgetListParam=jsonParam.children;if(widgetListParam instanceof Array){for(let i=0;i<widgetListParam.length;i++){const widgetParam=widgetListParam[i];if(widgetParam&&"name"in widgetParam){const widgetName=widgetParam.name;if(_widgets!==undefined){let nameFound=false;_widgets.map((value=>{if(null!==value&&ScriptSegment.GetWidgetName(value)===widgetName){nameFound=true;if(rootLayer!==-1){ScriptSegment.SetWidgetLayer(value,rootLayer)}ScriptSegment.SetWidgetParams(value,widgetParam)}}));if(!nameFound)console.error(TEMPLATE_TAG,"the widget name in json does not match any existing widget name")}}}}}if(_root&&_widgets){(_a=_root.rootAssociationController)===null||_a===void 0?void 0:_a.updateByAssociation(_widgets)}}static setRootWidgetResolutionType(_root,_widgets,resolutionType,screen_width,screen_heght){const pixelRatio=.5*screen_heght;let extraScale=new Amaz$1.Vector3f(1,1,1);const screenSizeVec=new Amaz$1.Vector2f(screen_width,screen_heght);if(_root){ScriptSegment.SetResolutionType(_root,resolutionType);if(WidgetResolutionType.DESIGN===resolutionType){const scale=screen_width/DEGSIN_SIZE.x;extraScale=new Amaz$1.Vector3f(scale,scale,1)}else if(WidgetResolutionType.DESIGN_HEIGHT===resolutionType){const scale=screen_heght/DEGSIN_SIZE.y;extraScale=new Amaz$1.Vector3f(scale,scale,1)}ScriptSegment.OnResize(_root,screenSizeVec,pixelRatio,extraScale)}if(_widgets!==undefined){_widgets.map((value=>{if(null!==value){value.widgetResolutionType=resolutionType}}))}}static setWidgetScreenSize(_root,_widgets,screenWidth,screenHeight){const pixelRatio=.5*screenHeight;let extraScale=new Amaz$1.Vector3f(1,1,1);const screenSizeVec=new Amaz$1.Vector2f(screenWidth,screenHeight);let resolutionType=WidgetResolutionType.DESIGN;if(_root){resolutionType=ScriptSegment.GetResolutionType(_root);if(WidgetResolutionType.DESIGN===resolutionType){const scale=screenWidth/DEGSIN_SIZE.x;extraScale=new Amaz$1.Vector3f(scale,scale,1)}else if(WidgetResolutionType.DESIGN_HEIGHT===resolutionType){const scale=screenHeight/DEGSIN_SIZE.y;extraScale=new Amaz$1.Vector3f(scale,scale,1)}ScriptSegment.OnResize(_root,screenSizeVec,pixelRatio,extraScale)}const widgetScale=new Amaz$1.Vector3f(1,1,1);if(_widgets!==undefined){_widgets.map((value=>{if(null!==value){ScriptSegment.OnResize(value,screenSizeVec,pixelRatio,widgetScale);value.widgetResolutionType=resolutionType}}))}}static updateSeekParamsToWidgets(_root,_widgets,jsonParam){if(_root){ScriptSegment.updateSeekParamsToJS(_root,jsonParam)}}static updateWidgetAssociationParams(widget){var _a,_b;if(!widget){return}if(widget instanceof RichText){const textWidget=widget;(_a=textWidget.textAssociationController)===null||_a===void 0?void 0:_a.updateAssociationParams();(_b=textWidget.textAssociationController)===null||_b===void 0?void 0:_b.updateByAssociation()}}static getWidgetParams(_root,_widgets,_params){LayoutUtils.updateTemplateBoundingBox(_root,_widgets);const jsonParam=JSON.parse(_params);if("get_all_properties"in jsonParam){if(jsonParam.get_all_properties===true){const outParam=this.getAllWidgetParams(_root,_widgets);const retStr=JSON.stringify(outParam);return retStr}}if("get_layout_properties"in jsonParam){if(jsonParam.get_layout_properties===true){const outParam=this.getTemplateLayoutParams(_root,_widgets);const retStr=JSON.stringify(outParam);return retStr}}if("get_sdk_version"in jsonParam&&jsonParam.get_sdk_version===true){let capaVersion=VersionUtils.str2Version(SDK_VERSION);if(_widgets!==undefined){_widgets.map((value=>{if(null!==value){const widgetCapaVersion=this.getWidgetCapaVersion(value);capaVersion=VersionUtils.versionMax(capaVersion,widgetCapaVersion)}}))}const retVersion={sdk_version:VersionUtils.version2Str(capaVersion),script_version:SCRIPT_VERSION};const retStr=JSON.stringify(retVersion);return retStr}if("root"in jsonParam){if(_root){jsonParam.root=this.getRootWidgetParams(_root)}}if("children"in jsonParam){const widgetListParam=jsonParam.children;if(widgetListParam instanceof Array){for(let i=0;i<widgetListParam.length;i++){const widgetParam=widgetListParam[i];if(widgetParam&&"name"in widgetParam){const widgetName=widgetParam.name;if(_widgets!==undefined){_widgets.map((value=>{if(null!==value&&ScriptSegment.GetWidgetName(value)===widgetName){jsonParam.children[i]=this.getOneWidgetParams(value,widgetParam)}}))}}}}}const retStr=JSON.stringify(jsonParam);return retStr}static getAllWidgetParams(_root,_widgets){const jsonParam={};jsonParam.type="ScriptTemplate";if(_root){jsonParam.globals=this.getGlobalParams(_root);jsonParam.root=this.getRootWidgetParams(_root)}const children=[];if(_widgets!==undefined){for(let i=0;i<_widgets.length;++i){const widget=_widgets[i];if(widget){const widgetParam=this.getOneWidgetParams(widget,null);children.push(widgetParam)}}}jsonParam.children=children;return jsonParam}static getOneWidgetParams(_widget,_widgetParam){if(_widget!==undefined){if(_widget.widgetType===WidgetType.TEXT){return this.getTextWidgetParams(_widget,_widgetParam)}else if(_widget.widgetType===WidgetType.SPRITE){return this.getSpriteWidgetParams(_widget)}else if(_widget.widgetType===WidgetType.SHAPE){return this.getShapeWidgetParams(_widget)}}return{}}static getRootWidgetParams(_widget){const outParam=_widget.parameters;outParam.extra_scale=[_widget.extraScale.x,_widget.extraScale.y,_widget.extraScale.z];outParam.local_boundingBox=[_widget.localBoundingBox.x,_widget.localBoundingBox.y,_widget.localBoundingBox.z,_widget.localBoundingBox.w];outParam.bounding_box=[_widget.boundingBox.x,_widget.boundingBox.y,_widget.boundingBox.z,_widget.boundingBox.w];delete outParam.layout_params;delete outParam.order_in_layer;return outParam}static getGlobalParams(_widget){const jsonParam={};if(_widget){jsonParam.resolution_type=_widget.widgetResolutionType;const screenSize=[_widget.screenSize.x,_widget.screenSize.y];jsonParam.screen_size=screenSize}return jsonParam}static getTextWidgetParams(_widget,_widgetParam){let outParam=_widgetParam;if(_widgetParam&&"rich_text_edit"in _widgetParam){const textEditParam=_widgetParam.rich_text_edit;const textOPRet=ScriptSegment.GetRichTextParams(_widget,textEditParam.op_code,textEditParam.fparam1,textEditParam.fparam2,textEditParam.fparam3,textEditParam.fparam4,textEditParam.sparam);const resultTextOP={op_code:textOPRet.m_iOpCode,fparam1:textOPRet.m_fParam1,fparam2:textOPRet.m_fParam2,fparam3:textOPRet.m_fParam3,fparam4:textOPRet.m_fParam4,sparam:textOPRet.m_sParam};outParam["text_get_command_result"]=resultTextOP}else if(_widgetParam&&"queries"in _widgetParam){outParam=_widget.query(_widgetParam.queries);delete outParam.layout_params}else{outParam=_widget.parameters}return outParam}static getSpriteWidgetParams(_widget){const outParam=_widget.parameters;return outParam}static getShapeWidgetParams(_widget){const outParam=_widget.parameters;return outParam}static getTemplateLayoutParams(_root,_widgets){const jsonParam=LayoutUtils.getAllWidgetLayoutParams(_root,_widgets);if(_root){jsonParam.globals=this.getGlobalParams(_root)}return jsonParam}static updateTemplateLayout(_root,_widgets){if(Widget.m_isPostLayoutEnable==false){return}const layoutDirty=LayoutUtils.isTemplateLayoutDirty(_root,_widgets);let outLayoutStr="";if(layoutDirty){const inLayoutParam=this.getTemplateLayoutParams(_root,_widgets);const inLayoutStr=JSON.stringify(inLayoutParam);const utils=new Amaz$1.SwingTemplateUtils;outLayoutStr=utils.updateTemplateLayout(inLayoutStr)}if(outLayoutStr!=""){this.updateWidgetParams(_root,_widgets,outLayoutStr)}LayoutUtils.setTemplateLayoutDirty(_root,_widgets,false)}static getWidgetCapaVersion(_widget){const capaVersion=VersionUtils.str2Version(SDK_VERSION);if(_widget!==undefined){if(_widget.widgetType===WidgetType.TEXT){return _widget.getCapabilityVersion()}else if(_widget.widgetType===WidgetType.SPRITE){return _widget.getCapabilityVersion()}else if(_widget.widgetType===WidgetType.SHAPE){return _widget.getCapabilityVersion()}}return capaVersion}static clearCache(_root,_widgets){if(_root!==undefined&&_widgets!==undefined){_widgets.map((value=>{var _a;if(null!==value&&value.widgetType){value.onLeaveAllAnimation()}if(null!==value&&value.widgetType===WidgetType.TEXT){(_a=value.textComp)===null||_a===void 0?void 0:_a.clearCache()}}))}}}var TemplateEventType;(function(TemplateEventType){TemplateEventType[TemplateEventType["layerOperation"]=10100]="layerOperation"})(TemplateEventType||(TemplateEventType={}));var Amaz=effect.Amaz;class Main{constructor(){this.name="Main";this.scene=undefined;this.rootWidget=undefined;this.renderWidgets=undefined;this.sceneRef=undefined;this.sceneConfig=undefined}onComponentAdded(_comp){}onComponentRemoved(_comp){}onInit(){if(!this.scene)return;this.sceneRef=this.scene;this.sceneConfig=this.sceneRef.config;this.initEventHandlers();let params=this.sceneConfig.get("params");const depends=this.sceneConfig.get("depends");const screenSize=this.sceneConfig.get("screenSize");const resolutionType=this.sceneConfig.get("resolutionType");if(params){const result=TemplateUtils.constructWidgetsFromConfig(params,depends,this.sceneRef,[screenSize.x,screenSize.y],resolutionType);if(result){[this.rootWidget,this.renderWidgets]=result}}else{console.error(TEMPLATE_TAG,"constructWidgetsFromConfig parameters error")}}onStart(){if(Amaz.DebugInstance!==undefined&&Array.isArray(Amaz.DebugInstance)){Amaz.DebugInstance.push(this)}else{Amaz.DebugInstance=[];Amaz.DebugInstance.push(this)}}onUpdate(){var _a,_b,_c;const timestamp=(_a=this.sceneConfig)===null||_a===void 0?void 0:_a.get("timestamp");(_b=this.rootWidget)===null||_b===void 0?void 0:_b.onUpdate(timestamp);(_c=this.renderWidgets)===null||_c===void 0?void 0:_c.forEach((widget=>{widget===null||widget===void 0?void 0:widget.onUpdate(timestamp)}));TemplateUtils.updateTemplateLayout(this.rootWidget,this.renderWidgets)}onLateUpdate(){var _a,_b,_c;const timestamp=(_a=this.sceneConfig)===null||_a===void 0?void 0:_a.get("timestamp");(_b=this.rootWidget)===null||_b===void 0?void 0:_b.onLateUpdate(timestamp);(_c=this.renderWidgets)===null||_c===void 0?void 0:_c.forEach((widget=>{widget===null||widget===void 0?void 0:widget.onLateUpdate(timestamp)}))}onEvent(event){var _a;const amazEvent=event;if(amazEvent.type==TemplateEventType.layerOperation){(_a=this.sceneEventHandler)===null||_a===void 0?void 0:_a.fire(amazEvent.args.get(0),amazEvent.args)}}onDestroy(){this.scene=undefined;this.rootWidget=undefined;this.renderWidgets=undefined;this.sceneEventHandler=undefined}getParameters(parameters){if(this.scene&&this.rootWidget&&this.renderWidgets){return TemplateUtils.getWidgetParams(this.rootWidget,this.renderWidgets,parameters)}return""}clearCache(){if(this.scene&&this.rootWidget&&this.renderWidgets){TemplateUtils.clearCache(this.rootWidget,this.renderWidgets)}}initEventHandlers(){this.sceneEventHandler=new EventHandler;const createLayerHandler=args=>{if(this.scene&&this.rootWidget&&this.renderWidgets&&args){if(args.size()>=5){const layerName=args.get(1);const layerParams=args.get(2);const screenWidth=args.get(3);const screenHeight=args.get(4);const widget=TemplateUtils.createLayer(layerName,layerParams,screenWidth,screenHeight,{mainScene:this.scene,rootWidget:this.rootWidget,renderWidgets:this.renderWidgets});if(widget!==null){this.renderWidgets.push(widget)}}else{console.error(TEMPLATE_TAG,"createLayer parameters error! createLayer failed!")}}else{console.error(TEMPLATE_TAG,"createLayer scene, root or renderWidgets is null!")}};const removeLayerHandler=args=>{if(this.scene&&this.rootWidget&&this.renderWidgets&&args){if(args.size()>=2){const layerName=args.get(1);this.renderWidgets=TemplateUtils.removeLayer(layerName,this.scene,this.rootWidget,this.renderWidgets)}else{console.error(TEMPLATE_TAG,"removeLayer parameters error! removeLayer failed!")}}};const setTimeRangeHandler=args=>{if(this.scene&&this.rootWidget&&this.renderWidgets&&args){if(args.size()>=3){const startTime=args.get(1);const endTime=args.get(2);TemplateUtils.setTemplateTimeRange(startTime,endTime,{mainScene:this.scene,rootWidget:this.rootWidget,renderWidgets:this.renderWidgets.filter((v=>v!=null))})}else{console.error(TEMPLATE_TAG,"setTemplateTimeRange parameters error! setTemplateTimeRange failed!")}}};const setParametersHandler=args=>{if(this.scene&&this.rootWidget&&this.renderWidgets&&args){if(args.size()>=2){const parametersStr=args.get(1);TemplateUtils.updateWidgetParams(this.rootWidget,this.renderWidgets,parametersStr)}else{console.error(TEMPLATE_TAG,"setParameters parameters error! setParameters failed!")}}};const setResolutionTypeHandler=args=>{if(this.scene&&this.rootWidget&&args){if(args.size()>=4){const resolutionType=args.get(1);const screen_width=args.get(2);const screen_heght=args.get(3);TemplateUtils.setRootWidgetResolutionType(this.rootWidget,this.renderWidgets,resolutionType,screen_width,screen_heght)}else{console.error(TEMPLATE_TAG,"setResolutionType parameters error! setResolutionType failed!")}}};const setScreenSizeHandler=args=>{if(this.scene&&this.rootWidget&&args){if(args.size()>=3){const screenWidth=args.get(1);const screenHeight=args.get(2);TemplateUtils.setWidgetScreenSize(this.rootWidget,this.renderWidgets,screenWidth,screenHeight)}else{console.error(TEMPLATE_TAG,"setResolutionType parameters error! setScreenSize failed!")}}};const updateSeekParamsToJSHandler=args=>{if(this.scene&&this.rootWidget&&args){if(args.size()>=2){const jsonParam=args.get(1);TemplateUtils.updateSeekParamsToWidgets(this.rootWidget,this.renderWidgets,jsonParam)}else{console.error(TEMPLATE_TAG,"updateSeekParamsToJS parameters error! update seek params failed!")}}};this.sceneEventHandler.on("createLayer",createLayerHandler,this);this.sceneEventHandler.on("removeLayer",removeLayerHandler,this);this.sceneEventHandler.on("setTimeRange",setTimeRangeHandler,this);this.sceneEventHandler.on("setParameters",setParametersHandler,this);this.sceneEventHandler.on("setResolutionType",setResolutionTypeHandler,this);this.sceneEventHandler.on("setScreenSize",setScreenSizeHandler,this);this.sceneEventHandler.on("updateSeekParamsToJS",updateSeekParamsToJSHandler,this)}}exports.main=Main;exports.Main=Main;
//# sourceMappingURL=main.cjs.js.map
