precision highp float;
varying vec2 texCoord;
varying vec2 sucaiTexCoord;
varying float varOpacity;

uniform sampler2D inputImageTexture;
uniform sampler2D sucaiImageTexture;
uniform sampler2D videoImageTexture;

// uniform float _blendMode;
uniform float intensity;
// uniform float _uniAlpha;

uniform float colorR;
uniform float colorG;
uniform float colorB;
uniform float inputColor;
// uniform vec3 inputRGB;

vec3 blendMultiply(vec3 base, vec3 blend) {
    return base * blend;
}

vec3 blendMultiply(vec3 base, vec3 blend, float opacity) {
    return (blendMultiply(base, blend) * opacity + blend * (1.0 - opacity));
}

void main(void)
{
    vec4 src = texture2D(videoImageTexture, texCoord);
    if(src.a > 0.) src.rgb /= src.a;
    vec4 sucai = texture2D(sucaiImageTexture, sucaiTexCoord);
    vec4 inputimage = texture2D(inputImageTexture, texCoord);
    sucai.rgb = clamp(sucai.rgb * (1.0 / sucai.a), 0.0, 1.0);

    if(inputColor > 0.0){
        sucai.rgb = vec3(colorR, colorG, colorB);
    }

    vec3 color = blendMultiply(src.rgb, sucai.rgb);

    float alpha = sucai.a * intensity* varOpacity;
    color *= alpha;
    gl_FragColor = vec4(color, alpha) * src.a;

}
