local initFlag = true
local male_factor = 0.4
local female_factor = 1.0
local inputColor = 1.0

local maxFaceCount = 10
local currentIndex = -1
local tempOpacitys = {}
local tempMaleOpacitys = {}
local inited = false

local function setAllIntensity(_feature, percentage)
    _feature:setIntensity("mask_faceuv2+2995",percentage)
end

local function setAllOpacity(_feature, vals)
    _feature:setOpacity("mask_faceuv2+2995",vals)
end

local function getValidVal(inputMap, key, default)
    local val = inputMap[key]
    if val==nil then 
        return default
    else
        return val
    end
end

local function initOpacitys()
    for i = 0, maxFaceCount-1 do
        tempOpacitys[i] = 0.0
        tempMaleOpacitys[i] = 1.0
    end
end

EventHandles =
{
    handleEffectEvent = function (this, eventCode)
        if not inited then     
            initOpacitys()
            inited = true
        end
        return true
    end,

    handleComposerUpdateNodeEvent = function (this, path, tag, percentage)
        if not inited then     
            initOpacitys()
            inited = true
        end
        local feature = this:getFeature("FaceMakeupV2_byTool")
        local _feature = EffectSdk.castFaceMakeupV2Feature(feature)
        if (not feature) or (not _feature) then
            print("FaceMakeupV2_byTool is not exist")
            return false
        end
        -- EffectSdk.LOG_LEVEL(5,"zglog: FaceMakeupV2 handleComposerUpdateNodeEvent tag: "..tag.." ,percentage: "..percentage)
        if tag == "currentIndex" then
            print("zglog currentIndex: "..percentage)
            currentIndex = math.floor(percentage)
        end

        if tag == "XTMakeupBlusher" then
            print("zglog percentage: "..percentage)
            if currentIndex < 0 then
                setAllIntensity(_feature, percentage)
            elseif(currentIndex < maxFaceCount) then
                setAllIntensity(_feature, 1.0)
                tempOpacitys[currentIndex] = percentage
                local vals = EffectSdk.vectorf()
                for i = 0,maxFaceCount do
                    local intensity = getValidVal(tempOpacitys, i, 0.0) * getValidVal(tempMaleOpacitys, i, 1.0)
                    vals:push_back(intensity)
                end
                setAllOpacity(_feature, vals)
            end
        end

        _feature:setUniform("mask_faceuv22995","inputColor",inputColor)
        if tag == "R" then
            _feature:setUniform("mask_faceuv22995","colorR",percentage)
        end

        if tag == "G" then
            _feature:setUniform("mask_faceuv22995","colorG",percentage)
        end

        if tag == "B" then
            _feature:setUniform("mask_faceuv22995","colorB",percentage)
        end

    end,
}
