local maxFaceCount = 10
local currentIndex = -1
local faceDetIDArray = {}
local faceDetNum = 0
local tempIntensitys = {}
local basicIntensitys = {}


local faceuFeaturePath = "fd_brow_position/"

-- keep EyeType in structure is for coordination with facepoint structure
local organName =
{
    "DISTORTION_V3_XT_FAR_EYE",
    "DISTORTION_V3_XT_ZOOM_EYE",
    "DISTORTION_V3_XT_ROTATE_EYE",
    "DISTORTION_V3_XT_MOVE_EYE",
    "DISTORTION_V3_XT_ZOOM_NOSE",
    "DISTORTION_V3_XT_MOVE_NOSE",
    "DISTORTION_V3_XT_MOVE_MOUTH",
    "DISTORTION_V3_XT_ZOOM_MOUTH",
    "DISTORTION_V3_XT_MOVE_CHIN",
    "DISTORTION_V3_XT_ZOOM_FOREHEAD",
    "DISTORTION_V3_XT_ZOOM_FACE",
    "DISTORTION_V3_XT_CUT_FACE",
    "DISTORTION_V3_XT_SMALL_FACE",
    "DISTORTION_V3_XT_ZOOM_JAW_BONE",
    "DISTORTION_V3_XT_ZOOM_CHEEK_BONE",
    "DISTORTION_V3_XT_DRAG_LIPS",
    "DISTORTION_V3_XT_CORNER_EYE",
    "DISTORTION_V3_XT_LIP_ENHANCE",
    "DISTORTION_V3_XT_POINTY_CHIN",
    "DISTORTION_V3_XT_TEMPLE",
    " ", -- eye type
    "DISTORTION_V3_XT_VFACE",
    "DISTORTION_V3_XT_RAISE_EYEBROW",
    "DISTORTION_V3_XT_MOVE_EYEBROW"
}

-- 22 items in organParam, [0,20] [22] 是小项，[21]是眼睛类型
-- 自然脸
local organParam =
{
 0.08,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
 -0.2,
    0,
-0.01,
    0,
    0,
    0,
    0,
    0,
    0,
 -0.2,
    2,
    1,
    0,
    0,
}

-- 对齐轻颜
-- small item param range
local organParamRange =
{
    {    0,     0}, -- far eye
    {    0,     0}, -- zoom eye
    {    0,     0}, -- rotate eye
    {    0,     0}, -- move eye
    {    0,     0}, -- zoom nose
    {    0,     0}, -- move nose
    { 0.22, -0.22}, -- move mouth
    {  0.2,  -0.2}, -- zoom mouth
    {    0,     0}, -- move chin
    {    0,     0}, -- zoom forehead
    {    0,     0}, -- zoom face
    {    0,     0}, -- cut face
    {    0,     0}, -- small face
    {    0,     0}, -- jawbone
    {    0,     0}, -- cheek bone
    {    0,     0}, -- mouth corner
    {    0,     0}, -- corner eye
    {    0,     0}, -- lip enhance
    {    0,     0}, -- pointy chin
    {    0,     0}, -- temple
    {    0,     0}, -- eye type
    {    0,     0}, -- vface
    { -1.0,   1.0}, -- raise eyebrow
    { -1.0,   1.0}, -- move eyebrow
}

local organParamPercentageInit =
{
      0.5, -- far eye
        0, -- zoom eye
        0, -- rotate eye
      0.5, -- move eye
        0, -- zoom nose
      0.5, -- move nose
      0.5, -- move mouth
      0.5, -- zoom mouth
0.4117647, -- move chin
      0.5, -- zoom forehead
        0, -- zoom face
        0, -- cut face
        0, -- small face
        0, -- jawbone
        0, -- cheek bone
        0, -- mouth corner
        0, -- corner eye
        0, -- lip enhance
      0.5, -- pointy chin
        0, -- temple
        0, -- eye type
        0, -- vface
        0, -- raise eyebrow
      0.5, -- move eyebrow
}


-- param range in engine
local organMaxInEigine =
{
        3, -- far eye, set default param max value to 3
      0.2, -- zoom eye
        3, -- rotate eye
      0.2, -- move eye
      0.2, -- zoom nose
     0.28, -- move nose
     0.36, -- move mouth
      0.2, -- zoom mouth
      0.2, -- move chin
      0.2, -- zoom forehead
        3, -- zoom face
      0.2, -- cut face
      0.2, -- small face
      0.2,-- jawbone
      0.2, -- cheek bone
      0.2, -- mouse corner
      0.2, -- corner eye
        3, --  lip enhance
      0.2, -- pointy chin
        3, -- temple
        3, -- eye type
        2, -- vface
        2, -- raise eyebrow
        2, -- move eyebrow 
}

local organParamSpecific = {}
local organParamCurrent = {}

local faceuInit = false

-- 确保获取的比例值是在[0,1]区间内
local function validatePercentage(percentage)
    if percentage < 0 then
        percentage = 0
    elseif percentage > 1 then
        percentage = 1
    end
    return percentage
end

-- 确保将要设置到引擎里面的参数在引擎允许值的范围内
local function validateParam(value, index)
    if value > organMaxInEigine[index] then
        value = organMaxInEigine[index]
    elseif value < -organMaxInEigine[index] then
        value = -organMaxInEigine[index]
    end
    return value
end

-- 获取每个小项在特定比例下调整后的具体参数
-- 注意正负非对称的情况，要特殊处理，比如 Internal_Deform_Chin，因为要确保滑竿0.5时没有形变效果
local function getSmallItemValueBy(percentage, index)
    if index == 9 then -- Internal_Deform_Chin
        if percentage < 0.5 then
            percentage = 1 - percentage * 2 -- [0, 0.5) -> [1, 0)
            return percentage * organParamRange[index][1]
        elseif percentage > 0.5 then
            percentage = percentage * 2 - 1 -- (0.5, 1] -> (0, 1]
            return percentage * organParamRange[index][2]
        else
            return 0
        end
    end
    percentage = validatePercentage(percentage)
    return organParamRange[index][1] + percentage * (organParamRange[index][2] - organParamRange[index][1])
end

-- 根据下标和比例设置小项值
local function setIntensityForSmallItem(feature, percentage, index)
    organParamSpecific[index] = getSmallItemValueBy(percentage, index)
    local value = validateParam(organParamSpecific[index] + organParamCurrent[index], index)
    feature:setIntensity(organName[index], value)
end

-- 获取基础脸型调整的具体参数
local function getBasicFaceValueBy(percentage, index)
    percentage = validatePercentage(percentage)
    return percentage * organParam[index]
end

-- 整体 调整基础脸型时设置每个小项的参数
local function setIntensityForBasicFace(feature, percentage, index)
    organParamCurrent[index] = getBasicFaceValueBy(percentage, index)
    local value = validateParam(organParamSpecific[index] + organParamCurrent[index], index)
    feature:setIntensity(organName[index], value)
end

-- 用滑杆的初始值来初始化小项的值
local function initAllSmallItem(feature)
    for i = 1,24 do
        setIntensityForSmallItem(feature, organParamPercentageInit[i], i);
    end
    -- setIntensityForSmallItem(feature, organParamPercentageInit[24], 24);
end

-- 初始化系统参数并使用滑杆初始值来初始化小项的值
local function initSystem(this)
    faceuInit = true
    local organParamCount = #organParam
    for i = 1, organParamCount do
        table.insert(organParamSpecific, i, 0)
        table.insert(organParamCurrent, i, 0)
        -- print("organParamCurrent", i, organParamCurrent[i])
    end

    local feature = this:getFeature(faceuFeaturePath)
    if not feature then
        print("dsFaceu feature nil")
        return
    end
    initAllSmallItem(feature)
end


local function resetIntensity(feature, id, index)
    for i = 1, 22 do
        organParamSpecific[i] = 0
        organParamCurrent[i] = 0
    end

    if id then
        feature:setIntensity("DISTORTION_V3_FACE_ID", id)
    end

    local percentage = basicIntensitys[index]
    if percentage~=nil then 
        for i = 1, 20 do
            setIntensityForBasicFace(feature, percentage, i);
        end
        setIntensityForBasicFace(feature, percentage, 22);
    end
    local IntensityItem = tempIntensitys[index]
    if IntensityItem~=nil then 
        for i, intensity in pairs(IntensityItem) do
            setIntensityForSmallItem(feature, intensity, i)
        end
    end
end
local function updateFaceId(this)
    local Bundle = this:getEffectManager():getBundleInfo()
    if not Bundle then
        print("dsFaceu Bundle nil")
        return
    end
    faceDetIDArray = {}
    for i = 0, maxFaceCount do
        local pts = Bundle:GetFloatArray("cv248points_"..i)
        if pts~=nil then
            local id = Bundle:GetInt("cv248id_"..i)
            faceDetIDArray[i] = id
        else
            faceDetNum = i
            return
        end
    end
end
local function updataIDIntensity(this, oldFaceDetNum, oldIDArray, newFaceDetNum, newIDArray)
    local feature = this:getFeature(faceuFeaturePath)
    if not feature then
        print("dsFaceu feature nil")
        return
    end
    -- if oldFaceDetNum ~= newFaceDetNum then
    --     tempIntensitys = {}
    --     return
    -- end
    for index, IntensityItem in pairs(tempIntensitys) do
        print("dsFaceu index = "..index)
        if(index >= 0 and index < newFaceDetNum) then
            local ID = newIDArray[index]
            print("dsFaceu new id = "..ID)
            resetIntensity(feature, ID, index)
        end
    end
    local currentID = newIDArray[currentIndex]
    if(currentID ~= nil) then
        feature:setIntensity("DISTORTION_V3_FACE_ID", currentID)
        resetIntensity(feature, currentID, currentIndex)
    end
end
local function setTempIntensity(tag, percentage)
    if (tag == "fd_intensity") then
        basicIntensitys[currentIndex] = percentage
    -- 眼间距
    elseif (tag == "Internal_Eye_Spacing") then
        tempIntensitys[currentIndex][1] = percentage
    -- 大眼
    elseif (tag == "Internal_Deform_Eye") then
        tempIntensitys[currentIndex][2] = percentage
    -- 眼上下
    elseif (tag == "Internal_Deform_MoveEye") then
        tempIntensitys[currentIndex][4] = percentage
    -- 瘦鼻
    elseif (tag == "Internal_Deform_Nose") then
        tempIntensitys[currentIndex][5] = percentage
     -- 长鼻
    elseif (tag == "Internal_Deform_MovNose") then
        tempIntensitys[currentIndex][6] = percentage
    -- 缩人中
    elseif (tag == "fd_mouse") then         -- 嘴型
        tempIntensitys[currentIndex][8] = percentage
    elseif (tag == "fd_mouse_position") then      -- 嘴位置
        tempIntensitys[currentIndex][7] = percentage
    -- 下巴
    elseif (tag == "Internal_Deform_Chin") then
        tempIntensitys[currentIndex][9] = percentage
    -- 额头/发际线
    elseif (tag == "Internal_Deform_Forehead") then
        tempIntensitys[currentIndex][10] = percentage
    -- 削脸/窄脸
    elseif (tag == "Internal_Deform_CutFace") then
        tempIntensitys[currentIndex][12] = percentage
    -- 小脸
    elseif tag == "Internal_Deform_SmallFace" then
        tempIntensitys[currentIndex][13] = percentage
    -- 瘦下颌骨
    elseif (tag == "Internal_Deform_Zoom_Jawbone") then
        tempIntensitys[currentIndex][14] = percentage
    -- 瘦颧骨
    elseif (tag == "Internal_Deform_Zoom_Cheekbone") then
        tempIntensitys[currentIndex][15] = percentage
    -- 微笑嘴角
    elseif (tag == "Internal_Deform_MouthCorner") then
        tempIntensitys[currentIndex][16] = percentage
    -- 开眼角
    elseif (tag == "Internal_Deform_CornerEye") then
        tempIntensitys[currentIndex][17] = percentage
    -- 尖下巴
    elseif (tag == "Internal_Deform_ChinSharp") then
        tempIntensitys[currentIndex][19] = percentage
    -- V 脸
    elseif (tag == "Internal_Deform_VFace") then
        tempIntensitys[currentIndex][22] = percentage
    -- 眉毛移动
    elseif (tag == "fd_brow_position") then
        tempIntensitys[currentIndex][24] = percentage
    end
end

print("dsFaceu handleComposerUpdateNodeEvent path = !!!!!!!!!!!!!!")
EventHandles =
{
    handleComposerUpdateNodeEvent = function (this, path, tag, percentage)
        -- 和composer配合使用时，有可能handleComposerUpdateNodeEvent调用在handleEffectEvent之前，
        -- 所以这里要考虑初始化
        if not faceuInit then
            print("dsFaceu handleComposerUpdateNodeEvent init")
            initSystem(this)
        end

        print("dsFaceu handleComposerUpdateNodeEvent path = ", path, "\n")
        print("dsFaceu handleComposerUpdateNodeEvent tag = ", tag, "\n")
        print("dsFaceu handleComposerUpdateNodeEvent value = ", percentage, "\n")
        local feature = this:getFeature(faceuFeaturePath)
        if not feature then
            print("dsFaceu feature nil")
            return
        end

        if (tag == "currentIndex") then
            updateFaceId(this)
            currentIndex = math.floor(percentage)
            local currentID = faceDetIDArray[currentIndex]
            if currentID == nil then
                print("dsFaceu currentID nil")
                return
            end
            resetIntensity(feature, currentID, currentIndex)
            if currentID then
                feature:setIntensity("DISTORTION_V3_FACE_ID", currentID)
            end
        end
        if (tag == "currentID") then
            updateFaceId(this)
            local currentID = math.floor(percentage)
            currentIndex = -1
            for index, ID in pairs(faceDetIDArray) do
                if ID == currentID then
                    currentIndex = index
                end
            end
            if currentIndex < 0  then
                return
            end
            resetIntensity(feature, currentID, currentIndex)
            feature:setIntensity("DISTORTION_V3_FACE_ID", currentID)
        end
        if(tempIntensitys[currentIndex] == nil) then
            tempIntensitys[currentIndex] = {}
        end
        if currentIndex >= 0 then
            setTempIntensity(tag, percentage)
            local currentID = faceDetIDArray[currentIndex]
            if(currentID == nil) then
                print("dsFaceu currentID nil")
                return
            end
            feature:setIntensity("DISTORTION_V3_FACE_ID", currentID)
        end
        -- setIntensityForSmallItem(feature, 1.0, 24)

        --  整体
        if (tag == "fd_intensity") then
            basicIntensitys[currentIndex] = percentage
            for i = 1, 20 do
                setIntensityForBasicFace(feature, percentage, i);
            end
            setIntensityForBasicFace(feature, percentage, 22);
            return
        -- 眼间距
        elseif (tag == "Internal_Eye_Spacing") then
            setIntensityForSmallItem(feature, percentage, 1)
            tempIntensitys[currentIndex][1] = percentage
        -- 大眼
        elseif (tag == "Internal_Deform_Eye") then
            setIntensityForSmallItem(feature, percentage, 2)
            tempIntensitys[currentIndex][2] = percentage
        -- 眼上下
        elseif (tag == "Internal_Deform_MoveEye") then
            setIntensityForSmallItem(feature, percentage, 4)
            tempIntensitys[currentIndex][4] = percentage
        -- 瘦鼻
        elseif (tag == "Internal_Deform_Nose") then
            setIntensityForSmallItem(feature, percentage, 5)
            tempIntensitys[currentIndex][5] = percentage
         -- 长鼻
        elseif (tag == "Internal_Deform_MovNose") then
            setIntensityForSmallItem(feature, percentage, 6)
            tempIntensitys[currentIndex][6] = percentage
        -- 缩人中
        elseif (tag == "fd_mouse") then         -- 嘴型
            setIntensityForSmallItem(feature, percentage, 8)
            tempIntensitys[currentIndex][8] = percentage
        elseif (tag == "fd_mouse_position") then      -- 嘴位置
            setIntensityForSmallItem(feature, percentage, 7)
            tempIntensitys[currentIndex][7] = percentage
        elseif (tag == "Internal_Deform_Chin") then
            setIntensityForSmallItem(feature, percentage, 9)
            tempIntensitys[currentIndex][9] = percentage
        -- 额头/发际线
        elseif (tag == "Internal_Deform_Forehead") then
            setIntensityForSmallItem(feature, percentage, 10)
            tempIntensitys[currentIndex][10] = percentage
        -- 削脸/窄脸
        elseif (tag == "Internal_Deform_CutFace") then
            setIntensityForSmallItem(feature, percentage, 12)
            tempIntensitys[currentIndex][12] = percentage
        -- 小脸
        elseif tag == "Internal_Deform_SmallFace" then
            setIntensityForSmallItem(feature, percentage, 13)
            tempIntensitys[currentIndex][13] = percentage
        -- 瘦下颌骨
        elseif (tag == "Internal_Deform_Zoom_Jawbone") then
            setIntensityForSmallItem(feature, percentage, 14)
            tempIntensitys[currentIndex][14] = percentage
        -- 瘦颧骨
        elseif (tag == "Internal_Deform_Zoom_Cheekbone") then
            setIntensityForSmallItem(feature, percentage, 15)
            tempIntensitys[currentIndex][15] = percentage
        -- 微笑嘴角
        elseif (tag == "Internal_Deform_MouthCorner") then
            setIntensityForSmallItem(feature, percentage, 16)
            tempIntensitys[currentIndex][16] = percentage
        -- 开眼角
        elseif (tag == "Internal_Deform_CornerEye") then
            setIntensityForSmallItem(feature, percentage, 17)
            tempIntensitys[currentIndex][17] = percentage
        -- 尖下巴
        elseif (tag == "Internal_Deform_ChinSharp") then
            setIntensityForSmallItem(feature, percentage, 19)
            tempIntensitys[currentIndex][19] = percentage
        -- V 脸
        elseif (tag == "Internal_Deform_VFace") then
            setIntensityForSmallItem(feature, percentage, 22)
            tempIntensitys[currentIndex][22] = percentage
        -- 眉毛移动
        elseif (tag == "fd_brow_position") then
            -- setIntensityForSmallItem(feature, percentage, 23)
            setIntensityForSmallItem(feature, percentage, 24)
            tempIntensitys[currentIndex][24] = percentage
        end
        return true
    end,
    handleEffectEvent = function(this, eventCode)
        if not faceuInit then
            print("dsFaceu handleEffectEvent init")
            initSystem(this)
        end
        return true
    end,
    handleFaceInfoEvent = function(this, faceInfo)
        print("dsFaceu handleFaceInfoEvent")
        local newfaceDetNum = faceInfo:getFaceCount()
        local newfaceDetIDArray = {}
        for i = 0, newfaceDetNum - 1 do
            newfaceDetIDArray[i] = faceInfo:getFaceID(i)
            print("dsFaceu handleFaceInfoEvent getFaceID: ", faceInfo:getFaceID(i))
        end
        print("dsFaceu handleFaceInfoEvent newfaceDetNum: ", newfaceDetNum)
        updataIDIntensity(this, faceDetNum, faceDetIDArray, newfaceDetNum, newfaceDetIDArray)
        faceDetNum = newfaceDetNum
        faceDetIDArray = newfaceDetIDArray
    end,
}
