local featurePath = "ManualLiquefy/"
local manualLiquefyFeature = nil

local width = 720
local height = 1280

local RADIUS_MIN = 100 -- 再大一些？
local RADIUS_MAX = 700
local radiusPercent = 0.5
local intensityPercent = 0.5
local hardnessPercent = 0.5
local speedPercent = 0.5
local scale = 1.0

local lastPos = nil

local curType = 0

local EPSC = 0.001

local enableActions = true

-- 单次位移距离过长，需要分成几段
local function setTouchInfo(feature, pt1, pt2)
    -- print('ManualLiquefy width ' .. width .. ' height '.. height)
    local radius = RADIUS_MIN + (RADIUS_MAX - RADIUS_MIN) * radiusPercent
    radius = radius / scale
    -- radius = 25

    local pos_s = {pt1.x * width, pt1.y * height}
    local pos_t = {pt2.x * width, pt2.y * height}
    local vct = {pos_t[1] - pos_s[1], pos_t[2] - pos_s[2]}
    local dist = math.sqrt(vct[1] * vct[1] + vct[2] * vct[2])
    if dist <= EPSC then
        return
    end
    local direct = {vct[1]/dist, vct[2]/dist}
    local deltaD = math.min(dist, radius)
    
    local posList = {}
    posList[1] = {pos_s[1], pos_s[2]}
    local i = 1
    while i * deltaD <= dist do
        posList[i+1] = {pos_s[1] + direct[1] * i * deltaD, pos_s[2] + direct[2] * i * deltaD}
        i = i + 1
    end
    for j=1, #posList-1 do
        local _pt1 = EffectSdk.Vec2(posList[j][1]/width, posList[j][2]/height)
        local _pt2 = EffectSdk.Vec2(posList[j+1][1]/width, posList[j+1][2]/height)
        feature:setTouchInfo(_pt1, _pt2)
    end
    print('ManualLiquefy path split num: ' .. i)
    -- feature:setTouchInfo(pt1, pt2)
end

EventHandles =
{
    handleEffectEvent = function (this, eventCode)
        this:addTimer( 3214341, EffectSdk.BEF_TIMER_EVENT_CIRCLE, 10)
        local effectManager = this:getEffectManager()
        if(effectManager) then
            width = effectManager:getInputWidth()
            height = effectManager:getInputHeight()
        end
        return true
    end,

    -- 一帧可能调用多次
    handleManipulateEvent = function (this, eventCode, x, y, dx, dy)
        -- print('ManualLiquefy handleManipulateEvent '..eventCode)
        if not enableActions then
            return
        end
        if eventCode ~= 4 then
            lastPos = nil
        end
        if eventCode == 0 then
            lastPos = EffectSdk.Vec2(x, y)
        end
        if(eventCode == 4) then
            -- print('values are '..x..' '..y..' '..dx..' '..dy)
            if not manualLiquefyFeature then
                local _feature = this:getFeature(featurePath)
                manualLiquefyFeature = EffectSdk.castManualLiquefyFeature(_feature)
            end

            if manualLiquefyFeature then
                local pt1 = lastPos
                local pt2 = EffectSdk.Vec2(x, y)
                lastPos = pt2
                -- manualLiquefyFeature:setTouchInfo(pt1, pt2)
                setTouchInfo(manualLiquefyFeature, pt1, pt2)
            end
        end
    end,

    handleTouchEvent = function(this, eventCode, screenX, screenY)
        local feature = this:getFeature(featurePath)
        if not feature then
            print("manualLiquefy feature nil")
            return
        end
        curType = curType + 1
        if curType > 3 then
            curType = 0
        end
        -- feature:setIntensity("MANUAL_LIQUEFY_TYPE", curType)
        return true
    end,

        -- 滑竿控制大小、强度、浓度
    handleComposerUpdateNodeEvent = function (this, path, tag, percentage)
        print("manualLiquefy composerUpdateNode path = ", path, "\n")
        print("manualLiquefy composerUpdateNode tag = ", tag, "\n")
        print("manualLiquefy composerUpdateNode value = ", percentage, "\n")
        if tag == "internal_manual_liquefy_enable" then
            if percentage < 0.5 then
                enableActions = false
            elseif percentage >= 0.5 then
                enableActions = true
            end
        end
        if not enableActions then
            return
        end
        local feature = this:getFeature(featurePath)
        if not feature then
            print("manualLiquefy feature nil")
            return
        end
        if tag == "internal_manual_liquefy_radius" then
            radiusPercent = percentage
            -- radius 范围限制
            local radius = RADIUS_MIN + (RADIUS_MAX - RADIUS_MIN) * radiusPercent
            radius = radius / scale -- 关联scale
            feature:setIntensity("MANUAL_LIQUEFY_RADIUS", radius) -- radius 需要传绝对值
        elseif tag == "internal_manual_liquefy_intensity" then
            intensityPercent = percentage
            -- intensity 关联半径？
            local intensity = percentage * 0.5 -- 强度修正，避免强度过大
            feature:setIntensity("MANUAL_LIQUEFY_INTENSITY", intensity)
        elseif tag == "internal_manual_liquefy_hardness" then
            hardnessPercent = percentage
            -- 约束到0.1-0.6
            local hardness = 0.1 + (0.6 - 0.1) * percentage
            hardness = 0.5 / (1.0 - hardness)
            feature:setIntensity("MANUAL_LIQUEFY_HARDNESS", hardness)
        elseif tag == "internal_manual_liquefy_speed" then
            speedPercent = percentage
            feature:setIntensity("MANUAL_LIQUEFY_SPEED", percentage)
        elseif tag == "internal_manual_liquefy_type" then
            feature:setIntensity("MANUAL_LIQUEFY_TYPE", percentage)
        elseif tag == "internal_manual_liquefy_scale" then
            scale = percentage -- scale 可能大于1
            local radius = RADIUS_MIN + (RADIUS_MAX - RADIUS_MIN) * radiusPercent
            radius = radius / scale
            feature:setIntensity("MANUAL_LIQUEFY_RADIUS", radius)
        end
    end,

    handleAnimationEvent = function (this, entityName, clipName, eventCode)
    end,

    handleSceneInfoEvent = function(this, sceneInfo)

    end,

    handleTimerEvent = function (this, timerId, milliSeconds)
        if timerId ~= 3214341 then
            return
        end
        local feature = this:getFeature(featurePath)
        if not feature then
            print("manualLiquefy feature nil")
            return
        end
        -- feature:setIntensity("MANUAL_LIQUEFY_RADIUS", 50)
        -- feature:setIntensity("MANUAL_LIQUEFY_TYPE", 1)
        
        -- print('ManualLiquefy handleTimerEvent ')
		return true
    end
}
