precision highp float;
varying vec2 texCoord;
varying vec2 sucaiTexCoord;
varying float varOpacity;

uniform sampler2D inputImageTexture; // 原图
uniform sampler2D sucaiImageTexture; // 素材
// uniform float _blendMode;
uniform float intensity;

// uniform float inputColor;
// uniform vec3 inputRGB;

vec4 blendFunc(vec4 base, vec4 blend, float blendMode){
    vec4 result = vec4(0., 0., 0., 1.);
    if(blendMode < 0.5) // normal
        result.rgb = blend.rgb;
    else if(blendMode < 1.5) // add
        result.rgb = clamp(base.rgb+blend.rgb, 0., 1.);
    else if(blendMode < 2.5) // average
        result.rgb = clamp((base.rgb+blend.rgb)/2., 0., 1.);
    else if(blendMode < 3.5) // color burn
        result.rgb = clamp((base.rgb+blend.rgb-1.)/blend.rgb, 0., 1.);
    else if(blendMode < 4.5) // color dodge
        result.rgb = clamp(blend.rgb/(1.-base.rgb), 0., 1.);
    else if(blendMode < 5.5) // color darken
        result.rgb = clamp(min(base.rgb, blend.rgb), 0., 1.);
    else if(blendMode < 6.5) // difference
        result.rgb = clamp(abs(base.rgb-blend.rgb), 0., 1.);
    else if(blendMode < 7.5) // exclusion
        result.rgb = clamp(base.rgb+blend.rgb-2.*base.rgb*blend.rgb, 0., 1.);
    // glow
    else if(blendMode < 9.5) // hard light
        result.rgb = clamp(mix(2.*blend.rgb*base.rgb, 1.-2.*(1.-base.rgb)*(1.-blend.rgb), step(0.5, blend.rgb)), 0., 1.);
    else if(blendMode < 10.5) // hard mix
        result.rgb = clamp(step(1.-base.rgb, blend.rgb), 0., 1.);
    else if(blendMode < 11.5) // lighten
        result.rgb = clamp(max(base.rgb,blend.rgb), 0., 1.);
    else if(blendMode < 12.5) // linear burn
        result.rgb = clamp(base.rgb+blend.rgb-1., 0., 1.);
    else if(blendMode < 13.5) // linear dodge
        result.rgb = clamp(base.rgb+blend.rgb, 0., 1.);
    else if(blendMode < 14.5) // linear light
        result.rgb = clamp(blend.rgb+2.*base.rgb-1., 0., 1.);
    else if(blendMode < 15.5) // multiply
        result.rgb = clamp(blend.rgb*base.rgb, 0., 1.);
    // negation
    else if(blendMode < 17.5) // overlay
        result.rgb = clamp(mix(2.*blend.rgb*base.rgb, 1.-2.*(1.-base.rgb)*(1.-blend.rgb), step(0.5, base.rgb)), 0., 1.);
    // phoenix
    else if(blendMode < 19.5){ // pin light
        result.rgb = mix(2.*blend.rgb-1., base.rgb, step(2.*blend.rgb-1., base.rgb));
        result.rgb = clamp(mix(1.*blend.rgb, result.rgb, step(blend.rgb, 2.*base.rgb)), 0., 1.);
    }
    //reflect
    else if(blendMode < 21.5) // screen
        result.rgb = clamp(1.-(1.-base.rgb)*(1.-blend.rgb), 0., 1.);
    else if(blendMode < 22.5) // soft light
        result.rgb = clamp(mix(2.*blend.rgb*base.rgb+base.rgb*base.rgb*(1.-2.*blend.rgb), 2.*base.rgb*(1.-blend.rgb)+sqrt(base.rgb)*(2.*blend.rgb-1.), step(0.5, blend.rgb)), 0., 1.);
    else if(blendMode < 23.5) // substract
        result.rgb = clamp(base.rgb-blend.rgb, 0., 1.);
    else if(blendMode < 24.5) // vivid
        result.rgb = clamp(mix(2.*blend.rgb+base.rgb-1., base.rgb/(2.*(1.-blend.rgb)), step(0.5, blend.rgb)), 0., 1.);
    else if(blendMode < 25.5){ // color
        
    }
    else if(blendMode < 26.5){ // hue
        
    }
    // result.rgb = mix(base.rgb, result.rgb, base.a);
    //            result = mix(base, result, blend.a);
    // 输入默认为有预乘
    // result.rgb = result.rgb * clamp(blend.a * 100.0, 0.0, 1.0) * intensity;
    // result = vec4(result.rgb * _intensity + (1.0 - blend.a * _intensity) * base.rgb, 1.0);
    return result;
}

// void main(){
//     vec4 base = texture2D(inputImageTexture, texCoord);
//     vec4 blend = texture2D(sucaiImageTexture, sucaiTexCoord);

//     // if(inputColor > 0.0){
//     //     blend.rgb = inputRGB;
//     // }
//     // gl_FragColor = mix(base, blendFunc(base, blend, _blendMode), _intensity);
//     gl_FragColor = vec4(blendFunc(base, blend, 15.0).rgb, blend.a * intensity);
//     }
void main(void)
{    
    vec4 src = texture2D(inputImageTexture, texCoord);
    if(src.a > 0.) src.rgb /= src.a;
    vec4 sucai = texture2D(sucaiImageTexture, sucaiTexCoord);
    
    sucai.rgb = clamp(sucai.rgb * (1.0 / sucai.a), 0.0, 1.0);
    // sucai.rgb = vec3(1.0, 0.0, 0.0);
    vec3 color = blendFunc(src, sucai, 21.0).rgb;
    color = mix(src.rgb, color, sucai.a);
    color = mix(src.rgb, color, intensity* varOpacity);
    gl_FragColor = vec4(color, 1.0) * src.a;
}