local initFlag = true
local male_factor = 0.4
local female_factor = 1.0
local inputColor = 1.0

EventHandles =
{
    handleGenderEvent = function(this, genderInfo)
        local feature = this:getFeature("FaceMakeupV2_byTool")
        local _feature = EffectSdk.castFaceMakeupV2Feature(feature)

        if (not feature) or (not _feature) then
            EffectSdk.LOG_LEVEL(5,"FaceMakeupV2 is not exist")
            return false
        end

        local _vals_lips = EffectSdk.vectorf()

        local effect_manager      = this:getEffectManager()
        local isMaleMakeupOpen    = effect_manager:getMaleMakeupState()
        local _male_factor        = male_factor
        if not isMaleMakeupOpen then
            _male_factor = female_factor
        end

        for i = 0,4 do
            if genderInfo:isMan(i) > 0.6 then
                _vals_lips:push_back(_male_factor)
            elseif genderInfo:isMan(i) < 0.4 then
                _vals_lips:push_back(female_factor)
            else
                _vals_lips:push_back(female_factor)
            end
        end

        _feature:setOpacity("eye_part_faceu+2991", _vals_lips)
        _feature:setOpacity("eye_part_faceu+2992", _vals_lips)
        _feature:setOpacity("jiemao_faceu+2990", _vals_lips)

    end,

    handleComposerUpdateNodeEvent = function (this, path, tag, percentage)
        local feature = this:getFeature("FaceMakeupV2_byTool")
        local _feature = EffectSdk.castFaceMakeupV2Feature(feature)
        if (not feature) or (not _feature) then
            print("FaceMakeupV2_byTool is not exist")
            return false
        end
        if tag == "XTMakeupEyeLine" then
            _feature:setIntensity("eye_part_faceu+2990",percentage)
        end

        _feature:setUniform("eye_part_faceu2990","inputColor",inputColor)--标志位是否开启颜色输入模式
        if tag == "R" then
            _feature:setUniform("eye_part_faceu2990","colorR",percentage)
        end

        if tag == "G" then
            _feature:setUniform("eye_part_faceu2990","colorG",percentage)
        end

        if tag == "B" then
            _feature:setUniform("eye_part_faceu2990","colorB",percentage)
        end
    end,
}
