precision highp float;

uniform sampler2D uCustomAlgoTexture;
uniform sampler2D uLastStrokeTexture;
uniform sampler2D inputTexture;
uniform float uColorR;
uniform float uColorG;
uniform float uColorB;
uniform float uColorA;

varying vec2 vTextureCoord;

void main()
{
    lowp vec4 resultColor = texture2D(uCustomAlgoTexture, vTextureCoord);
    float alpha =  texture2D(inputTexture, vTextureCoord).a;
    if(alpha > 0.0) resultColor.rgb /= alpha;

    if (uColorA > 0.001)
    {
        lowp vec3 highLightColor = vec3(uColorR, uColorG, uColorB);
        lowp float mixture = texture2D(uLastStrokeTexture, vTextureCoord).a * 0.7;

        resultColor.rgb = mix(resultColor.rgb, highLightColor, mixture * uColorA);
    }        

    gl_FragColor = vec4(resultColor.rgb, 1.0) * alpha;
}
