#version 300 es
precision highp float;

uniform sampler2D u_inputTexture;
uniform sampler2D u_inputMask;
uniform sampler2D u_inputSearchMask;
uniform sampler2D u_inpaintTexture;
uniform sampler2D u_targetToSource;
uniform sampler2D u_targetTexture;
uniform float u_level;
uniform float u_seed;
uniform vec4 uResolution;
uniform vec2 uPatchSize;
uniform bool u_isStart;

in vec2 v_TextureCoordinates;
layout(location=0) out vec4 out_targetToSource;

#define  MAX_RETRY 100

bool isMask(sampler2D mask, vec2 texcoor, float level)
{
    return textureLod(mask, texcoor, level).a > 0.99;
}

bool isAlphaMask(sampler2D mask, vec2 texcoor, float level)
{
    return textureLod(mask, texcoor, level).a > 0.0;
}

float random(vec2 uv)
{
    return fract(sin(dot(uv, vec2(12.9898, 78.233))) * u_seed);
}

bool equalTof(float a, float b)
{
    return abs(a - b) <= 0.000001;
}

bool needSkip(vec2 coor_ks, vec2 coor_kt, float level)
{
    if (coor_ks.x < 0.0 || coor_ks.x > 1.0) {return true;}
    if (coor_ks.y < 0.0 || coor_ks.y > 1.0) {return true;}

    if (coor_kt.x < 0.0 || coor_kt.x > 1.0) {return true;}
    if (coor_kt.y < 0.0 || coor_kt.y > 1.0) {return true;}

    if (u_isStart)
    {
        if (isMask(u_inputMask, coor_ks, level)) { return true; }
        if (isMask(u_inputMask, coor_kt, level)) { return true; }
    }
    else
    {
        if (isAlphaMask(u_targetTexture, coor_ks, level)) { return true; }
        if (isMask(u_inputMask, coor_ks, level) && isMask(u_inputSearchMask, coor_kt, level) ) { return true; }

        if (isMask(u_inputMask, coor_kt, level)) { return true; }
        if (isAlphaMask(u_targetTexture, coor_kt, level) && isMask(u_inputSearchMask, coor_ks, level) ) { return true; }
    }
    return false;
}

float pixelDistance(sampler2D srcTex, vec2 coord, vec2 r_coord, float level)
{
    float dis = 0.0, wsum = 0.0;
    ///ssd: Sum of Squared Difference: RGB_value + gradient_x + gradient_y
    float ssdmax = 3.0;

    for (float dy0 = -uPatchSize.y; dy0 <= uPatchSize.y; dy0 += 1.0)
    {
        for (float dx0 = -uPatchSize.x; dx0 <= uPatchSize.x; dx0 += 1.0)
        {
            vec2 d = vec2(dx0, dy0) * uResolution.zw;
            vec2 coor_ks = coord + d;
            vec2 coor_kt = r_coord + d;

            wsum += 1.0;

            if (needSkip(coor_ks, coor_kt, level))
            {
                dis += 1.0;
                continue;
            }

            vec3 s_value = textureLod(srcTex, coor_ks, level).rgb;
            vec3 t_value = textureLod(srcTex, coor_kt, level).rgb;
            vec3 ssd_value_vec = (s_value - t_value) * (s_value - t_value);
            float s_inpaint = textureLod(u_inpaintTexture, coor_ks, level).a;
            float t_inpaint = textureLod(u_inpaintTexture, coor_kt, level).a;
            float ssd_inpaint = (s_inpaint - t_inpaint) * (s_inpaint - t_inpaint) * 3.0;
            float ssd = mix(ssd_inpaint, dot(ssd_value_vec, vec3(1.0)), 0.75);

            dis += (ssd / ssdmax);
        }
    }

    float res = dis / wsum;
    return clamp(res, res, 1.0);
}

vec4 offset2Texture(vec2 offset, float dis)
{
    float dir = step(0.0, offset.x) * 0.25 + step(0.0, offset.y) * 0.5 + 0.25;
    return vec4(abs(offset), dis, dir);
}

vec4 texture2Offset(vec4 offsetColor)
{
    int index = int(round(offsetColor.w * 4.0 - 1.0)); // int(round((offsetColor.w - 0.25) * 4.0));

    // Android
    // vec2 dir = vec2(
    //     float((index + 2) % 2 * 2 - 1),
    //     float(int(index >= 2) * 2 - 1)
    // );
    // return vec4(offsetColor.xy * dir, offsetColor.z, 1.0);

    // iOS
    vec2 g_direction[4];
    g_direction[0] = vec2(-1.0, -1.0);
    g_direction[1] = vec2( 1.0, -1.0);
    g_direction[2] = vec2(-1.0,  1.0);
    g_direction[3] = vec2( 1.0,  1.0);
    return vec4(offsetColor.xy * g_direction[index], offsetColor.z, 1.0);
}

void main()
{
    vec2 texCoord = v_TextureCoordinates;

    if (u_isStart)
    {
        // prevent uv(0.0, 0.0) miss random hit
        float offest_seed = u_seed / 1000.0;
        vec2 input_coord = step(texCoord.x + texCoord.y, 0.0) * offest_seed + texCoord;

        vec2 r_coord;
        r_coord.x = random(input_coord);
        // prevent divide by zero
        r_coord.y = random(1.0 / (input_coord + r_coord.x));

        r_coord = floor(r_coord * 10000.0);
        r_coord.x = float(int(r_coord.x) % int(uResolution.x)) * uResolution.z;
        r_coord.y = float(int(r_coord.y) % int(uResolution.y)) * uResolution.w;

        int iter = 0;
        while (textureLod(u_inputMask, r_coord , u_level).a > 0.0 && iter < MAX_RETRY)
        {
            input_coord = r_coord;

            r_coord.x = random(input_coord);
            r_coord.y = random(1.0 / (input_coord + r_coord.x));

            r_coord = floor(r_coord * 10000.0);
            r_coord.x = float(int(r_coord.x) % int(uResolution.x)) * uResolution.z;
            r_coord.y = float(int(r_coord.y) % int(uResolution.y)) * uResolution.w;

            iter++;
        }

        float dis = pixelDistance(u_inputTexture, texCoord, r_coord, u_level);

        out_targetToSource = offset2Texture(r_coord - texCoord, dis);
    }
    else
    {
        //target2source
        vec2 v_TextureCoordinatesMain = texCoord;
        vec2 curCoor = texCoord * uResolution.xy;
        curCoor = vec2(ceil(curCoor.x) + 1.0, ceil(curCoor.y) + 1.0);
        curCoor = vec2(floor(curCoor.x * 0.5) - 1.0, floor(curCoor.y * 0.5) - 1.0);
        curCoor = curCoor * 2.0 + vec2(1.0, 1.0);
        v_TextureCoordinatesMain = curCoor * uResolution.zw;

        vec4 preOffset = texture2Offset(textureLod(u_targetToSource, v_TextureCoordinatesMain, u_level + 1.0));
        vec2 upscaleOffset;
        if( equalTof(preOffset.x, 0.0) && equalTof(preOffset.y, 0.0) )
        {
            upscaleOffset = texCoord;
        }
        else{
            upscaleOffset = preOffset.xy + texCoord;
        }
        float dis = pixelDistance(u_targetTexture, texCoord, upscaleOffset, u_level);
        out_targetToSource =  offset2Texture(preOffset.xy, dis);
    }
}
