#version 300 es
precision highp float;

uniform sampler2D u_inputTexture;
uniform sampler2D u_inputMask;
uniform sampler2D u_targetToSource;
uniform sampler2D u_targetTexture;

uniform vec4 uResolution;
uniform vec2 uPatchSize;
uniform vec2 uLevel; // level and mainLevel
uniform float uSimilSize;
uniform bool u_isFirst;
uniform bool u_upScale;

in vec2 v_TextureCoordinates;
layout(location=0) out vec4 out_targetColor;

#define  MAX_DISTANCE 65535.0

bool isMask(sampler2D mask, vec2 texcoor, float level)
{
    return textureLod(mask, texcoor, level).a > 0.99;
}

vec4 offset2Texture(vec2 offset, float dis)
{
    float dir = step(0.0, offset.x) * 0.25 + step(0.0, offset.y) * 0.5 + 0.25;
    return vec4(abs(offset), dis, dir);
}

vec4 texture2Offset(vec4 offsetColor)
{
    int index = int(round(offsetColor.w * 4.0 - 1.0)); // int(round((offsetColor.w - 0.25) * 4.0));

    // Android
    // vec2 dir = vec2(
    //     float((index + 2) % 2 * 2 - 1),
    //     float(int(index >= 2) * 2 - 1)
    // );
    // return vec4(offsetColor.xy * dir, offsetColor.z, 1.0);

    // iOS
    vec2 g_direction[4];
    g_direction[0] = vec2(-1.0, -1.0);
    g_direction[1] = vec2( 1.0, -1.0);
    g_direction[2] = vec2(-1.0,  1.0);
    g_direction[3] = vec2( 1.0,  1.0);
    return vec4(offsetColor.xy * g_direction[index], offsetColor.z, 1.0);
}

vec4 weightedCopy(vec2 newCoord, float w, float level)
{
    return vec4(w * textureLod(u_inputTexture, newCoord, level).rgb, w);
}

vec4 voteForTarget(sampler2D offsetMap, vec2 coord, vec3 curOffest, ivec2 step)
{
    vec4 result = vec4(0.0);

    ////////////weight calculation/////////
    float w = 1.0;
    ////////////vote calculation/////////
    vec2 resolution = uResolution.xy;
    vec2 resolutionInverse = uResolution.zw;

    if (u_upScale)
    {
        resolution *= 0.5;
        resolutionInverse += resolutionInverse;
    }

    vec2 xys = (curOffest.xy + coord) * uResolution.xy;
    vec2 xyt = coord * uResolution.xy;

    if (xys.x < 0.0 || xys.x > uResolution.x) {return result;}
    if (xys.y < 0.0 || xys.y > uResolution.y) {return result;}
    if (xyt.x < 0.0 || xyt.x > uResolution.x) {return result;}
    if (xyt.y < 0.0 || xyt.y > uResolution.y) {return result;}

    vec2 newTexCoor = coord + curOffest.xy;
    if (isMask(u_inputMask, newTexCoor, uLevel.x))
    {
        return result;
    }

    vec2 off_tem = curOffest.xy * resolution;

    int off_x =  int(round(off_tem.x));
    int off_y =  int(round(off_tem.y));

    int dis_x = abs(off_x - step.x);
    int dis_y = abs(off_y - step.y);

    float nw = 1.0;

    if (uSimilSize > 1.0 || uSimilSize < 0.5)
    {
        float dis_yn = float(dis_y) * resolution.y;
        nw = 1.0 / (dis_yn + 1.0);
    }
    else
    {
        nw = 1.0 / float(min(dis_x, dis_y) + 1);
    }

    if (uLevel.y < 1.0)
    {
        nw = 1.0;
    }

    //vote
    result += weightedCopy(newTexCoor, w * nw, uLevel.x);

    return result;
}

void main()
{
    vec4 voteColor = vec4(0.0);
    vec2 resolutionInverse = uResolution.zw * (float(u_upScale) + 1.0);

    for (float dx = -uPatchSize.x; dx <= uPatchSize.x; dx += 1.0)
    {
        for (float dy = -uPatchSize.y; dy <= uPatchSize.y; dy += 1.0)
        {
            vec2 v_TextureCoordinatesMain = v_TextureCoordinates;

            if (u_upScale)
            {
                vec2 curCoor = v_TextureCoordinates * uResolution.xy;
                curCoor = vec2(ceil(curCoor.x) + 1.0, ceil(curCoor.y) + 1.0);
                curCoor = vec2(floor(curCoor.x * 0.5) - 1.0, floor(curCoor.y * 0.5) -1.0);
                curCoor = curCoor * 2.0 + vec2(1.0, 1.0);
                v_TextureCoordinatesMain = curCoor * uResolution.zw;
            }

            vec2 offMapCoord = v_TextureCoordinatesMain + vec2(dx, dy) * resolutionInverse;

            if(offMapCoord.x < 0.0 || offMapCoord.x > 1.0) {continue;}
            if(offMapCoord.y < 0.0 || offMapCoord.y > 1.0) {continue;}

            vec3 targetToSource = texture2Offset(textureLod(u_targetToSource, offMapCoord, uLevel.y)).rgb;

            voteColor += voteForTarget(u_targetToSource, v_TextureCoordinates, targetToSource, ivec2(dx, dy));
        }
    }

    vec4 out_color;

    if (u_isFirst)
    {
        out_color = textureLod(u_inputTexture, v_TextureCoordinates, uLevel.y);
        out_color.a = textureLod(u_inputMask, v_TextureCoordinates, uLevel.y).a;
    }
    else
    {
        out_color = textureLod(u_targetTexture, v_TextureCoordinates, uLevel.y);
    }

    if(voteColor.a > 0.0)
    {
        out_color.rgb = voteColor.rgb / voteColor.a;
        out_color.a = 0.0;
    }

    out_targetColor = out_color;
}
