local LogLevel = {
    BEF_LOG_LEVEL_NONE    = 0,
    BEF_LOG_LEVEL_DEFAULT = 1,
    BEF_LOG_LEVEL_VERBOSE = 2,
    BEF_LOG_LEVEL_DEBUG   = 3,
    BEF_LOG_LEVEL_INFO    = 4,
    BEF_LOG_LEVEL_WARN    = 5,
    BEF_LOG_LEVEL_ERROR   = 6,
    BEF_LOG_LEVEL_FATAL   = 7,
    BEF_LOG_LEVEL_SILENT  = 8
}

local UniformType = {
    GeneralUniformIntege = 2,
    GeneralUniformFloat  = 3
}

local _initFlag = true
local _featurePath = "GESticker_Removal_Pen"
local _ge = nil

EventHandles =
{
    handleEffectEvent = function(this, eventCode)
        if _initFlag then
            _feature = this:getFeature(_featurePath)
            _ge = EffectSdk.castGeneralEffectFeature(_feature)    
            if nil == _ge then
                EffectSdk.LOG_LEVEL(LogLevel.BEF_LOG_LEVEL_ERROR, "invalid GE feature: " .. _featurePath)
                return false
            end
            _initFlag = false
            -- print("init complete!")
        end
        return true
    end,

    handleComposerUpdateNodeEvent = function(this, path, tag, percentage)
        if nil == _ge then
            print("GESticker_Removal_Pen feature is nil!")
            return
        end

        if "colorR" == tag and _ge ~= nil then
            _ge:setUniformFloat("final", UniformType.GeneralUniformFloat, "uColorR", percentage)
        elseif "colorG" == tag and _ge ~= nil then
            _ge:setUniformFloat("final", UniformType.GeneralUniformFloat, "uColorG", percentage)
        elseif "colorB" == tag and _ge ~= nil then
            _ge:setUniformFloat("final", UniformType.GeneralUniformFloat, "uColorB", percentage)
        elseif "colorA" == tag and _ge ~= nil then
            _ge:setUniformFloat("final", UniformType.GeneralUniformFloat, "uColorA", percentage)
        elseif "deviceLevel" == tag and _ge ~= nil then
            _ge:setUniformFloat("inpaintAlgo", UniformType.GeneralUniformFloat, "deviceLevel", percentage)
        end
    end
}
