package com.alibaba.aliexpress.live.service;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;

import com.ugc.aaf.base.util.Log;

import java.util.Arrays;
import java.util.List;

/**
 * Created by jiajie.djj on 2017/2/18.
 *
 * @email llfer2006@gmail.com
 */

public class AppRunningDetector implements Application.ActivityLifecycleCallbacks, Runnable {
    private static final String TAG = "AppRunningDetector";
    private static final long DETECT_DELAY = 200L;

    public interface OnAppForegroundChangedListener {
        /**
         * app 在前后切换时
         * @param foreground app是否在前台运行
         * */
        void onForegroundChanged(boolean foreground);
        void onForegroundChanged(boolean foreground, Activity activity);
    }

    private Application mApp;
    private boolean mIsRunning;
    private boolean mMedian;
    private Handler mHandler;

    private OnAppForegroundChangedListener mListener;

    public AppRunningDetector(Application app, OnAppForegroundChangedListener l) {
        mApp = app;
        mListener = l;

        mMedian = true;
        mIsRunning = true;
        mHandler = new Handler(Looper.getMainLooper());
    }


    public void detectApp() {
//        mIsRunning = checkPackageIsFront();
        //因为一般activity pause才会调用 此方法,此时下一个activity的onResume方法还未执行
        // 所以此值默认为false,此时checkPackageIsFront方法检测永远为true
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            mIsRunning = true;
        } else {
            mIsRunning = true;
        }
        mMedian = mIsRunning;
        mHandler.removeCallbacks(this);
        mApp.registerActivityLifecycleCallbacks(this);
        Log.i(TAG, "detectApp: Start " + mIsRunning);
    }

    public void stopDetect() {
        Log.i(TAG, "stopDetect app " + mIsRunning);
        mApp.unregisterActivityLifecycleCallbacks(this);
        mHandler.removeCallbacks(this);
    }

    public boolean isAppRunningFront() {
        return mIsRunning;
    }

    private void changeRunningStatus(boolean run) {
        if (mIsRunning != run) {
            mIsRunning = run;

            mListener.onForegroundChanged(mIsRunning);
        }
    }

    private void changeRunningStatus(boolean run, Activity activity) {
        if (mIsRunning != run) {
            mIsRunning = run;

            mListener.onForegroundChanged(mIsRunning, activity);
        }
    }

    @Override
    public void run() {
        Log.i(TAG, "Activity delay pause median :" + mMedian + ", run:" + mIsRunning);
        if (!mMedian) {
            changeRunningStatus(false);
        }
    }

    @Override
    public void onActivityResumed(Activity activity) {
        Log.i(TAG, "onActivityResumed: " + activity);
        mMedian = true;
        changeRunningStatus(true, activity);
        mHandler.removeCallbacks(this);
    }

    @Override
    public void onActivityPaused(Activity activity) {
        Log.i(TAG, "onActivityPaused: " + activity);
        mMedian = false;
        mHandler.postDelayed(this, DETECT_DELAY);
    }

    /*检测当前app是否处理前台*/
    private boolean checkPackageIsFront() {
        ActivityManager am = (ActivityManager) mApp.getSystemService(Context.ACTIVITY_SERVICE);
        String pkg = mApp.getPackageName();
        List<ActivityManager.RunningAppProcessInfo> runningAppProcesses = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo app : runningAppProcesses) {
            if (app.importance == ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND
                    && Arrays.binarySearch(app.pkgList, pkg) >= 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        Log.i(TAG, "onActivityCreated: " + activity);
    }

    @Override
    public void onActivityStarted(Activity activity) {
        Log.i(TAG, "onActivityStarted: "+ activity);
    }

    @Override
    public void onActivityStopped(Activity activity) {
        Log.i(TAG, "onActivityStopped: " + activity);
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {

    }
}
