package com.alibaba.aliexpress.live.service;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IBinder;
import android.util.TimingLogger;

import com.ugc.aaf.base.app.BaseUgcService;
import com.ugc.aaf.base.util.StringUtil;

import java.util.List;

public class MiniPlayerService extends BaseUgcService implements AppRunningDetector.OnAppForegroundChangedListener {
    private static final String TAG = "MiniPlayerService";

    public static final String ACTION_PLAY = "com.aliexpress.live.action.PLAY";
    public static final String ACTION_STOP = "com.aliexpress.live.action.STOP";
    public static final String EXTRA_URL = "extra_url";
    public static final String IS_LAND = "is_land";
    public static final String EXTRA_START_TIME = "extra_start_time";

    public static void startMiniPlayer(Context ctx, long liveId, String playerUrl, boolean isLand) {
        if (StringUtil.isBlankOrNull(playerUrl) || liveId == 0) {
            return;
        }
        Intent intent = new Intent(ctx, MiniPlayerService.class);
        intent.setAction(MiniPlayerService.ACTION_PLAY);
        intent.putExtra(MiniPlayerService.EXTRA_URL, playerUrl);
        intent.putExtra(Intent.EXTRA_UID, liveId);
        intent.putExtra(MiniPlayerService.IS_LAND, isLand);
        intent.setPackage(ctx.getPackageName());
        ctx.startService(intent);
    }

    public static void startMiniPlayer(Context ctx, long liveId, String playerUrl, int startTime, boolean isLand) {
        if (StringUtil.isBlankOrNull(playerUrl) || liveId == 0) {
            return;
        }
        Intent intent = new Intent(ctx, MiniPlayerService.class);
        intent.setAction(MiniPlayerService.ACTION_PLAY);
        intent.putExtra(MiniPlayerService.EXTRA_URL, playerUrl);
        intent.putExtra(Intent.EXTRA_UID, liveId);
        intent.putExtra(MiniPlayerService.IS_LAND, isLand);
        intent.putExtra(MiniPlayerService.EXTRA_START_TIME, startTime);
        intent.setPackage(ctx.getPackageName());
        ctx.startService(intent);
    }

    public static void stopMiniPlayer(Context ctx) {
        TimingLogger timingLogger = new TimingLogger(TAG, "Check Service Running");
        ActivityManager am = (ActivityManager) ctx.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningServiceInfo> runningServices = am.getRunningServices(Integer.MAX_VALUE);
        boolean found = false;
        if (runningServices != null && !runningServices.isEmpty()) {
            for (ActivityManager.RunningServiceInfo info : runningServices) {
                if (MiniPlayerService.class.getName().equals(info.service.getClassName())) {
                    found = true;
                    break;
                }
            }
        }
        timingLogger.addSplit("Check Finish");
        timingLogger.dumpToLog();
        if (!found){
            return;
        }

        Intent intent = new Intent(ctx, MiniPlayerService.class);
        intent.setAction(MiniPlayerService.ACTION_STOP);
        intent.setPackage(ctx.getPackageName());
        ctx.startService(intent);
    }

    private boolean mIsMiniPlayer;
    private DragLayout mDragLayout;
    private AppRunningDetector mAppDetector;
    private BroadcastReceiver mStopReceiver;

    @Override
    public void onCreate() {
        super.onCreate();

        mDragLayout = new DragLayout(getApplicationContext());
        mAppDetector = new AppRunningDetector(getApplication(), this);

    }

    @Override
    public IBinder onBind(Intent intent) {
        // TODO: Return the communication channel to the service.
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            String action = intent.getAction();
            if (ACTION_PLAY.equals(action)) {
                if (!mIsMiniPlayer) {
                    mIsMiniPlayer = true;
                    listenStopReceiver();
                }
                showMiniPlayer(
                        intent.getLongExtra(Intent.EXTRA_UID, 0L),
                        intent.getStringExtra(EXTRA_URL),
                        intent.getIntExtra(EXTRA_START_TIME, 0),
                        intent.getBooleanExtra(IS_LAND, true));
                return START_STICKY;
            }
            if (ACTION_STOP.equals(action)) {
                stopPlay();
                return START_NOT_STICKY;

            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onForegroundChanged(boolean foreground) {
        if (!mIsMiniPlayer){
            return;
        }
        if (foreground) {
            mDragLayout.showPlay();
        } else {
            mDragLayout.pause();
        }
    }

    @Override
    public void onForegroundChanged(boolean foreground, Activity activity) {
        if (!mIsMiniPlayer){
            return;
        }
        if (foreground) {
            mDragLayout.showPlay(activity);
        } else {
            mDragLayout.pause();
        }
    }

    private void stopPlay(){
        if (mIsMiniPlayer) {
            mIsMiniPlayer = false;
            unListenStopReceiver();
        }
        hideMiniPlayer();
    }

    private void showMiniPlayer(long liveId, String url, int seek, boolean isLand) {
        mAppDetector.detectApp();
        mDragLayout.bindLiveData(liveId, url, seek);
        mDragLayout.setPosition(isLand);
        if (mAppDetector.isAppRunningFront()) {
            mDragLayout.showPlay();
        }
    }

    private void hideMiniPlayer() {
        mAppDetector.stopDetect();
        mDragLayout.stopIfNeed();
    }

    void listenStopReceiver() {
        if (mStopReceiver == null) {
            mStopReceiver = new BroadcastReceiver() {
                @Override
                public void onReceive(Context context, Intent intent) {
                    stopPlay();
                }
            };
        }

        IntentFilter filter = new IntentFilter(ACTION_STOP);
        registerReceiver(mStopReceiver, filter);
    }

    void unListenStopReceiver() {
        if (mStopReceiver == null) {
            return;
        }
        unregisterReceiver(mStopReceiver);
    }
}
