package com.alibaba.aliexpress.live.service;

import android.app.Activity;
import android.content.Context;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;

import com.alibaba.aliexpress.live.R;
import com.alibaba.aliexpress.live.common.LiveConstants.LiveEvent;
import com.alibaba.aliexpress.live.presenter.event.LiveVideoCurrentPositionEvent;
import com.alibaba.aliexpress.live.proxy.LiveProxyImpl;
import com.aliexpress.service.eventcenter.EventBean;
import com.aliexpress.service.eventcenter.EventCenter;
import com.aliexpress.service.eventcenter.EventType;
import com.aliexpress.service.utils.AndroidUtil;
import com.taobao.taobaoavsdk.widget.media.TaoLiveVideoView;
import com.ugc.aaf.base.util.Log;

import tv.danmaku.ijk.media.player.IMediaPlayer;

/**
 * Created by jiajie.djj on 2017/1/4.
 *
 * @email llfer2006@gmail.
 */

public class DragLayout extends FrameLayout implements View.OnClickListener, IMediaPlayer.OnInfoListener, IMediaPlayer.OnErrorListener {
    private static final String TAG = "DragLayout";
    private static final long DOUBLE_CLICK_DURING = 1000L;


    private WindowManager mWM;
    private boolean mAttachToWindow;
    private WindowManager.LayoutParams mParams;
    private VideoPlayerView mVideoPlayer;
    private Button btn_retry;

    private Point mTouchPoint;
    private boolean isDragging;
    private int mTouchSlop;
    private long mLiveId;

    private boolean mIsLand;

    /**
     * 上次点击时间(双击跳转)
     */
    private long mLastClickTime;
    //浮动位置()
    private int mOffsetX, mOffsetY;
    private int mSeekTime;
    private Activity activity;

    public DragLayout(Context context) {
        super(context);
        init(context);
    }

    public DragLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DragLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void init(Context context) {
        LayoutInflater.from(context).inflate(R.layout.live_layout_mini, this, true);
        findViewById(R.id.iv_close).setOnClickListener(this);
        btn_retry = (Button) findViewById(R.id.btn_retry);
        btn_retry.setVisibility(View.GONE);
        btn_retry.setOnClickListener(this);
        mVideoPlayer = (VideoPlayerView) findViewById(R.id.player);
        mVideoPlayer.registerOnInfoListener(this);
        mVideoPlayer.registerOnErrorListener(this);
        mVideoPlayer.setSurfaceListener(new TaoLiveVideoView.SurfaceListener() {
            @Override
            public void onSurfaceCreated() {
                Log.w(TAG, "onSurfaceCreated: ");
                mVideoPlayer.play();
            }

            @Override
            public void onSurfaceDestroyed() {

            }
        });
        mVideoPlayer.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                LiveProxyImpl.getInstance().startLiveDetail(getContext(), mLiveId);
            }
        });

        mOffsetX = 0;
        mOffsetY = 0;
        isDragging = false;
        mTouchPoint = new Point();
        mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();

        mAttachToWindow = false;
        Context ctx = context.getApplicationContext();
        mWM = (WindowManager) ctx.getSystemService(Context.WINDOW_SERVICE);
        mParams = new WindowManager.LayoutParams();
        mParams.gravity = Gravity.TOP | Gravity.START | Gravity.LEFT;
        if(Build.VERSION.SDK_INT >= 26){
            mParams.type =  WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY;
        }else if (Build.VERSION.SDK_INT < 24) {
            //7.0系统无法使用TYPE_TOAST
            if (isSpecialDevice()) {
                // 使用toast有异常的特殊机型，使用alert
                mParams.type = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
            } else {
                mParams.type = WindowManager.LayoutParams.TYPE_TOAST;
            }
        } else {
            mParams.type = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
        }
        mParams.format = PixelFormat.RGBA_8888;
        mParams.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE;
    }

    private boolean isSpecialDevice() {
        if ("ONEPLUS".equals(Build.BRAND) && "A0001".equals(Build.DEVICE)){
            // dialog toast模式显示异常的特殊机型
            return true;
        } else {
            return false;
        }
    }

    public void setPosition(boolean isLand) {
        mIsLand = isLand;
        DisplayMetrics dm = getResources().getDisplayMetrics();
        int max = Math.max(dm.widthPixels / 4, AndroidUtil.dp2px(getContext(), 160f));
        if (isLand) {
            mParams.width = max;
            mParams.height = mParams.width * 9 / 16;
        } else {
            mParams.height = max;
            mParams.width = mParams.height * 9 / 16;
        }
        mParams.x = dm.widthPixels - mParams.width;
        mParams.y = 0;
    }

    @Override
    public boolean onError(IMediaPlayer iMediaPlayer, int i, int i1) {
        Log.i(TAG, "onError: what " + i + ",extra :" + i1);
        mVideoPlayer.hideLoading();
        mVideoPlayer.showMask();
        btn_retry.setVisibility(View.VISIBLE);

        return true;
    }

    @Override
    public boolean onInfo(IMediaPlayer iMediaPlayer, long l, long l1, long l2, Object o) {
        Log.i(TAG, "onInfo: " + l + " data :" + l1 + " data2 :" + l2);
        /*if(l == IMediaPlayer.MEDIA_INFO_BUFFERING_START){
            showLoading();
        }else */
        if (l == IMediaPlayer.MEDIA_INFO_VIDEO_RENDERING_START) {
            mVideoPlayer.hideLoading();
        }
        return true;
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.iv_close) {
            stop();
        } else if (v.getId() == R.id.btn_retry) {
            btn_retry.setVisibility(View.GONE);
            mVideoPlayer.hideMask();
            mVideoPlayer.play();
        }
    }

    public void bindLiveData(long liveId, String url, int seek) {
        mLiveId = liveId;
        mSeekTime = seek;
        if (mSeekTime > 0) {
            mVideoPlayer.setPlayback();
        }
        try {
            mVideoPlayer.setVideoPath(url);
        } catch (Exception e) {
            Log.e(TAG, "bindLiveData error ,url " + url, e);
        }
    }

    public void showPlay() {
        try {
            mWM.addView(this, mParams);
            mAttachToWindow = true;

            btn_retry.setVisibility(View.GONE);
            mVideoPlayer.play();
            if (mSeekTime > 0) {
                mVideoPlayer.seekTo(mSeekTime);
            }
        } catch (Exception e) {
            Log.e(TAG, e);
        }
    }

    public void showPlay(Activity activity) {
        this.activity = activity;
        showPlay();
    }

    public void pause() {
        if (mAttachToWindow) {
            mWM.removeViewImmediate(this);
            mAttachToWindow = false;

            mVideoPlayer.pause();
        }
    }

    public void resume() {
        if (!mAttachToWindow) {
            mWM.addView(this, mParams);
            mAttachToWindow = true;

            mVideoPlayer.play();
        }
    }


    public void stopIfNeed() {
        if (mAttachToWindow) {
            stop();
        }
    }

    public void stop() {
        try {
            EventCenter.getInstance().post(EventBean.build(
                EventType.build(LiveEvent.NAME, LiveEvent.VIDEO_CURRENT_POSITION),
                new LiveVideoCurrentPositionEvent(mVideoPlayer.getCurrentPosition())));
            mVideoPlayer.pause();
            mVideoPlayer.release();

            mWM.removeView(this);
            mAttachToWindow = false;
            setPosition(mIsLand);
        } catch (Exception e) {
            Log.e(TAG, e);
        }
    }

    void updatePosition(int x, int y) {
        mParams.x = x;
        mParams.y = y;
        mWM.updateViewLayout(this, mParams);
    }

    void beggingDragging() {
        isDragging = true;
        int[] loc = new int[2];
        getLocationOnScreen(loc);
        mOffsetX = mTouchPoint.x - loc[0];
        mOffsetY = mTouchPoint.y - loc[1];
    }

    void endDragging() {
        isDragging = false;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        final int action = MotionEventCompat.getActionMasked(ev);
        if (isDragging && action == MotionEvent.ACTION_MOVE) {
            return true;
        }
        if (action == MotionEvent.ACTION_DOWN) {
            mTouchPoint.set((int) ev.getRawX(), (int) ev.getRawY());
            endDragging();
            return false;
        }
        if (action == MotionEvent.ACTION_MOVE) {
            float x = ev.getRawX();
            float y = ev.getRawY();
            if (Math.abs(mTouchPoint.x - x) > mTouchSlop || Math.abs(mTouchPoint.y - y) > mTouchSlop) {
                beggingDragging();
            }
        }
        return isDragging;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        final int action = event.getAction();
        switch (action) {
            case MotionEvent.ACTION_DOWN:
                mTouchPoint.set((int) event.getRawX(), (int) event.getRawY());
                break;
            case MotionEvent.ACTION_MOVE:
                int x = (int) event.getRawX();
                int y = (int) event.getRawY();
                if (!isDragging && (Math.abs(mTouchPoint.x - x) > mTouchSlop || Math.abs(mTouchPoint.y - y) > mTouchSlop)) {
                    beggingDragging();
                }
                if (isDragging) {
                    updatePosition(x - mOffsetX, y - mOffsetY);
                }
                break;
            case MotionEvent.ACTION_UP:
            case MotionEvent.ACTION_CANCEL:
                endDragging();
                break;
            default:
                break;
        }
        return true;
    }
}