package com.alibaba.aliexpress.live.service

import android.app.Activity
import android.app.Application
import android.content.Context
import android.os.Bundle
import com.ugc.aaf.base.util.StringUtil
import java.util.*

class MiniPlayerHelper(ctx: Context) :
        Application.ActivityLifecycleCallbacks {

    companion object {
        const val PRODUCTDETAILACTIVITY_NAME = "com.aliexpress.global.productdetailactivity"
        const val UGCPROFILEACTIVITY_NAME ="com.alibaba.ugc.modules.profile.view.ugcprofileactivity"
        const val SELLERSTOREACTIVITY_NAME ="com.aliexpress.module.module_store.sellerstoreactivity"
        const val V3_NAME ="com.alibaba.aliexpress.live.view.livescrolllistactivity"
    }

    private var mContext: Context = ctx
    var mLiveId: Long = -1
    var mUrl: String? = null
    var mIsLand: Boolean = false
    var mCurrentPos: Int = 0

    private var isLiveRoomPaused :Boolean = false

    init {
        (mContext.applicationContext as Application).registerActivityLifecycleCallbacks(this)
    }

    override fun onActivityPaused(activity: Activity?) {
        if (isNamedActivity(activity, V3_NAME)) {
            isLiveRoomPaused = true
        }
    }

    override fun onActivityResumed(activity: Activity?) {
        if (isNamedActivity(activity, V3_NAME)) {
            MiniPlayerService.stopMiniPlayer(mContext)
        }
        isLiveRoomPaused = false
    }

    override fun onActivityStarted(activity: Activity?) {
    }

    override fun onActivityDestroyed(activity: Activity?) {
    }

    override fun onActivitySaveInstanceState(activity: Activity?, outState: Bundle?) {
    }

    override fun onActivityStopped(activity: Activity?) {
    }

    override fun onActivityCreated(activity: Activity?, savedInstanceState: Bundle?) {
        if (isNamedActivity(activity, PRODUCTDETAILACTIVITY_NAME) ||
                isNamedActivity(activity, UGCPROFILEACTIVITY_NAME) ||
                isNamedActivity(activity, SELLERSTOREACTIVITY_NAME)) {
            if (StringUtil.isNotNullOrBlank(mUrl) && isLiveRoomPaused) {
                    MiniPlayerService.startMiniPlayer(mContext, mLiveId, mUrl, mCurrentPos, mIsLand)
            }
        }
    }

    fun destory() {
        (mContext.applicationContext as Application).unregisterActivityLifecycleCallbacks(this)
    }

    private fun isNamedActivity(activity: Activity?, nameString: String): Boolean {
        return if (activity != null) {
            val name = activity?.javaClass.name.toLowerCase(Locale.ENGLISH)
            name.contains(nameString)
        } else {
            false
        }
    }

    fun setData(liveId: Long, url: String?, isLand: Boolean, pos: Int) {
        mLiveId = liveId
        mUrl = url
        mIsLand = isLand
        mCurrentPos = pos
    }
}