package com.alibaba.aliexpress.live.service;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ProgressBar;

import com.alibaba.aliexpress.live.R;
import com.alibaba.aliexpress.live.common.LiveLibraryManager;
import com.alibaba.aliexpress.live.common.netspeed.NetSpeedCollect;
import com.alibaba.aliexpress.live.common.widget.LiveRoomLayout;
import com.alibaba.aliexpress.live.presenter.ILiveLogPresenter;
import com.alibaba.aliexpress.live.presenter.impl.LiveLogPresenterImpl;
import com.alibaba.aliexpress.live.track.LiveBufferTrackInfo;
import com.alibaba.aliexpress.live.track.LiveFirstRenderTrackInfo;
import com.alibaba.aliexpress.live.track.LivePlayMonitorTrackInfo;
import com.alibaba.aliexpress.live.track.LiveTrack;
import com.alibaba.aliexpress.live.track.MediaBufferDetail;
import com.aliexpress.ugc.components.modules.player.live.MediaCenterView;
import com.taobao.taobaoavsdk.widget.media.TaoLiveVideoViewConfig;
import com.ugc.aaf.base.util.Log;
import com.ugc.aaf.base.util.NumberUtil;
import com.ugc.aaf.base.util.StringUtil;

import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer.OnCompletionListener;
import tv.danmaku.ijk.media.player.IMediaPlayer.OnErrorListener;
import tv.danmaku.ijk.media.player.IMediaPlayer.OnInfoListener;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

/**
 * Created by jiajie.djj on 2017/1/5.
 *
 * @email llfer2006@gmail.com
 */

public class VideoPlayerView extends MediaCenterView {
    private static final String TAG = "VideoPlayerView";
    /**
     * bussinessID
     */
    private static final String BID = "AELIVE";
    private static final int STREAM_BIT_RATE_ORIGINAL = 0;
    private static final int STREAM_BIT_RATE_HD = 1;
    private static final int STREAM_BIT_RATE_SD = 2;

    public interface VideoInitListener {
        void onLoadLibraryError(Throwable e);
    }

    /**
     * mask view,播放器在加载时是透明状态,特加上一个蒙版层
     */
    View mMaskView;
    ProgressBar mPbView;
    /**
     * 播放器是否处于暂停状态
     */
    private boolean mPaused;
    /**
     * 播放器是否是自动暂停,比如说当前activity切换到后台,来电
     */
    private boolean mAutoPaused;
    /**
     * 播放地址是否改变过
     */
    private boolean mUrlChanged;
    /**
     * 是否播放过
     */
    private boolean mPlayed;
    /**
     * 播放地址
     */
    private String mStreamUrl;
    /**
     * 横竖屏下的 长宽比
     */
    private float mLandscapeRatio;
    private float mPortraitRatio;
    private boolean mUseLandscape;
    private int mStreamBitRateLevel = 0;
    private String[] mStreamUrls = new String[3];
    public boolean mNeedAutoChangeBitRate = false;
    private int changeBitRateBufferTimes = 0;
    private long changeBitRateAllBufferDuration = 0;

    private TaoLiveVideoViewConfig mVideoCfg;
    private VideoInitListener mInitListener;
    private LivePlayMonitorTrackInfo mLivePlayMonitorTrackInfo;
    private LiveBufferTrackInfo mLiveBufferTrackInfo;
    private LiveFirstRenderTrackInfo mLiveFirstRenderTrackInfo;
    private ILiveLogPresenter mLiveLogPresenter;
    private MediaBufferDetail mMediaBufferDetail;
    private NetSpeedCollect mNetSpeedCollect;

    private long liveId;


    public VideoPlayerView(Context context) {
        this(context, null);
    }

    public VideoPlayerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VideoPlayerView);
        mLandscapeRatio = a.getFloat(R.styleable.VideoPlayerView_landscapeRatio, 0f);
        mPortraitRatio = a.getFloat(R.styleable.VideoPlayerView_portraitRatio, 0f);
        a.recycle();
        mUseLandscape = false;
        mPaused = false;
        mUrlChanged = false;
        mPlayed = false;
        mAutoPaused = false;
        mStreamUrl = null;
        mLivePlayMonitorTrackInfo = new LivePlayMonitorTrackInfo();
        mLiveBufferTrackInfo = new LiveBufferTrackInfo();
        mLiveFirstRenderTrackInfo = new LiveFirstRenderTrackInfo();
        mLiveFirstRenderTrackInfo.enterTime = System.currentTimeMillis();
        mLiveLogPresenter = new LiveLogPresenterImpl(null);
        mMediaBufferDetail = new MediaBufferDetail();
        initAttr(context);
    }

    private void initAttr(Context ctx) {
        //init cfg
        mVideoCfg = new TaoLiveVideoViewConfig(BID);
        mVideoCfg.mDecoderType = TaoLiveVideoViewConfig.DECODER_TYPE_SOFTWARE;
        mVideoCfg.mScenarioType = TaoLiveVideoViewConfig.SCENARIO_TYPE_LIVE;
        mVideoCfg.mRenderType = TaoLiveVideoViewConfig.RENDER_TYPE_SURFACE_VIEW;
        mVideoCfg.mPlayerType = TaoLiveVideoViewConfig.PLAYER_TYPE_FF;
        initConfig(mVideoCfg);

        mMediaBufferDetail.setBusinessId(BID);

        //add Mask
        mMaskView = new View(ctx);
        mMaskView.setBackgroundColor(getResources().getColor(R.color.black_000000_70));
        LayoutParams lp = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT, Gravity.CENTER);
        addView(mMaskView, lp);
        mMaskView.setVisibility(View.GONE);
        //add Progress
        mPbView = new ProgressBar(ctx);
        addView(mPbView, new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT, Gravity.CENTER));
        mPbView.setVisibility(GONE);

        setCustomLibLoader(LiveLibraryManager.LiveLibLoader);

        registerOnCompletionListener(new OnCompletionListener() {
            @Override
            public void onCompletion(IMediaPlayer iMediaPlayer) {
                mLivePlayMonitorTrackInfo.isCompletion = true;
                mLivePlayMonitorTrackInfo.duration = mLivePlayMonitorTrackInfo.duration + (System.currentTimeMillis() - mLivePlayMonitorTrackInfo.playTime);
            }
        });

        registerOnErrorListener(new OnErrorListener() {
            @Override
            public boolean onError(IMediaPlayer iMediaPlayer, int arg1, int arg2) {
                mLivePlayMonitorTrackInfo.playErrorTimes++;
                return false;
            }
        });

        registerOnInfoListener(new OnInfoListener() {
            @Override
            public boolean onInfo(IMediaPlayer iMediaPlayer, long what, long extra, long ext, Object o) {
                switch ((int) what) {
                    case IMediaPlayer.MEDIA_INFO_VIDEO_RENDERING_START:
                        if (StringUtil.isBlankOrNull(mMediaBufferDetail.getPlayTime())) {
                            mMediaBufferDetail.setPlayTime(String.valueOf(System.currentTimeMillis()));
                        }
                        mLivePlayMonitorTrackInfo.playSuccessTimes++;
                        if (mLiveFirstRenderTrackInfo != null && mLiveFirstRenderTrackInfo.videoFirstRender == 0 && mLiveFirstRenderTrackInfo.setPlayUrlTime > 0) {
                            mLiveFirstRenderTrackInfo.videoFirstRender = System.currentTimeMillis() - mLiveFirstRenderTrackInfo.setPlayUrlTime;
                            mLiveFirstRenderTrackInfo.videoFirstRender2 = System.currentTimeMillis() - mLiveFirstRenderTrackInfo.enterTime;
                            Log.d(TAG, "videoFirstRender: " + mLiveFirstRenderTrackInfo.videoFirstRender + " extra: " + extra);
                        }
                        Log.d(TAG, "playSuccessTime: " + mLivePlayMonitorTrackInfo.playSuccessTimes);
                        Log.d(TAG, "MEDIA_INFO_VIDEO_RENDERING_START: " + extra + " ext: " + ext);
                        break;
                    case IMediaPlayer.MEDIA_INFO_AUDIO_RENDERING_START:
                        if (mLiveFirstRenderTrackInfo != null && mLiveFirstRenderTrackInfo.audioFirstRender == 0 && mLiveFirstRenderTrackInfo.setPlayUrlTime > 0) {
                            mLiveFirstRenderTrackInfo.audioFirstRender = System.currentTimeMillis() - mLiveFirstRenderTrackInfo.setPlayUrlTime;
                            Log.d(TAG, "audioFirstRender: " + mLiveFirstRenderTrackInfo.audioFirstRender + " extra: " + extra);
                        }
                        Log.d(TAG, "MEDIA_INFO_AUDIO_RENDERING_START: " + extra + " ext: " + ext);
                        break;
                    case IMediaPlayer.MEDIA_INFO_BUFFERING_START:
                        try {
                            showLoading();
                            changeBitRateBufferTimes++;
                            mLivePlayMonitorTrackInfo.bufferTimes++;
                            mLiveBufferTrackInfo.bufferPrevStartTime = mLiveBufferTrackInfo.bufferStartTime;
                            mLiveBufferTrackInfo.bufferStartTime = System.currentTimeMillis();
                            mMediaBufferDetail.setStartTime(String.valueOf(mLiveBufferTrackInfo.bufferStartTime));
                            Log.d(TAG, "changeBitRateBufferTimes: " + changeBitRateBufferTimes + " changeBitRateAllBufferDuration: " + changeBitRateAllBufferDuration);
                            boolean isNeedChangeBitRate = (mNeedAutoChangeBitRate && mStreamBitRateLevel != STREAM_BIT_RATE_SD
                                && ((changeBitRateBufferTimes >= 3 && changeBitRateAllBufferDuration >= 10000) || changeBitRateAllBufferDuration > 15000));
                            if (isNeedChangeBitRate) {
                                String x = "original";
                                if (mStreamBitRateLevel == STREAM_BIT_RATE_ORIGINAL) {
                                    mStreamBitRateLevel = STREAM_BIT_RATE_HD;
                                    x = "HD";
                                } else if (mStreamBitRateLevel == STREAM_BIT_RATE_HD) {
                                    mStreamBitRateLevel = STREAM_BIT_RATE_SD;
                                    x = "SD";
                                }
                                if (mStreamUrls != null && StringUtil.isNotNullOrBlank(mStreamUrls[mStreamBitRateLevel])) {
                                    mStreamUrl = mStreamUrls[mStreamBitRateLevel];
                                    Log.e(TAG, "after change bit rate stream url:" + mStreamUrl);
                                    switchVideoPath(mStreamUrl, true);
                                    LiveTrack.commitChangeBitRate(String.valueOf(liveId), BID, getConfig().mSubBusinessType, mStreamUrl, String.valueOf(getConfig().mScenarioType), String.valueOf(mLiveBufferTrackInfo.bufferStartTime));
                                }
                                changeBitRateAllBufferDuration = 0;
                                changeBitRateBufferTimes = 0;
                            }
                        } catch (Exception e) {
                            Log.e(TAG, e);
                        }
                        break;
                    case IMediaPlayer.MEDIA_INFO_BUFFERING_END:
                        hideLoading();
                        mLiveBufferTrackInfo.bufferPrevEndTime = mLiveBufferTrackInfo.bufferEndTime;
                        mLiveBufferTrackInfo.bufferEndTime = System.currentTimeMillis();
                        mLiveBufferTrackInfo.bufferDuration = mLiveBufferTrackInfo.bufferEndTime - mLiveBufferTrackInfo.bufferStartTime;
                        changeBitRateAllBufferDuration = changeBitRateAllBufferDuration + mLiveBufferTrackInfo.bufferDuration;
                        if (mLiveBufferTrackInfo.bufferPrevEndTime > 0) {
                            mLiveBufferTrackInfo.bufferInterval = mLiveBufferTrackInfo.bufferStartTime - mLiveBufferTrackInfo.bufferPrevEndTime;
                        }
                        mLiveBufferTrackInfo.liveId = liveId;
                        mLiveBufferTrackInfo.status = getConfig().mScenarioType;
                        LiveTrack.commitBuffer(mLiveBufferTrackInfo);
                        mMediaBufferDetail.setEndTime(String.valueOf(mLiveBufferTrackInfo.bufferEndTime));
                        trackBuffer();
                        break;
                    case IMediaPlayer.MEDIA_INFO_NETWORK_TRAFFIC:
                        mLivePlayMonitorTrackInfo.traffic = mLivePlayMonitorTrackInfo.traffic + extra;
                        Log.d(TAG, "traffic: " + mLivePlayMonitorTrackInfo.traffic + " extra: " + extra + " ext: " + ext);
                        break;
                    default:
                        break;
                }
                if (mLiveFirstRenderTrackInfo != null && !mLiveFirstRenderTrackInfo.hasCommit && mLiveFirstRenderTrackInfo.videoFirstRender > 0 && mLiveFirstRenderTrackInfo.audioFirstRender > 0) {
                    mLiveFirstRenderTrackInfo.liveId = liveId;
                    mLiveFirstRenderTrackInfo.status = getConfig().mScenarioType;
                    LiveTrack.commitFirstRender(mLiveFirstRenderTrackInfo);
                    mLiveFirstRenderTrackInfo.hasCommit = true;
                }

                return false;
            }
        });

        registerOnStartListener(new OnStartListener() {
            @Override
            public void onStart(IMediaPlayer iMediaPlayer) {
                mLivePlayMonitorTrackInfo.playTime = System.currentTimeMillis();
                Log.d(TAG, "playTime: " + mLivePlayMonitorTrackInfo.playTime);
            }
        });

        registerOnPauseListener(new OnPauseListener() {
            @Override
            public void onPause(IMediaPlayer iMediaPlayer) {
                mLivePlayMonitorTrackInfo.pausedTime = System.currentTimeMillis();
                Log.d(TAG, "pausedTime: " + mLivePlayMonitorTrackInfo.pausedTime);
                if (mLivePlayMonitorTrackInfo.playTime > 0) {
                    mLivePlayMonitorTrackInfo.duration = mLivePlayMonitorTrackInfo.duration + (mLivePlayMonitorTrackInfo.pausedTime - mLivePlayMonitorTrackInfo.playTime);
                }
            }
        });
    }

    public void trackBuffer() {
        try {
            if (StringUtil.isNotNullOrBlank(mMediaBufferDetail.getStartTime())
                && StringUtil.isNotNullOrBlank(mMediaBufferDetail.getEndTime())) {
                mMediaBufferDetail.setScenarioType(String.valueOf(getConfig().mScenarioType));
                mMediaBufferDetail.setMediaUrl(mStreamUrl);
                LiveTrack.commitBuffer(mMediaBufferDetail);
                mMediaBufferDetail.reset();
            }
        } catch (Exception e) {
            Log.e(TAG, e);
        }
    }


    public void startNetTestSample(String host) {
        try {
            if (StringUtil.isBlankOrNull(host)) {
                return;
            }
            mNetSpeedCollect = new NetSpeedCollect(host + "/akamaiTest.txt", new NetSpeedCollect.NetSpeedCollectListener() {
                @Override
                public void onCollectComplete(String avgSpeed, String ip, String packetLoss) {
                    Log.d(TAG, "avgSpeed: " + avgSpeed + " ip: " + ip + " packetLoss: " + packetLoss);
                    try {
                        mMediaBufferDetail.setCdnip(ip);
                        mMediaBufferDetail.setPacketLoss(packetLoss);
                        mMediaBufferDetail.setNetSpeed(avgSpeed);
                        if (NumberUtil.isDouble(avgSpeed)) {
                            float fs = Float.parseFloat(avgSpeed);
                            getConfig().mNetSpeed = (int) fs;
                        }
                    } catch (Exception e) {
                        Log.e(TAG, e);
                    }
                }
            });
            mNetSpeedCollect.start();
        } catch (Exception e) {
            Log.e(TAG, e);
        }
    }

    public void stopNetTestSample() {
        if (mNetSpeedCollect != null) {
            mNetSpeedCollect.stopCollect();
        }
    }

    public void setSubBusinessType(String type) {
        try {
            getConfig().mSubBusinessType = type;
            mMediaBufferDetail.setSubBusinessType(type);
        } catch (Exception e) {
            Log.e(TAG, e);
        }
    }

    public void setUserId(String userId) {
        try {
            getConfig().mUserId = userId;
        } catch (Exception e) {
            Log.e(TAG, e);
        }
    }

    public void setNeedAutoChangeBitRate(boolean need) {
        mNeedAutoChangeBitRate = need;
    }

    public void setStreamUrls(String[] streamUrls) {
        this.mStreamUrls = streamUrls;
    }

    public void setLiveId(long liveId) {
        this.liveId = liveId;
        mMediaBufferDetail.setPostId(String.valueOf(liveId));
    }

    public void setInitListener(VideoInitListener l) {
        mInitListener = l;
    }

    public void showMask() {
        mMaskView.setVisibility(VISIBLE);
    }

    public void hideMask() {
        mMaskView.setVisibility(GONE);
    }

    void showLoading() {
        mMaskView.setVisibility(VISIBLE);
        mPbView.setVisibility(VISIBLE);
    }

    public void hideLoading() {
        mMaskView.setVisibility(GONE);
        mPbView.setVisibility(GONE);
    }

    public void setPlayback() {
        setScenarioType(TaoLiveVideoViewConfig.SCENARIO_TYPE_PLAYBACK);
    }

    public void changeMode(boolean landscape) {
        mUseLandscape = landscape;
    }

    public void play() {
        if (mUrlChanged || (!mPaused && mPlayed)) {
            release();
            showLoading();
        }
        mUrlChanged = false;
        mPaused = false;
        mPlayed = true;

        superStart();
    }

    private void superStart() {
        try {
            super.start();
        } catch (UnsatisfiedLinkError e) {
            hideLoading();
            //加载so失败
            if (mInitListener != null) {
                mInitListener.onLoadLibraryError(e);
            }
        }
    }

    public void autoPause() {
        if (isPlaying()) {
            mAutoPaused = true;
            superPause();
        }
    }

    public void autoPlay() {
        if (mAutoPaused) {
            mAutoPaused = false;
            superStart();
        }
    }

    @Override
    public void pause() {
        mPaused = true;

        superPause();
    }

    private void superPause() {
        super.pause();
    }



    @Override
    public void release() {
        mPaused = false;
        mPlayed = false;
        mUrlChanged = false;
        commitLivePlayMonitor();
        super.release();
    }

    private void commitLivePlayMonitor() {
        if (!mLivePlayMonitorTrackInfo.isCompletion && mLivePlayMonitorTrackInfo.playTime > 0) {
            mLivePlayMonitorTrackInfo.duration = mLivePlayMonitorTrackInfo.duration + (System.currentTimeMillis() - mLivePlayMonitorTrackInfo.playTime);
        }
        mLivePlayMonitorTrackInfo.liveId = liveId;
        mLivePlayMonitorTrackInfo.status = getConfig().mScenarioType;
        mLivePlayMonitorTrackInfo.downloadBitrate = getPropertyLong(IjkMediaPlayer.FFP_PROP_DOWNLOAD_BITRATE, 0);
        mLivePlayMonitorTrackInfo.frameRate = getPropertyLong(IjkMediaPlayer.FFP_PROP_RENDER_VIDEO_FPS, 0);
        LiveTrack.commitLivePlayMonitor(mLivePlayMonitorTrackInfo);
        mLivePlayMonitorTrackInfo = null;
        mLivePlayMonitorTrackInfo = new LivePlayMonitorTrackInfo();
    }

    @Override
    public void setVideoPath(String path) {
        super.setVideoPath(path);
        if (mStreamUrl == null || !mStreamUrl.equals(path)) {
            mStreamUrl = path;
            mUrlChanged = true;
            mLiveFirstRenderTrackInfo.setPlayUrlTime = System.currentTimeMillis();
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float ratio = mUseLandscape ? mLandscapeRatio : mPortraitRatio;
        int widthMode = MeasureSpec.getMode(widthMeasureSpec);
        int widthSize = MeasureSpec.getSize(widthMeasureSpec);
        if (ratio > 0f && widthMode == MeasureSpec.EXACTLY) {
            heightMeasureSpec = MeasureSpec.makeMeasureSpec((int) (widthSize * ratio), MeasureSpec.EXACTLY);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    /**
     * 主要是为了配合{@link LiveRoomLayout} 的 {@link android.support.v4.view.NestedScrollingChild}
     * 让scroll到不可见的view 接收不到touch 事件.
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        return true;
    }
}
