<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:template match="/">
[Interface]
PrivateKey = <xsl:value-of select="/config/interface/@private_key" />
Address = <xsl:value-of select="/config/interface/@ip_address" />/32
<xsl:choose>
    <xsl:when test="/config/interface/@dns_addresses != ''">DNS = <xsl:value-of select="/config/interface/@dns_addresses" /></xsl:when>
</xsl:choose>

<xsl:for-each select="/config/peer">
[Peer]
PublicKey = <xsl:value-of select="./@peer_public_key" />
<xsl:choose>
<xsl:when test="./@peer_ip_address != ''">
AllowedIPs = <xsl:value-of select="./@peer_ip_address" />/32
</xsl:when>
</xsl:choose>
PersistentKeepalive = 25
</xsl:for-each>
</xsl:template>
</xsl:stylesheet>