local exports = exports or {}
local SmoothV6 = SmoothV6 or {}
SmoothV6.__index = SmoothV6

function SmoothV6.new(construct, ...)
    local self = setmetatable({}, SmoothV6)
    self.comps = {}
    self.compsdirty = true

    self.commandBufSmooth = Amaz.CommandBuffer()
    self.commandBufSharpen = Amaz.CommandBuffer()

    self.width = 720
    self.height = 1280

    self.smoothIntensity = 0
    self.sharpIntensity = 0.05
    self.exclusiveFlag = false

    return self
end

function SmoothV6:initialize(sys)
    local commandTableResources = sys.scene:findEntityBy("SmoothV6"):getComponent("TableComponent")

    -- INPUT0
    self.inputTex = commandTableResources.table:get("input_texture")

    -- camera input width and height
    self.width = self.inputTex.width
    self.height = self.inputTex.height
    self.identityMatrix = Amaz.Matrix4x4f():SetIdentity()

    self.blitMesh = commandTableResources.table:get("blit_mesh")

    self.box1Material = commandTableResources.table:get("box1_material")
    self.varMaterial = commandTableResources.table:get("var_material")
    self.box2Material = commandTableResources.table:get("box2_material")
    self.box3Material = commandTableResources.table:get("box3_material")
    self.smoothMaterial = commandTableResources.table:get("smooth_material")

    self.box1RT = commandTableResources.table:get("box1_rt")
    self.varRT = commandTableResources.table:get("var_rt")
    self.smoothRT = commandTableResources.table:get("smooth_rt")   --output

    -- disable depth rt
    local outputRT = sys.scene:getOutputRenderTexture()
    outputRT.attachment = Amaz.RenderTextureAttachment.NONE

    -- clear irrelevant events
    local scriptSys = sys.scene:getSystem("ScriptSystem")
    scriptSys:clearAllEventType()
    scriptSys:addEventType(Amaz.BEFEventType.BET_COMPOSER)
    scriptSys:addEventType(Amaz.BEFEventType.BET_EXCLUSIVE)

    -- -- set sharp intensity
    -- local platformName = Amaz.Platform.name()
    -- if platformName == "iOS" then
    --     self.sharpIntensity = 0.7
    -- elseif platformName == "Android" then
    --     self.sharpIntensity = 0.05
    -- else
    --     self.sharpIntensity = 0.0   -- TBD
    -- end
end

function SmoothV6:onStart(sys)

    self:initialize(sys)

    -- box blur x -- pass 1
    self.commandBufSmooth:setRenderTexture(self.box1RT)
    self.commandBufSmooth:clearRenderTexture(true, true, Amaz.Color(0, 0, 0, 0))
    self.commandBufSmooth:drawMesh(self.blitMesh, self.identityMatrix, self.box1Material, 0, 0, nil, true)

    -- box blur y -- pass 2
    self.commandBufSmooth:setRenderTexture(self.varRT)
    self.commandBufSmooth:clearRenderTexture(true, true, Amaz.Color(0, 0, 0, 0))
    self.commandBufSmooth:drawMesh(self.blitMesh, self.identityMatrix, self.varMaterial, 0, 0, nil, true)

    -- var blur x -- pass 3
    self.commandBufSmooth:setRenderTexture(self.box1RT)
    self.commandBufSmooth:clearRenderTexture(true, true, Amaz.Color(0, 0, 0, 0))
    self.commandBufSmooth:drawMesh(self.blitMesh, self.identityMatrix, self.box2Material, 0, 0, nil, true)

    -- var blur y -- pass 4 
    self.commandBufSmooth:setRenderTexture(self.varRT)
    self.commandBufSmooth:clearRenderTexture(true, true, Amaz.Color(0, 0, 0, 0))
    self.commandBufSmooth:drawMesh(self.blitMesh, self.identityMatrix, self.box3Material, 0, 0, nil, true)

    -- smooth -- pass 5
    self.commandBufSmooth:setRenderTexture(self.smoothRT)
    self.commandBufSmooth:clearRenderTexture(true, true, Amaz.Color(0, 0, 0, 0))
    self.commandBufSmooth:drawMesh(self.blitMesh, self.identityMatrix, self.smoothMaterial, 0, 0, nil, true)

    -- sharpen -- pass 1
    self.commandBufSharpen:setRenderTexture(self.smoothRT)
    self.commandBufSharpen:clearRenderTexture(true, true, Amaz.Color(0, 0, 0, 0))
    self.commandBufSharpen:drawMesh(self.blitMesh, self.identityMatrix, self.smoothMaterial, 0, 0, nil, true)

end

function SmoothV6:onUpdate(sys, deltaTime)
    -- handle the case when been exclusive or skipped
    if self.exclusiveFlag or (self.smoothIntensity <= 0 and self.sharpIntensity <= 0) then
        -- case 1: been exclusived or smooth and sharp is 0, simply blit 
        self.smoothRT.inputTexture = self.inputTex
        return
    end

    local width = self.inputTex.width
    local height = self.inputTex.height
    if width ~= self.width or height ~= self.height then
        Amaz.LOGI("v6", "v6: onUpdate resolution changed")
        self.width = width
        self.height = height
    end

    -- update uniforms which needs to update
    self.smoothMaterial:setFloat("texEpmHeightOffset", 1 / self.height)
    self.smoothMaterial:setFloat("texEpmWidthOffset", 1 / self.width)
    self.smoothMaterial:setFloat("smoothIntensity", self.smoothIntensity)
    self.smoothMaterial:setFloat("sharpIntensity", self.sharpIntensity)

    -- handle the case when intensity is zero 
    if self.smoothIntensity > 0 then
        -- case 2: smooth is not 0
        sys.scene:commitCommandBuffer(self.commandBufSmooth)
    else
        -- case 3: sharp is not 0
        sys.scene:commitCommandBuffer(self.commandBufSharpen)
    end
end

function SmoothV6:onEvent(sys, event)
    if event.type == Amaz.BEFEventType.BET_COMPOSER then
        if event.args:get(0) == "Smooth_ALL" then
            local _intensity = event.args:get(2)
            self.smoothIntensity = _intensity * 0.85
        end
    elseif event.type == Amaz.BEFEventType.BET_EXCLUSIVE then
        if event.args:get(0) == "EXCLUSIVE_ALL_PARAM" then
            self.exclusiveFlag = event.args:get(1)
        end
    end
end

exports.SmoothV6 = SmoothV6
return exports