local organName = {
    "DISTORTION_FACEU_FAR_EYE",
    "DISTORTION_FACEU_ZOOM_EYE",
    "DISTORTION_FACEU_ROTATE_EYE",
    "DISTORTION_FACEU_MOVE_EYE",
    "DISTORTION_FACEU_ZOOM_NOSE",
    "DISTORTION_FACEU_MOVE_NOSE",
    "DISTORTION_FACEU_MOVE_MOUTH",
    "DISTORTION_FACEU_ZOOM_MOUTH",
    "DISTORTION_FACEU_MOVE_CHIN",
    "DISTORTION_FACEU_ZOOM_FOREHEAD",
    "DISTORTION_FACEU_ZOOM_FACE",
    "DISTORTION_FACEU_CUT_FACE",
    "DISTORTION_FACEU_SMALL_FACE",
    "DISTORTION_FACEU_ZOOM_JAW_BONE",
    "DISTORTION_FACEU_ZOOM_CHEEK_BONE",
    "DISTORTION_FACEU_DRAG_LIPS",
    "DISTORTION_FACEU_CORNER_EYE",
    "DISTORTION_FACEU_LIP_ENHANCE",
    "DISTORTION_FACEU_POINTY_CHIN",
    "DISTORTION_FACEU_SHRINK_CHIN"
}

local organParams = {
    ["DISTORTION_FACEU_FAR_EYE"] = 0.12,
    ["DISTORTION_FACEU_ZOOM_EYE"] = 0.2,
    ["DISTORTION_FACEU_ROTATE_EYE"] = 0.0,
    ["DISTORTION_FACEU_MOVE_EYE"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_NOSE"] = -0.06,
    ["DISTORTION_FACEU_MOVE_NOSE"] = -0.0,
    ["DISTORTION_FACEU_MOVE_MOUTH"] = -0.07,
    ["DISTORTION_FACEU_ZOOM_MOUTH"] = -0.0,
    ["DISTORTION_FACEU_MOVE_CHIN"] = -0.0,
    ["DISTORTION_FACEU_ZOOM_FOREHEAD"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_FACE"] = -0.2,
    ["DISTORTION_FACEU_CUT_FACE"] = -0.2,
    ["DISTORTION_FACEU_SMALL_FACE"] = -0.06,
    ["DISTORTION_FACEU_ZOOM_JAW_BONE"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_CHEEK_BONE"] = -0.04,
    ["DISTORTION_FACEU_DRAG_LIPS"] = 0.0,
    ["DISTORTION_FACEU_CORNER_EYE"] = 0.0,
    ["DISTORTION_FACEU_LIP_ENHANCE"] = 0.0,
    ["DISTORTION_FACEU_POINTY_CHIN"] = -0.4,
    ["DISTORTION_FACEU_SHRINK_CHIN"] = -0.0
}

local paramNameMap = {
    ["DISTORTION_FACEU_FAR_EYE"] = 0,
    ["DISTORTION_FACEU_ZOOM_EYE"] = 1,
    ["DISTORTION_FACEU_ROTATE_EYE"] = 2,
    ["DISTORTION_FACEU_MOVE_EYE"] = 3,
    ["DISTORTION_FACEU_ZOOM_NOSE"] = 4,
    ["DISTORTION_FACEU_MOVE_NOSE"] = 5,
    ["DISTORTION_FACEU_MOVE_MOUTH"] = 6,
    ["DISTORTION_FACEU_ZOOM_MOUTH"] = 7,
    ["DISTORTION_FACEU_MOVE_CHIN"] = 8,
    ["DISTORTION_FACEU_ZOOM_FOREHEAD"] = 9,
    ["DISTORTION_FACEU_ZOOM_FACE"] = 10,
    ["DISTORTION_FACEU_CUT_FACE"] = 11,
    ["DISTORTION_FACEU_SMALL_FACE"] = 12,
    ["DISTORTION_FACEU_ZOOM_JAW_BONE"] = 13,
    ["DISTORTION_FACEU_ZOOM_CHEEK_BONE"] = 14,
    ["DISTORTION_FACEU_DRAG_LIPS"] = 15,
    ["DISTORTION_FACEU_CORNER_EYE"] = 16,
    ["DISTORTION_FACEU_LIP_ENHANCE"] = 17,
    ["DISTORTION_FACEU_POINTY_CHIN"] = 18,
    ["DISTORTION_FACEU_SHRINK_CHIN"] = 19,
    ["Eye_Type"] = 20
}

local intensityMap = {
    ["DISTORTION_FACEU_FAR_EYE"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_EYE"] = 0.0,
    ["DISTORTION_FACEU_ROTATE_EYE"] = 0.0,
    ["DISTORTION_FACEU_MOVE_EYE"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_NOSE"] = 0.0,
    ["DISTORTION_FACEU_MOVE_NOSE"] = 0.0,
    ["DISTORTION_FACEU_MOVE_MOUTH"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_MOUTH"] = 0.0,
    ["DISTORTION_FACEU_MOVE_CHIN"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_FOREHEAD"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_FACE"] = -0.0,
    ["DISTORTION_FACEU_CUT_FACE"] = 0.0,
    ["DISTORTION_FACEU_SMALL_FACE"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_JAW_BONE"] = 0.0,
    ["DISTORTION_FACEU_ZOOM_CHEEK_BONE"] = 0.0,
    ["DISTORTION_FACEU_DRAG_LIPS"] = 0.0,
    ["DISTORTION_FACEU_CORNER_EYE"] = 0.0,
    ["DISTORTION_FACEU_LIP_ENHANCE"] = 0.0,
    ["DISTORTION_FACEU_POINTY_CHIN"] = 0.0,
    ["DISTORTION_FACEU_SHRINK_CHIN"] = 0.0
}

local intensityMapCache = nil

local faceVal = 0.0
local eyeVal = 0.0

local exports = exports or {}
local SystemScript = SystemScript or {}
SystemScript.__index = SystemScript

function SystemScript.new(construct, ...)
    local self = setmetatable({}, SystemScript)
    self.comps = {}
    self.entities = {}
    self.compsdirty = true

    --dirty flags
    self.faceDeformationNeedUpdate = true
    self.inputTexture = nil
    self.camera = nil
    self.cameraRenderTexture = nil
    self.hasInputTexture = true
    self.isDrawFaceEntity = false
    return self
end

function SystemScript:constructor()
    -- print('running: SystemScript:constructor')
end

function SystemScript:onComponentAdded(sys, comp)
    -- print('running: SystemScript:onComponentAdded')

    -- Amaz.LOGE("SystemScript","running: SystemScript:onComponentAdded")
    if comp:isInstanceOf("FaceReshapeV4") then
        table.insert(self.comps, comp)
        self.compsdirty = true
    end
end

function SystemScript:onComponentRemoved(sys, comp)
    -- print('running: SystemScript:onComponentRemoved')

    -- Amaz.LOGE("SystemScript","running: SystemScript:onComponentRemoved")
    local compCount = #self.comps
    for i = 1, compCount do
        if self.comps[i] == comp then
            table.remove(self.comps, i)
            self.compsdirty = true
        end
    end
end

function SystemScript:onStart(sys)
    -- print('running: SystemScript:onStart')

    -- disable depth rt
    local output_rt = sys.scene:getOutputRenderTexture()
    output_rt.attachment = Amaz.RenderTextureAttachment.NONE

    self.scene = sys.scene
    local cameraEntity = self.scene:findEntityBy("Camera_entity")
    if cameraEntity ~= nil then 
        self.camera = cameraEntity:getComponent("Camera")
        self.cameraRenderTexture = self.camera.renderTexture
        self.inputTexture = self.cameraRenderTexture.inputTexture
    end
    
    sys:clearAllEventType()
    sys:addEventType(Amaz.BEFEventType.BET_COMPOSER)
    sys:addEventType(Amaz.BEFEventType.BET_EXCLUSIVE)

    self.path = self.scene.assetMgr.rootDir
    self.materialSingle = self.scene.assetMgr:SyncLoad(self.path .. "material/single.material")
    self.materialMultiy = self.scene.assetMgr:SyncLoad(self.path .. "material/FaceDistortionV4Material0.material")

    self.singlePer = false
    self.multiPer = false
    local algRes = Amaz.Algorithm.getAEAlgorithmResult()
    self.person_count = algRes:getFaceCount()
    if self.person_count > 1 then
        self.multiPer = true
        for i = 1, #self.comps, 1 do
            self.comps[i].entity:getComponent("MeshRenderer").material = self.materialMultiy
        end
    elseif self.person_count <= 1 then
        self.singlePer = true
    end
end

function SystemScript:onUpdate(sys,deltaTime)

    local algRes = Amaz.Algorithm.getAEAlgorithmResult()
    self.person_count = algRes:getFaceCount()
    if self.person_count > 1 and self.singlePer == true then
        for i = 1, #self.comps, 1 do
            self.comps[i].entity:getComponent("MeshRenderer").sharedMaterial = self.materialMultiy
        end
        self.singlePer = false
        self.multiPer = true
    elseif self.person_count <= 1 and self.multiPer == true then
        for i = 1, #self.comps, 1 do
            self.comps[i].entity:getComponent("MeshRenderer").sharedMaterial = self.materialSingle
        end
        self.singlePer = true
        self.multiPer = false
    end

    -- print('person count: '..self.person_count)

    if self.person_count <= 0 or self.person_count > 1 then
        self.cameraRenderTexture.inputTexture = self.inputTexture
        self.hasInputTexture = true
    elseif self.hasInputTexture then 
        self.cameraRenderTexture.inputTexture = nil
        self.hasInputTexture = false
    end

    -- print('running: SystemScript:onUpdate')

    if self.faceDeformationNeedUpdate then
        -- Amaz.LOGE("SystemScript","running: SystemScript:onUpdate")
        local compCount = #self.comps
        for i = 1, compCount do
            local isAllZero = true
            local intensities = self.comps[i].param

            for k, v in pairs(intensityMap) do
                intensities:set(paramNameMap[k], v)

                -- Amaz.LOGE("SystemScript","running: SystemScript:onUpdate, k : "..k..", value is : "..v)
                if k ~= "Eye_Type" then 
                    if math.abs(v) ~= 0.0 then
                        isAllZero = false
                    end                        
                end
            end

            self.comps[i].param = intensities

            --check if all intensity zero
            if isAllZero then
                -- Amaz.LOGE("SystemScript","running: SystemScript:onUpdate all intensity is zero !!!")
                self.comps[i].entity.visible = false
                Amaz.Algorithm.setAlgorithmEnable(sys.scene.name, "face_0", false)
                self.isDrawFaceEntity = false
            else
                -- Amaz.LOGE("SystemScript","running: SystemScript:onUpdate all intensity is not zero")
                self.comps[i].entity.visible = true
                Amaz.Algorithm.setAlgorithmEnable(sys.scene.name, "face_0", true)
                self.isDrawFaceEntity = true
            end
        end
        self.faceDeformationNeedUpdate = false
    end

    if not self.isDrawFaceEntity and not self.hasInputTexture then
        -- draw background
        self.cameraRenderTexture.inputTexture = self.inputTexture
        self.hasInputTexture = true
    end
end

function SystemScript:onEvent(sys, event)
    if event.type == Amaz.BEFEventType.BET_COMPOSER then
        -- Composer event
        local tag = event.args:get(0)
        local path = event.args:get(1)
        local value = event.args:get(2)

        -- Amaz.LOGE("SystemScript","composer tag is : "..tag..", value is : "..value)

        if tag == "Face_ALL" then
            faceVal = value
            self.faceDeformationNeedUpdate = true
        elseif tag == "Eye_ALL" then
            eyeVal = value
            self.faceDeformationNeedUpdate = true
        end

        if self.faceDeformationNeedUpdate then
            self:setIntensity(organName[1], organParams[organName[1]] * faceVal)
            self:setIntensity(organName[5], organParams[organName[5]] * faceVal)
            self:setIntensity(organName[7], organParams[organName[7]] * faceVal)
            self:setIntensity(organName[11], organParams[organName[11]] * faceVal)
            self:setIntensity(organName[12], organParams[organName[12]] * faceVal)
            self:setIntensity(organName[13], organParams[organName[13]] * faceVal)
            self:setIntensity(organName[15], organParams[organName[15]] * faceVal)
            self:setIntensity(organName[19], organParams[organName[19]] * faceVal)

            self:setIntensity(organName[2], organParams[organName[2]] * eyeVal)
        end
    end

    if event.type == Amaz.BEFEventType.BET_EXCLUSIVE then
        local exclusiveTag = event.args:get(0)
        local exclusive = event.args:get(1)

        if exclusiveTag ~= "EXCLUSIVE_ALL_PARAM" then
            if intensityMap[exclusiveTag] ~= nil then
                if exclusive then
                    if intensityMapCache == nil then
                        intensityMapCache = {}
                    end

                    if intensityMapCache[exclusiveTag] == nil then
                        intensityMapCache[exclusiveTag] = intensityMap[exclusiveTag]
                        intensityMap[exclusiveTag] = 0

                        self.faceDeformationNeedUpdate = true
                    end
                else
                    if intensityMapCache ~= nil and intensityMapCache[exclusiveTag] ~= nil then
                        intensityMap[exclusiveTag] = intensityMapCache[exclusiveTag]
                        intensityMapCache[exclusiveTag] = nil

                        self.faceDeformationNeedUpdate = true
                    end
                end
            end
        else
            if exclusive then
                --do nothing
            else
                if intensityMapCache ~= nil then
                    for k, v in pairs(intensityMapCache) do
                        if v ~= nil then
                            intensityMap[k] = v
                            self.faceDeformationNeedUpdate = true
                        end
                    end

                    intensityMapCache = nil
                end
            end
        end

        if exclusive then
            -- Amaz.LOGE("SystemScript","tag is : "..exclusiveTag.." is true")
        else
            -- Amaz.LOGE("SystemScript","tag is : "..exclusiveTag.." is false")
        end
    end
end

function SystemScript:setIntensity(params, value)
    -- Amaz.LOGE("SystemScript","setIntensity, params : "..params.." value: "..value)
    if intensityMapCache ~= nil and intensityMapCache[params] ~= nil then
        -- Amaz.LOGE("SystemScript","setIntensity to cache")
        intensityMapCache[params] = value
    else
        -- Amaz.LOGE("SystemScript","setIntensity to current")
        intensityMap[params] = value
    end
end

function SystemScript:onDestroy()
    self.inputTexture = nil
    self.camera = nil
    self.cameraRenderTexture = nil
    self.scene = nil
end

exports.SystemScript = SystemScript
return exports
