local exports = exports or {}
local SmoothV6 = SmoothV6 or {}
SmoothV6.__index = SmoothV6

function SmoothV6.new(construct, ...)
    local self = setmetatable({}, SmoothV6)
    self.comps = {}
    self.compsdirty = true

    self.inputTex = nil

    self.commandBufDynamic = Amaz.CommandBuffer()
    self.commandBufStatic = Amaz.CommandBuffer() 

    self.box1Material = nil
    self.varMaterial = nil
    self.varMaterialBlock = Amaz.MaterialPropertyBlock()
    self.box2Material = nil
    self.box3Material = nil
    self.smoothMaterial = nil
    self.smoothMaterialBlock = Amaz.MaterialPropertyBlock()

    self.box1RT = nil
    self.varRT = nil
    self.smoothRT = nil

    self.width = 720
    self.height = 1280

    self.smoothIntensity = 0.0
    self.sharpIntensity = 0.05
    self.exclusiveFlag = false

    return self
end

function SmoothV6:initialize(sys)
    local commandTableResources = sys.scene:findEntityBy("SmoothV6"):getComponent("TableComponent")

    -- INPUT0
    self.inputTex = commandTableResources.table:get("input_texture")

    -- camera input width and height
    self.width = self.inputTex.width
    self.height = self.inputTex.height

    self.box1Material = commandTableResources.table:get("box1_material")
    self.varMaterial = commandTableResources.table:get("var_material")
    self.box2Material = commandTableResources.table:get("box2_material")
    self.box3Material = commandTableResources.table:get("box3_material")
    self.smoothMaterial = commandTableResources.table:get("smooth_material")

    self.box1RT = commandTableResources.table:get("box1_rt")
    self.varRT = commandTableResources.table:get("var_rt")
    self.smoothRT = commandTableResources.table:get("smooth_rt")   --output

    -- disable depth rt
    local outputRT = sys.scene:getOutputRenderTexture()
    outputRT.attachment = Amaz.RenderTextureAttachment.NONE

    -- clear irrelevant events
    local scriptSys = sys.scene:getSystem("ScriptSystem")
    scriptSys:clearAllEventType()
    scriptSys:addEventType(Amaz.BEFEventType.BET_COMPOSER)
    scriptSys:addEventType(Amaz.BEFEventType.BET_EXCLUSIVE)

    -- -- set sharp intensity
    -- local platformName = Amaz.Platform.name()
    -- if platformName == "iOS" then
    --     self.sharpIntensity = 0.7
    -- elseif platformName == "Android" then
    --     self.sharpIntensity = 0.05
    -- else
    --     self.sharpIntensity = 0.0   -- TBD
    -- end
end

function SmoothV6:onStart(sys)
    
    self:initialize(sys)

    -- box blur x -- pass 1
    self.commandBufStatic:setRenderTexture(self.box1RT)
    self.commandBufStatic:clearRenderTexture(true, true, Amaz.Color(0.0, 0.0, 0.0, 0.0))
    self.commandBufStatic:blitWithMaterial(self.inputTex, self.box1RT, self.box1Material, 0, true)

    -- box blur y -- pass 2
    self.commandBufStatic:setRenderTexture(self.varRT)
    self.commandBufStatic:clearRenderTexture(true, true, Amaz.Color(0.0, 0.0, 0.0, 0.0))
    self.varMaterial:setTex("blurImageTex", self.box1RT)
    self.commandBufStatic:blitWithMaterialAndProperties(self.inputTex, self.varRT, self.varMaterial, 0, self.varMaterialBlock, true)

    -- var blur x -- pass 3
    self.commandBufStatic:setRenderTexture(self.box1RT)
    self.commandBufStatic:clearRenderTexture(true, true, Amaz.Color(0.0, 0.0, 0.0, 0.0))
    self.commandBufStatic:blitWithMaterial(self.varRT, self.box1RT, self.box2Material, 0, true)   -- reuse box1

    -- var blur y -- pass 4 
    self.commandBufStatic:setRenderTexture(self.varRT)
    self.commandBufStatic:clearRenderTexture(true, true, Amaz.Color(0.0, 0.0, 0.0, 0.0))
    self.commandBufStatic:blitWithMaterial(self.box1RT, self.varRT, self.box3Material, 0, true)   -- reuse box1, var

    -- smooth -- pass 5
    self.commandBufStatic:setRenderTexture(self.smoothRT)
    self.commandBufStatic:clearRenderTexture(true, true, Amaz.Color(0.0, 0.0, 0.0, 0.0))
    self.smoothMaterial:setTex("blurImageTex", self.varRT) 
    self.commandBufStatic:blitWithMaterialAndProperties(self.inputTex, self.smoothRT, self.smoothMaterial, 0, self.smoothMaterialBlock, true)
end

function SmoothV6:onUpdate(sys,deltaTime)
    -- handle the case when been exclusive
    if self.exclusiveFlag then
        -- case 1: been exclusived, simply blit 
        self.commandBufDynamic:clearAll()
        self.commandBufDynamic:setRenderTexture(self.smoothRT)
        self.commandBufDynamic:clearRenderTexture(true, true, Amaz.Color(0.0, 0.0, 0.0, 0.0))
        self.commandBufDynamic:blit(self.inputTex, self.smoothRT)
        sys.scene:commitCommandBuffer(self.commandBufDynamic)
        return
    end

    local width = self.inputTex.width
    local height = self.inputTex.height
    if width ~= self.width or height ~= self.height then
        Amaz.LOGI("v6", "v6: onUpdate resolution changed")
        self.width = width
        self.height = height
    end

    -- update uniforms which needs to update
    self.smoothMaterialBlock:setFloat("texEpmHeightOffset", 1.0 / self.height)
    self.smoothMaterialBlock:setFloat("texEpmWidthOffset", 1.0 / self.width)
    self.smoothMaterialBlock:setFloat("smoothIntensity", self.smoothIntensity)
    self.smoothMaterialBlock:setFloat("sharpIntensity", self.sharpIntensity)

    -- handle the case when intensity is zero 
    if self.smoothIntensity > 0.0 then 
        sys.scene:commitCommandBuffer(self.commandBufStatic)
    elseif self.sharpIntensity > 0.0 then
        -- case 2: smooth is 0, sharp is not 0, take pass 6
        self.commandBufDynamic:clearAll()
        self.commandBufDynamic:setRenderTexture(self.smoothRT)
        self.commandBufDynamic:clearRenderTexture(true, true, Amaz.Color(0.0, 0.0, 0.0, 0.0))
        self.commandBufDynamic:blitWithMaterialAndProperties(self.inputTex, self.smoothRT, self.smoothMaterial, 0, self.smoothMaterialBlock)
        sys.scene:commitCommandBuffer(self.commandBufDynamic)
    else
        -- case 3: smooth and sharp is 0, simply blit
        self.commandBufDynamic:clearAll()
        self.commandBufDynamic:setRenderTexture(self.smoothRT)
        self.commandBufDynamic:clearRenderTexture(true, true, Amaz.Color(0.0, 0.0, 0.0, 0.0))
        self.commandBufDynamic:blit(self.inputTex, self.smoothRT)
        sys.scene:commitCommandBuffer(self.commandBufDynamic)
    end
end

function SmoothV6:onEvent(sys,event)
    if event.type == Amaz.BEFEventType.BET_COMPOSER then
        if event.args:get(0) == "Smooth_ALL" then
            local _intensity = event.args:get(2)
            self.smoothIntensity = _intensity * 0.85
        end
    elseif event.type == Amaz.BEFEventType.BET_EXCLUSIVE then
        if event.args:get(0) == "EXCLUSIVE_ALL_PARAM" then
            self.exclusiveFlag = event.args:get(1)
        end       
    end
end

exports.SmoothV6 = SmoothV6
return exports
